/*
 * Decompiled with CFR 0.152.
 */
package coursier.install;

import cats.Applicative;
import cats.implicits$;
import coursier.cache.internal.FileUtil;
import coursier.cache.internal.FileUtil$;
import coursier.install.ArtifactsLock;
import coursier.install.ArtifactsLock$Entry$;
import coursier.util.Artifact;
import java.io.File;
import java.io.InputStream;
import java.io.Serializable;
import java.math.BigInteger;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.security.MessageDigest;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

public final class ArtifactsLock$
implements Serializable {
    public static final ArtifactsLock$ MODULE$ = new ArtifactsLock$();

    public Either<String, ArtifactsLock> read(String input) {
        return ((Either)implicits$.MODULE$.toTraverseOps((Object)Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.filter$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.zipWithIndex$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])StringOps$.MODULE$.split$extension(Predef$.MODULE$.augmentString(input), '\n')), (Function1 & Serializable)x$1 -> x$1.trim(), ClassTag$.MODULE$.apply(String.class))))), (Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString((String)x$2._1()))))).toList(), implicits$.MODULE$.catsStdInstancesForList()).traverse((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String line = (String)tuple2._1();
                int lineNum = tuple2._2$mcI$sp();
                int idx = line.indexOf(35);
                if (idx < 0) {
                    return new Left((Object)new StringBuilder(15).append("Malformed line ").append(lineNum + 1).toString());
                }
                String url = StringOps$.MODULE$.take$extension(Predef$.MODULE$.augmentString(line), idx);
                String checksumPart = StringOps$.MODULE$.drop$extension(Predef$.MODULE$.augmentString(line), idx + 1);
                int idx0 = checksumPart.indexOf(58);
                if (idx0 < 0) {
                    return new Left((Object)new StringBuilder(15).append("Malformed line ").append(lineNum + 1).toString());
                }
                String checksumType = StringOps$.MODULE$.take$extension(Predef$.MODULE$.augmentString(checksumPart), idx0);
                String checksum = StringOps$.MODULE$.drop$extension(Predef$.MODULE$.augmentString(checksumPart), idx0 + 1);
                return new Right((Object)ArtifactsLock$Entry$.MODULE$.apply(url, checksumType, checksum));
            }
            throw new MatchError((Object)tuple2);
        }, (Applicative)implicits$.MODULE$.catsStdInstancesForEither())).map((Function1 & Serializable)entries -> MODULE$.apply((Set<ArtifactsLock.Entry>)entries.toSet()));
    }

    private String sha1(File f) {
        MessageDigest md = MessageDigest.getInstance("SHA-1");
        try (InputStream is = null;){
            is = Files.newInputStream(f.toPath(), new OpenOption[0]);
            FileUtil$.MODULE$.withContent(is, (FileUtil.WithContent)new FileUtil.UpdateDigest(md), FileUtil$.MODULE$.withContent$default$3());
        }
        byte[] b = md.digest();
        return new BigInteger(1, b).toString(16);
    }

    public ArtifactsLock ofArtifacts(Seq<Tuple2<Artifact, File>> artifacts) {
        Seq entries = (Seq)artifacts.map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                Artifact a = (Artifact)tuple2._1();
                File f = (File)tuple2._2();
                return ArtifactsLock$Entry$.MODULE$.apply(a.url(), "SHA-1", MODULE$.sha1(f));
            }
            throw new MatchError((Object)tuple2);
        });
        return this.apply((Set<ArtifactsLock.Entry>)entries.toSet());
    }

    public ArtifactsLock apply(Set<ArtifactsLock.Entry> entries) {
        return new ArtifactsLock(entries);
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(ArtifactsLock$.class);
    }

    private ArtifactsLock$() {
    }
}

