/*
 * Decompiled with CFR 0.152.
 */
package coursier.install.internal;

import coursier.cache.ArchiveCache;
import coursier.cache.ArchiveType;
import coursier.cache.ArchiveType$;
import coursier.cache.ArtifactError;
import coursier.cache.Cache;
import coursier.cache.loggers.ProgressBarRefreshDisplay$;
import coursier.install.AppDescriptor;
import coursier.install.error.DownloadError;
import coursier.install.internal.PrebuiltApp;
import coursier.util.Artifact;
import coursier.util.Artifact$;
import coursier.util.Task;
import coursier.util.Task$;
import coursier.version.Version;
import java.io.File;
import java.io.Serializable;
import java.nio.file.Files;
import javax.net.ssl.SSLHandshakeException;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.Tuple4;
import scala.collection.Iterator;
import scala.collection.StringOps$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

public final class PrebuiltApp$
implements Serializable {
    public static final PrebuiltApp$ MODULE$ = new PrebuiltApp$();

    public Either<Seq<String>, PrebuiltApp> get(AppDescriptor desc, Cache<Task> cache, ArchiveCache<Task> archiveCache, int verbosity, Option<String> platform, Seq<String> platformExtensions, boolean preferPrebuilt) {
        return this.candidatePrebuiltArtifacts(desc, cache, verbosity, platform, platformExtensions, preferPrebuilt).toRight((Function0 & Serializable)() -> Nil$.MODULE$).flatMap((Function1 & Serializable)artifacts -> {
            Iterator iterator = PrebuiltApp$.downloadArtifacts$1(artifacts, verbosity, cache, archiveCache);
            if (iterator.hasNext()) {
                return new Right(iterator.next());
            }
            return new Left(artifacts.map((Function1 & Serializable)x$5 -> ((Artifact)x$5._1()).url()));
        });
    }

    public Option<File> handleArtifactErrors(Either<ArtifactError, File> maybeFile, Artifact artifact, int verbosity) {
        ArtifactError.DownloadError downloadError;
        ArtifactError e;
        boolean bl = false;
        Left left = null;
        Either<ArtifactError, File> either = maybeFile;
        if (either instanceof Left) {
            bl = true;
            left = (Left)either;
            ArtifactError e2 = (ArtifactError)left.value();
            if (e2 instanceof ArtifactError.NotFound) {
                if (verbosity >= 2) {
                    System.err.println(new StringBuilder(30).append("No prebuilt launcher found at ").append(artifact.url()).toString());
                }
                return None$.MODULE$;
            }
        }
        if (bl && (e = (ArtifactError)left.value()) instanceof ArtifactError.DownloadError && (downloadError = (ArtifactError.DownloadError)e).getCause() instanceof SSLHandshakeException) {
            if (verbosity >= 2) {
                System.err.println(new StringBuilder(56).append("No prebuilt launcher found at ").append(artifact.url()).append(" (SSL handshake exception)").toString());
            }
            return None$.MODULE$;
        }
        if (bl) {
            ArtifactError e3 = (ArtifactError)left.value();
            throw new DownloadError(artifact.url(), (Throwable)e3);
        }
        if (either instanceof Right) {
            Right right = (Right)either;
            File f = (File)right.value();
            if (verbosity >= 1) {
                String size = ProgressBarRefreshDisplay$.MODULE$.byteCount(Files.size(f.toPath()), ProgressBarRefreshDisplay$.MODULE$.byteCount$default$2());
                System.err.println(new StringBuilder(30).append("Found prebuilt launcher at ").append(artifact.url()).append(" (").append(size).append(")").toString());
            }
            return new Some((Object)f);
        }
        throw new MatchError(either);
    }

    private Option<Seq<Tuple2<Artifact, Option<Tuple2<ArchiveType, Option<String>>>>>> candidatePrebuiltArtifacts(AppDescriptor desc, Cache<Task> cache, int verbosity, Option<String> platform, Seq<String> platformExtensions, boolean preferPrebuilt) {
        if (desc.launcherType().isNative()) {
            return desc.prebuiltLauncher().orElse((Function0 & Serializable)() -> platform.flatMap((Function1 & Serializable)key -> desc.prebuiltBinaries().get(key))).map((Function1 & Serializable)pattern -> PrebuiltApp$.patternArtifacts$1(pattern, platform, platformExtensions, desc, cache, verbosity, preferPrebuilt));
        }
        return None$.MODULE$;
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(PrebuiltApp$.class);
    }

    private static final Iterator maybeFileIt$1(Cache cache$1, Artifact artifact$1, int verbosity$1) {
        Either either;
        cache$1.loggerOpt().foreach((Function1 & Serializable)x$1 -> {
            x$1.init(x$1.init$default$1());
            return BoxedUnit.UNIT;
        });
        try {
            either = (Either)Task$.MODULE$.PlatformTaskOps(((Task)cache$1.file(artifact$1).run()).value()).unsafeRun(cache$1.ec());
        }
        finally {
            cache$1.loggerOpt().foreach((Function1 & Serializable)x$2 -> {
                x$2.stop();
                return BoxedUnit.UNIT;
            });
        }
        Either maybeFile = either;
        return MODULE$.handleArtifactErrors((Either<ArtifactError, File>)maybeFile, artifact$1, verbosity$1).iterator();
    }

    private static final Iterator maybeExtractedArchiveIt$1(Cache cache$1, ArchiveCache archiveCache$1, Artifact artifact$1, int verbosity$1) {
        Either either;
        cache$1.loggerOpt().foreach((Function1 & Serializable)x$3 -> {
            x$3.init(x$3.init$default$1());
            return BoxedUnit.UNIT;
        });
        try {
            either = (Either)Task$.MODULE$.PlatformTaskOps(((Task)archiveCache$1.get(artifact$1)).value()).unsafeRun(cache$1.ec());
        }
        finally {
            cache$1.loggerOpt().foreach((Function1 & Serializable)x$4 -> {
                x$4.stop();
                return BoxedUnit.UNIT;
            });
        }
        Either maybeDir = either;
        return MODULE$.handleArtifactErrors((Either<ArtifactError, File>)maybeDir, artifact$1, verbosity$1).iterator();
    }

    private static final Iterator downloadArtifacts$1(Seq artifacts, int verbosity$1, Cache cache$1, ArchiveCache archiveCache$1) {
        return artifacts.iterator().flatMap((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                Option option;
                Tuple2 tuple22;
                Artifact artifact = (Artifact)tuple2._1();
                Option archiveTypeOpt = (Option)tuple2._2();
                if (verbosity$1 >= 2) {
                    System.err.println(new StringBuilder(30).append("Checking prebuilt launcher at ").append(artifact.url()).toString());
                }
                boolean bl = false;
                Some some = null;
                Option option2 = archiveTypeOpt;
                if (None$.MODULE$.equals(option2)) {
                    return PrebuiltApp$.maybeFileIt$1(cache$1, artifact, verbosity$1).map((Function1 & Serializable)f -> new PrebuiltApp.Uncompressed(artifact, (File)f));
                }
                if (option2 instanceof Some) {
                    bl = true;
                    some = (Some)option2;
                    Tuple2 tuple23 = (Tuple2)some.value();
                    if (tuple23 != null) {
                        ArchiveType archiveType = (ArchiveType)tuple23._1();
                        Option option3 = (Option)tuple23._2();
                        if (None$.MODULE$.equals(option3)) {
                            return PrebuiltApp$.maybeFileIt$1(cache$1, artifact, verbosity$1).map((Function1 & Serializable)f -> new PrebuiltApp.Compressed(artifact, (File)f, archiveType, (Option<String>)None$.MODULE$));
                        }
                    }
                }
                if (bl && (tuple22 = (Tuple2)some.value()) != null && (option = (Option)tuple22._2()) instanceof Some) {
                    Some some2 = (Some)option;
                    String pathInArchive = (String)some2.value();
                    return PrebuiltApp$.maybeExtractedArchiveIt$1(cache$1, archiveCache$1, artifact, verbosity$1).flatMap((Function1 & Serializable)f -> {
                        File innerF = new File((File)f, pathInArchive);
                        if (innerF.exists()) {
                            return package$.MODULE$.Iterator().single((Object)new PrebuiltApp.ExtractedArchive(artifact, (File)f, pathInArchive, innerF));
                        }
                        return package$.MODULE$.Iterator().empty();
                    });
                }
                throw new MatchError((Object)option2);
            }
            throw new MatchError((Object)tuple2);
        });
    }

    private static final Iterator mainVersionsIterator$1(AppDescriptor desc$1, Cache cache$2, int verbosity$2, boolean preferPrebuilt$1) {
        Iterator<Version> it0 = desc$1.candidateMainVersions((Cache<Task>)cache$2, verbosity$2);
        Iterator it = it0.hasNext() ? it0.map((Function1 & Serializable)x$6 -> x$6.asString()) : desc$1.mainVersionOpt().iterator().map((Function1 & Serializable)x$7 -> x$7.asString());
        return it.take(preferPrebuilt$1 ? 5 : 1);
    }

    private static final Tuple2 urlArchiveType$1(String url) {
        int idx = url.indexOf(43);
        if (idx < 0) {
            return new Tuple2((Object)url, (Object)None$.MODULE$);
        }
        Option option = ArchiveType$.MODULE$.parse(StringOps$.MODULE$.take$extension(Predef$.MODULE$.augmentString(url), idx));
        if (option instanceof Some) {
            Some some = (Some)option;
            ArchiveType tpe = (ArchiveType)some.value();
            String url0 = StringOps$.MODULE$.drop$extension(Predef$.MODULE$.augmentString(url), idx + 1);
            int subPathIndex = url0.indexOf(33);
            if (subPathIndex < 0) {
                return new Tuple2((Object)url0, (Object)new Some((Object)new Tuple2((Object)tpe, (Object)None$.MODULE$)));
            }
            String subPath = StringOps$.MODULE$.drop$extension(Predef$.MODULE$.augmentString(url0), subPathIndex + 1);
            return new Tuple2((Object)StringOps$.MODULE$.take$extension(Predef$.MODULE$.augmentString(url0), subPathIndex), (Object)new Some((Object)new Tuple2((Object)tpe, (Object)new Some((Object)subPath))));
        }
        if (None$.MODULE$.equals(option)) {
            return new Tuple2((Object)url, (Object)None$.MODULE$);
        }
        throw new MatchError((Object)option);
    }

    public static final /* synthetic */ boolean $anonfun$candidatePrebuiltArtifacts$6(Tuple2 x$8) {
        return ((Option)x$8._2()).nonEmpty();
    }

    private static final Seq patternArtifacts$1(String pattern, Option platform$1, Seq platformExtensions$1, AppDescriptor desc$1, Cache cache$2, int verbosity$2, boolean preferPrebuilt$1) {
        Iterator artifactsIt = PrebuiltApp$.mainVersionsIterator$1(desc$1, cache$2, verbosity$2, preferPrebuilt$1).map((Function1 & Serializable)version -> {
            boolean isSnapshot = version.endsWith("SNAPSHOT");
            String baseUrl0 = pattern.replace("${version}", (CharSequence)version).replace("${platform}", (CharSequence)platform$1.getOrElse((Function0 & Serializable)() -> ""));
            Tuple2 tuple2 = PrebuiltApp$.urlArchiveType$1(baseUrl0);
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String baseUrl = (String)tuple2._1();
            Option archiveTypeAndPathOpt = (Option)tuple2._2();
            Tuple3 tuple3 = new Tuple3((Object)tuple2, (Object)baseUrl, (Object)archiveTypeAndPathOpt);
            Tuple2 x$10 = (Tuple2)tuple3._1();
            String baseUrl2 = (String)tuple3._2();
            Option archiveTypeAndPathOpt2 = (Option)tuple3._3();
            return new Tuple4(version, (Object)BoxesRunTime.boxToBoolean((boolean)isSnapshot), (Object)baseUrl0, (Object)x$10);
        }).flatMap((Function1 & Serializable)x$15 -> {
            Tuple4 tuple4 = x$15;
            if (tuple4 != null) {
                boolean isSnapshot = BoxesRunTime.unboxToBoolean((Object)tuple4._2());
                Tuple2 tuple2 = (Tuple2)tuple4._4();
                if (tuple2 != null) {
                    String baseUrl = (String)tuple2._1();
                    Option archiveTypeAndPathOpt = (Option)tuple2._2();
                    return (archiveTypeAndPathOpt.forall((Function1 & Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)PrebuiltApp$.$anonfun$candidatePrebuiltArtifacts$6(x$8))) ? platformExtensions$1.iterator().$plus$plus((Function0 & Serializable)() -> package$.MODULE$.Iterator().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{""}))) : package$.MODULE$.Iterator().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{""}))).map((Function1 & Serializable)ext -> {
                        Some some;
                        Tuple2 tuple2;
                        Tuple2 tuple22;
                        Option option = archiveTypeAndPathOpt;
                        if (None$.MODULE$.equals(option)) {
                            tuple22 = new Tuple2((Object)new StringBuilder(0).append(baseUrl).append((String)ext).toString(), (Object)archiveTypeAndPathOpt);
                        } else if (option instanceof Some && (tuple2 = (Tuple2)(some = (Some)option).value()) != null) {
                            ArchiveType tpe = (ArchiveType)tuple2._1();
                            Option subPath0 = (Option)tuple2._2();
                            tuple22 = new Tuple2((Object)baseUrl, (Object)new Some((Object)new Tuple2((Object)tpe, (Object)subPath0.map((Function1 & Serializable)x$9 -> new StringBuilder(0).append((String)x$9).append((String)ext).toString()))));
                        } else {
                            throw new MatchError((Object)option);
                        }
                        Tuple2 tuple23 = tuple22;
                        if (tuple23 == null) {
                            throw new MatchError((Object)tuple23);
                        }
                        String url = (String)tuple23._1();
                        Option archiveTypeAndPathOpt0 = (Option)tuple23._2();
                        Tuple3 tuple3 = new Tuple3((Object)tuple23, (Object)url, (Object)archiveTypeAndPathOpt0);
                        Tuple2 x$12 = (Tuple2)tuple3._1();
                        String url2 = (String)tuple3._2();
                        Option archiveTypeAndPathOpt02 = (Option)tuple3._3();
                        return new Tuple2(ext, (Object)x$12);
                    }).map((Function1 & Serializable)x$14 -> {
                        Tuple2 tuple2;
                        Tuple2 tuple22 = x$14;
                        if (tuple22 != null && (tuple2 = (Tuple2)tuple22._2()) != null) {
                            String url = (String)tuple2._1();
                            Option archiveTypeAndPathOpt0 = (Option)tuple2._2();
                            return new Tuple2((Object)Artifact$.MODULE$.apply(url).withChanging(isSnapshot), (Object)archiveTypeAndPathOpt0);
                        }
                        throw new MatchError((Object)tuple22);
                    });
                }
            }
            throw new MatchError((Object)tuple4);
        });
        return artifactsIt.toVector();
    }

    private PrebuiltApp$() {
    }
}

