/*
 * Decompiled with CFR 0.152.
 */
package coursier.jvm;

import com.oracle.svm.core.CErrorNumber;
import com.oracle.svm.core.annotate.Substitute;
import com.oracle.svm.core.annotate.TargetClass;
import coursier.jvm.ErrnoException;
import coursier.jvm.GraalvmErrnoExtras;
import coursier.jvm.GraalvmUnistdExtras;
import java.io.FileNotFoundException;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.c.type.CTypeConversion;

@TargetClass(className="coursier.jvm.Execve")
@Platforms(value={Platform.LINUX.class, Platform.DARWIN.class})
final class ExecveGraalvm {
    ExecveGraalvm() {
    }

    @Substitute
    public static boolean available() {
        return true;
    }

    @Substitute
    public static void execve(String string, String[] stringArray, String[] stringArray2) throws ErrnoException {
        CTypeConversion.CCharPointerHolder cCharPointerHolder = CTypeConversion.toCString((CharSequence)string);
        CTypeConversion.CCharPointerPointerHolder cCharPointerPointerHolder = CTypeConversion.toCStrings((CharSequence[])stringArray);
        CTypeConversion.CCharPointerPointerHolder cCharPointerPointerHolder2 = CTypeConversion.toCStrings((CharSequence[])stringArray2);
        GraalvmUnistdExtras.execve(cCharPointerHolder.get(), cCharPointerPointerHolder.get(), cCharPointerPointerHolder2.get());
        int n = CErrorNumber.getCErrorNumber();
        FileNotFoundException fileNotFoundException = null;
        if (n == GraalvmErrnoExtras.ENOENT() || n == GraalvmErrnoExtras.ENOTDIR()) {
            fileNotFoundException = new FileNotFoundException(string);
        }
        throw new ErrnoException(n, (Throwable)fileNotFoundException);
    }
}

