/*
 * Decompiled with CFR 0.152.
 */
package coursier.paths.shaded.dirs.impl;

import coursier.paths.shaded.dirs.Constants;
import coursier.paths.shaded.dirs.impl.Windows;
import java.lang.foreign.AddressLayout;
import java.lang.foreign.Arena;
import java.lang.foreign.FunctionDescriptor;
import java.lang.foreign.GroupLayout;
import java.lang.foreign.Linker;
import java.lang.foreign.MemoryLayout;
import java.lang.foreign.MemorySegment;
import java.lang.foreign.SymbolLookup;
import java.lang.foreign.ValueLayout;
import java.lang.invoke.MethodHandle;

public final class WindowsForeign
implements Windows {
    private static final SymbolLookup SYMBOL_LOOKUP;
    private static final ValueLayout.OfByte C_CHAR;
    private static final ValueLayout.OfShort C_SHORT;
    private static final AddressLayout C_POINTER;
    private static final ValueLayout.OfInt C_LONG;
    private static final GroupLayout GUID_LAYOUT;

    private static String getDir(String string) {
        try (Arena arena = Arena.ofConfined();){
            MemorySegment memorySegment = arena.allocate(GUID_LAYOUT);
            if (WindowsForeign.CLSIDFromString(WindowsForeign.createSegmentFromString(string, arena), memorySegment) != 0) {
                throw new AssertionError((Object)("failed converting string " + string + " to KnownFolderId"));
            }
            MemorySegment memorySegment2 = arena.allocate(C_POINTER);
            WindowsForeign.SHGetKnownFolderPath(memorySegment, 0, MemorySegment.NULL, memorySegment2);
            String string2 = WindowsForeign.createStringFromSegment(memorySegment2.get(C_POINTER, 0L));
            return string2;
        }
    }

    @Override
    public String[] winDirs(String ... stringArray) {
        String[] stringArray2 = new String[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray2[i] = WindowsForeign.getDir("{" + stringArray[i] + "}");
        }
        return stringArray2;
    }

    private static MemorySegment createSegmentFromString(String string, Arena arena) {
        MemorySegment memorySegment = arena.allocate(ValueLayout.JAVA_CHAR, (long)string.length() + 1L);
        memorySegment.copyFrom(MemorySegment.ofArray(string.toCharArray()));
        return memorySegment;
    }

    private static String createStringFromSegment(MemorySegment memorySegment) {
        int n = 0;
        while (memorySegment.get(ValueLayout.JAVA_CHAR, (long)n) != '\u0000') {
            n += 2;
        }
        return new String(memorySegment.asSlice(0L, n).toArray(ValueLayout.JAVA_CHAR));
    }

    private static MemorySegment findOrThrow(String string) {
        return SYMBOL_LOOKUP.find(string).orElseThrow(() -> new UnsatisfiedLinkError("unresolved symbol: " + string));
    }

    private static int CLSIDFromString(MemorySegment memorySegment, MemorySegment memorySegment2) {
        MethodHandle methodHandle = CLSIDFromString.HANDLE;
        try {
            return methodHandle.invokeExact(memorySegment, memorySegment2);
        }
        catch (Throwable throwable) {
            throw new AssertionError("failed to invoke `CLSIDFromString`", throwable);
        }
    }

    private static int SHGetKnownFolderPath(MemorySegment memorySegment, int n, MemorySegment memorySegment2, MemorySegment memorySegment3) {
        MethodHandle methodHandle = SHGetKnownFolderPath.HANDLE;
        try {
            return methodHandle.invokeExact(memorySegment, n, memorySegment2, memorySegment3);
        }
        catch (Throwable throwable) {
            throw new AssertionError("failed to invoke `SHGetKnownFolderPath`", throwable);
        }
    }

    static {
        if (Constants.operatingSystem == 'w') {
            System.loadLibrary("ole32");
            System.loadLibrary("shell32");
        }
        SYMBOL_LOOKUP = SymbolLookup.loaderLookup().or(Linker.nativeLinker().defaultLookup());
        C_CHAR = ValueLayout.JAVA_BYTE;
        C_SHORT = ValueLayout.JAVA_SHORT;
        C_POINTER = ValueLayout.ADDRESS.withTargetLayout(MemoryLayout.sequenceLayout(Long.MAX_VALUE, ValueLayout.JAVA_BYTE));
        C_LONG = ValueLayout.JAVA_INT;
        GUID_LAYOUT = MemoryLayout.structLayout(C_LONG.withName("Data1"), C_SHORT.withName("Data2"), C_SHORT.withName("Data3"), MemoryLayout.sequenceLayout(8L, C_CHAR).withName("Data4")).withName("_GUID");
    }

    private static class CLSIDFromString {
        public static final FunctionDescriptor DESC = FunctionDescriptor.of(C_LONG, C_POINTER, C_POINTER);
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(WindowsForeign.findOrThrow("CLSIDFromString"), DESC, new Linker.Option[0]);

        private CLSIDFromString() {
        }
    }

    private static class SHGetKnownFolderPath {
        public static final FunctionDescriptor DESC = FunctionDescriptor.of(C_LONG, C_POINTER, C_LONG, C_POINTER, C_POINTER);
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(WindowsForeign.findOrThrow("SHGetKnownFolderPath"), DESC, new Linker.Option[0]);

        private SHGetKnownFolderPath() {
        }
    }
}

