/*
 * Decompiled with CFR 0.152.
 */
package coursier.paths;

import coursier.paths.Util;
import coursier.paths.shaded.dirs.ProjectDirectories;
import coursier.paths.shaded.dirs.impl.Windows;
import coursier.paths.shaded.dirs.impl.WindowsPowerShell;
import coursier.paths.shaded.dirs.jni.WindowsJni;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.function.Supplier;

public final class CoursierPaths {
    private static final Object coursierDirectoriesLock = new Object();
    private static ProjectDirectories coursierDirectories0;
    private static final Object cacheDirectoryLock;
    private static volatile Path cacheDirectory0;
    private static volatile Path archiveCacheDirectory0;
    private static volatile Path priviledgedArchiveCacheDirectory0;
    private static volatile Path digestBasedCacheDirectory0;
    private static volatile Path jvmCacheDirectory0;
    private static final Object configDirectoryLock;
    private static volatile Path[] configDirectories0;
    private static final Object dataLocalDirectoryLock;
    private static volatile Path dataLocalDirectory0;
    private static Path scalaConfigFile0;

    private CoursierPaths() {
        throw new Error();
    }

    private static String computeCacheDirectory() throws IOException {
        return CoursierPaths.computeCacheDirectory("COURSIER_CACHE", "coursier.cache", "v1");
    }

    private static String computeArchiveCacheDirectory() throws IOException {
        return CoursierPaths.computeCacheDirectory("COURSIER_ARCHIVE_CACHE", "coursier.archive.cache", "arc");
    }

    private static String computePriviledgedArchiveCacheDirectory() throws IOException {
        return CoursierPaths.computeCacheDirectory("COURSIER_PRIVILEDGED_ARCHIVE_CACHE", "coursier.priviledged.archive.cache", "priv");
    }

    private static String computeDigestBasedCacheDirectory() throws IOException {
        return CoursierPaths.computeCacheDirectory("COURSIER_DIGEST_BASED_CACHE", "coursier.digest-based.cache", "digest");
    }

    private static String computeJvmCacheDirectory() throws IOException {
        return CoursierPaths.computeCacheDirectory("COURSIER_JVM_CACHE", "coursier.jvm.cache", "jvm");
    }

    private static String computeCacheDirectory(String string, String string2, String string3) throws IOException {
        return CoursierPaths.computeCacheDirectoryFrom(System.getenv(string), System.getProperty(string2), string3);
    }

    public static String computeCacheDirectoryFrom(String string, String string2, String string3) throws IOException {
        if (string != null) {
            return string;
        }
        if (string2 != null) {
            return string2;
        }
        Path path = Paths.get(CoursierPaths.coursierDirectories().cacheDir, new String[0]);
        Path path2 = path.resolve(string3);
        Util.createDirectories(path2);
        return path2.toAbsolutePath().normalize().toString();
    }

    public static File cacheDirectory() throws IOException {
        return CoursierPaths.cacheDirectoryPath().toFile();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Path cacheDirectoryPath() throws IOException {
        if (cacheDirectory0 == null) {
            Object object = cacheDirectoryLock;
            synchronized (object) {
                if (cacheDirectory0 == null) {
                    cacheDirectory0 = Paths.get(CoursierPaths.computeCacheDirectory(), new String[0]).toAbsolutePath().normalize();
                }
            }
        }
        return cacheDirectory0;
    }

    public static File archiveCacheDirectory() throws IOException {
        return CoursierPaths.archiveCacheDirectoryPath().toFile();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Path archiveCacheDirectoryPath() throws IOException {
        if (archiveCacheDirectory0 == null) {
            Object object = cacheDirectoryLock;
            synchronized (object) {
                if (archiveCacheDirectory0 == null) {
                    archiveCacheDirectory0 = Paths.get(CoursierPaths.computeArchiveCacheDirectory(), new String[0]).toAbsolutePath().normalize();
                }
            }
        }
        return archiveCacheDirectory0;
    }

    public static File priviledgedArchiveCacheDirectory() throws IOException {
        return CoursierPaths.priviledgedArchiveCacheDirectoryPath().toFile();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Path priviledgedArchiveCacheDirectoryPath() throws IOException {
        if (priviledgedArchiveCacheDirectory0 == null) {
            Object object = cacheDirectoryLock;
            synchronized (object) {
                if (priviledgedArchiveCacheDirectory0 == null) {
                    priviledgedArchiveCacheDirectory0 = Paths.get(CoursierPaths.computePriviledgedArchiveCacheDirectory(), new String[0]).toAbsolutePath().normalize();
                }
            }
        }
        return priviledgedArchiveCacheDirectory0;
    }

    public static File digestBasedCacheDirectory() throws IOException {
        return CoursierPaths.digestBasedCacheDirectoryPath().toFile();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Path digestBasedCacheDirectoryPath() throws IOException {
        if (digestBasedCacheDirectory0 == null) {
            Object object = cacheDirectoryLock;
            synchronized (object) {
                if (digestBasedCacheDirectory0 == null) {
                    digestBasedCacheDirectory0 = Paths.get(CoursierPaths.computeDigestBasedCacheDirectory(), new String[0]).toAbsolutePath().normalize();
                }
            }
        }
        return digestBasedCacheDirectory0;
    }

    public static File jvmCacheDirectory() throws IOException {
        return CoursierPaths.jvmCacheDirectoryPath().toFile();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Path jvmCacheDirectoryPath() throws IOException {
        if (jvmCacheDirectory0 == null) {
            Object object = cacheDirectoryLock;
            synchronized (object) {
                if (jvmCacheDirectory0 == null) {
                    jvmCacheDirectory0 = Paths.get(CoursierPaths.computeJvmCacheDirectory(), new String[0]).toAbsolutePath().normalize();
                }
            }
        }
        return jvmCacheDirectory0;
    }

    public static ProjectDirectories directoriesInstance(String string) {
        Supplier<Windows> supplier = Boolean.getBoolean("coursier.windows.disable-ffm") ? (Util.useJni() ? () -> new WindowsJni() : () -> new WindowsPowerShell()) : (Util.useJni() ? WindowsJni.getJdkAwareSupplier() : Windows.getDefaultSupplier());
        return ProjectDirectories.from(null, null, string, supplier);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ProjectDirectories coursierDirectories() throws IOException {
        if (coursierDirectories0 == null) {
            Object object = coursierDirectoriesLock;
            synchronized (object) {
                if (coursierDirectories0 == null) {
                    coursierDirectories0 = CoursierPaths.directoriesInstance("Coursier");
                }
            }
        }
        return coursierDirectories0;
    }

    private static Path[] computeConfigDirectories() throws IOException {
        return CoursierPaths.computeConfigDirectories(System.getenv("COURSIER_CONFIG_DIR"), System.getProperty("coursier.config-dir"));
    }

    private static Path[] computeConfigDirectories(String string, String string2) throws IOException {
        String string3 = string;
        if (string3 == null) {
            string3 = string2;
        }
        if (string3 != null) {
            return new Path[]{Paths.get(string3, new String[0]).toAbsolutePath().normalize()};
        }
        String string4 = CoursierPaths.coursierDirectories().configDir;
        String string5 = CoursierPaths.coursierDirectories().preferenceDir;
        if (string4.equals(string5)) {
            return new Path[]{Paths.get(string4, new String[0]).toAbsolutePath().normalize()};
        }
        return new Path[]{Paths.get(string4, new String[0]).toAbsolutePath().normalize(), Paths.get(string5, new String[0]).toAbsolutePath().normalize()};
    }

    public static File[] configDirectories() throws IOException {
        return (File[])Arrays.stream(CoursierPaths.configDirectoriesPaths()).map(Path::toFile).toArray(File[]::new);
    }

    public static File[] configDirectories(String string, String string2) throws IOException {
        return (File[])Arrays.stream(CoursierPaths.configDirectoriesPaths(string, string2)).map(Path::toFile).toArray(File[]::new);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Path[] configDirectoriesPaths() throws IOException {
        if (configDirectories0 == null) {
            Object object = configDirectoryLock;
            synchronized (object) {
                if (configDirectories0 == null) {
                    configDirectories0 = CoursierPaths.computeConfigDirectories();
                }
            }
        }
        return (Path[])configDirectories0.clone();
    }

    public static Path[] configDirectoriesPaths(String string, String string2) throws IOException {
        if (string == null && string2 == null) {
            return CoursierPaths.configDirectoriesPaths();
        }
        return CoursierPaths.computeConfigDirectories(string, string2);
    }

    @Deprecated
    public static File configDirectory() throws IOException {
        return CoursierPaths.configDirectories()[0];
    }

    public static File defaultConfigDirectory() throws IOException {
        return CoursierPaths.configDirectories()[0];
    }

    public static Path defaultConfigDirectoryPath() throws IOException {
        return CoursierPaths.configDirectoriesPaths()[0];
    }

    private static String computeDataLocalDirectory() throws IOException {
        String string = System.getenv("COURSIER_DATA_DIR");
        if (string == null) {
            string = System.getProperty("coursier.data-dir");
        }
        if (string != null) {
            return string;
        }
        return CoursierPaths.coursierDirectories().dataLocalDir;
    }

    public static File dataLocalDirectory() throws IOException {
        return CoursierPaths.dataLocalDirectoryPath().toFile();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Path dataLocalDirectoryPath() throws IOException {
        if (dataLocalDirectory0 == null) {
            Object object = dataLocalDirectoryLock;
            synchronized (object) {
                if (dataLocalDirectory0 == null) {
                    dataLocalDirectory0 = Paths.get(CoursierPaths.computeDataLocalDirectory(), new String[0]).toAbsolutePath().normalize();
                }
            }
        }
        return dataLocalDirectory0;
    }

    public static File projectCacheDirectory() throws IOException {
        return new File(CoursierPaths.coursierDirectories().cacheDir);
    }

    public static Path projectCacheDirectoryPath() throws IOException {
        return Paths.get(CoursierPaths.coursierDirectories().cacheDir, new String[0]);
    }

    public static Path scalaConfigFile(String string, String string2) throws Throwable {
        Path path = null;
        if (string != null && string.length() > 0) {
            path = Paths.get(string, new String[0]);
        }
        if (path == null && string2 != null && string2.length() > 0) {
            path = Paths.get(string2, new String[0]);
        }
        if (path == null) {
            ProjectDirectories projectDirectories = CoursierPaths.directoriesInstance("ScalaCli");
            path = Paths.get(projectDirectories.dataLocalDir, new String[0]).resolve("secrets/config.json");
        }
        return path;
    }

    public static Path scalaConfigFile() throws Throwable {
        if (scalaConfigFile0 == null) {
            scalaConfigFile0 = CoursierPaths.scalaConfigFile(System.getenv("SCALA_CLI_CONFIG"), System.getProperty("scala-cli.config"));
        }
        return scalaConfigFile0;
    }

    static {
        cacheDirectoryLock = new Object();
        cacheDirectory0 = null;
        archiveCacheDirectory0 = null;
        priviledgedArchiveCacheDirectory0 = null;
        digestBasedCacheDirectory0 = null;
        jvmCacheDirectory0 = null;
        configDirectoryLock = new Object();
        configDirectories0 = null;
        dataLocalDirectoryLock = new Object();
        dataLocalDirectory0 = null;
        scalaConfigFile0 = null;
    }
}

