/*
 * Decompiled with CFR 0.152.
 */
package coursier.proxy;

import java.io.File;
import java.io.IOException;
import java.net.Authenticator;
import java.net.PasswordAuthentication;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public final class SetupProxy {
    private static final boolean debug = Boolean.getBoolean("cs.proxy-setup.debug");

    public static void setupTunnelingProp() {
        if (System.getProperty("jdk.http.auth.tunneling.disabledSchemes") == null) {
            System.setProperty("jdk.http.auth.tunneling.disabledSchemes", "");
        }
    }

    static void setProperty(String string, String string2) {
        if (debug) {
            System.err.println("cs-proxy: setProperty(" + string + ", " + string2 + ")");
        }
        System.setProperty(string, string2);
    }

    public static void setProxyProperties(String string, String string2, String string3, String string4) throws URISyntaxException {
        if (string != null && string.length() > 0) {
            URI uRI = new URI(string);
            String string5 = uRI.getScheme();
            int n = uRI.getPort();
            if (n < 0) {
                n = string5.equals("https") ? 443 : 80;
            }
            SetupProxy.setProxyProperties(uRI.getScheme(), uRI.getHost(), Integer.toString(n), string2, string3, string4, "");
        }
    }

    public static void setProxyProperties(String string, String string2, String string3, String string4, String string5, String string6, String string7) {
        SetupProxy.setupTunnelingProp();
        String string8 = string == null ? "https" : string;
        SetupProxy.setProperty(string7 + "http.proxyProtocol", string8);
        SetupProxy.setProperty(string7 + "https.proxyProtocol", string8);
        SetupProxy.setProperty(string7 + "http.proxyHost", string2);
        SetupProxy.setProperty(string7 + "https.proxyHost", string2);
        if (string3 != null) {
            SetupProxy.setProperty(string7 + "http.proxyPort", string3);
            SetupProxy.setProperty(string7 + "https.proxyPort", string3);
        }
        if (string4 != null) {
            SetupProxy.setProperty(string7 + "http.proxyUser", string4);
            SetupProxy.setProperty(string7 + "https.proxyUser", string4);
        }
        if (string5 != null) {
            SetupProxy.setProperty(string7 + "http.proxyPassword", string5);
            SetupProxy.setProperty(string7 + "https.proxyPassword", string5);
        }
        if (string6 != null) {
            SetupProxy.setProperty(string7 + "http.nonProxyHosts", string6);
        }
    }

    public static void setupPropertiesFrom(File file, String string) throws ParserConfigurationException, SAXException, IOException {
        SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
        SAXParser sAXParser = sAXParserFactory.newSAXParser();
        Handler handler = new Handler();
        sAXParser.parse(file, (DefaultHandler)handler);
        List<Map<String, String>> list = handler.getProxies();
        for (Map<String, String> map : list) {
            boolean bl;
            String string2 = map.get("active");
            boolean bl2 = bl = string2 == null || string2.equalsIgnoreCase("true");
            if (debug) {
                System.err.println("cs-proxy, in map:");
                for (Map.Entry entry : map.entrySet()) {
                    System.err.println("  " + (String)entry.getKey() + "=" + (String)entry.getValue());
                }
            }
            if (!bl) continue;
            String string3 = map.get("protocol");
            String string4 = map.get("host");
            String string5 = map.get("port");
            String string6 = map.get("username");
            String string7 = map.get("password");
            String string8 = map.get("nonProxyHosts");
            if (string4 == null) continue;
            SetupProxy.setProxyProperties(string3, string4, string5, string6, string7, string8, string);
        }
    }

    public static void setupProperties() throws ParserConfigurationException, SAXException, IOException {
        Object object;
        File file = null;
        String string = System.getenv("CS_MAVEN_HOME");
        if (string != null) {
            file = new File(string);
        }
        if (file == null && (object = System.getenv("MAVEN_HOME")) != null) {
            file = new File((String)object);
        }
        if (file == null && (object = System.getProperty("cs.maven.home")) != null) {
            file = new File((String)object);
        }
        if (file == null && (object = System.getProperty("maven.home")) != null) {
            file = new File((String)object);
        }
        if (file == null) {
            file = new File(new File(System.getProperty("user.home")), ".m2");
        }
        if (!((File)(object = new File(file, "settings.xml"))).isFile()) {
            if (debug) {
                System.err.println("cs-proxy, not found:" + object);
            }
            return;
        }
        if (debug) {
            System.err.println("cs-proxy, found " + object);
        }
        SetupProxy.setupPropertiesFrom((File)object, "");
    }

    public static boolean setupAuthenticator(final String string, final String string2, final String string3, final String string4, final String string5, final String string6, final String string7, final String string8, final String string9, final String string10, String string11, String string12, String string13, String string14, String string15) {
        boolean bl;
        boolean bl2 = bl = string2 != null && string4 != null || string7 != null && string9 != null;
        if (!bl) {
            return false;
        }
        SetupProxy.setupTunnelingProp();
        Authenticator.setDefault(new Authenticator(){

            @Override
            protected PasswordAuthentication getPasswordAuthentication() {
                String string11 = this.getRequestingProtocol();
                String string22 = this.getRequestingHost();
                String string32 = Integer.toString(this.getRequestingPort());
                if (debug) {
                    System.err.println("cs-proxy, Authenticator.getPasswordAuthentication:");
                    System.err.println("  protocol=" + string11);
                    System.err.println("  host=" + string22);
                    System.err.println("  port=" + string32);
                }
                if (string11.equals(string) && string4 != null && string22 != null && string22.equals(string2) && string32.equals(string3)) {
                    return new PasswordAuthentication(string4, (string5 == null ? "" : string5).toCharArray());
                }
                if (string11.equals(string6) && string9 != null && string22 != null && string22.equals(string7) && string32.equals(string8)) {
                    return new PasswordAuthentication(string9, (string10 == null ? "" : string10).toCharArray());
                }
                return super.getPasswordAuthentication();
            }
        });
        return true;
    }

    public static boolean setupAuthenticator() {
        String string = System.getProperty("http.proxyProtocol");
        String string2 = System.getProperty("http.proxyHost");
        String string3 = System.getProperty("http.proxyPort");
        String string4 = System.getProperty("http.proxyUser");
        String string5 = System.getProperty("http.proxyPassword");
        String string6 = string3 == null ? "80" : string3;
        String string7 = System.getProperty("https.proxyProtocol");
        String string8 = System.getProperty("https.proxyHost");
        String string9 = System.getProperty("https.proxyPort");
        String string10 = System.getProperty("https.proxyUser");
        String string11 = System.getProperty("https.proxyPassword");
        String string12 = string9 == null ? "443" : string9;
        return SetupProxy.setupAuthenticator(string, string2, string6, string4, string5, string7, string8, string12, string10, string11, null, null, null, null, null);
    }

    public static boolean setup() throws ParserConfigurationException, SAXException, IOException {
        SetupProxy.setupProperties();
        return SetupProxy.setupAuthenticator();
    }

    private static final class Handler
    extends DefaultHandler {
        private int settingsDistance = -1;
        private int proxiesDistance = -1;
        private int proxyDistance = -1;
        private String proxyKey = "";
        private String proxyValue = "";
        private ArrayList<Map<String, String>> proxies = new ArrayList();
        private HashMap<String, String> current = new HashMap();
        private static final String SETTINGS = "settings";
        private static final String PROXIES = "proxies";
        private static final String PROXY = "proxy";

        private Handler() {
        }

        @Override
        public void startDocument() {
            this.settingsDistance = -1;
            this.proxiesDistance = -1;
            this.proxyDistance = -1;
            this.proxyKey = "";
            this.proxyValue = "";
            this.proxies = new ArrayList();
            this.current = new HashMap();
        }

        @Override
        public void startElement(String string, String string2, String string3, Attributes attributes) {
            if (this.settingsDistance < 0) {
                assert (this.proxiesDistance < 0);
                assert (this.proxyDistance < 0);
                if (string3.equals(SETTINGS)) {
                    this.settingsDistance = 0;
                }
            } else if (this.settingsDistance == 0 && this.proxiesDistance < 0) {
                assert (this.proxyDistance < 0);
                if (string3.equals(PROXIES)) {
                    this.proxiesDistance = 0;
                }
                ++this.settingsDistance;
            } else if (this.proxiesDistance == 0 && this.proxyDistance < 0) {
                assert (this.settingsDistance >= 0);
                if (string3.equals(PROXY)) {
                    this.proxyDistance = 0;
                }
                ++this.proxiesDistance;
                ++this.settingsDistance;
            } else {
                if (this.proxyDistance == 0) {
                    this.proxyKey = string3;
                    this.proxyValue = "";
                }
                if (this.proxyDistance >= 0) {
                    ++this.proxyDistance;
                }
                if (this.proxiesDistance >= 0) {
                    ++this.proxiesDistance;
                }
                ++this.settingsDistance;
            }
        }

        @Override
        public void characters(char[] cArray, int n, int n2) {
            if (this.proxyDistance == 1) {
                this.proxyValue = this.proxyValue + new String(cArray, n, n2);
            }
        }

        @Override
        public void endElement(String string, String string2, String string3) {
            if (this.proxyDistance == 1) {
                this.current.put(this.proxyKey, this.proxyValue);
                this.proxyKey = "";
                this.proxyValue = "";
            }
            if (this.proxiesDistance == 1) {
                this.proxies.add(Collections.unmodifiableMap(new HashMap<String, String>(this.current)));
                this.current = new HashMap();
            }
            if (this.proxyDistance == 0 && string3.equals(PROXY)) {
                this.proxyDistance = -1;
            } else if (this.proxyDistance > 0) {
                --this.proxyDistance;
            }
            if (this.proxiesDistance == 0 && string3.equals(PROXIES)) {
                this.proxiesDistance = -1;
            } else if (this.proxiesDistance > 0) {
                --this.proxiesDistance;
            }
            if (this.settingsDistance == 0 && string3.equals(SETTINGS)) {
                this.settingsDistance = -1;
            } else if (this.settingsDistance > 0) {
                --this.settingsDistance;
            }
        }

        public List<Map<String, String>> getProxies() {
            return Collections.unmodifiableList(new ArrayList<Map<String, String>>(this.proxies));
        }
    }
}

