/*
 * Decompiled with CFR 0.152.
 */
package coursier.util.shaded.org.jsoup.select;

import coursier.util.shaded.org.jsoup.nodes.Element;
import coursier.util.shaded.org.jsoup.nodes.Node;
import coursier.util.shaded.org.jsoup.select.Elements;
import coursier.util.shaded.org.jsoup.select.Evaluator;
import coursier.util.shaded.org.jsoup.select.NodeFilter;
import coursier.util.shaded.org.jsoup.select.NodeTraversor;
import coursier.util.shaded.org.jsoup.select.NodeVisitor;
import javax.annotation.Nullable;

public class Collector {
    private Collector() {
    }

    public static Elements collect(Evaluator eval, Element root) {
        Elements elements = new Elements();
        NodeTraversor.traverse((NodeVisitor)new Accumulator(root, elements, eval), root);
        return elements;
    }

    @Nullable
    public static Element findFirst(Evaluator eval, Element root) {
        FirstFinder finder = new FirstFinder(eval);
        return finder.find(root, root);
    }

    private static class Accumulator
    implements NodeVisitor {
        private final Element root;
        private final Elements elements;
        private final Evaluator eval;

        Accumulator(Element root, Elements elements, Evaluator eval) {
            this.root = root;
            this.elements = elements;
            this.eval = eval;
        }

        @Override
        public void head(Node node, int depth) {
            Element el;
            if (node instanceof Element && this.eval.matches(this.root, el = (Element)node)) {
                this.elements.add(el);
            }
        }

        @Override
        public void tail(Node node, int depth) {
        }
    }

    static class FirstFinder
    implements NodeFilter {
        @Nullable
        private Element evalRoot = null;
        @Nullable
        private Element match = null;
        private final Evaluator eval;

        FirstFinder(Evaluator eval) {
            this.eval = eval;
        }

        @Nullable
        Element find(Element root, Element start) {
            this.evalRoot = root;
            this.match = null;
            NodeTraversor.filter((NodeFilter)this, start);
            return this.match;
        }

        @Override
        public NodeFilter.FilterResult head(Node node, int depth) {
            Element el;
            if (node instanceof Element && this.eval.matches(this.evalRoot, el = (Element)node)) {
                this.match = el;
                return NodeFilter.FilterResult.STOP;
            }
            return NodeFilter.FilterResult.CONTINUE;
        }

        @Override
        public NodeFilter.FilterResult tail(Node node, int depth) {
            return NodeFilter.FilterResult.CONTINUE;
        }
    }
}

