/*
 * Decompiled with CFR 0.152.
 */
package coursier.util.shaded.org.jsoup.parser;

import coursier.util.shaded.org.jsoup.internal.StringUtil;
import coursier.util.shaded.org.jsoup.parser.HtmlTreeBuilder;
import coursier.util.shaded.org.jsoup.parser.ParseSettings;
import coursier.util.shaded.org.jsoup.parser.TagSet;
import coursier.util.shaded.org.jsoup.parser.TokeniserState;
import java.util.Objects;
import org.jspecify.annotations.Nullable;

public class Tag
implements Cloneable {
    public static int Known = 1;
    public static int Void = 2;
    public static int Block = 4;
    public static int InlineContainer = 8;
    public static int SelfClose = 16;
    public static int SeenSelfClose = 32;
    public static int PreserveWhitespace = 64;
    public static int RcData = 128;
    public static int Data = 256;
    public static int FormSubmittable = 512;
    String namespace;
    String tagName;
    String normalName;
    int options = 0;

    public Tag(String tagName, String namespace) {
        this(tagName, ParseSettings.normalName(tagName), namespace);
    }

    public Tag(String tagName) {
        this(tagName, ParseSettings.normalName(tagName), "http://www.w3.org/1999/xhtml");
    }

    Tag(String tagName, String normalName, String namespace) {
        this.tagName = tagName;
        this.normalName = normalName;
        this.namespace = namespace;
    }

    public String getName() {
        return this.tagName;
    }

    public String name() {
        return this.tagName;
    }

    public Tag name(String tagName) {
        this.tagName = tagName;
        this.normalName = ParseSettings.normalName(tagName);
        return this;
    }

    public String prefix() {
        int pos = this.tagName.indexOf(58);
        if (pos == -1) {
            return "";
        }
        return this.tagName.substring(0, pos);
    }

    public String localName() {
        int pos = this.tagName.indexOf(58);
        if (pos == -1) {
            return this.tagName;
        }
        return this.tagName.substring(pos + 1);
    }

    public String normalName() {
        return this.normalName;
    }

    public String namespace() {
        return this.namespace;
    }

    public Tag namespace(String namespace) {
        this.namespace = namespace;
        return this;
    }

    public Tag set(int option) {
        this.options |= option;
        this.options |= Known;
        return this;
    }

    public boolean is(int option) {
        return (this.options & option) != 0;
    }

    public Tag clear(int option) {
        this.options &= ~option;
        if (option != Known) {
            this.options |= Known;
        }
        return this;
    }

    public static Tag valueOf(String tagName, String namespace, ParseSettings settings) {
        return TagSet.Html().valueOf(tagName, ParseSettings.normalName(tagName), namespace, settings.preserveTagCase());
    }

    public static Tag valueOf(String tagName) {
        return Tag.valueOf(tagName, "http://www.w3.org/1999/xhtml", ParseSettings.preserveCase);
    }

    public static Tag valueOf(String tagName, ParseSettings settings) {
        return Tag.valueOf(tagName, "http://www.w3.org/1999/xhtml", settings);
    }

    public boolean isBlock() {
        return (this.options & Block) != 0;
    }

    @Deprecated
    public boolean formatAsBlock() {
        return (this.options & InlineContainer) != 0;
    }

    public boolean isInline() {
        return (this.options & Block) == 0;
    }

    public boolean isEmpty() {
        return (this.options & Void) != 0;
    }

    public boolean isSelfClosing() {
        return (this.options & SelfClose) != 0 || (this.options & Void) != 0;
    }

    public boolean isKnownTag() {
        return (this.options & Known) != 0;
    }

    public static boolean isKnownTag(String tagName) {
        return TagSet.HtmlTagSet.get(tagName, "http://www.w3.org/1999/xhtml") != null;
    }

    public boolean preserveWhitespace() {
        return (this.options & PreserveWhitespace) != 0;
    }

    @Deprecated
    public boolean isFormListed() {
        return this.namespace.equals("http://www.w3.org/1999/xhtml") && StringUtil.inSorted(this.normalName, HtmlTreeBuilder.TagFormListed);
    }

    public boolean isFormSubmittable() {
        return (this.options &= FormSubmittable) != 0;
    }

    void setSeenSelfClose() {
        this.options |= SeenSelfClose;
    }

    @Nullable TokeniserState textState() {
        if (this.is(RcData)) {
            return TokeniserState.Rcdata;
        }
        if (this.is(Data)) {
            return TokeniserState.Rawtext;
        }
        return null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Tag)) {
            return false;
        }
        Tag tag = (Tag)o;
        return Objects.equals(this.tagName, tag.tagName) && Objects.equals(this.namespace, tag.namespace) && Objects.equals(this.normalName, tag.normalName) && this.options == tag.options;
    }

    public int hashCode() {
        return Objects.hash(this.tagName, this.namespace, this.normalName, this.options);
    }

    public String toString() {
        return this.tagName;
    }

    protected Tag clone() {
        try {
            return (Tag)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }
}

