/*
 * Decompiled with CFR 0.152.
 */
package coursier.util.shaded.org.jsoup.parser;

import coursier.util.shaded.org.jsoup.helper.Validate;
import coursier.util.shaded.org.jsoup.internal.StringUtil;
import coursier.util.shaded.org.jsoup.parser.CharacterReader;

public class TokenQueue {
    private static final char Esc = '\\';
    private static final char Hyphen_Minus = '-';
    private static final char Unicode_Null = '\u0000';
    private static final char Replacement = '\ufffd';
    private final CharacterReader reader;
    private static final char[] ElementSelectorChars = new char[]{'*', '|', '_', '-'};
    private static final char[] CssIdentifierChars = new char[]{'-', '_'};

    public TokenQueue(String data) {
        this.reader = new CharacterReader(data);
    }

    public boolean isEmpty() {
        return this.reader.isEmpty();
    }

    public char consume() {
        return this.reader.consume();
    }

    public void advance() {
        if (!this.isEmpty()) {
            this.reader.advance();
        }
    }

    char current() {
        return this.reader.current();
    }

    @Deprecated
    public void addFirst(String seq) {
        throw new UnsupportedOperationException("addFirst() not supported");
    }

    public boolean matches(String seq) {
        return this.reader.matchesIgnoreCase(seq);
    }

    public boolean matches(char c) {
        return this.reader.matches(c);
    }

    @Deprecated
    public boolean matchesAny(String ... seq) {
        for (String s : seq) {
            if (!this.matches(s)) continue;
            return true;
        }
        return false;
    }

    public boolean matchesAny(char ... seq) {
        return this.reader.matchesAny(seq);
    }

    public boolean matchChomp(String seq) {
        return this.reader.matchConsumeIgnoreCase(seq);
    }

    public boolean matchChomp(char c) {
        if (this.reader.matches(c)) {
            this.consume();
            return true;
        }
        return false;
    }

    public boolean matchesWhitespace() {
        return StringUtil.isWhitespace(this.reader.current());
    }

    public boolean matchesWord() {
        return Character.isLetterOrDigit(this.reader.current());
    }

    public void consume(String seq) {
        boolean found = this.reader.matchConsumeIgnoreCase(seq);
        if (!found) {
            throw new IllegalStateException("Queue did not match expected sequence");
        }
    }

    public String consumeTo(String seq) {
        return this.reader.consumeTo(seq);
    }

    @Deprecated
    public String consumeToIgnoreCase(String seq) {
        StringBuilder sb = StringUtil.borrowBuilder();
        while (!this.isEmpty() && !this.reader.matchesIgnoreCase(seq)) {
            sb.append(this.consume());
        }
        return StringUtil.releaseBuilder(sb);
    }

    public String consumeToAny(String ... seq) {
        StringBuilder sb = StringUtil.borrowBuilder();
        block0: while (!this.isEmpty()) {
            for (String s : seq) {
                if (this.reader.matchesIgnoreCase(s)) break block0;
            }
            sb.append(this.consume());
        }
        return StringUtil.releaseBuilder(sb);
    }

    @Deprecated
    public String chompTo(String seq) {
        String data = this.reader.consumeTo(seq);
        this.matchChomp(seq);
        return data;
    }

    @Deprecated
    public String chompToIgnoreCase(String seq) {
        String data = this.consumeToIgnoreCase(seq);
        this.matchChomp(seq);
        return data;
    }

    public String chompBalanced(char open, char close) {
        StringBuilder accum = StringUtil.borrowBuilder();
        int depth = 0;
        int last = 0;
        boolean inSingleQuote = false;
        boolean inDoubleQuote = false;
        boolean inRegexQE = false;
        this.reader.mark();
        while (!this.isEmpty()) {
            block17: {
                char c;
                block18: {
                    block15: {
                        block16: {
                            c = this.consume();
                            if (last == 92) break block15;
                            if (c == '\'' && c != open && !inDoubleQuote) {
                                inSingleQuote = !inSingleQuote;
                            } else if (c == '\"' && c != open && !inSingleQuote) {
                                boolean bl = inDoubleQuote = !inDoubleQuote;
                            }
                            if (!inSingleQuote && !inDoubleQuote && !inRegexQE) break block16;
                            accum.append(c);
                            last = c;
                            break block17;
                        }
                        if (c == open) {
                            if (++depth > 1) {
                                accum.append(c);
                            }
                        } else if (c == close) {
                            if (--depth > 0) {
                                accum.append(c);
                            }
                        } else {
                            accum.append(c);
                        }
                        break block18;
                    }
                    if (c == 'Q') {
                        inRegexQE = true;
                        accum.append(c);
                    } else if (c == 'E') {
                        inRegexQE = false;
                        accum.append(c);
                    } else {
                        accum.append(c);
                    }
                }
                last = c;
            }
            if (depth > 0) continue;
        }
        String out = StringUtil.releaseBuilder(accum);
        if (depth > 0) {
            this.reader.rewindToMark();
            Validate.fail("Did not find balanced marker at '" + out + "'");
        }
        return out;
    }

    public static String unescape(String in) {
        if (in.indexOf(92) == -1) {
            return in;
        }
        StringBuilder out = StringUtil.borrowBuilder();
        char last = '\u0000';
        for (char c : in.toCharArray()) {
            if (c == '\\') {
                if (last == '\\') {
                    out.append(c);
                    c = '\u0000';
                }
            } else {
                out.append(c);
            }
            last = c;
        }
        return StringUtil.releaseBuilder(out);
    }

    public static String escapeCssIdentifier(String in) {
        if (in.isEmpty()) {
            return in;
        }
        StringBuilder out = StringUtil.borrowBuilder();
        TokenQueue q = new TokenQueue(in);
        char firstChar = q.current();
        if (firstChar == '-') {
            q.advance();
            if (q.isEmpty()) {
                TokenQueue.appendEscaped(out, '-');
            } else {
                out.append('-');
                char secondChar = q.current();
                if (StringUtil.isDigit(secondChar)) {
                    TokenQueue.appendEscapedCodepoint(out, q.consume());
                }
            }
        } else if (StringUtil.isDigit(firstChar)) {
            TokenQueue.appendEscapedCodepoint(out, q.consume());
        }
        while (!q.isEmpty()) {
            char c = q.consume();
            if (c == '\u0000') {
                out.append('\ufffd');
                continue;
            }
            if (c <= '\u001f' || c == '\u007f') {
                TokenQueue.appendEscapedCodepoint(out, c);
                continue;
            }
            if (TokenQueue.isIdent(c)) {
                out.append(c);
                continue;
            }
            TokenQueue.appendEscaped(out, c);
        }
        return StringUtil.releaseBuilder(out);
    }

    private static void appendEscaped(StringBuilder out, char c) {
        out.append('\\').append(c);
    }

    private static void appendEscapedCodepoint(StringBuilder out, char c) {
        out.append('\\').append(Integer.toHexString(c)).append(' ');
    }

    public boolean consumeWhitespace() {
        boolean seen = false;
        while (this.matchesWhitespace()) {
            this.advance();
            seen = true;
        }
        return seen;
    }

    @Deprecated
    public String consumeWord() {
        return this.reader.consumeMatching(Character::isLetterOrDigit);
    }

    public String consumeElementSelector() {
        return this.consumeEscapedCssIdentifier(ElementSelectorChars);
    }

    public String consumeCssIdentifier() {
        if (this.isEmpty()) {
            throw new IllegalArgumentException("CSS identifier expected, but end of input found");
        }
        String identifier = this.reader.consumeMatching(TokenQueue::isIdent);
        char c = this.current();
        if (c != '\\' && c != '\u0000') {
            return identifier;
        }
        StringBuilder out = StringUtil.borrowBuilder();
        if (!identifier.isEmpty()) {
            out.append(identifier);
        }
        while (!this.isEmpty()) {
            c = this.current();
            if (TokenQueue.isIdent(c)) {
                out.append(this.consume());
                continue;
            }
            if (c == '\u0000') {
                this.advance();
                out.append('\ufffd');
                continue;
            }
            if (c != '\\') break;
            this.advance();
            if (!this.isEmpty() && TokenQueue.isNewline(this.current())) {
                this.reader.unconsume();
                break;
            }
            this.consumeCssEscapeSequenceInto(out);
        }
        return StringUtil.releaseBuilder(out);
    }

    private void consumeCssEscapeSequenceInto(StringBuilder out) {
        if (this.isEmpty()) {
            out.append('\ufffd');
            return;
        }
        char firstEscaped = this.consume();
        if (!StringUtil.isHexDigit(firstEscaped)) {
            out.append(firstEscaped);
        } else {
            int codePoint;
            this.reader.unconsume();
            String hexString = this.reader.consumeMatching(StringUtil::isHexDigit, 6);
            try {
                codePoint = Integer.parseInt(hexString, 16);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Invalid escape sequence: " + hexString, e);
            }
            if (TokenQueue.isValidCodePoint(codePoint)) {
                out.appendCodePoint(codePoint);
            } else {
                out.append('\ufffd');
            }
            if (!this.isEmpty()) {
                char c = this.current();
                if (c == '\r') {
                    this.advance();
                    if (!this.isEmpty() && this.current() == '\n') {
                        this.advance();
                    }
                } else if (c == ' ' || c == '\t' || TokenQueue.isNewline(c)) {
                    this.advance();
                }
            }
        }
    }

    private static boolean isNonAscii(char c) {
        return c >= '\u0080';
    }

    private static boolean isIdentStart(char c) {
        return c == '_' || StringUtil.isAsciiLetter(c) || TokenQueue.isNonAscii(c);
    }

    private static boolean isIdent(char c) {
        return c == '-' || StringUtil.isDigit(c) || TokenQueue.isIdentStart(c);
    }

    private static boolean isNewline(char c) {
        return c == '\n' || c == '\r' || c == '\f';
    }

    private static boolean isValidCodePoint(int codePoint) {
        return codePoint != 0 && Character.isValidCodePoint(codePoint) && !Character.isSurrogate((char)codePoint);
    }

    private String consumeEscapedCssIdentifier(char ... matches) {
        StringBuilder sb = StringUtil.borrowBuilder();
        while (!this.isEmpty()) {
            char c = this.current();
            if (c == '\\') {
                this.advance();
                if (this.isEmpty()) break;
                sb.append(this.consume());
                continue;
            }
            if (!this.matchesCssIdentifier(matches)) break;
            sb.append(c);
            this.advance();
        }
        return StringUtil.releaseBuilder(sb);
    }

    private boolean matchesCssIdentifier(char ... matches) {
        return this.matchesWord() || this.reader.matchesAny(matches);
    }

    public String remainder() {
        return this.reader.consumeToEnd();
    }

    public String toString() {
        return this.reader.toString();
    }
}

