/*
 * Decompiled with CFR 0.152.
 */
package coursier.util.shaded.org.jsoup.parser;

import coursier.util.shaded.org.jsoup.helper.Validate;
import coursier.util.shaded.org.jsoup.nodes.Attribute;
import coursier.util.shaded.org.jsoup.nodes.Attributes;
import coursier.util.shaded.org.jsoup.nodes.CDataNode;
import coursier.util.shaded.org.jsoup.nodes.Comment;
import coursier.util.shaded.org.jsoup.nodes.DataNode;
import coursier.util.shaded.org.jsoup.nodes.Document;
import coursier.util.shaded.org.jsoup.nodes.DocumentType;
import coursier.util.shaded.org.jsoup.nodes.Element;
import coursier.util.shaded.org.jsoup.nodes.Entities;
import coursier.util.shaded.org.jsoup.nodes.LeafNode;
import coursier.util.shaded.org.jsoup.nodes.Node;
import coursier.util.shaded.org.jsoup.nodes.TextNode;
import coursier.util.shaded.org.jsoup.nodes.XmlDeclaration;
import coursier.util.shaded.org.jsoup.parser.ParseSettings;
import coursier.util.shaded.org.jsoup.parser.Parser;
import coursier.util.shaded.org.jsoup.parser.Tag;
import coursier.util.shaded.org.jsoup.parser.TagSet;
import coursier.util.shaded.org.jsoup.parser.Token;
import coursier.util.shaded.org.jsoup.parser.TokeniserState;
import coursier.util.shaded.org.jsoup.parser.TreeBuilder;
import coursier.util.shaded.org.jsoup.select.Elements;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayDeque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jspecify.annotations.Nullable;

public class XmlTreeBuilder
extends TreeBuilder {
    static final String XmlnsKey = "xmlns";
    static final String XmlnsPrefix = "xmlns:";
    private final ArrayDeque<HashMap<String, String>> namespacesStack = new ArrayDeque();
    private static final int maxQueueDepth = 256;

    @Override
    ParseSettings defaultSettings() {
        return ParseSettings.preserveCase;
    }

    @Override
    protected void initialiseParse(Reader input, String baseUri, Parser parser) {
        super.initialiseParse(input, baseUri, parser);
        this.doc.outputSettings().syntax(Document.OutputSettings.Syntax.xml).escapeMode(Entities.EscapeMode.xhtml).prettyPrint(false);
        this.namespacesStack.clear();
        HashMap<String, String> ns = new HashMap<String, String>();
        ns.put("xml", "http://www.w3.org/XML/1998/namespace");
        ns.put("", "http://www.w3.org/XML/1998/namespace");
        this.namespacesStack.push(ns);
    }

    @Override
    void initialiseParseFragment(@Nullable Element context) {
        super.initialiseParseFragment(context);
        if (context == null) {
            return;
        }
        TokeniserState textState = context.tag().textState();
        if (textState != null) {
            this.tokeniser.transition(textState);
        }
        Elements chain = context.parents();
        chain.add(0, context);
        for (int i = chain.size() - 1; i >= 0; --i) {
            Element el = (Element)chain.get(i);
            HashMap<String, String> namespaces = new HashMap<String, String>((Map)this.namespacesStack.peek());
            this.namespacesStack.push(namespaces);
            if (el.attributesSize() <= 0) continue;
            XmlTreeBuilder.processNamespaces(el.attributes(), namespaces);
        }
    }

    Document parse(Reader input, String baseUri) {
        return this.parse(input, baseUri, new Parser(this));
    }

    Document parse(String input, String baseUri) {
        return this.parse(new StringReader(input), baseUri, new Parser(this));
    }

    @Override
    List<Node> completeParseFragment() {
        return this.doc.childNodes();
    }

    @Override
    XmlTreeBuilder newInstance() {
        return new XmlTreeBuilder();
    }

    @Override
    public String defaultNamespace() {
        return "http://www.w3.org/XML/1998/namespace";
    }

    @Override
    TagSet defaultTagSet() {
        return new TagSet();
    }

    @Override
    protected boolean process(Token token) {
        this.currentToken = token;
        switch (token.type) {
            case StartTag: {
                this.insertElementFor(token.asStartTag());
                break;
            }
            case EndTag: {
                this.popStackToClose(token.asEndTag());
                break;
            }
            case Comment: {
                this.insertCommentFor(token.asComment());
                break;
            }
            case Character: {
                this.insertCharacterFor(token.asCharacter());
                break;
            }
            case Doctype: {
                this.insertDoctypeFor(token.asDoctype());
                break;
            }
            case XmlDecl: {
                this.insertXmlDeclarationFor(token.asXmlDecl());
                break;
            }
            case EOF: {
                break;
            }
            default: {
                Validate.fail("Unexpected token type: " + (Object)((Object)token.type));
            }
        }
        return true;
    }

    void insertElementFor(Token.StartTag startTag) {
        HashMap<String, String> namespaces = new HashMap<String, String>((Map)this.namespacesStack.peek());
        this.namespacesStack.push(namespaces);
        Attributes attributes = startTag.attributes;
        if (attributes != null) {
            attributes.deduplicate(this.settings);
            XmlTreeBuilder.processNamespaces(attributes, namespaces);
            XmlTreeBuilder.applyNamespacesToAttributes(attributes, namespaces);
        }
        String tagName = startTag.tagName.value();
        String ns = XmlTreeBuilder.resolveNamespace(tagName, namespaces);
        Tag tag = this.tagFor(tagName, startTag.normalName, ns, this.settings);
        Element el = new Element(tag, null, this.settings.normalizeAttributes(attributes));
        this.currentElement().appendChild(el);
        this.push(el);
        if (startTag.isSelfClosing()) {
            tag.setSeenSelfClose();
            this.pop();
        } else if (tag.isEmpty()) {
            this.pop();
        } else {
            TokeniserState textState = tag.textState();
            if (textState != null) {
                this.tokeniser.transition(textState);
            }
        }
    }

    private static void processNamespaces(Attributes attributes, HashMap<String, String> namespaces) {
        for (Attribute attr : attributes) {
            String key = attr.getKey();
            String value = attr.getValue();
            if (key.equals(XmlnsKey)) {
                namespaces.put("", value);
                continue;
            }
            if (!key.startsWith(XmlnsPrefix)) continue;
            String nsPrefix = key.substring(XmlnsPrefix.length());
            namespaces.put(nsPrefix, value);
        }
    }

    private static void applyNamespacesToAttributes(Attributes attributes, HashMap<String, String> namespaces) {
        HashMap<String, String> attrPrefix = new HashMap<String, String>();
        for (Attribute attribute : attributes) {
            String ns;
            String prefix = attribute.prefix();
            if (prefix.isEmpty() || prefix.equals(XmlnsKey) || (ns = namespaces.get(prefix)) == null) continue;
            attrPrefix.put("jsoup.xmlns-" + prefix, ns);
        }
        for (Map.Entry<String, String> entry : attrPrefix.entrySet()) {
            attributes.userData(entry.getKey(), entry.getValue());
        }
    }

    private static String resolveNamespace(String tagName, HashMap<String, String> namespaces) {
        String prefix;
        String ns = namespaces.get("");
        int pos = tagName.indexOf(58);
        if (pos > 0 && namespaces.containsKey(prefix = tagName.substring(0, pos))) {
            ns = namespaces.get(prefix);
        }
        return ns;
    }

    void insertLeafNode(LeafNode node) {
        this.currentElement().appendChild(node);
        this.onNodeInserted(node);
    }

    void insertCommentFor(Token.Comment commentToken) {
        Comment comment = new Comment(commentToken.getData());
        this.insertLeafNode(comment);
    }

    void insertCharacterFor(Token.Character token) {
        String data = token.getData();
        LeafNode node = token.isCData() ? new CDataNode(data) : (this.currentElement().tag().is(Tag.Data) ? new DataNode(data) : new TextNode(data));
        this.insertLeafNode(node);
    }

    void insertDoctypeFor(Token.Doctype token) {
        DocumentType doctypeNode = new DocumentType(this.settings.normalizeTag(token.getName()), token.getPublicIdentifier(), token.getSystemIdentifier());
        doctypeNode.setPubSysKey(token.getPubSysKey());
        this.insertLeafNode(doctypeNode);
    }

    void insertXmlDeclarationFor(Token.XmlDecl token) {
        XmlDeclaration decl = new XmlDeclaration(token.name(), token.isDeclaration);
        if (token.attributes != null) {
            decl.attributes().addAll(token.attributes);
        }
        this.insertLeafNode(decl);
    }

    @Override
    Element pop() {
        this.namespacesStack.pop();
        return super.pop();
    }

    protected void popStackToClose(Token.EndTag endTag) {
        Element next;
        int pos;
        String elName = this.settings.normalizeTag(endTag.name());
        Element firstFound = null;
        int bottom = this.stack.size() - 1;
        int upper = bottom >= 256 ? bottom - 256 : 0;
        for (pos = this.stack.size() - 1; pos >= upper; --pos) {
            next = (Element)this.stack.get(pos);
            if (!next.nodeName().equals(elName)) continue;
            firstFound = next;
            break;
        }
        if (firstFound == null) {
            return;
        }
        for (pos = this.stack.size() - 1; pos >= 0 && (next = this.pop()) != firstFound; --pos) {
        }
    }
}

