/*
 * Decompiled with CFR 0.152.
 */
package coursierapi;

import coursierapi.Cache;
import coursierapi.Dependency;
import coursierapi.FetchResult;
import coursierapi.Repository;
import coursierapi.ResolutionParams;
import coursierapi.error.CoursierError;
import coursierapi.shaded.coursier.internal.api.ApiHelper;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

public final class Fetch {
    private final List<Dependency> dependencies = new ArrayList<Dependency>();
    private final List<Repository> repositories = new ArrayList<Repository>(Arrays.asList(ApiHelper.defaultRepositories()));
    private Cache cache = Cache.create();
    private Boolean mainArtifacts = null;
    private final Set<String> classifiers = new HashSet<String>();
    private Set<String> artifactTypes = null;
    private File fetchCache = null;
    private ResolutionParams resolutionParams = ResolutionParams.create();

    private Fetch() {
    }

    public boolean equals(Object object) {
        if (object instanceof Fetch) {
            Fetch fetch = (Fetch)object;
            return this.dependencies.equals(fetch.dependencies) && this.repositories.equals(fetch.repositories) && this.cache.equals(fetch.cache) && Objects.equals(this.mainArtifacts, fetch.mainArtifacts) && this.classifiers.equals(fetch.classifiers) && Objects.equals(this.artifactTypes, fetch.artifactTypes) && Objects.equals(this.fetchCache, fetch.fetchCache) && this.resolutionParams.equals(fetch.resolutionParams);
        }
        return false;
    }

    public int hashCode() {
        return 37 * (37 * (37 * (37 * (37 * (37 * (37 * (17 + this.dependencies.hashCode()) + this.repositories.hashCode()) + this.cache.hashCode()) + Objects.hashCode(this.mainArtifacts)) + this.classifiers.hashCode()) + Objects.hashCode(this.fetchCache)) + this.resolutionParams.hashCode()) + Objects.hashCode(this.artifactTypes);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("Fetch(dependencies=[");
        for (Dependency iterator : this.dependencies) {
            stringBuilder.append(iterator.toString());
            stringBuilder.append(", ");
        }
        stringBuilder.append("], repositories=[");
        for (Repository repository : this.repositories) {
            stringBuilder.append(repository.toString());
            stringBuilder.append(", ");
        }
        stringBuilder.append("], cache=");
        stringBuilder.append(this.cache.toString());
        if (this.mainArtifacts != null) {
            stringBuilder.append(", mainArtifacts=");
            stringBuilder.append(this.mainArtifacts.toString());
        }
        stringBuilder.append(", classifiers=[");
        for (String string : this.classifiers) {
            stringBuilder.append(string);
            stringBuilder.append(", ");
        }
        stringBuilder.append("]");
        if (this.artifactTypes != null) {
            stringBuilder.append(", artifactTypes=[");
            boolean bl = true;
            for (String string : this.artifactTypes) {
                if (bl) {
                    bl = false;
                } else {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(string);
            }
            stringBuilder.append("]");
        }
        if (this.fetchCache != null) {
            stringBuilder.append(", fetchCache=");
            stringBuilder.append(this.fetchCache.toString());
        }
        stringBuilder.append(", resolutionParams=");
        stringBuilder.append(this.resolutionParams.toString());
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    public static Fetch create() {
        return new Fetch();
    }

    public Fetch addDependencies(Dependency ... dependencyArray) {
        this.dependencies.addAll(Arrays.asList(dependencyArray));
        return this;
    }

    public Fetch withDependencies(Dependency ... dependencyArray) {
        this.dependencies.clear();
        this.dependencies.addAll(Arrays.asList(dependencyArray));
        return this;
    }

    public Fetch addRepositories(Repository ... repositoryArray) {
        this.repositories.addAll(Arrays.asList(repositoryArray));
        return this;
    }

    public Fetch withRepositories(Repository ... repositoryArray) {
        this.repositories.clear();
        this.repositories.addAll(Arrays.asList(repositoryArray));
        return this;
    }

    public Fetch withCache(Cache cache) {
        this.cache = cache;
        return this;
    }

    public Fetch withMainArtifacts(Boolean bl) {
        this.mainArtifacts = bl;
        return this;
    }

    public Fetch withMainArtifacts(boolean bl) {
        this.mainArtifacts = bl;
        return this;
    }

    public Fetch withMainArtifacts() {
        this.mainArtifacts = true;
        return this;
    }

    public Fetch withClassifiers(Set<String> set) {
        this.classifiers.clear();
        this.classifiers.addAll(set);
        return this;
    }

    public Fetch addClassifiers(String ... stringArray) {
        this.classifiers.addAll(Arrays.asList(stringArray));
        return this;
    }

    public Fetch withArtifactTypes(Set<String> set) {
        this.artifactTypes = set == null ? null : new HashSet<String>(set);
        return this;
    }

    public Fetch addArtifactTypes(String ... stringArray) {
        if (this.artifactTypes == null) {
            this.artifactTypes = new HashSet<String>();
        }
        this.artifactTypes.addAll(Arrays.asList(stringArray));
        return this;
    }

    public Fetch withFetchCache(File file) {
        this.fetchCache = file;
        return this;
    }

    public Fetch withResolutionParams(ResolutionParams resolutionParams) {
        this.resolutionParams = ResolutionParams.of(resolutionParams);
        return this;
    }

    public List<Dependency> getDependencies() {
        return Collections.unmodifiableList(this.dependencies);
    }

    public List<Repository> getRepositories() {
        return Collections.unmodifiableList(this.repositories);
    }

    public Cache getCache() {
        return this.cache;
    }

    public Boolean getMainArtifacts() {
        return this.mainArtifacts;
    }

    public Set<String> getClassifiers() {
        return Collections.unmodifiableSet(this.classifiers);
    }

    public Set<String> getArtifactTypes() {
        if (this.artifactTypes == null) {
            return null;
        }
        return Collections.unmodifiableSet(this.artifactTypes);
    }

    public File getFetchCache() {
        return this.fetchCache;
    }

    public ResolutionParams getResolutionParams() {
        return this.resolutionParams;
    }

    public List<File> fetch() throws CoursierError {
        FetchResult fetchResult = this.fetchResult();
        return fetchResult.getFiles();
    }

    public FetchResult fetchResult() throws CoursierError {
        return ApiHelper.doFetch(this);
    }
}

