/*
 * Decompiled with CFR 0.152.
 */
package coursierapi.shaded.coursier.cache;

import coursierapi.shaded.coursier.cache.ArtifactError;
import coursierapi.shaded.coursier.cache.ArtifactError$NotFound$;
import coursierapi.shaded.coursier.cache.CacheDefaults$;
import coursierapi.shaded.coursier.cache.CacheLocks$;
import coursierapi.shaded.coursier.cache.CacheLogger;
import coursierapi.shaded.coursier.cache.CacheLogger$;
import coursierapi.shaded.coursier.cache.CacheUrl$;
import coursierapi.shaded.coursier.cache.FileCache;
import coursierapi.shaded.coursier.core.Authentication;
import coursierapi.shaded.coursier.credentials.DirectCredentials;
import coursierapi.shaded.coursier.paths.CachePath;
import coursierapi.shaded.coursier.util.Sync;
import coursierapi.shaded.coursier.util.Task$;
import coursierapi.shaded.scala.$less$colon$less$;
import coursierapi.shaded.scala.Array$;
import coursierapi.shaded.scala.Function0;
import coursierapi.shaded.scala.Function1;
import coursierapi.shaded.scala.MatchError;
import coursierapi.shaded.scala.None$;
import coursierapi.shaded.scala.Option;
import coursierapi.shaded.scala.Option$;
import coursierapi.shaded.scala.Predef$;
import coursierapi.shaded.scala.Some;
import coursierapi.shaded.scala.collection.ArrayOps$;
import coursierapi.shaded.scala.collection.StringOps$;
import coursierapi.shaded.scala.collection.immutable.Seq;
import coursierapi.shaded.scala.collection.immutable.Seq$;
import coursierapi.shaded.scala.concurrent.ExecutionContext;
import coursierapi.shaded.scala.concurrent.Future;
import coursierapi.shaded.scala.package$;
import coursierapi.shaded.scala.reflect.ClassTag$;
import coursierapi.shaded.scala.runtime.BoxesRunTime;
import coursierapi.shaded.scala.runtime.ScalaRunTime$;
import coursierapi.shaded.scala.util.Either;
import coursierapi.shaded.scala.util.Left;
import coursierapi.shaded.scala.util.Right;
import coursierapi.shaded.scala.util.control.NonFatal$;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.HttpURLConnection;
import java.net.URLConnection;
import java.util.Locale;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSocketFactory;

public final class FileCache$ {
    public static final FileCache$ MODULE$ = new FileCache$();
    private static final Seq<String> coursier$cache$FileCache$$checksumHeader = (Seq)Seq$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"MD5", "SHA1", "SHA256"}));

    public File localFile0(String url, File cache, Option<String> user, boolean localArtifactsShouldBeCached) {
        return CachePath.localFile(url, cache, (String)user.orNull($less$colon$less$.MODULE$.refl()), localArtifactsShouldBeCached);
    }

    private String auxiliaryFilePrefix(File file) {
        return new StringBuilder(3).append(".").append(file.getName()).append("__").toString();
    }

    public void coursier$cache$FileCache$$clearAuxiliaryFiles(File file) {
        String prefix = this.auxiliaryFilePrefix(file);
        FilenameFilter filter = new FilenameFilter(prefix){
            private final String prefix$1;

            public boolean accept(File dir, String name) {
                return name.startsWith(this.prefix$1);
            }
            {
                this.prefix$1 = prefix$1;
            }
        };
        ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps(file.getParentFile().listFiles(filter)), (Function1<File, Object> & Serializable)f -> BoxesRunTime.boxToBoolean(f.delete()));
    }

    public File auxiliaryFile(File file, String key) {
        String key0 = StringOps$.MODULE$.filter$extension(Predef$.MODULE$.augmentString(key.toLowerCase(Locale.ROOT)), (Function1<Object, Object> & Serializable)x$45 -> BoxesRunTime.boxToBoolean(FileCache$.$anonfun$auxiliaryFile$1(BoxesRunTime.unboxToChar(x$45))));
        return new File(file.getParentFile(), new StringBuilder(0).append(this.auxiliaryFilePrefix(file)).append(key0).toString());
    }

    public void coursier$cache$FileCache$$readFullyTo(InputStream in, OutputStream out, CacheLogger logger, String url, long alreadyDownloaded, int bufferSize) {
        byte[] b = (byte[])Array$.MODULE$.fill(bufferSize, () -> 0, ClassTag$.MODULE$.Byte());
        this.helper$1(alreadyDownloaded, in, b, out, logger, url);
    }

    public <T> Either<ArtifactError, T> coursier$cache$FileCache$$downloading(String url, File file, int sslRetry, Function0<Either<ArtifactError, T>> f) {
        return this.helper$2(sslRetry, url, f);
    }

    public Either<ArtifactError, Option<Object>> coursier$cache$FileCache$$contentLength(String url, Option<Authentication> authentication, boolean followHttpToHttpsRedirections, boolean followHttpsToHttpRedirections, Seq<DirectCredentials> credentials, Option<SSLSocketFactory> sslSocketFactoryOpt, Option<HostnameVerifier> hostnameVerifierOpt, CacheLogger logger, Option<Object> maxRedirectionsOpt) {
        Left<ArtifactError, Option<Object>> left;
        block10: {
            URLConnection conn = null;
            try {
                Either either;
                URLConnection uRLConnection = conn = CacheUrl$.MODULE$.urlConnection(url, authentication, followHttpToHttpsRedirections, followHttpsToHttpRedirections, credentials, sslSocketFactoryOpt, hostnameVerifierOpt, "HEAD", maxRedirectionsOpt);
                if (uRLConnection instanceof HttpURLConnection) {
                    Right right;
                    HttpURLConnection httpURLConnection = (HttpURLConnection)uRLConnection;
                    logger.gettingLength(url);
                    boolean success = false;
                    try {
                        Option<Object> len = new Some<Long>(BoxesRunTime.boxToLong(httpURLConnection.getContentLengthLong())).filter(x$47 -> x$47 >= 0L);
                        success = true;
                        logger.gettingLengthResult(url, len);
                        right = package$.MODULE$.Right().apply(len);
                    }
                    finally {
                        if (!success) {
                            logger.gettingLengthResult(url, None$.MODULE$);
                        }
                    }
                    either = right;
                } else {
                    either = package$.MODULE$.Left().apply(new ArtifactError.DownloadError(new StringBuilder(42).append("Cannot do HEAD request with connection ").append(uRLConnection).append(" (").append(url).append(")").toString(), None$.MODULE$));
                }
                left = either;
            }
            catch (Throwable throwable) {
                if (conn != null) {
                    CacheUrl$.MODULE$.closeConn(conn);
                }
                throw throwable;
            }
            if (conn == null) break block10;
            CacheUrl$.MODULE$.closeConn(conn);
        }
        return left;
    }

    public <F> FileCache<F> apply(Sync<F> S) {
        return new FileCache<F>(new FileCache.Params<F>(CacheDefaults$.MODULE$.location(), CacheDefaults$.MODULE$.cachePolicies(), CacheDefaults$.MODULE$.checksums(), CacheDefaults$.MODULE$.credentials(), CacheLogger$.MODULE$.nop(), CacheDefaults$.MODULE$.pool(), CacheDefaults$.MODULE$.ttl(), false, true, false, CacheDefaults$.MODULE$.maxRedirections(), CacheDefaults$.MODULE$.sslRetryCount(), None$.MODULE$, None$.MODULE$, CacheDefaults$.MODULE$.defaultRetryCount(), CacheDefaults$.MODULE$.bufferSize(), S));
    }

    public <F> Sync<Function1<ExecutionContext, Future<Object>>> apply$default$1() {
        return Task$.MODULE$.sync();
    }

    public Seq<String> coursier$cache$FileCache$$checksumHeader() {
        return coursier$cache$FileCache$$checksumHeader;
    }

    public static final /* synthetic */ boolean $anonfun$auxiliaryFile$1(char x$45) {
        return x$45 != '-';
    }

    private final void helper$1(long count, InputStream in$1, byte[] b$1, OutputStream out$1, CacheLogger logger$2, String url$6) {
        int read;
        while ((read = in$1.read(b$1)) >= 0) {
            out$1.write(b$1, 0, read);
            out$1.flush();
            logger$2.downloadProgress(url$6, count + (long)read);
            count += (long)read;
        }
    }

    private final Either helper$2(int retry, String url$7, Function0 f$4) {
        Either res;
        Option option;
        block7: {
            while (true) {
                Option resOpt;
                Option option2;
                try {
                    Option res0 = CacheLocks$.MODULE$.withUrlLock(url$7, (Function0<Either> & Serializable)() -> {
                        Left left;
                        try {
                            left = (Left)f$4.apply();
                        }
                        catch (Throwable throwable) {
                            FileNotFoundException fileNotFoundException;
                            Throwable throwable2 = throwable;
                            if (!(throwable2 instanceof FileNotFoundException) || (fileNotFoundException = (FileNotFoundException)throwable2).getMessage() == null) {
                                throw throwable;
                            }
                            Left left2 = package$.MODULE$.Left().apply(new ArtifactError.NotFound(fileNotFoundException.getMessage(), ArtifactError$NotFound$.MODULE$.$lessinit$greater$default$2()));
                            left = left2;
                        }
                        return left;
                    });
                    Either res2 = (Either)res0.getOrElse((Function0<Left> & Serializable)() -> package$.MODULE$.Left().apply(new ArtifactError.ConcurrentDownload(url$7)));
                    option2 = new Some<Either>(res2);
                }
                catch (Throwable throwable) {
                    Option<Throwable> option3;
                    Option option4;
                    Throwable throwable2 = throwable;
                    if (throwable2 instanceof SSLException && retry >= 1) {
                        option4 = None$.MODULE$;
                    } else if (throwable2 != null && !(option3 = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                        Throwable e = option3.get();
                        option4 = new Some(package$.MODULE$.Left().apply(new ArtifactError.DownloadError(new StringBuilder(26).append("Caught ").append(e).append(Option$.MODULE$.apply(e.getMessage()).fold((Function0<String> & Serializable)() -> "", (Function1<String, String> & Serializable)x$46 -> new StringBuilder(3).append(" (").append((String)x$46).append(")").toString())).append(" while downloading ").append(url$7).toString(), new Some<Throwable>(e))));
                    } else {
                        throw throwable;
                    }
                    option2 = option4;
                }
                option = resOpt = option2;
                if (option instanceof Some) break block7;
                if (!None$.MODULE$.equals(option)) break;
                --retry;
            }
            throw new MatchError(option);
        }
        Option option5 = option;
        Either either = res = (Either)((Some)option5).value();
        return either;
    }

    private FileCache$() {
    }
}

