/*
 * Decompiled with CFR 0.152.
 */
package coursierapi.shaded.coursier.core;

import coursierapi.shaded.coursier.core.Authentication$;
import coursierapi.shaded.scala.Function1;
import coursierapi.shaded.scala.MatchError;
import coursierapi.shaded.scala.Option;
import coursierapi.shaded.scala.Option$;
import coursierapi.shaded.scala.Tuple2;
import coursierapi.shaded.scala.collection.immutable.Seq;
import coursierapi.shaded.scala.runtime.Statics;
import java.io.Serializable;

public final class Authentication {
    private final String user;
    private final Option<String> passwordOpt;
    private final Seq<Tuple2<String, String>> httpHeaders;
    private final boolean optional;
    private final Option<String> realmOpt;
    private final boolean httpsOnly;
    private final boolean passOnRedirect;

    public String user() {
        return this.user;
    }

    public Option<String> passwordOpt() {
        return this.passwordOpt;
    }

    public Seq<Tuple2<String, String>> httpHeaders() {
        return this.httpHeaders;
    }

    public boolean optional() {
        return this.optional;
    }

    public Option<String> realmOpt() {
        return this.realmOpt;
    }

    public boolean httpsOnly() {
        return this.httpsOnly;
    }

    public boolean passOnRedirect() {
        return this.passOnRedirect;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        Object object = obj;
        if (!(object instanceof Authentication)) return false;
        Authentication authentication = (Authentication)object;
        String string = this.user();
        String string2 = authentication.user();
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        Option<String> option = this.passwordOpt();
        Option<String> option2 = authentication.passwordOpt();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        Seq<Tuple2<String, String>> seq = this.httpHeaders();
        Seq<Tuple2<String, String>> seq2 = authentication.httpHeaders();
        if (seq == null) {
            if (seq2 != null) {
                return false;
            }
        } else if (!seq.equals(seq2)) return false;
        if (this.optional() != authentication.optional()) return false;
        Option<String> option3 = this.realmOpt();
        Option<String> option4 = authentication.realmOpt();
        if (option3 == null) {
            if (option4 != null) {
                return false;
            }
        } else if (!option3.equals(option4)) return false;
        if (this.httpsOnly() != authentication.httpsOnly()) return false;
        if (this.passOnRedirect() != authentication.passOnRedirect()) return false;
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public int hashCode() {
        void var1_1;
        int code = 17 + Statics.anyHash("coursierapi.shaded.coursier.core.Authentication");
        code = 37 * code + Statics.anyHash(this.user());
        code = 37 * code + Statics.anyHash(this.passwordOpt());
        code = 37 * code + Statics.anyHash(this.httpHeaders());
        code = 37 * code + (this.optional() ? 1231 : 1237);
        code = 37 * code + Statics.anyHash(this.realmOpt());
        code = 37 * code + (this.httpsOnly() ? 1231 : 1237);
        code = 37 * code + (this.passOnRedirect() ? 1231 : 1237);
        return (int)var1_1;
    }

    public String toString() {
        return new StringBuilder(32).append("Authentication(").append(this.user()).append(", ****, ").append(this.httpHeaders().map((Function1<Tuple2, Tuple2> & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            String k = (String)tuple2._1();
            Tuple2<String, String> tuple22 = new Tuple2<String, String>(k, "****");
            return tuple22;
        })).append(", ").append(this.optional()).append(", ").append(this.realmOpt()).append(", ").append(this.httpsOnly()).append(", ").append(this.passOnRedirect()).append(")").toString();
    }

    private Authentication copy(String user, Option<String> passwordOpt, Seq<Tuple2<String, String>> httpHeaders, boolean optional, Option<String> realmOpt, boolean httpsOnly, boolean passOnRedirect) {
        return new Authentication(user, passwordOpt, httpHeaders, optional, realmOpt, httpsOnly, passOnRedirect);
    }

    private String copy$default$1() {
        return this.user();
    }

    private Option<String> copy$default$2() {
        return this.passwordOpt();
    }

    private Seq<Tuple2<String, String>> copy$default$3() {
        return this.httpHeaders();
    }

    private boolean copy$default$4() {
        return this.optional();
    }

    private Option<String> copy$default$5() {
        return this.realmOpt();
    }

    private boolean copy$default$6() {
        return this.httpsOnly();
    }

    private boolean copy$default$7() {
        return this.passOnRedirect();
    }

    public Authentication withOptional(boolean optional) {
        boolean x$1 = optional;
        String x$2 = this.copy$default$1();
        Option<String> x$3 = this.copy$default$2();
        Seq<Tuple2<String, String>> x$4 = this.copy$default$3();
        Option<String> x$5 = this.copy$default$5();
        boolean x$6 = this.copy$default$6();
        boolean x$7 = this.copy$default$7();
        return this.copy(x$2, x$3, x$4, x$1, x$5, x$6, x$7);
    }

    public Authentication withHttpsOnly(boolean httpsOnly) {
        boolean x$1 = httpsOnly;
        String x$2 = this.copy$default$1();
        Option<String> x$3 = this.copy$default$2();
        Seq<Tuple2<String, String>> x$4 = this.copy$default$3();
        boolean x$5 = this.copy$default$4();
        Option<String> x$6 = this.copy$default$5();
        boolean x$7 = this.copy$default$7();
        return this.copy(x$2, x$3, x$4, x$5, x$6, x$1, x$7);
    }

    public boolean userOnly() {
        Authentication authentication = this;
        Authentication authentication2 = Authentication$.MODULE$.apply(this.user());
        return !(authentication != null ? !((Object)authentication).equals(authentication2) : authentication2 != null);
    }

    public Seq<Tuple2<String, String>> allHttpHeaders() {
        Seq basicAuthHeader = (Seq)Option$.MODULE$.option2Iterable(this.passwordOpt()).toSeq().map((Function1<String, Tuple2> & Serializable)p -> new Tuple2<String, String>("Authorization", new StringBuilder(6).append("Basic ").append(Authentication$.MODULE$.basicAuthenticationEncode(this.user(), (String)p)).toString()));
        return (Seq)basicAuthHeader.$plus$plus(this.httpHeaders());
    }

    public Authentication(String user, Option<String> passwordOpt, Seq<Tuple2<String, String>> httpHeaders, boolean optional, Option<String> realmOpt, boolean httpsOnly, boolean passOnRedirect) {
        this.user = user;
        this.passwordOpt = passwordOpt;
        this.httpHeaders = httpHeaders;
        this.optional = optional;
        this.realmOpt = realmOpt;
        this.httpsOnly = httpsOnly;
        this.passOnRedirect = passOnRedirect;
    }
}

