/*
 * Decompiled with CFR 0.152.
 */
package coursierapi.shaded.coursier.credentials;

import coursierapi.shaded.coursier.core.Authentication;
import coursierapi.shaded.coursier.core.Authentication$;
import coursierapi.shaded.coursier.credentials.Credentials;
import coursierapi.shaded.scala.Function0;
import coursierapi.shaded.scala.Function1;
import coursierapi.shaded.scala.None$;
import coursierapi.shaded.scala.Option;
import coursierapi.shaded.scala.Option$;
import coursierapi.shaded.scala.Some;
import coursierapi.shaded.scala.collection.immutable.Seq;
import coursierapi.shaded.scala.collection.immutable.Seq$;
import coursierapi.shaded.scala.runtime.BoxesRunTime;
import coursierapi.shaded.scala.runtime.ScalaRunTime$;
import coursierapi.shaded.scala.runtime.Statics;
import coursierapi.shaded.scala.util.Try$;
import java.io.Serializable;
import java.net.URI;

public final class DirectCredentials
extends Credentials {
    private final String host;
    private final Option<String> usernameOpt;
    private final Option<String> passwordOpt;
    private final Option<String> realm;
    private final boolean optional;
    private final boolean matchHost;
    private final boolean httpsOnly;
    private final boolean passOnRedirect;

    public String host() {
        return this.host;
    }

    public Option<String> usernameOpt() {
        return this.usernameOpt;
    }

    public Option<String> passwordOpt() {
        return this.passwordOpt;
    }

    public Option<String> realm() {
        return this.realm;
    }

    public boolean optional() {
        return this.optional;
    }

    public boolean matchHost() {
        return this.matchHost;
    }

    public boolean httpsOnly() {
        return this.httpsOnly;
    }

    public boolean passOnRedirect() {
        return this.passOnRedirect;
    }

    public String username() {
        return (String)this.usernameOpt().getOrElse((Function0<String> & Serializable)() -> "");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object o) {
        Object object = o;
        if (!(object instanceof DirectCredentials)) return false;
        DirectCredentials directCredentials = (DirectCredentials)object;
        String string = this.host();
        String string2 = directCredentials.host();
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        Option<String> option = this.usernameOpt();
        Option<String> option2 = directCredentials.usernameOpt();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        Option<String> option3 = this.passwordOpt();
        Option<String> option4 = directCredentials.passwordOpt();
        if (option3 == null) {
            if (option4 != null) {
                return false;
            }
        } else if (!option3.equals(option4)) return false;
        Option<String> option5 = this.realm();
        Option<String> option6 = directCredentials.realm();
        if (option5 == null) {
            if (option6 != null) {
                return false;
            }
        } else if (!option5.equals(option6)) return false;
        if (this.optional() != directCredentials.optional()) return false;
        if (this.matchHost() != directCredentials.matchHost()) return false;
        if (this.httpsOnly() != directCredentials.httpsOnly()) return false;
        if (this.passOnRedirect() != directCredentials.passOnRedirect()) return false;
        return true;
    }

    public int hashCode() {
        return 37 * (37 * (37 * (37 * (37 * (37 * (37 * (37 * (37 * (17 + Statics.anyHash("coursierapi.shaded.coursier.credentials.DirectCredentials")) + Statics.anyHash(this.host())) + Statics.anyHash(this.usernameOpt())) + Statics.anyHash(this.passwordOpt())) + Statics.anyHash(this.realm())) + (this.optional() ? 1231 : 1237)) + (this.matchHost() ? 1231 : 1237)) + (this.httpsOnly() ? 1231 : 1237)) + (this.passOnRedirect() ? 1231 : 1237));
    }

    public String toString() {
        return new StringBuilder(31).append("Credentials(").append(this.host()).append(", ").append(this.usernameOpt()).append(", ").append("****").append(", ").append(this.realm()).append(", ").append(this.optional()).append(", ").append(this.matchHost()).append(", ").append(this.httpsOnly()).append(", ").append(this.passOnRedirect()).append(")").toString();
    }

    private DirectCredentials copy(String host, Option<String> usernameOpt, Option<String> passwordOpt, Option<String> realm2, boolean optional, boolean matchHost, boolean httpsOnly, boolean passOnRedirect) {
        return new DirectCredentials(host, usernameOpt, passwordOpt, realm2, optional, matchHost, httpsOnly, passOnRedirect);
    }

    private String copy$default$1() {
        return this.host();
    }

    private Option<String> copy$default$2() {
        return this.usernameOpt();
    }

    private Option<String> copy$default$3() {
        return this.passwordOpt();
    }

    private Option<String> copy$default$4() {
        return this.realm();
    }

    private boolean copy$default$5() {
        return this.optional();
    }

    private boolean copy$default$6() {
        return this.matchHost();
    }

    private boolean copy$default$7() {
        return this.httpsOnly();
    }

    private boolean copy$default$8() {
        return this.passOnRedirect();
    }

    public DirectCredentials withRealm(Option<String> realm2) {
        Option<String> x$1 = realm2;
        String x$2 = this.copy$default$1();
        Option<String> x$3 = this.copy$default$2();
        Option<String> x$4 = this.copy$default$3();
        boolean x$5 = this.copy$default$5();
        boolean x$6 = this.copy$default$6();
        boolean x$7 = this.copy$default$7();
        boolean x$8 = this.copy$default$8();
        return this.copy(x$2, x$3, x$4, x$1, x$5, x$6, x$7, x$8);
    }

    public DirectCredentials withMatchHost(boolean matchHost) {
        boolean x$1 = matchHost;
        String x$2 = this.copy$default$1();
        Option<String> x$3 = this.copy$default$2();
        Option<String> x$4 = this.copy$default$3();
        Option<String> x$5 = this.copy$default$4();
        boolean x$6 = this.copy$default$5();
        boolean x$7 = this.copy$default$7();
        boolean x$8 = this.copy$default$8();
        return this.copy(x$2, x$3, x$4, x$5, x$6, x$1, x$7, x$8);
    }

    public DirectCredentials withHttpsOnly(boolean httpsOnly) {
        boolean x$1 = httpsOnly;
        String x$2 = this.copy$default$1();
        Option<String> x$3 = this.copy$default$2();
        Option<String> x$4 = this.copy$default$3();
        Option<String> x$5 = this.copy$default$4();
        boolean x$6 = this.copy$default$5();
        boolean x$7 = this.copy$default$6();
        boolean x$8 = this.copy$default$8();
        return this.copy(x$2, x$3, x$4, x$5, x$6, x$7, x$1, x$8);
    }

    public DirectCredentials withPassOnRedirect(boolean passOnRedirect) {
        boolean x$1 = passOnRedirect;
        String x$2 = this.copy$default$1();
        Option<String> x$3 = this.copy$default$2();
        Option<String> x$4 = this.copy$default$3();
        Option<String> x$5 = this.copy$default$4();
        boolean x$6 = this.copy$default$5();
        boolean x$7 = this.copy$default$6();
        boolean x$8 = this.copy$default$7();
        return this.copy(x$2, x$3, x$4, x$5, x$6, x$7, x$8, x$1);
    }

    private boolean nonEmpty() {
        return this.usernameOpt().nonEmpty() && this.passwordOpt().nonEmpty();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean autoMatches(String url, Option<String> realm0) {
        if (!this.nonEmpty()) return false;
        if (!this.matchHost()) return false;
        Option uriOpt = Try$.MODULE$.apply((Function0<URI> & Serializable)() -> new URI(url)).toOption();
        Option schemeOpt = uriOpt.flatMap((Function1<URI, Option> & Serializable)uri -> Option$.MODULE$.apply(uri.getScheme()));
        Option hostOpt = uriOpt.flatMap((Function1<URI, Option> & Serializable)uri -> Option$.MODULE$.apply(uri.getHost()));
        if (!schemeOpt.contains("http") || this.httpsOnly()) {
            if (!schemeOpt.contains("https")) return false;
        }
        if (!hostOpt.contains(this.host())) return false;
        if (!this.realm().forall((Function1<String, Object>)(Function1<Object, Object> & Serializable)elem -> BoxesRunTime.boxToBoolean(realm0.contains(elem)))) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean matches(String url, String user) {
        if (!this.nonEmpty()) return false;
        Option uriOpt = Try$.MODULE$.apply((Function0<URI> & Serializable)() -> new URI(url)).toOption();
        Option schemeOpt = uriOpt.flatMap((Function1<URI, Option> & Serializable)uri -> Option$.MODULE$.apply(uri.getScheme()));
        Option hostOpt = uriOpt.flatMap((Function1<URI, Option> & Serializable)uri -> Option$.MODULE$.apply(uri.getHost()));
        Option userInfoOpt = uriOpt.flatMap((Function1<URI, Option> & Serializable)uri -> Option$.MODULE$.apply(uri.getUserInfo()));
        if (!userInfoOpt.isEmpty()) return false;
        if (!schemeOpt.contains("http") || this.httpsOnly()) {
            if (!schemeOpt.contains("https")) return false;
        }
        if (!hostOpt.contains(this.host())) return false;
        if (!this.usernameOpt().contains(user)) return false;
        return true;
    }

    public Authentication authentication() {
        String x$1 = this.username();
        Option<String> x$2 = this.passwordOpt();
        Option<String> x$3 = this.realm();
        boolean x$4 = this.optional();
        boolean x$5 = this.httpsOnly();
        boolean x$6 = this.passOnRedirect();
        return Authentication$.MODULE$.apply(x$1, x$2, x$4, x$3, x$5, x$6);
    }

    @Override
    public Seq<DirectCredentials> get() {
        return (Seq)Seq$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new DirectCredentials[]{this}));
    }

    public DirectCredentials(String host, Option<String> usernameOpt, Option<String> passwordOpt, Option<String> realm2, boolean optional, boolean matchHost, boolean httpsOnly, boolean passOnRedirect) {
        this.host = host;
        this.usernameOpt = usernameOpt;
        this.passwordOpt = passwordOpt;
        this.realm = realm2;
        this.optional = optional;
        this.matchHost = matchHost;
        this.httpsOnly = httpsOnly;
        this.passOnRedirect = passOnRedirect;
    }

    public DirectCredentials() {
        this("", None$.MODULE$, None$.MODULE$, None$.MODULE$, true, false, true, false);
    }

    public DirectCredentials(String host, String username, String password) {
        this(host, new Some<String>(username), new Some<String>(password), None$.MODULE$, true, false, true, false);
    }
}

