/*
 * Decompiled with CFR 0.152.
 */
package coursierapi.shaded.coursier.credentials;

import coursierapi.shaded.coursier.credentials.Credentials;
import coursierapi.shaded.coursier.credentials.DirectCredentials;
import coursierapi.shaded.coursier.credentials.DirectCredentials$;
import coursierapi.shaded.scala.Function0;
import coursierapi.shaded.scala.Function1;
import coursierapi.shaded.scala.Option;
import coursierapi.shaded.scala.Option$;
import coursierapi.shaded.scala.Predef$;
import coursierapi.shaded.scala.collection.JavaConverters$;
import coursierapi.shaded.scala.collection.StringOps$;
import coursierapi.shaded.scala.collection.immutable.Nil$;
import coursierapi.shaded.scala.collection.immutable.Seq;
import coursierapi.shaded.scala.collection.immutable.Vector;
import coursierapi.shaded.scala.runtime.BoxesRunTime;
import coursierapi.shaded.scala.runtime.Nothing$;
import coursierapi.shaded.scala.runtime.Statics;
import java.io.File;
import java.io.FileInputStream;
import java.io.Serializable;
import java.util.Properties;

public final class FileCredentials
extends Credentials {
    private final String path;
    private final boolean optional;

    public String path() {
        return this.path;
    }

    public boolean optional() {
        return this.optional;
    }

    public boolean equals(Object o) {
        boolean bl;
        Object object = o;
        if (object instanceof FileCredentials) {
            FileCredentials fileCredentials = (FileCredentials)object;
            String string = this.path();
            String string2 = fileCredentials.path();
            bl = !(string != null ? !string.equals(string2) : string2 != null) && this.optional() == fileCredentials.optional();
        } else {
            bl = false;
        }
        return bl;
    }

    public int hashCode() {
        return 37 * (37 * (37 * (17 + Statics.anyHash("coursierapi.shaded.coursier.credentials.CredentialFile")) + Statics.anyHash(this.path())) + (this.optional() ? 1231 : 1237));
    }

    public String toString() {
        return new StringBuilder(18).append("CredentialFile(").append(this.path()).append(", ").append(this.optional()).append(")").toString();
    }

    @Override
    public Seq<DirectCredentials> get() {
        Seq<Nothing$> seq;
        File f = new File(this.path());
        if (f.isFile()) {
            Properties props = new Properties();
            try (FileInputStream fis = null;){
                fis = new FileInputStream(f);
                props.load(fis);
            }
            Vector userProps = JavaConverters$.MODULE$.enumerationAsScalaIteratorConverter(props.propertyNames()).asScala().map((Function1<Object, String> & Serializable)x$1 -> (String)x$1).filter((Function1<String, Object> & Serializable)x$2 -> BoxesRunTime.boxToBoolean(x$2.endsWith(".username"))).toVector();
            seq = (Seq)userProps.map((Function1<String, DirectCredentials> & Serializable)userProp -> {
                String prefix = StringOps$.MODULE$.stripSuffix$extension(Predef$.MODULE$.augmentString((String)userProp), ".username");
                String user = props.getProperty((String)userProp);
                String password = (String)Option$.MODULE$.apply(props.getProperty(new StringBuilder(9).append(prefix).append(".password").toString())).getOrElse((Function0<Nothing$> & Serializable)() -> {
                    throw new Exception(new StringBuilder(32).append("Property ").append(prefix).append(".password not found in ").append(this.path()).toString());
                });
                String host = (String)Option$.MODULE$.apply(props.getProperty(new StringBuilder(5).append(prefix).append(".host").toString())).getOrElse((Function0<Nothing$> & Serializable)() -> {
                    throw new Exception(new StringBuilder(28).append("Property ").append(prefix).append(".host not found in ").append(this.path()).toString());
                });
                Option<String> realmOpt = Option$.MODULE$.apply(props.getProperty(new StringBuilder(6).append(prefix).append(".realm").toString()));
                boolean matchHost = BoxesRunTime.unboxToBoolean(Option$.MODULE$.apply(props.getProperty(new StringBuilder(5).append(prefix).append(".auto").toString())).fold(() -> false, (Function1<String, Object> & Serializable)x$3 -> BoxesRunTime.boxToBoolean(StringOps$.MODULE$.toBoolean$extension(Predef$.MODULE$.augmentString(x$3)))));
                boolean httpsOnly = BoxesRunTime.unboxToBoolean(Option$.MODULE$.apply(props.getProperty(new StringBuilder(11).append(prefix).append(".https-only").toString())).fold(() -> true, (Function1<String, Object> & Serializable)x$4 -> BoxesRunTime.boxToBoolean(StringOps$.MODULE$.toBoolean$extension(Predef$.MODULE$.augmentString(x$4)))));
                boolean passOnRedirect = BoxesRunTime.unboxToBoolean(Option$.MODULE$.apply(props.getProperty(new StringBuilder(17).append(prefix).append(".pass-on-redirect").toString())).fold(() -> false, (Function1<String, Object> & Serializable)x$5 -> BoxesRunTime.boxToBoolean(StringOps$.MODULE$.toBoolean$extension(Predef$.MODULE$.augmentString(x$5)))));
                return DirectCredentials$.MODULE$.apply(host, user, password).withRealm(realmOpt).withMatchHost(matchHost).withHttpsOnly(httpsOnly).withPassOnRedirect(passOnRedirect);
            });
        } else if (this.optional()) {
            seq = Nil$.MODULE$;
        } else {
            throw new Exception(new StringBuilder(26).append("Credential file ").append(this.path()).append(" not found").toString());
        }
        return seq;
    }

    public FileCredentials(String path, boolean optional) {
        this.path = path;
        this.optional = optional;
    }
}

