/*
 * Decompiled with CFR 0.152.
 */
package coursierapi.shaded.coursier.internal.api;

import coursierapi.Artifact;
import coursierapi.Cache;
import coursierapi.Complete;
import coursierapi.CompleteResult;
import coursierapi.Credentials;
import coursierapi.Dependency;
import coursierapi.Fetch;
import coursierapi.FetchResult;
import coursierapi.IvyRepository;
import coursierapi.Logger;
import coursierapi.MavenRepository;
import coursierapi.Module;
import coursierapi.Repository;
import coursierapi.ResolutionParams;
import coursierapi.SimpleLogger;
import coursierapi.error.CoursierError;
import coursierapi.error.DownloadingArtifactsError;
import coursierapi.error.FetchError;
import coursierapi.error.MultipleResolutionError;
import coursierapi.error.ResolutionError;
import coursierapi.error.SimpleResolutionError;
import coursierapi.shaded.coursier.Fetch;
import coursierapi.shaded.coursier.Fetch$;
import coursierapi.shaded.coursier.Fetch$FetchTaskOps$;
import coursierapi.shaded.coursier.LocalRepositories$;
import coursierapi.shaded.coursier.Repositories$;
import coursierapi.shaded.coursier.Resolve$;
import coursierapi.shaded.coursier.cache.ArtifactError;
import coursierapi.shaded.coursier.cache.CacheDefaults$;
import coursierapi.shaded.coursier.cache.CacheLogger;
import coursierapi.shaded.coursier.cache.CacheLogger$;
import coursierapi.shaded.coursier.cache.FileCache;
import coursierapi.shaded.coursier.cache.FileCache$;
import coursierapi.shaded.coursier.cache.loggers.RefreshLogger$;
import coursierapi.shaded.coursier.complete.Complete$;
import coursierapi.shaded.coursier.core.Attributes;
import coursierapi.shaded.coursier.core.Authentication;
import coursierapi.shaded.coursier.core.Authentication$;
import coursierapi.shaded.coursier.core.Classifier;
import coursierapi.shaded.coursier.core.Configuration$;
import coursierapi.shaded.coursier.core.ModuleName;
import coursierapi.shaded.coursier.core.Organization;
import coursierapi.shaded.coursier.core.Type;
import coursierapi.shaded.coursier.error.FetchError;
import coursierapi.shaded.coursier.error.ResolutionError;
import coursierapi.shaded.coursier.internal.api.ApiHelper;
import coursierapi.shaded.coursier.internal.api.WrappedLogger;
import coursierapi.shaded.coursier.ivy.IvyRepository$;
import coursierapi.shaded.coursier.ivy.Pattern;
import coursierapi.shaded.coursier.package$;
import coursierapi.shaded.coursier.package$Attributes$;
import coursierapi.shaded.coursier.package$Dependency$;
import coursierapi.shaded.coursier.package$Module$;
import coursierapi.shaded.coursier.params.ResolutionParams$;
import coursierapi.shaded.coursier.parse.DependencyParser$;
import coursierapi.shaded.coursier.parse.ModuleParser$;
import coursierapi.shaded.coursier.util.Task;
import coursierapi.shaded.coursier.util.Task$;
import coursierapi.shaded.scala.$less$colon$less$;
import coursierapi.shaded.scala.Function0;
import coursierapi.shaded.scala.Function1;
import coursierapi.shaded.scala.MatchError;
import coursierapi.shaded.scala.None$;
import coursierapi.shaded.scala.Option;
import coursierapi.shaded.scala.Option$;
import coursierapi.shaded.scala.Predef$;
import coursierapi.shaded.scala.Predef$ArrowAssoc$;
import coursierapi.shaded.scala.Some;
import coursierapi.shaded.scala.Tuple2;
import coursierapi.shaded.scala.collection.Iterable;
import coursierapi.shaded.scala.collection.IterableOnce;
import coursierapi.shaded.scala.collection.IterableOnceOps;
import coursierapi.shaded.scala.collection.IterableOps;
import coursierapi.shaded.scala.collection.JavaConverters$;
import coursierapi.shaded.scala.collection.Set;
import coursierapi.shaded.scala.collection.StringOps$;
import coursierapi.shaded.scala.collection.immutable.Map;
import coursierapi.shaded.scala.collection.immutable.Vector;
import coursierapi.shaded.scala.concurrent.ExecutionContext;
import coursierapi.shaded.scala.concurrent.Future;
import coursierapi.shaded.scala.reflect.ClassTag$;
import coursierapi.shaded.scala.runtime.BoxesRunTime;
import coursierapi.shaded.scala.util.Either;
import coursierapi.shaded.scala.util.Left;
import coursierapi.shaded.scala.util.Right;
import java.io.File;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ExecutorService;

public final class ApiHelper$ {
    public static final ApiHelper$ MODULE$ = new ApiHelper$();

    public Repository[] defaultRepositories() {
        return (Repository[])((IterableOnceOps)Resolve$.MODULE$.defaultRepositories().map((Function1<coursierapi.shaded.coursier.core.Repository, ApiHelper.ApiRepo> & Serializable)repo -> new ApiHelper.ApiRepo((coursierapi.shaded.coursier.core.Repository)repo))).toArray(ClassTag$.MODULE$.apply(Repository.class));
    }

    public IvyRepository ivy2Local() {
        IvyRepository repo = IvyRepository.of(LocalRepositories$.MODULE$.ivy2Local().pattern().string(), (String)LocalRepositories$.MODULE$.ivy2Local().metadataPatternOpt().map((Function1<Pattern, String> & Serializable)x$1 -> x$1.string()).orNull($less$colon$less$.MODULE$.refl()));
        return repo.withDropInfoAttributes(LocalRepositories$.MODULE$.ivy2Local().dropInfoAttributes());
    }

    public MavenRepository central() {
        return MavenRepository.of(Repositories$.MODULE$.central().root());
    }

    public ExecutorService defaultPool() {
        return CacheDefaults$.MODULE$.pool();
    }

    public File defaultLocation() {
        return CacheDefaults$.MODULE$.location();
    }

    public Logger progressBarLogger(OutputStreamWriter writer) {
        return WrappedLogger.of(RefreshLogger$.MODULE$.create(writer));
    }

    public Logger nopLogger() {
        return WrappedLogger.of(CacheLogger$.MODULE$.nop());
    }

    public Module parseModule(String s, String scalaVersion) {
        Either<String, coursierapi.shaded.coursier.core.Module> either = ModuleParser$.MODULE$.module(s, scalaVersion);
        if (either instanceof Left) {
            Left left = (Left)either;
            String err = (String)left.value();
            throw new IllegalArgumentException(err);
        }
        if (!(either instanceof Right)) {
            throw new MatchError(either);
        }
        Right right = (Right)either;
        coursierapi.shaded.coursier.core.Module m = (coursierapi.shaded.coursier.core.Module)right.value();
        Module module = this.module(m);
        return module;
    }

    public Dependency parseDependency(String s, String scalaVersion) {
        Either<String, coursierapi.shaded.coursier.core.Dependency> either = DependencyParser$.MODULE$.dependency(s, scalaVersion, Configuration$.MODULE$.empty());
        if (either instanceof Left) {
            Left left = (Left)either;
            String err = (String)left.value();
            throw new IllegalArgumentException(err);
        }
        if (!(either instanceof Right)) {
            throw new MatchError(either);
        }
        Right right = (Right)either;
        coursierapi.shaded.coursier.core.Dependency dep = (coursierapi.shaded.coursier.core.Dependency)right.value();
        Dependency dependency = this.dependency(dep);
        return dependency;
    }

    private Option<Authentication> authenticationOpt(Credentials credentials) {
        return credentials == null ? None$.MODULE$ : new Some<Authentication>(Authentication$.MODULE$.apply(credentials.getUser(), credentials.getPassword()));
    }

    private coursierapi.shaded.coursier.ivy.IvyRepository ivyRepository(IvyRepository ivy) {
        coursierapi.shaded.coursier.ivy.IvyRepository repo;
        boolean x$10;
        boolean x$9;
        boolean x$8;
        boolean x$7;
        Map<String, String> x$6;
        String x$1 = ivy.getPattern();
        Option<String> x$22 = Option$.MODULE$.apply(ivy.getMetadataPattern()).filter((Function1<String, Object> & Serializable)x$2 -> BoxesRunTime.boxToBoolean(StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(x$2))));
        Option<Authentication> x$3 = this.authenticationOpt(ivy.getCredentials());
        boolean x$4 = ivy.getDropInfoAttributes();
        Option<Object> x$5 = IvyRepository$.MODULE$.parse$default$3();
        Either<String, coursierapi.shaded.coursier.ivy.IvyRepository> either = IvyRepository$.MODULE$.parse(x$1, x$22, x$5, x$6 = IvyRepository$.MODULE$.parse$default$4(), x$7 = IvyRepository$.MODULE$.parse$default$5(), x$8 = IvyRepository$.MODULE$.parse$default$6(), x$9 = IvyRepository$.MODULE$.parse$default$7(), x$4, x$3, x$10 = IvyRepository$.MODULE$.parse$default$10());
        if (either instanceof Left) {
            Left left = (Left)either;
            String err = (String)left.value();
            throw new Exception(new StringBuilder(25).append("Invalid Ivy repository ").append(ivy).append(": ").append(err).toString());
        }
        if (!(either instanceof Right)) {
            throw new MatchError(either);
        }
        Right right = (Right)either;
        coursierapi.shaded.coursier.ivy.IvyRepository ivyRepository = repo = (coursierapi.shaded.coursier.ivy.IvyRepository)right.value();
        return ivyRepository;
    }

    public coursierapi.shaded.coursier.core.Module module(Module mod) {
        return package$Module$.MODULE$.apply(package$.MODULE$.Organization().apply(mod.getOrganization()), package$.MODULE$.ModuleName().apply(mod.getName()), ((IterableOnce)JavaConverters$.MODULE$.mapAsScalaMapConverter(mod.getAttributes()).asScala()).iterator().toMap($less$colon$less$.MODULE$.refl()));
    }

    public Module module(coursierapi.shaded.coursier.core.Module mod) {
        return Module.of(mod.organization(), mod.name(), JavaConverters$.MODULE$.mapAsJavaMapConverter(mod.attributes()).asJava());
    }

    public coursierapi.shaded.coursier.core.Dependency dependency(Dependency dep) {
        coursierapi.shaded.coursier.core.Module module0 = this.module(dep.getModule());
        coursierapi.shaded.scala.collection.immutable.Set<Tuple2<String, String>> exclusions = JavaConverters$.MODULE$.asScalaIteratorConverter(dep.getExclusions().iterator()).asScala().map((Function1<Map.Entry, Tuple2> & Serializable)e -> new Tuple2<Organization, ModuleName>(new Organization(package$.MODULE$.Organization().apply((String)e.getKey())), new ModuleName(package$.MODULE$.ModuleName().apply((String)e.getValue())))).toSet();
        String configuration = dep.getConfiguration();
        String tpe = package$.MODULE$.Type().apply(dep.getType());
        String classifier = package$.MODULE$.Classifier().apply(dep.getClassifier());
        coursierapi.shaded.coursier.core.Module x$1 = module0;
        String x$2 = dep.getVersion();
        coursierapi.shaded.scala.collection.immutable.Set<Tuple2<String, String>> x$3 = exclusions;
        String x$4 = configuration;
        Attributes x$5 = package$Attributes$.MODULE$.apply(tpe, classifier);
        boolean x$6 = dep.isTransitive();
        boolean x$7 = package$Dependency$.MODULE$.apply$default$6();
        return package$Dependency$.MODULE$.apply(x$1, x$2, x$4, x$5, x$3, x$7, x$6);
    }

    public Dependency dependency(coursierapi.shaded.coursier.core.Dependency dep) {
        return Dependency.of(this.module(dep.module()), dep.version()).withConfiguration(dep.configuration()).withType(dep.attributes().type()).withClassifier(dep.attributes().classifier()).withExclusion(JavaConverters$.MODULE$.setAsJavaSetConverter((Set)dep.exclusions().map((Function1<Tuple2, Map.Entry> & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            String o = ((Organization)tuple2._1()).value();
            String n = ((ModuleName)tuple2._2()).value();
            AbstractMap.SimpleImmutableEntry<String, String> simpleImmutableEntry = new AbstractMap.SimpleImmutableEntry<String, String>(o, n);
            return simpleImmutableEntry;
        })).asJava()).withTransitive(dep.transitive());
    }

    public coursierapi.shaded.coursier.core.Repository repository(Repository repo) {
        coursierapi.shaded.coursier.core.Repository repository;
        Repository repository2 = repo;
        if (repository2 instanceof ApiHelper.ApiRepo) {
            coursierapi.shaded.coursier.core.Repository repo0;
            ApiHelper.ApiRepo apiRepo = (ApiHelper.ApiRepo)repository2;
            repository = repo0 = apiRepo.repo();
        } else if (repository2 instanceof MavenRepository) {
            MavenRepository mavenRepository = (MavenRepository)repository2;
            String x$1 = mavenRepository.getBase();
            Option<Authentication> x$2 = this.authenticationOpt(mavenRepository.getCredentials());
            Option<Object> x$3 = package$.MODULE$.MavenRepository().apply$default$2();
            boolean x$4 = package$.MODULE$.MavenRepository().apply$default$3();
            repository = package$.MODULE$.MavenRepository().apply(x$1, x$3, x$4, x$2);
        } else if (repository2 instanceof IvyRepository) {
            IvyRepository ivyRepository = (IvyRepository)repository2;
            repository = this.ivyRepository(ivyRepository);
        } else {
            throw new Exception(new StringBuilder(0).append("Unrecognized repository: ").append(repository2).toString());
        }
        return repository;
    }

    public Credentials credentials(Authentication auth) {
        return Credentials.of(auth.user(), (String)auth.passwordOpt().getOrElse((Function0<String> & Serializable)() -> ""));
    }

    public coursierapi.shaded.coursier.params.ResolutionParams resolutionParams(ResolutionParams params) {
        coursierapi.shaded.coursier.params.ResolutionParams params0;
        block0: {
            params0 = ResolutionParams$.MODULE$.apply();
            if (params.getMaxIterations() == null) break block0;
            params0 = params0.withMaxIterations(Predef$.MODULE$.Integer2int(params.getMaxIterations()));
        }
        return params0.withForceVersion((Map)((IterableOnce)JavaConverters$.MODULE$.mapAsScalaMapConverter(params.getForceVersions()).asScala()).iterator().toMap($less$colon$less$.MODULE$.refl()).map((Function1<Tuple2, Tuple2> & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            Module m = (Module)tuple2._1();
            String v = (String)tuple2._2();
            Tuple2<coursierapi.shaded.coursier.core.Module, String> tuple22 = Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(MODULE$.module(m)), v);
            return tuple22;
        })).withForcedProperties(((IterableOnce)JavaConverters$.MODULE$.mapAsScalaMapConverter(params.getForcedProperties()).asScala()).iterator().toMap($less$colon$less$.MODULE$.refl())).withProfiles(((IterableOnceOps)JavaConverters$.MODULE$.asScalaSetConverter(params.getProfiles()).asScala()).toSet()).withExclusions(((IterableOnceOps)((IterableOps)JavaConverters$.MODULE$.asScalaSetConverter(params.getExclusions()).asScala()).map((Function1<Map.Entry, Tuple2> & Serializable)e -> new Tuple2<Organization, ModuleName>(new Organization(package$.MODULE$.Organization().apply((String)e.getKey())), new ModuleName(package$.MODULE$.ModuleName().apply((String)e.getValue()))))).toSet()).withUseSystemOsInfo(params.getUseSystemOsInfo()).withUseSystemJdkVersion(params.getUseSystemJdkVersion());
    }

    public FileCache<Function1<ExecutionContext, Future<Object>>> cache(Cache cache) {
        Option loggerOpt = Option$.MODULE$.apply(cache.getLogger()).map((Function1<Logger, CacheLogger> & Serializable)x0$1 -> {
            CacheLogger cacheLogger;
            Logger logger = x0$1;
            if (logger instanceof SimpleLogger) {
                SimpleLogger simpleLogger = (SimpleLogger)logger;
                cacheLogger = new CacheLogger(simpleLogger){
                    private final SimpleLogger x2$1;

                    public void foundLocally(String url) {
                        CacheLogger.foundLocally$(this, url);
                    }

                    public void checkingUpdates(String url, Option<Object> currentTimeOpt) {
                        CacheLogger.checkingUpdates$(this, url, currentTimeOpt);
                    }

                    public void checkingUpdatesResult(String url, Option<Object> currentTimeOpt, Option<Object> remoteTimeOpt) {
                        CacheLogger.checkingUpdatesResult$(this, url, currentTimeOpt, remoteTimeOpt);
                    }

                    public void gettingLength(String url) {
                        CacheLogger.gettingLength$(this, url);
                    }

                    public void gettingLengthResult(String url, Option<Object> length) {
                        CacheLogger.gettingLengthResult$(this, url, length);
                    }

                    public void removedCorruptFile(String url, Option<String> reason) {
                        CacheLogger.removedCorruptFile$(this, url, reason);
                    }

                    public void init(Option<Object> sizeHint) {
                        CacheLogger.init$(this, sizeHint);
                    }

                    public Option<Object> init$default$1() {
                        return CacheLogger.init$default$1$(this);
                    }

                    public void stop() {
                        CacheLogger.stop$(this);
                    }

                    public void downloadingArtifact(String url) {
                        this.x2$1.starting(url);
                    }

                    public void downloadLength(String url, long totalLength, long alreadyDownloaded, boolean watching) {
                        this.x2$1.length(url, totalLength, alreadyDownloaded, watching);
                    }

                    public void downloadProgress(String url, long downloaded) {
                        this.x2$1.progress(url, downloaded);
                    }

                    public void downloadedArtifact(String url, boolean success) {
                        this.x2$1.done(url, success);
                    }
                    {
                        this.x2$1 = x2$1;
                        CacheLogger.$init$(this);
                    }
                };
            } else if (logger instanceof WrappedLogger) {
                WrappedLogger wrappedLogger = (WrappedLogger)logger;
                cacheLogger = wrappedLogger.getLogger();
            } else {
                throw new MatchError(logger);
            }
            return cacheLogger;
        });
        return FileCache$.MODULE$.apply(FileCache$.MODULE$.apply$default$1()).withPool(cache.getPool()).withLocation(cache.getLocation()).withLogger((CacheLogger)loggerOpt.getOrElse((Function0<CacheLogger> & Serializable)() -> CacheLogger$.MODULE$.nop()));
    }

    public coursierapi.shaded.coursier.Fetch<Function1<ExecutionContext, Future<Object>>> fetch(Fetch fetch) {
        coursierapi.shaded.coursier.Fetch<Function1<ExecutionContext, Future<Object>>> f;
        block0: {
            Vector<coursierapi.shaded.coursier.core.Dependency> dependencies = ((IterableOnceOps)((IterableOps)JavaConverters$.MODULE$.asScalaBufferConverter(fetch.getDependencies()).asScala()).map((Function1<Dependency, coursierapi.shaded.coursier.core.Dependency> & Serializable)dep -> MODULE$.dependency((Dependency)dep))).toVector();
            Vector<coursierapi.shaded.coursier.core.Repository> repositories = ((IterableOnceOps)((IterableOps)JavaConverters$.MODULE$.asScalaBufferConverter(fetch.getRepositories()).asScala()).map((Function1<Repository, coursierapi.shaded.coursier.core.Repository> & Serializable)repo -> MODULE$.repository((Repository)repo))).toVector();
            FileCache<Function1<ExecutionContext, Future<Object>>> cache0 = this.cache(fetch.getCache());
            coursierapi.shaded.scala.collection.immutable.Set classifiers = (coursierapi.shaded.scala.collection.immutable.Set)((IterableOnce)JavaConverters$.MODULE$.asScalaSetConverter(fetch.getClassifiers()).asScala()).iterator().toSet().map((Function1<String, Object> & Serializable)x$4 -> new Classifier(ApiHelper$.$anonfun$fetch$3(x$4)));
            coursierapi.shaded.coursier.params.ResolutionParams params = this.resolutionParams(fetch.getResolutionParams());
            f = Fetch$.MODULE$.apply(Fetch$.MODULE$.apply$default$1(), Task$.MODULE$.sync()).withDependencies(dependencies).withRepositories(repositories).withCache(cache0).withMainArtifacts(fetch.getMainArtifacts()).withClassifiers(classifiers).withFetchCache(Option$.MODULE$.apply(fetch.getFetchCache())).withResolutionParams(params);
            if (fetch.getArtifactTypes() == null) break block0;
            f = f.withArtifactTypes((coursierapi.shaded.scala.collection.immutable.Set)((IterableOnceOps)JavaConverters$.MODULE$.asScalaSetConverter(fetch.getArtifactTypes()).asScala()).toSet().map((Function1<String, Object> & Serializable)x$5 -> new Type(ApiHelper$.$anonfun$fetch$4(x$5))));
        }
        return f;
    }

    private SimpleResolutionError simpleResError(ResolutionError.Simple err) {
        ResolutionError.Simple simple = err;
        if (simple == null) {
            throw new MatchError((Object)simple);
        }
        ResolutionError.Simple simple2 = simple;
        SimpleResolutionError simpleResolutionError = SimpleResolutionError.of(simple2.getMessage());
        return simpleResolutionError;
    }

    public FetchResult doFetch(Fetch apiFetch) {
        ExecutionContext x$1;
        coursierapi.shaded.coursier.Fetch<Function1<ExecutionContext, Future<Object>>> qual$1 = Fetch$.MODULE$.FetchTaskOps(this.fetch(apiFetch));
        Either<coursierapi.shaded.coursier.error.CoursierError, Fetch.Result> either = Fetch$FetchTaskOps$.MODULE$.eitherResult$extension(qual$1, x$1 = Fetch$FetchTaskOps$.MODULE$.eitherResult$default$1$extension(qual$1));
        Either<coursierapi.shaded.coursier.error.CoursierError, Fetch.Result> either2 = either;
        if (either2 instanceof Left) {
            CoursierError coursierError;
            Left left = (Left)either2;
            coursierapi.shaded.coursier.error.CoursierError err2 = (coursierapi.shaded.coursier.error.CoursierError)left.value();
            coursierapi.shaded.coursier.error.CoursierError coursierError2 = err2;
            if (coursierError2 instanceof FetchError.DownloadingArtifacts) {
                FetchError.DownloadingArtifacts downloadingArtifacts = (FetchError.DownloadingArtifacts)coursierError2;
                coursierError = DownloadingArtifactsError.of(JavaConverters$.MODULE$.mapAsJavaMapConverter(((IterableOnceOps)downloadingArtifacts.errors().map((Function1<Tuple2, Tuple2> & Serializable)x0$1 -> {
                    Tuple2 tuple2 = x0$1;
                    if (tuple2 == null) {
                        throw new MatchError(tuple2);
                    }
                    coursierapi.shaded.coursier.core.Artifact a = (coursierapi.shaded.coursier.core.Artifact)tuple2._1();
                    ArtifactError e = (ArtifactError)tuple2._2();
                    Tuple2<String, String> tuple22 = Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(a.url()), e.describe());
                    return tuple22;
                })).toMap($less$colon$less$.MODULE$.refl())).asJava());
            } else if (coursierError2 instanceof coursierapi.shaded.coursier.error.FetchError) {
                coursierapi.shaded.coursier.error.FetchError fetchError = (coursierapi.shaded.coursier.error.FetchError)coursierError2;
                coursierError = FetchError.of(fetchError.getMessage());
            } else if (coursierError2 instanceof ResolutionError.Several) {
                ResolutionError.Several several = (ResolutionError.Several)coursierError2;
                coursierError = MultipleResolutionError.of(this.simpleResError(several.head()), (SimpleResolutionError[])((IterableOnceOps)several.tail().map((Function1<ResolutionError.Simple, SimpleResolutionError> & Serializable)err -> MODULE$.simpleResError((ResolutionError.Simple)err))).toArray(ClassTag$.MODULE$.apply(SimpleResolutionError.class)));
            } else if (coursierError2 instanceof ResolutionError.Simple) {
                ResolutionError.Simple simple = (ResolutionError.Simple)coursierError2;
                coursierError = this.simpleResError(simple);
            } else if (coursierError2 instanceof coursierapi.shaded.coursier.error.ResolutionError) {
                coursierapi.shaded.coursier.error.ResolutionError resolutionError = (coursierapi.shaded.coursier.error.ResolutionError)coursierError2;
                coursierError = ResolutionError.of(resolutionError.getMessage());
            } else if (coursierError2 != null) {
                coursierapi.shaded.coursier.error.CoursierError coursierError3 = coursierError2;
                coursierError = CoursierError.of(coursierError3.getMessage());
            } else {
                throw new MatchError((Object)coursierError2);
            }
            FetchError ex = coursierError;
            throw ex;
        }
        if (!(either2 instanceof Right)) {
            throw new MatchError(either2);
        }
        Right right = (Right)either2;
        Fetch.Result res = (Fetch.Result)right.value();
        ArrayList<Map.Entry<Artifact, File>> l = new ArrayList<Map.Entry<Artifact, File>>();
        res.artifacts().withFilter((Function1<Tuple2, Object> & Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean(ApiHelper$.$anonfun$doFetch$3(check$ifrefutable$1))).foreach((Function1<Tuple2, Object> & Serializable)x$6 -> BoxesRunTime.boxToBoolean(ApiHelper$.$anonfun$doFetch$4(l, x$6)));
        FetchResult fetchResult = FetchResult.of(l);
        return fetchResult;
    }

    public CompleteResult doComplete(Complete complete) {
        FileCache<Function1<ExecutionContext, Future<Object>>> cache0 = this.cache(complete.getCache());
        Vector<coursierapi.shaded.coursier.core.Repository> repositories = ((IterableOnceOps)((IterableOps)JavaConverters$.MODULE$.asScalaBufferConverter(complete.getRepositories()).asScala()).map((Function1<Repository, coursierapi.shaded.coursier.core.Repository> & Serializable)repo -> MODULE$.repository((Repository)repo))).toVector();
        Tuple2 res = (Tuple2)Task$.MODULE$.PlatformTaskOps(((Task)((Object)Complete$.MODULE$.apply(cache0, Task$.MODULE$.sync()).withRepositories(repositories).withScalaBinaryVersion(Option$.MODULE$.apply(complete.getScalaBinaryVersion())).withScalaVersion(Option$.MODULE$.apply(complete.getScalaVersion())).withInput(complete.getInput()).complete())).value()).unsafeRun(cache0.ec());
        ArrayList<String> l = new ArrayList<String>(JavaConverters$.MODULE$.asJavaCollectionConverter((Iterable)res._2()).asJavaCollection());
        return CompleteResult.of(res._1$mcI$sp(), l);
    }

    public static final /* synthetic */ String $anonfun$fetch$3(String x$4) {
        return package$.MODULE$.Classifier().apply(x$4);
    }

    public static final /* synthetic */ String $anonfun$fetch$4(String x$5) {
        return package$.MODULE$.Type().apply(x$5);
    }

    public static final /* synthetic */ boolean $anonfun$doFetch$3(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        boolean bl = tuple2 != null;
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$doFetch$4(ArrayList l$1, Tuple2 x$6) {
        Tuple2 tuple2 = x$6;
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        coursierapi.shaded.coursier.core.Artifact a = (coursierapi.shaded.coursier.core.Artifact)tuple2._1();
        File f = (File)tuple2._2();
        Credentials credentials0 = (Credentials)a.authentication().map((Function1<Authentication, Credentials> & Serializable)auth -> MODULE$.credentials((Authentication)auth)).orNull($less$colon$less$.MODULE$.refl());
        Artifact a0 = Artifact.of(a.url(), a.changing(), a.optional(), credentials0);
        AbstractMap.SimpleEntry<Artifact, File> ent = new AbstractMap.SimpleEntry<Artifact, File>(a0, f);
        boolean bl = l$1.add(ent);
        return bl;
    }

    private ApiHelper$() {
    }
}

