/*
 * Decompiled with CFR 0.152.
 */
package coursierapi.shaded.coursier.paths;

import coursierapi.shaded.directories.ProjectDirectories;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;

public final class CoursierPaths {
    private static ProjectDirectories coursierDirectories;
    private static volatile File cacheDirectory0;
    private static final Object lock;

    private static File computeCacheDirectory() throws IOException {
        File file;
        String string = System.getenv("COURSIER_CACHE");
        if (string == null) {
            string = System.getProperty("coursierapi.shaded.coursier.cache");
        }
        File file2 = new File(CoursierPaths.coursierDirectories.cacheDir);
        File file3 = new File(file2, "v1");
        String string2 = file3.getAbsolutePath();
        if (string == null && file2.isDirectory()) {
            string = string2;
        }
        if (string == null && (file = new File(System.getProperty("user.home") + "/.coursier")).isDirectory()) {
            string = System.getProperty("user.home") + "/.coursier/cache/v1/";
        }
        if (string == null) {
            string = string2;
            Files.createDirectories(file3.toPath(), new FileAttribute[0]);
        }
        return new File(string).getAbsoluteFile();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void init() throws IOException {
        if (cacheDirectory0 == null) {
            Object object = lock;
            synchronized (object) {
                if (cacheDirectory0 == null) {
                    coursierDirectories = ProjectDirectories.from(null, null, "Coursier");
                    cacheDirectory0 = CoursierPaths.computeCacheDirectory();
                }
            }
        }
    }

    public static File cacheDirectory() throws IOException {
        CoursierPaths.init();
        return cacheDirectory0;
    }

    public static File configDirectory() throws IOException {
        CoursierPaths.init();
        return new File(CoursierPaths.coursierDirectories.configDir);
    }

    static {
        cacheDirectory0 = null;
        lock = new Object();
    }
}

