/*
 * Decompiled with CFR 0.152.
 */
package coursierapi.shaded.org.jline.terminal;

import coursierapi.shaded.org.jline.terminal.Attributes;
import coursierapi.shaded.org.jline.terminal.Size;
import coursierapi.shaded.org.jline.terminal.Terminal;
import coursierapi.shaded.org.jline.terminal.impl.AbstractPosixTerminal;
import coursierapi.shaded.org.jline.terminal.impl.DumbTerminal;
import coursierapi.shaded.org.jline.terminal.impl.ExecPty;
import coursierapi.shaded.org.jline.terminal.impl.ExternalTerminal;
import coursierapi.shaded.org.jline.terminal.impl.PosixPtyTerminal;
import coursierapi.shaded.org.jline.terminal.impl.PosixSysTerminal;
import coursierapi.shaded.org.jline.terminal.spi.JansiSupport;
import coursierapi.shaded.org.jline.terminal.spi.JnaSupport;
import coursierapi.shaded.org.jline.terminal.spi.Pty;
import coursierapi.shaded.org.jline.utils.Log;
import coursierapi.shaded.org.jline.utils.OSUtils;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import java.util.Optional;
import java.util.ServiceLoader;

public final class TerminalBuilder {
    private String name;
    private InputStream in;
    private OutputStream out;
    private String type;
    private Charset encoding;
    private int codepage;
    private Boolean system;
    private Boolean jna;
    private Boolean jansi;
    private Boolean exec;
    private Boolean dumb;
    private Attributes attributes;
    private Size size;
    private boolean nativeSignals = false;
    private Terminal.SignalHandler signalHandler = Terminal.SignalHandler.SIG_DFL;
    private boolean paused = false;

    public static Terminal terminal() throws IOException {
        return TerminalBuilder.builder().build();
    }

    public static TerminalBuilder builder() {
        return new TerminalBuilder();
    }

    private TerminalBuilder() {
    }

    public Terminal build() throws IOException {
        Terminal terminal = this.doBuild();
        Log.debug(() -> "Using terminal " + terminal.getClass().getSimpleName());
        if (terminal instanceof AbstractPosixTerminal) {
            Log.debug(() -> "Using pty " + ((AbstractPosixTerminal)terminal).getPty().getClass().getSimpleName());
        }
        return terminal;
    }

    private Terminal doBuild() throws IOException {
        Boolean dumb;
        Boolean exec;
        Boolean jansi;
        Boolean jna;
        String type;
        String str;
        int codepage;
        String charsetName;
        Charset encoding;
        String name = this.name;
        if (name == null) {
            name = "JLine terminal";
        }
        if ((encoding = this.encoding) == null && (charsetName = System.getProperty("coursierapi.shaded.org.jline.terminal.encoding")) != null && Charset.isSupported(charsetName)) {
            encoding = Charset.forName(charsetName);
        }
        if ((codepage = this.codepage) <= 0 && (str = System.getProperty("coursierapi.shaded.org.jline.terminal.codepage")) != null) {
            codepage = Integer.parseInt(str);
        }
        if ((type = this.type) == null) {
            type = System.getProperty("coursierapi.shaded.org.jline.terminal.type");
        }
        if (type == null) {
            type = System.getenv("TERM");
        }
        if ((jna = this.jna) == null) {
            jna = TerminalBuilder.getBoolean("coursierapi.shaded.org.jline.terminal.jna", true);
        }
        if ((jansi = this.jansi) == null) {
            jansi = TerminalBuilder.getBoolean("coursierapi.shaded.org.jline.terminal.jansi", true);
        }
        if ((exec = this.exec) == null) {
            exec = TerminalBuilder.getBoolean("coursierapi.shaded.org.jline.terminal.exec", true);
        }
        if ((dumb = this.dumb) == null) {
            dumb = TerminalBuilder.getBoolean("coursierapi.shaded.org.jline.terminal.dumb", null);
        }
        if (this.system != null && this.system.booleanValue() || this.system == null && this.in == null && this.out == null) {
            if (this.attributes != null || this.size != null) {
                Log.warn("Attributes and size fields are ignored when creating a system terminal");
            }
            IllegalStateException exception = new IllegalStateException("Unable to create a system terminal");
            if (OSUtils.IS_WINDOWS) {
                boolean cygwinTerm = "cygwin".equals(System.getenv("TERM"));
                boolean ansiPassThrough = OSUtils.IS_CONEMU;
                if ((OSUtils.IS_CYGWIN || OSUtils.IS_MSYSTEM) && exec.booleanValue() && !cygwinTerm) {
                    try {
                        Pty pty = ExecPty.current();
                        if ("xterm".equals(type) && this.type == null && System.getProperty("coursierapi.shaded.org.jline.terminal.type") == null) {
                            type = "xterm-256color";
                        }
                        return new PosixSysTerminal(name, type, pty, encoding, this.nativeSignals, this.signalHandler);
                    }
                    catch (IOException e) {
                        Log.debug("Error creating EXEC based terminal: ", e.getMessage(), e);
                        exception.addSuppressed(e);
                    }
                }
                if (jna.booleanValue()) {
                    try {
                        return this.load(JnaSupport.class).winSysTerminal(name, type, ansiPassThrough, encoding, codepage, this.nativeSignals, this.signalHandler, this.paused);
                    }
                    catch (Throwable t) {
                        Log.debug("Error creating JNA based terminal: ", t.getMessage(), t);
                        exception.addSuppressed(t);
                    }
                }
                if (jansi.booleanValue()) {
                    try {
                        return this.load(JansiSupport.class).winSysTerminal(name, type, ansiPassThrough, encoding, codepage, this.nativeSignals, this.signalHandler, this.paused);
                    }
                    catch (Throwable t) {
                        Log.debug("Error creating JANSI based terminal: ", t.getMessage(), t);
                        exception.addSuppressed(t);
                    }
                }
            } else {
                if (jna.booleanValue()) {
                    try {
                        Pty pty = this.load(JnaSupport.class).current();
                        return new PosixSysTerminal(name, type, pty, encoding, this.nativeSignals, this.signalHandler);
                    }
                    catch (Throwable t) {
                        Log.debug("Error creating JNA based terminal: ", t.getMessage(), t);
                        exception.addSuppressed(t);
                    }
                }
                if (jansi.booleanValue()) {
                    try {
                        Pty pty = this.load(JansiSupport.class).current();
                        return new PosixSysTerminal(name, type, pty, encoding, this.nativeSignals, this.signalHandler);
                    }
                    catch (Throwable t) {
                        Log.debug("Error creating JANSI based terminal: ", t.getMessage(), t);
                        exception.addSuppressed(t);
                    }
                }
                if (exec.booleanValue()) {
                    try {
                        Pty pty = ExecPty.current();
                        return new PosixSysTerminal(name, type, pty, encoding, this.nativeSignals, this.signalHandler);
                    }
                    catch (Throwable t) {
                        Log.debug("Error creating EXEC based terminal: ", t.getMessage(), t);
                        exception.addSuppressed(t);
                    }
                }
            }
            if (dumb == null || dumb.booleanValue()) {
                boolean color = TerminalBuilder.getBoolean("coursierapi.shaded.org.jline.terminal.dumb.color", false);
                if (!color) {
                    boolean bl = color = System.getenv("INSIDE_EMACS") != null;
                }
                if (!color) {
                    String command = TerminalBuilder.getParentProcessCommand();
                    boolean bl = color = command != null && command.contains("idea");
                }
                if (!color && dumb == null) {
                    if (Log.isDebugEnabled()) {
                        Log.warn("Creating a dumb terminal", exception);
                    } else {
                        Log.warn("Unable to create a system terminal, creating a dumb terminal (enable debug logging for more information)");
                    }
                }
                return new DumbTerminal(name, color ? "dumb-color" : "dumb", new FileInputStream(FileDescriptor.in), new FileOutputStream(FileDescriptor.out), encoding, this.signalHandler);
            }
            throw exception;
        }
        if (jna.booleanValue()) {
            try {
                Pty pty = this.load(JnaSupport.class).open(this.attributes, this.size);
                return new PosixPtyTerminal(name, type, pty, this.in, this.out, encoding, this.signalHandler, this.paused);
            }
            catch (Throwable t) {
                Log.debug("Error creating JNA based terminal: ", t.getMessage(), t);
            }
        }
        if (jansi.booleanValue()) {
            try {
                Pty pty = this.load(JansiSupport.class).open(this.attributes, this.size);
                return new PosixPtyTerminal(name, type, pty, this.in, this.out, encoding, this.signalHandler, this.paused);
            }
            catch (Throwable t) {
                Log.debug("Error creating JANSI based terminal: ", t.getMessage(), t);
            }
        }
        ExternalTerminal terminal = new ExternalTerminal(name, type, this.in, this.out, encoding, this.signalHandler, this.paused);
        if (this.attributes != null) {
            terminal.setAttributes(this.attributes);
        }
        if (this.size != null) {
            terminal.setSize(this.size);
        }
        return terminal;
    }

    private static String getParentProcessCommand() {
        try {
            Class<?> phClass = Class.forName("java.lang.ProcessHandle");
            Object current = phClass.getMethod("current", new Class[0]).invoke(null, new Object[0]);
            Object parent = ((Optional)phClass.getMethod("parent", new Class[0]).invoke(current, new Object[0])).orElse(null);
            Method infoMethod = phClass.getMethod("info", new Class[0]);
            Object info = infoMethod.invoke(parent, new Object[0]);
            Object command = ((Optional)infoMethod.getReturnType().getMethod("command", new Class[0]).invoke(info, new Object[0])).orElse(null);
            return command;
        }
        catch (Throwable t) {
            return null;
        }
    }

    private static Boolean getBoolean(String name, Boolean def) {
        try {
            String str = System.getProperty(name);
            if (str != null) {
                return Boolean.parseBoolean(str);
            }
        }
        catch (IllegalArgumentException | NullPointerException runtimeException) {
            // empty catch block
        }
        return def;
    }

    private <S> S load(Class<S> clazz) {
        return ServiceLoader.load(clazz, clazz.getClassLoader()).iterator().next();
    }
}

