/*
 * Decompiled with CFR 0.152.
 */
package coursierapi.shaded.org.jline.terminal.impl;

import coursierapi.shaded.org.jline.terminal.Attributes;
import coursierapi.shaded.org.jline.terminal.Size;
import coursierapi.shaded.org.jline.terminal.Terminal;
import coursierapi.shaded.org.jline.terminal.impl.AbstractTerminal;
import coursierapi.shaded.org.jline.terminal.spi.Pty;
import java.io.IOError;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Objects;

public abstract class AbstractPosixTerminal
extends AbstractTerminal {
    protected final Pty pty;
    protected final Attributes originalAttributes;

    public AbstractPosixTerminal(String name, String type, Pty pty, Charset encoding, Terminal.SignalHandler signalHandler) throws IOException {
        super(name, type, encoding, signalHandler);
        Objects.requireNonNull(pty);
        this.pty = pty;
        this.originalAttributes = this.pty.getAttr();
    }

    public Pty getPty() {
        return this.pty;
    }

    @Override
    public Attributes getAttributes() {
        try {
            return this.pty.getAttr();
        }
        catch (IOException e) {
            throw new IOError(e);
        }
    }

    @Override
    public void setAttributes(Attributes attr) {
        try {
            this.pty.setAttr(attr);
        }
        catch (IOException e) {
            throw new IOError(e);
        }
    }

    @Override
    public Size getSize() {
        try {
            return this.pty.getSize();
        }
        catch (IOException e) {
            throw new IOError(e);
        }
    }

    @Override
    public void setSize(Size size) {
        try {
            this.pty.setSize(size);
        }
        catch (IOException e) {
            throw new IOError(e);
        }
    }

    @Override
    public void close() throws IOException {
        super.close();
        this.pty.setAttr(this.originalAttributes);
        this.pty.close();
    }
}

