/*
 * Decompiled with CFR 0.152.
 */
package coursierapi.shaded.org.jline.utils;

public class AttributedStyle {
    public static final AttributedStyle DEFAULT = new AttributedStyle();
    public static final AttributedStyle BOLD = DEFAULT.bold();
    public static final AttributedStyle BOLD_OFF = DEFAULT.boldOff();
    public static final AttributedStyle INVERSE = DEFAULT.inverse();
    public static final AttributedStyle INVERSE_OFF = DEFAULT.inverseOff();
    public static final AttributedStyle HIDDEN = DEFAULT.hidden();
    public static final AttributedStyle HIDDEN_OFF = DEFAULT.hiddenOff();
    final int style;
    final int mask;

    public AttributedStyle() {
        this(0, 0);
    }

    public AttributedStyle(int style, int mask) {
        this.style = style;
        this.mask = mask & 0x7FF | ((style & 0x100) != 0 ? 0xFF0000 : 0) | ((style & 0x200) != 0 ? -16777216 : 0);
    }

    public AttributedStyle bold() {
        return new AttributedStyle(this.style | 1, this.mask | 1);
    }

    public AttributedStyle boldOff() {
        return new AttributedStyle(this.style & 0xFFFFFFFE, this.mask | 1);
    }

    public AttributedStyle inverse() {
        return new AttributedStyle(this.style | 0x20, this.mask | 0x20);
    }

    public AttributedStyle inverseOff() {
        return new AttributedStyle(this.style & 0xFFFFFFDF, this.mask | 0x20);
    }

    public AttributedStyle hidden() {
        return new AttributedStyle(this.style | 0x400, this.mask | 0x400);
    }

    public AttributedStyle hiddenOff() {
        return new AttributedStyle(this.style & 0xFFFFFBFF, this.mask | 0x400);
    }

    public int getStyle() {
        return this.style;
    }

    public int getMask() {
        return this.mask;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AttributedStyle that = (AttributedStyle)o;
        if (this.style != that.style) {
            return false;
        }
        return this.mask == that.mask;
    }

    public int hashCode() {
        int result = this.style;
        result = 31 * result + this.mask;
        return result;
    }
}

