/*
 * Decompiled with CFR 0.152.
 */
package coursierapi.shaded.org.jline.utils;

import coursierapi.shaded.org.jline.terminal.Size;
import coursierapi.shaded.org.jline.terminal.impl.AbstractTerminal;
import coursierapi.shaded.org.jline.utils.AttributedString;
import coursierapi.shaded.org.jline.utils.InfoCmp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class Status {
    protected final AbstractTerminal terminal;
    protected final boolean supported;
    protected List<AttributedString> oldLines;
    protected List<AttributedString> linesToRestore;
    protected int rows;
    protected int columns;
    protected boolean force;
    protected boolean suspended;

    public void resize() {
        Size size = this.terminal.getSize();
        this.rows = size.getRows();
        this.columns = size.getColumns();
        this.force = true;
    }

    public void update(List<AttributedString> lines) {
        int i;
        if (!this.supported) {
            return;
        }
        if (lines == null) {
            lines = Collections.emptyList();
        }
        if (this.suspended) {
            this.linesToRestore = new ArrayList<AttributedString>(lines);
            return;
        }
        if (this.oldLines.equals(lines) && !this.force) {
            return;
        }
        int nb = lines.size() - this.oldLines.size();
        if (nb > 0) {
            for (i = 0; i < nb; ++i) {
                this.terminal.puts(InfoCmp.Capability.cursor_down, new Object[0]);
            }
            for (i = 0; i < nb; ++i) {
                this.terminal.puts(InfoCmp.Capability.cursor_up, new Object[0]);
            }
        }
        this.terminal.puts(InfoCmp.Capability.save_cursor, new Object[0]);
        this.terminal.puts(InfoCmp.Capability.cursor_address, this.rows - lines.size(), 0);
        this.terminal.puts(InfoCmp.Capability.clr_eos, new Object[0]);
        for (i = 0; i < lines.size(); ++i) {
            this.terminal.puts(InfoCmp.Capability.cursor_address, this.rows - lines.size() + i, 0);
            lines.get(i).columnSubSequence(0, this.columns).print(this.terminal);
        }
        this.terminal.puts(InfoCmp.Capability.change_scroll_region, 0, this.rows - 1 - lines.size());
        this.terminal.puts(InfoCmp.Capability.restore_cursor, new Object[0]);
        this.terminal.flush();
        this.oldLines = new ArrayList<AttributedString>(lines);
        this.force = false;
    }
}

