/*
 * Decompiled with CFR 0.152.
 */
package coursierapi.shaded.scala.collection.mutable;

import coursierapi.shaded.scala.Function1;
import coursierapi.shaded.scala.PartialFunction;
import coursierapi.shaded.scala.Tuple2;
import coursierapi.shaded.scala.collection.Iterable;
import coursierapi.shaded.scala.collection.IterableOnce;
import coursierapi.shaded.scala.collection.IterableOps;
import coursierapi.shaded.scala.collection.Iterator;
import coursierapi.shaded.scala.collection.LinearSeqOps;
import coursierapi.shaded.scala.collection.SeqFactory;
import coursierapi.shaded.scala.collection.StrictOptimizedIterableOps;
import coursierapi.shaded.scala.collection.StrictOptimizedSeqOps;
import coursierapi.shaded.scala.collection.generic.DefaultSerializable;
import coursierapi.shaded.scala.collection.immutable.$colon$colon;
import coursierapi.shaded.scala.collection.immutable.List;
import coursierapi.shaded.scala.collection.immutable.Nil$;
import coursierapi.shaded.scala.collection.mutable.AbstractBuffer;
import coursierapi.shaded.scala.collection.mutable.Builder;
import coursierapi.shaded.scala.collection.mutable.ListBuffer$;
import coursierapi.shaded.scala.collection.mutable.ReusableBuilder;
import coursierapi.shaded.scala.runtime.BoxesRunTime;
import coursierapi.shaded.scala.runtime.Nothing$;
import coursierapi.shaded.scala.runtime.Statics;
import java.util.NoSuchElementException;

public class ListBuffer<A>
extends AbstractBuffer<A>
implements StrictOptimizedSeqOps<A, ListBuffer, ListBuffer<A>>,
DefaultSerializable,
ReusableBuilder<A, List<A>> {
    private List<A> first = Nil$.MODULE$;
    private $colon$colon<A> last0 = null;
    private boolean aliased = false;
    private int len = 0;

    @Override
    public void sizeHint(int size) {
        Builder.sizeHint$(this, size);
    }

    @Override
    public final void sizeHint(IterableOnce<?> coll, int delta) {
        Builder.sizeHint$(this, coll, delta);
    }

    @Override
    public final void sizeHintBounded(int size, Iterable<?> boundingColl) {
        Builder.sizeHintBounded$(this, size, boundingColl);
    }

    @Override
    public <NewTo> Builder<A, NewTo> mapResult(Function1<List<A>, NewTo> f) {
        return Builder.mapResult$(this, f);
    }

    @Override
    public Object distinctBy(Function1 f) {
        return StrictOptimizedSeqOps.distinctBy$(this, f);
    }

    @Override
    public Object prepended(Object elem) {
        return StrictOptimizedSeqOps.prepended$(this, elem);
    }

    @Override
    public Object appended(Object elem) {
        return StrictOptimizedSeqOps.appended$(this, elem);
    }

    @Override
    public Object appendedAll(IterableOnce suffix) {
        return StrictOptimizedSeqOps.appendedAll$(this, suffix);
    }

    @Override
    public Tuple2<ListBuffer<A>, ListBuffer<A>> partition(Function1<A, Object> p) {
        return StrictOptimizedIterableOps.partition$(this, p);
    }

    @Override
    public Object map(Function1 f) {
        return StrictOptimizedIterableOps.map$(this, f);
    }

    @Override
    public Object flatMap(Function1 f) {
        return StrictOptimizedIterableOps.flatMap$(this, f);
    }

    @Override
    public Object collect(PartialFunction pf) {
        return StrictOptimizedIterableOps.collect$(this, pf);
    }

    @Override
    public Object flatten(Function1 toIterableOnce) {
        return StrictOptimizedIterableOps.flatten$(this, toIterableOnce);
    }

    @Override
    public Object zip(IterableOnce that) {
        return StrictOptimizedIterableOps.zip$(this, that);
    }

    @Override
    public Object filter(Function1 pred) {
        return StrictOptimizedIterableOps.filter$(this, pred);
    }

    @Override
    public Object filterNot(Function1 pred) {
        return StrictOptimizedIterableOps.filterNot$(this, pred);
    }

    @Override
    public Object filterImpl(Function1 pred, boolean isFlipped) {
        return StrictOptimizedIterableOps.filterImpl$(this, pred, isFlipped);
    }

    @Override
    public Object takeRight(int n) {
        return StrictOptimizedIterableOps.takeRight$(this, n);
    }

    @Override
    public Object dropRight(int n) {
        return StrictOptimizedIterableOps.dropRight$(this, n);
    }

    private List<A> first() {
        return this.first;
    }

    private void first_$eq(List<A> x$1) {
        this.first = x$1;
    }

    private $colon$colon<A> last0() {
        return this.last0;
    }

    private void last0_$eq($colon$colon<A> x$1) {
        this.last0 = x$1;
    }

    @Override
    public Iterator<A> iterator() {
        return this.first().iterator();
    }

    @Override
    public SeqFactory<ListBuffer> iterableFactory() {
        return ListBuffer$.MODULE$;
    }

    @Override
    public A apply(int i) throws IndexOutOfBoundsException {
        List<A> list = this.first();
        if (list == null) {
            throw null;
        }
        return (A)LinearSeqOps.apply$(list, i);
    }

    @Override
    public int length() {
        return this.len;
    }

    @Override
    public int knownSize() {
        return this.len;
    }

    @Override
    public boolean isEmpty() {
        return this.len == 0;
    }

    private void copyElems() {
        Object buf = ListBuffer$.MODULE$.from((IterableOnce)this);
        this.first_$eq(super.first());
        this.last0_$eq(super.last0());
        this.aliased = false;
    }

    private void ensureUnaliased() {
        if (this.aliased) {
            this.copyElems();
        }
    }

    @Override
    public List<A> toList() {
        this.aliased = this.nonEmpty();
        Statics.releaseFence();
        return this.first();
    }

    @Override
    public List<A> result() {
        return this.toList();
    }

    public List<A> prependToList(List<A> xs) {
        if (this.isEmpty()) {
            return xs;
        }
        this.ensureUnaliased();
        this.last0().next_$eq(xs);
        return this.toList();
    }

    @Override
    public void clear() {
        this.first_$eq(Nil$.MODULE$);
        this.len = 0;
        this.last0_$eq(null);
        this.aliased = false;
    }

    @Override
    public final ListBuffer<A> addOne(A elem) {
        this.ensureUnaliased();
        $colon$colon<Nothing$> last1 = new $colon$colon<Nothing$>((Nothing$)elem, Nil$.MODULE$);
        if (this.len == 0) {
            this.first_$eq(last1);
        } else {
            this.last0().next_$eq(last1);
        }
        this.last0_$eq(last1);
        ++this.len;
        return this;
    }

    @Override
    public final ListBuffer<A> addAll(IterableOnce<A> xs) {
        Iterator<A> it = xs.iterator();
        if (it.hasNext()) {
            this.ensureUnaliased();
            $colon$colon<Nothing$> last1 = new $colon$colon<Nothing$>((Nothing$)it.next(), Nil$.MODULE$);
            if (this.len == 0) {
                this.first_$eq(last1);
            } else {
                this.last0().next_$eq(last1);
            }
            this.last0_$eq(last1);
            ++this.len;
            while (it.hasNext()) {
                $colon$colon<Nothing$> last12 = new $colon$colon<Nothing$>((Nothing$)it.next(), Nil$.MODULE$);
                this.last0().next_$eq(last12);
                this.last0_$eq(last12);
                ++this.len;
            }
        }
        return this;
    }

    @Override
    public ListBuffer<A> subtractOne(A elem) {
        this.ensureUnaliased();
        if (!this.isEmpty()) {
            if (BoxesRunTime.equals(this.first().head(), elem)) {
                this.first_$eq((List)this.first().tail());
                this.reduceLengthBy(1);
            } else {
                List cursor = this.first();
                while (!((List)cursor.tail()).isEmpty() && !BoxesRunTime.equals(((IterableOps)cursor.tail()).head(), elem)) {
                    cursor = (List)cursor.tail();
                }
                if (!((List)cursor.tail()).isEmpty()) {
                    $colon$colon z = ($colon$colon)cursor;
                    List list = z.next();
                    $colon$colon<A> $colon$colon = this.last0();
                    if (!(list != null ? !((Object)list).equals($colon$colon) : $colon$colon != null)) {
                        this.last0_$eq(z);
                    }
                    z.next_$eq((List)((IterableOps)cursor.tail()).tail());
                    this.reduceLengthBy(1);
                }
            }
        }
        return this;
    }

    private void reduceLengthBy(int num) {
        this.len -= num;
        if (this.len <= 0) {
            this.last0_$eq(null);
        }
    }

    private $colon$colon<A> locate(int i) {
        if (i == 0) {
            return null;
        }
        if (i == this.len) {
            return this.last0();
        }
        List p = this.first();
        for (int j = i - 1; j > 0; --j) {
            p = (List)p.tail();
        }
        return ($colon$colon)p;
    }

    private List<A> getNext($colon$colon<A> p) {
        if (p == null) {
            return this.first();
        }
        return p.next();
    }

    @Override
    public void update(int idx, A elem) {
        this.ensureUnaliased();
        if (idx < 0 || idx >= this.len) {
            throw new IndexOutOfBoundsException(new StringBuilder(31).append(idx).append(" is out of bounds (min 0, max ").append(this.len - 1).append(")").toString());
        }
        if (idx == 0) {
            $colon$colon<A> newElem = new $colon$colon<A>(elem, (List)this.first().tail());
            if (this.last0() == this.first()) {
                this.last0_$eq(newElem);
            }
            this.first_$eq(newElem);
            return;
        }
        $colon$colon<A> p = this.locate(idx);
        if (p == null) {
            throw null;
        }
        $colon$colon<A> newElem = new $colon$colon<A>(elem, (List)p.next().tail());
        if (this.last0() == p.next()) {
            this.last0_$eq(newElem);
        }
        p.next_$eq(newElem);
    }

    @Override
    public A remove(int idx) {
        this.ensureUnaliased();
        if (idx < 0 || idx >= this.len) {
            throw new IndexOutOfBoundsException(new StringBuilder(31).append(idx).append(" is out of bounds (min 0, max ").append(this.len - 1).append(")").toString());
        }
        $colon$colon<A> p = this.locate(idx);
        List<A> nx = this.getNext(p);
        if (p == null) {
            this.first_$eq((List)nx.tail());
            if (this.first().isEmpty()) {
                this.last0_$eq(null);
            }
        } else {
            if (this.last0() == nx) {
                this.last0_$eq(p);
            }
            p.next_$eq((List)nx.tail());
        }
        --this.len;
        return nx.head();
    }

    @Override
    public void remove(int idx, int count) {
        if (count > 0) {
            this.ensureUnaliased();
            if (idx < 0 || idx + count > this.len) {
                throw new IndexOutOfBoundsException(new StringBuilder(35).append(idx).append(" to ").append(idx + count).append(" is out of bounds (min 0, max ").append(this.len - 1).append(")").toString());
            }
            this.removeAfter(this.locate(idx), count);
            return;
        }
        if (count < 0) {
            throw new IllegalArgumentException(new StringBuilder(38).append("removing negative number of elements: ").append(count).toString());
        }
    }

    private void removeAfter($colon$colon<A> prev, int n) {
        List nx = this.ahead$1(this.getNext(prev), n);
        if (prev == null) {
            this.first_$eq(nx);
        } else {
            prev.next_$eq(nx);
        }
        if (nx.isEmpty()) {
            this.last0_$eq(prev);
        }
        this.len -= n;
    }

    @Override
    public A last() {
        if (this.last0() == null) {
            throw new NoSuchElementException("last of empty ListBuffer");
        }
        return this.last0().head();
    }

    @Override
    public String stringPrefix() {
        return "ListBuffer";
    }

    private final List ahead$1(List p, int n) {
        while (n != 0) {
            --n;
            p = (List)p.tail();
        }
        return p;
    }
}

