/*
 * Decompiled with CFR 0.152.
 */
package coursierapi.shaded.scala.math;

import coursierapi.shaded.scala.math.BigDecimal;
import coursierapi.shaded.scala.math.BigInt$;
import coursierapi.shaded.scala.math.Ordered;
import coursierapi.shaded.scala.math.ScalaNumber;
import coursierapi.shaded.scala.math.ScalaNumericAnyConversions;
import coursierapi.shaded.scala.math.ScalaNumericConversions;
import coursierapi.shaded.scala.runtime.BoxesRunTime;
import coursierapi.shaded.scala.runtime.Statics;
import java.math.BigInteger;

public final class BigInt
extends ScalaNumber
implements Ordered<BigInt>,
ScalaNumericConversions {
    private final BigInteger bigInteger;

    @Override
    public boolean $less$eq(Object that) {
        return Ordered.$less$eq$(this, that);
    }

    @Override
    public boolean $greater$eq(Object that) {
        return Ordered.$greater$eq$(this, that);
    }

    @Override
    public int compareTo(Object that) {
        return Ordered.compareTo$(this, that);
    }

    @Override
    public byte toByte() {
        return ScalaNumericAnyConversions.toByte$(this);
    }

    @Override
    public short toShort() {
        return ScalaNumericAnyConversions.toShort$(this);
    }

    @Override
    public int toInt() {
        return ScalaNumericAnyConversions.toInt$(this);
    }

    @Override
    public long toLong() {
        return ScalaNumericAnyConversions.toLong$(this);
    }

    @Override
    public float toFloat() {
        return ScalaNumericAnyConversions.toFloat$(this);
    }

    @Override
    public double toDouble() {
        return ScalaNumericAnyConversions.toDouble$(this);
    }

    @Override
    public int unifiedPrimitiveHashcode() {
        return ScalaNumericAnyConversions.unifiedPrimitiveHashcode$(this);
    }

    @Override
    public boolean unifiedPrimitiveEquals(Object x) {
        return ScalaNumericAnyConversions.unifiedPrimitiveEquals$(this, x);
    }

    public BigInteger bigInteger() {
        return this.bigInteger;
    }

    public int hashCode() {
        if (this.isValidLong()) {
            return ScalaNumericAnyConversions.unifiedPrimitiveHashcode$(this);
        }
        return Statics.anyHash(this.bigInteger());
    }

    public boolean equals(Object that) {
        boolean bl;
        if (that instanceof BigInt) {
            BigInt bigInt = (BigInt)that;
            bl = this.equals(bigInt);
        } else if (that instanceof BigDecimal) {
            bl = ((BigDecimal)that).equals(this);
        } else if (that instanceof Double) {
            double d = BoxesRunTime.unboxToDouble(that);
            bl = this.isValidDouble() && ScalaNumericAnyConversions.toDouble$(this) == d;
        } else if (that instanceof Float) {
            float f = BoxesRunTime.unboxToFloat(that);
            bl = this.isValidFloat() && ScalaNumericAnyConversions.toFloat$(this) == f;
        } else {
            bl = this.isValidLong() && ScalaNumericAnyConversions.unifiedPrimitiveEquals$(this, that);
        }
        return bl;
    }

    @Override
    public boolean isValidByte() {
        BigInt bigInt;
        BigInt bigInt2 = BigInt$.MODULE$.apply(-128);
        return Ordered.$greater$eq$(this, bigInt2) && Ordered.$less$eq$(this, bigInt = BigInt$.MODULE$.apply(127));
    }

    @Override
    public boolean isValidShort() {
        BigInt bigInt;
        BigInt bigInt2 = BigInt$.MODULE$.apply(Short.MIN_VALUE);
        return Ordered.$greater$eq$(this, bigInt2) && Ordered.$less$eq$(this, bigInt = BigInt$.MODULE$.apply(Short.MAX_VALUE));
    }

    @Override
    public boolean isValidChar() {
        BigInt bigInt;
        BigInt bigInt2 = BigInt$.MODULE$.apply(0);
        return Ordered.$greater$eq$(this, bigInt2) && Ordered.$less$eq$(this, bigInt = BigInt$.MODULE$.apply(65535));
    }

    @Override
    public boolean isValidInt() {
        BigInt bigInt;
        BigInt bigInt2 = BigInt$.MODULE$.apply(Integer.MIN_VALUE);
        return Ordered.$greater$eq$(this, bigInt2) && Ordered.$less$eq$(this, bigInt = BigInt$.MODULE$.apply(Integer.MAX_VALUE));
    }

    public boolean isValidLong() {
        BigInt bigInt;
        BigInt bigInt2 = BigInt$.MODULE$.apply(Long.MIN_VALUE);
        return Ordered.$greater$eq$(this, bigInt2) && Ordered.$less$eq$(this, bigInt = BigInt$.MODULE$.apply(Long.MAX_VALUE));
    }

    public boolean isValidFloat() {
        block5: {
            block4: {
                int bitLen = this.bitLength();
                if (bitLen <= 24) break block4;
                int lowest = this.lowestSetBit();
                if (!(bitLen <= 128 && lowest >= bitLen - 24 && lowest < 128)) break block5;
            }
            if (!this.bitLengthOverflow()) {
                return true;
            }
        }
        return false;
    }

    public boolean isValidDouble() {
        block5: {
            block4: {
                int bitLen = this.bitLength();
                if (bitLen <= 53) break block4;
                int lowest = this.lowestSetBit();
                if (!(bitLen <= 1024 && lowest >= bitLen - 53 && lowest < 1024)) break block5;
            }
            if (!this.bitLengthOverflow()) {
                return true;
            }
        }
        return false;
    }

    private boolean bitLengthOverflow() {
        BigInteger shifted = this.bigInteger().shiftRight(Integer.MAX_VALUE);
        return shifted.signum() != 0 && !shifted.equals(BigInt$.MODULE$.scala$math$BigInt$$minusOne());
    }

    @Override
    public boolean isWhole() {
        return true;
    }

    @Override
    public BigInteger underlying() {
        return this.bigInteger();
    }

    public boolean equals(BigInt that) {
        return this.compare(that) == 0;
    }

    @Override
    public int compare(BigInt that) {
        return this.bigInteger().compareTo(that.bigInteger());
    }

    public int lowestSetBit() {
        return this.bigInteger().getLowestSetBit();
    }

    public int bitLength() {
        return this.bigInteger().bitLength();
    }

    @Override
    public byte byteValue() {
        return (byte)this.intValue();
    }

    @Override
    public short shortValue() {
        return (short)this.intValue();
    }

    @Override
    public int intValue() {
        return this.bigInteger().intValue();
    }

    @Override
    public long longValue() {
        return this.bigInteger().longValue();
    }

    @Override
    public float floatValue() {
        return this.bigInteger().floatValue();
    }

    @Override
    public double doubleValue() {
        return this.bigInteger().doubleValue();
    }

    public String toString() {
        return this.bigInteger().toString();
    }

    public BigInt(BigInteger bigInteger) {
        this.bigInteger = bigInteger;
    }
}

