/*
 * Decompiled with CFR 0.152.
 */
package coursierapi.shaded.scala.math;

import coursierapi.shaded.scala.Function1;
import coursierapi.shaded.scala.Option;
import coursierapi.shaded.scala.Tuple2;
import coursierapi.shaded.scala.Tuple4;
import coursierapi.shaded.scala.math.PartialOrdering;
import coursierapi.shaded.scala.util.hashing.MurmurHash3$;
import java.util.Comparator;

public interface Ordering<T>
extends Comparator<T>,
PartialOrdering<T> {
    @Override
    public int compare(T var1, T var2);

    default public boolean lteq(T x, T y) {
        return this.compare(x, y) <= 0;
    }

    default public boolean gteq(T x, T y) {
        return this.compare(x, y) >= 0;
    }

    default public boolean gt(T x, T y) {
        return this.compare(x, y) > 0;
    }

    default public <U extends T> U max(U x, U y) {
        if (this.gteq(x, y)) {
            return x;
        }
        return y;
    }

    default public <U extends T> U min(U x, U y) {
        if (this.lteq(x, y)) {
            return x;
        }
        return y;
    }

    default public Ordering<T> reverse() {
        return new Reverse(this);
    }

    default public boolean isReverseOf(Ordering<?> other) {
        boolean bl;
        if (other instanceof Reverse) {
            Ordering ordering = ((Reverse)other).outer();
            bl = ordering != null && ordering.equals(this);
        } else {
            bl = false;
        }
        return bl;
    }

    default public <U> Ordering<U> on(Function1<U, T> f) {
        return new Ordering<U>(this, f){
            private final /* synthetic */ Ordering $outer;
            private final Function1 f$1;

            public boolean lteq(U x, U y) {
                return Ordering.lteq$(this, x, y);
            }

            public boolean gteq(U x, U y) {
                return Ordering.gteq$(this, x, y);
            }

            public boolean gt(U x, U y) {
                return Ordering.gt$(this, x, y);
            }

            public <U extends U> U max(U x, U y) {
                return (U)Ordering.max$(this, x, y);
            }

            public <U extends U> U min(U x, U y) {
                return (U)Ordering.min$(this, x, y);
            }

            public Ordering<U> reverse() {
                return Ordering.reverse$(this);
            }

            public boolean isReverseOf(Ordering<?> other) {
                return Ordering.isReverseOf$(this, other);
            }

            public <U> Ordering<U> on(Function1<U, U> f) {
                return Ordering.on$(this, f);
            }

            public int compare(U x, U y) {
                return this.$outer.compare(this.f$1.apply(x), this.f$1.apply(y));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.f$1 = f$1;
            }
        };
    }

    public static interface BooleanOrdering
    extends Ordering<Object> {
        public static /* synthetic */ int compare$(BooleanOrdering $this, boolean x, boolean y) {
            return $this.compare(x, y);
        }

        @Override
        default public int compare(boolean x, boolean y) {
            return Boolean.compare(x, y);
        }
    }

    public static interface ByteOrdering
    extends Ordering<Object> {
        public static /* synthetic */ int compare$(ByteOrdering $this, byte x, byte y) {
            return $this.compare(x, y);
        }

        @Override
        default public int compare(byte x, byte y) {
            return Byte.compare(x, y);
        }
    }

    public static interface CachedReverse<T>
    extends Ordering<T> {
        public void scala$math$Ordering$CachedReverse$_setter_$scala$math$Ordering$CachedReverse$$_reverse_$eq(Ordering<T> var1);

        public /* synthetic */ Ordering scala$math$Ordering$CachedReverse$$super$reverse();

        public Ordering<T> scala$math$Ordering$CachedReverse$$_reverse();

        public static /* synthetic */ Ordering reverse$(CachedReverse $this) {
            return $this.reverse();
        }

        @Override
        default public Ordering<T> reverse() {
            return this.scala$math$Ordering$CachedReverse$$_reverse();
        }

        public static /* synthetic */ boolean isReverseOf$(CachedReverse $this, Ordering other) {
            return $this.isReverseOf(other);
        }

        @Override
        default public boolean isReverseOf(Ordering<?> other) {
            return other == this.scala$math$Ordering$CachedReverse$$_reverse();
        }

        public static void $init$(CachedReverse $this) {
            $this.scala$math$Ordering$CachedReverse$_setter_$scala$math$Ordering$CachedReverse$$_reverse_$eq($this.scala$math$Ordering$CachedReverse$$super$reverse());
        }
    }

    public static interface CharOrdering
    extends Ordering<Object> {
        public static /* synthetic */ int compare$(CharOrdering $this, char x, char y) {
            return $this.compare(x, y);
        }

        @Override
        default public int compare(char x, char y) {
            return Character.compare(x, y);
        }
    }

    public static interface IntOrdering
    extends Ordering<Object> {
        public static /* synthetic */ int compare$(IntOrdering $this, int x, int y) {
            return $this.compare(x, y);
        }

        @Override
        default public int compare(int x, int y) {
            return Integer.compare(x, y);
        }
    }

    public static interface LongOrdering
    extends Ordering<Object> {
        public static /* synthetic */ int compare$(LongOrdering $this, long x, long y) {
            return $this.compare(x, y);
        }

        @Override
        default public int compare(long x, long y) {
            return Long.compare(x, y);
        }
    }

    public static interface OptionOrdering<T>
    extends Ordering<Option<T>> {
        public Ordering<T> optionOrdering();

        @Override
        default public boolean equals(Object obj) {
            boolean bl;
            if (obj instanceof Object && this == obj) {
                bl = true;
            } else if (obj instanceof OptionOrdering) {
                OptionOrdering optionOrdering = (OptionOrdering)obj;
                Ordering<T> ordering = this.optionOrdering();
                Ordering<T> ordering2 = optionOrdering.optionOrdering();
                bl = !(ordering != null ? !ordering.equals(ordering2) : ordering2 != null);
            } else {
                bl = false;
            }
            return bl;
        }

        default public int hashCode() {
            return this.optionOrdering().hashCode() * 43;
        }
    }

    public static final class Reverse<T>
    implements Ordering<T> {
        private final Ordering<T> outer;

        @Override
        public <U> Ordering<U> on(Function1<U, T> f) {
            return ((Ordering)this).on(f);
        }

        public Ordering<T> outer() {
            return this.outer;
        }

        @Override
        public Ordering<T> reverse() {
            return this.outer();
        }

        @Override
        public boolean isReverseOf(Ordering<?> other) {
            Ordering<?> ordering = other;
            Ordering<T> ordering2 = this.outer();
            return !(ordering != null ? !ordering.equals(ordering2) : ordering2 != null);
        }

        @Override
        public int compare(T x, T y) {
            return this.outer().compare(y, x);
        }

        @Override
        public boolean lteq(T x, T y) {
            return this.outer().lteq(y, x);
        }

        @Override
        public boolean gteq(T x, T y) {
            return this.outer().gteq(y, x);
        }

        @Override
        public boolean gt(T x, T y) {
            return this.outer().gt(y, x);
        }

        @Override
        public <U extends T> U max(U x, U y) {
            return this.outer().min(x, y);
        }

        @Override
        public <U extends T> U min(U x, U y) {
            return this.outer().max(x, y);
        }

        @Override
        public boolean equals(Object obj) {
            boolean bl;
            if (obj instanceof Object && this == obj) {
                bl = true;
            } else if (obj instanceof Reverse) {
                Reverse reverse = (Reverse)obj;
                Ordering<T> ordering = this.outer();
                Ordering<T> ordering2 = reverse.outer();
                bl = !(ordering != null ? !ordering.equals(ordering2) : ordering2 != null);
            } else {
                bl = false;
            }
            return bl;
        }

        public int hashCode() {
            return this.outer().hashCode() * 41;
        }

        public Reverse(Ordering<T> outer) {
            this.outer = outer;
        }
    }

    public static interface ShortOrdering
    extends Ordering<Object> {
        public static /* synthetic */ int compare$(ShortOrdering $this, short x, short y) {
            return $this.compare(x, y);
        }

        @Override
        default public int compare(short x, short y) {
            return Short.compare(x, y);
        }
    }

    public static interface StringOrdering
    extends Ordering<String> {
        public static /* synthetic */ int compare$(StringOrdering $this, String x, String y) {
            return $this.compare(x, y);
        }

        @Override
        default public int compare(String x, String y) {
            return x.compareTo(y);
        }
    }

    public static final class Tuple2Ordering<T1, T2>
    implements Ordering<Tuple2<T1, T2>> {
        private final Ordering<T1> ord1;
        private final Ordering<T2> ord2;

        @Override
        public boolean lteq(Object x, Object y) {
            return ((Ordering)this).lteq(x, y);
        }

        @Override
        public boolean gteq(Object x, Object y) {
            return ((Ordering)this).gteq(x, y);
        }

        @Override
        public boolean gt(Object x, Object y) {
            return ((Ordering)this).gt(x, y);
        }

        @Override
        public Object max(Object x, Object y) {
            return ((Ordering)this).max(x, y);
        }

        @Override
        public Object min(Object x, Object y) {
            return ((Ordering)this).min(x, y);
        }

        @Override
        public Ordering<Tuple2<T1, T2>> reverse() {
            return ((Ordering)this).reverse();
        }

        @Override
        public boolean isReverseOf(Ordering<?> other) {
            return ((Ordering)this).isReverseOf((Ordering)other);
        }

        @Override
        public <U> Ordering<U> on(Function1<U, Tuple2<T1, T2>> f) {
            return ((Ordering)this).on(f);
        }

        private Ordering<T1> ord1() {
            return this.ord1;
        }

        private Ordering<T2> ord2() {
            return this.ord2;
        }

        @Override
        public int compare(Tuple2<T1, T2> x, Tuple2<T1, T2> y) {
            int compare1 = this.ord1().compare(x._1(), y._1());
            if (compare1 != 0) {
                return compare1;
            }
            return this.ord2().compare(x._2(), y._2());
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(Object obj) {
            if (obj instanceof Object && this == obj) {
                return true;
            }
            if (!(obj instanceof Tuple2Ordering)) return false;
            Tuple2Ordering tuple2Ordering = (Tuple2Ordering)obj;
            Ordering<T1> ordering = this.ord1();
            Ordering<T1> ordering2 = tuple2Ordering.ord1();
            if (ordering == null) {
                if (ordering2 != null) {
                    return false;
                }
            } else if (!ordering.equals(ordering2)) return false;
            Ordering<T2> ordering3 = this.ord2();
            Ordering<T2> ordering4 = tuple2Ordering.ord2();
            if (ordering3 == null) {
                if (ordering4 == null) return true;
                return false;
            } else {
                if (!ordering3.equals(ordering4)) return false;
                return true;
            }
        }

        public int hashCode() {
            return new Tuple2<Ordering<T1>, Ordering<T2>>(this.ord1(), this.ord2()).hashCode();
        }

        public Tuple2Ordering(Ordering<T1> ord1, Ordering<T2> ord2) {
            this.ord1 = ord1;
            this.ord2 = ord2;
        }
    }

    public static final class Tuple4Ordering<T1, T2, T3, T4>
    implements Ordering<Tuple4<T1, T2, T3, T4>> {
        private final Ordering<T1> ord1;
        private final Ordering<T2> ord2;
        private final Ordering<T3> ord3;
        private final Ordering<T4> ord4;

        @Override
        public boolean lteq(Object x, Object y) {
            return ((Ordering)this).lteq(x, y);
        }

        @Override
        public boolean gteq(Object x, Object y) {
            return ((Ordering)this).gteq(x, y);
        }

        @Override
        public boolean gt(Object x, Object y) {
            return ((Ordering)this).gt(x, y);
        }

        @Override
        public Object max(Object x, Object y) {
            return ((Ordering)this).max(x, y);
        }

        @Override
        public Object min(Object x, Object y) {
            return ((Ordering)this).min(x, y);
        }

        @Override
        public Ordering<Tuple4<T1, T2, T3, T4>> reverse() {
            return ((Ordering)this).reverse();
        }

        @Override
        public boolean isReverseOf(Ordering<?> other) {
            return ((Ordering)this).isReverseOf((Ordering)other);
        }

        @Override
        public <U> Ordering<U> on(Function1<U, Tuple4<T1, T2, T3, T4>> f) {
            return ((Ordering)this).on(f);
        }

        private Ordering<T1> ord1() {
            return this.ord1;
        }

        private Ordering<T2> ord2() {
            return this.ord2;
        }

        private Ordering<T3> ord3() {
            return this.ord3;
        }

        private Ordering<T4> ord4() {
            return this.ord4;
        }

        @Override
        public int compare(Tuple4<T1, T2, T3, T4> x, Tuple4<T1, T2, T3, T4> y) {
            int compare1 = this.ord1().compare(x._1(), y._1());
            if (compare1 != 0) {
                return compare1;
            }
            int compare2 = this.ord2().compare(x._2(), y._2());
            if (compare2 != 0) {
                return compare2;
            }
            int compare3 = this.ord3().compare(x._3(), y._3());
            if (compare3 != 0) {
                return compare3;
            }
            return this.ord4().compare(x._4(), y._4());
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(Object obj) {
            if (obj instanceof Object && this == obj) {
                return true;
            }
            if (!(obj instanceof Tuple4Ordering)) return false;
            Tuple4Ordering tuple4Ordering = (Tuple4Ordering)obj;
            Ordering<T1> ordering = this.ord1();
            Ordering<T1> ordering2 = tuple4Ordering.ord1();
            if (ordering == null) {
                if (ordering2 != null) {
                    return false;
                }
            } else if (!ordering.equals(ordering2)) return false;
            Ordering<T2> ordering3 = this.ord2();
            Ordering<T2> ordering4 = tuple4Ordering.ord2();
            if (ordering3 == null) {
                if (ordering4 != null) {
                    return false;
                }
            } else if (!ordering3.equals(ordering4)) return false;
            Ordering<T3> ordering5 = this.ord3();
            Ordering<T3> ordering6 = tuple4Ordering.ord3();
            if (ordering5 == null) {
                if (ordering6 != null) {
                    return false;
                }
            } else if (!ordering5.equals(ordering6)) return false;
            Ordering<T4> ordering7 = this.ord4();
            Ordering<T4> ordering8 = tuple4Ordering.ord4();
            if (ordering7 == null) {
                if (ordering8 == null) return true;
                return false;
            } else {
                if (!ordering7.equals(ordering8)) return false;
                return true;
            }
        }

        public int hashCode() {
            Tuple4<Ordering<T1>, Ordering<T2>, Ordering<T3>, Ordering<T4>> hashCode_this = new Tuple4<Ordering<T1>, Ordering<T2>, Ordering<T3>, Ordering<T4>>(this.ord1(), this.ord2(), this.ord3(), this.ord4());
            return MurmurHash3$.MODULE$.productHash(hashCode_this);
        }

        public Tuple4Ordering(Ordering<T1> ord1, Ordering<T2> ord2, Ordering<T3> ord3, Ordering<T4> ord4) {
            this.ord1 = ord1;
            this.ord2 = ord2;
            this.ord3 = ord3;
            this.ord4 = ord4;
        }
    }
}

