/*
 * Decompiled with CFR 0.152.
 */
package coursierapi;

import coursierapi.Artifact;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public final class FetchResult
implements Serializable {
    private List<Map.Entry<Artifact, File>> artifacts;

    private FetchResult(List<Map.Entry<Artifact, File>> list) {
        this.artifacts = Collections.unmodifiableList(new ArrayList<Map.Entry<Artifact, File>>(list));
    }

    public static FetchResult of(List<Map.Entry<Artifact, File>> list) {
        return new FetchResult(list);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof FetchResult) {
            FetchResult fetchResult = (FetchResult)object;
            return this.artifacts.equals(fetchResult.artifacts);
        }
        return false;
    }

    public int hashCode() {
        return 37 * (17 + this.artifacts.hashCode());
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("FetchResult(");
        boolean bl = true;
        for (Map.Entry<Artifact, File> entry : this.artifacts) {
            if (bl) {
                bl = false;
            } else {
                stringBuilder.append(", ");
            }
            stringBuilder.append(entry.getKey().toString());
            stringBuilder.append(": ");
            stringBuilder.append(entry.getValue().toString());
        }
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    public List<Map.Entry<Artifact, File>> getArtifacts() {
        return this.artifacts;
    }

    public List<File> getFiles() {
        ArrayList<File> arrayList = new ArrayList<File>();
        for (Map.Entry<Artifact, File> entry : this.artifacts) {
            arrayList.add(entry.getValue());
        }
        return arrayList;
    }
}

