/*
 * Decompiled with CFR 0.152.
 */
package coursierapi.shaded.coursier.error;

import coursierapi.shaded.coursier.core.Dependency;
import coursierapi.shaded.coursier.core.Module;
import coursierapi.shaded.coursier.core.Resolution;
import coursierapi.shaded.coursier.core.compatibility.package$;
import coursierapi.shaded.coursier.error.CoursierError;
import coursierapi.shaded.coursier.error.ResolutionError$;
import coursierapi.shaded.coursier.error.ResolutionError$Simple$;
import coursierapi.shaded.coursier.error.conflict.UnsatisfiedRule;
import coursierapi.shaded.coursier.graph.ReverseModuleTree;
import coursierapi.shaded.coursier.graph.ReverseModuleTree$;
import coursierapi.shaded.coursier.params.rule.Rule;
import coursierapi.shaded.coursier.util.Print;
import coursierapi.shaded.coursier.util.Print$;
import coursierapi.shaded.coursier.util.Print$Colors$;
import coursierapi.shaded.coursier.util.Tree$;
import coursierapi.shaded.scala.Function1;
import coursierapi.shaded.scala.Some;
import coursierapi.shaded.scala.Tuple3;
import coursierapi.shaded.scala.collection.IterableOnceOps;
import coursierapi.shaded.scala.collection.IterableOps;
import coursierapi.shaded.scala.collection.SeqOps;
import coursierapi.shaded.scala.collection.immutable.Seq;
import coursierapi.shaded.scala.collection.immutable.Set;
import coursierapi.shaded.scala.math.Ordering$;
import coursierapi.shaded.scala.math.Ordering$String$;
import java.io.Serializable;

public abstract class ResolutionError
extends CoursierError {
    private final Resolution resolution;

    public Resolution resolution() {
        return this.resolution;
    }

    public ResolutionError(Resolution resolution, String message, Throwable cause) {
        this.resolution = resolution;
        super(message, cause);
    }

    public static final class CantDownloadModule
    extends Simple {
        private final Module module;
        private final String version;
        private final Seq<String> perRepositoryErrors;

        public CantDownloadModule(Resolution resolution, Module module, String version, Seq<String> perRepositoryErrors) {
            this.module = module;
            this.version = version;
            this.perRepositoryErrors = perRepositoryErrors;
            super(resolution, new StringBuilder(0).append(new StringBuilder(20).append("Error downloading ").append(module).append(":").append(version).append("\n").toString()).append(((IterableOnceOps)perRepositoryErrors.map(new Serializable(){

                public final String apply(String x$1) {
                    return new StringBuilder(2).append("  ").append(x$1.replace("\n", "  \n")).toString();
                }
            })).mkString("\n")).toString(), ResolutionError$Simple$.MODULE$.$lessinit$greater$default$3());
        }
    }

    public static final class ConflictingDependencies
    extends Simple {
        private final Set<Dependency> dependencies;

        public ConflictingDependencies(Resolution resolution, Set<Dependency> dependencies) {
            this.dependencies = dependencies;
            Set roots = (Set)resolution.conflicts().map(new Serializable(){

                public final Module apply(Dependency x$2) {
                    return x$2.module();
                }
            });
            Seq<ReverseModuleTree> trees = ReverseModuleTree$.MODULE$.apply(resolution, (Seq)roots.toVector().sortBy((Function1)((Object)new Serializable(){

                public final Tuple3<String, String, String> apply(Module m) {
                    return new Tuple3<String, String, String>(m.organization(), m.name(), m.nameWithAttributes());
                }
            }), Ordering$.MODULE$.Tuple3(Ordering$String$.MODULE$, Ordering$String$.MODULE$, Ordering$String$.MODULE$)), ReverseModuleTree$.MODULE$.apply$default$3());
            Print.Colors colors0 = Print$Colors$.MODULE$.get(package$.MODULE$.hasConsole());
            Seq renderedTrees = (Seq)trees.map(new Serializable(colors0){
                private final Print.Colors colors0$1;

                public final String apply(ReverseModuleTree t) {
                    String rendered = Tree$.MODULE$.apply(t.dependees().toVector(), (Function1<ReverseModuleTree, Seq> & Serializable)x$3 -> x$3.dependees()).customRender(false, "  ", new Some<String>(""), (Function1<ReverseModuleTree, String> & Serializable)node -> {
                        String string;
                        if (node.excludedDependsOn()) {
                            string = new StringBuilder(15).append($this.colors0$1.yellow()).append("(excluded by)").append($this.colors0$1.reset()).append(" ").append(node.module()).append(":").append(node.reconciledVersion()).toString();
                        } else {
                            Module module = node.dependsOnModule();
                            Module module2 = t.module();
                            if (!(module != null ? !((Object)module).equals(module2) : module2 != null)) {
                                boolean assumeCompatibleVersions = Print$.MODULE$.compatibleVersions(node.dependsOnVersion(), node.dependsOnReconciledVersion());
                                string = new StringBuilder(0).append(new StringBuilder(2).append(node.module()).append(":").append(node.reconciledVersion()).append(" ").toString()).append((Object)(assumeCompatibleVersions ? $this.colors0$1.yellow() : $this.colors0$1.red())).append(new StringBuilder(6).append("wants ").append(node.dependsOnVersion()).toString()).append($this.colors0$1.reset()).toString();
                            } else {
                                String string2 = node.dependsOnVersion();
                                String string3 = node.dependsOnReconciledVersion();
                                if (string2 == null ? string3 != null : !string2.equals(string3)) {
                                    boolean assumeCompatibleVersions = Print$.MODULE$.compatibleVersions(node.dependsOnVersion(), node.dependsOnReconciledVersion());
                                    string = new StringBuilder(0).append(new StringBuilder(2).append(node.module()).append(":").append(node.reconciledVersion()).append(" ").toString()).append((Object)(assumeCompatibleVersions ? $this.colors0$1.yellow() : $this.colors0$1.red())).append(new StringBuilder(7).append("wants ").append(node.dependsOnModule()).append(":").append(node.dependsOnVersion()).toString()).append($this.colors0$1.reset()).toString();
                                } else {
                                    string = new StringBuilder(1).append(node.module()).append(":").append(node.reconciledVersion()).toString();
                                }
                            }
                        }
                        return string;
                    });
                    return new StringBuilder(1).append(new StringBuilder(13).append(t.module().repr()).append(":").append(((IterableOnceOps)((SeqOps)t.dependees().map((Function1<ReverseModuleTree, String> & Serializable)x$4 -> x$4.dependsOnVersion())).distinct()).mkString(" or ")).append(" wanted by\n\n").toString()).append(rendered).append("\n").toString();
                }
                {
                    this.colors0$1 = colors0$1;
                }
            });
            super(resolution, new StringBuilder(26).append("Conflicting dependencies:\n").append(renderedTrees.mkString("\n")).toString(), ResolutionError$Simple$.MODULE$.$lessinit$greater$default$3());
        }
    }

    public static final class MaximumIterationReached
    extends Simple {
        public MaximumIterationReached(Resolution resolution) {
            super(resolution, "Maximum number of iterations reached", ResolutionError$Simple$.MODULE$.$lessinit$greater$default$3());
        }
    }

    public static final class Several
    extends ResolutionError {
        private final Simple head;
        private final Seq<Simple> tail;

        public Simple head() {
            return this.head;
        }

        public Seq<Simple> tail() {
            return this.tail;
        }

        public Several(Simple head, Seq<Simple> tail) {
            this.head = head;
            this.tail = tail;
            Simple simple = head;
            super(head.resolution(), ((IterableOnceOps)((IterableOps)tail.$plus$colon(simple)).map(new Serializable(){

                public final String apply(Simple x$5) {
                    return x$5.getMessage();
                }
            })).mkString("\n"), ResolutionError$.MODULE$.$lessinit$greater$default$3());
        }
    }

    public static abstract class Simple
    extends ResolutionError {
        public Simple(Resolution resolution, String message, Throwable cause) {
            super(resolution, message, cause);
        }
    }

    public static abstract class UnsatisfiableRule
    extends Simple {
        private final Rule rule;
        private final UnsatisfiedRule conflict;

        public UnsatisfiableRule(Resolution resolution, Rule rule, UnsatisfiedRule conflict, String message) {
            this.rule = rule;
            this.conflict = conflict;
            super(resolution, message, conflict);
        }
    }
}

