/*
 * Decompiled with CFR 0.152.
 */
package coursierapi.shaded.scala.collection.immutable;

import coursierapi.shaded.scala.None$;
import coursierapi.shaded.scala.Option;
import coursierapi.shaded.scala.Some;
import coursierapi.shaded.scala.Tuple2;
import coursierapi.shaded.scala.collection.AbstractIterator;
import coursierapi.shaded.scala.collection.Iterator$;
import coursierapi.shaded.scala.collection.immutable.RedBlackTree$;
import coursierapi.shaded.scala.math.Ordering;
import java.util.NoSuchElementException;

public final class RedBlackTree {

    public static final class BlackTree<A, B>
    extends Tree<A, B> {
        @Override
        public Tree<A, B> black() {
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public Tree<A, B> red() {
            void apply_right;
            void apply_left;
            Tree tree = super.right();
            Tree tree2 = super.left();
            Object apply_value = super.value();
            Object apply_key = super.key();
            return new RedTree(apply_key, apply_value, apply_left, apply_right);
        }

        public String toString() {
            return new StringBuilder(17).append("BlackTree(").append(super.key()).append(", ").append(super.value()).append(", ").append(super.left()).append(", ").append(super.right()).append(")").toString();
        }

        public BlackTree(A key, B value, Tree<A, B> left, Tree<A, B> right) {
            super(key, value, left, right);
        }
    }

    public static class EntriesIterator<A, B>
    extends TreeIterator<A, B, Tuple2<A, B>> {
        @Override
        public Tuple2<A, B> nextResult(Tree<A, B> tree) {
            return new Tuple2<A, B>(tree.key(), tree.value());
        }

        public EntriesIterator(Tree<A, B> tree, Option<A> focus, Ordering<A> evidence$16) {
            super(tree, focus, evidence$16);
        }
    }

    public static class KeysIterator<A, B>
    extends TreeIterator<A, B, A> {
        @Override
        public A nextResult(Tree<A, B> tree) {
            return tree.key();
        }

        public KeysIterator(Tree<A, B> tree, Option<A> focus, Ordering<A> evidence$17) {
            super(tree, focus, evidence$17);
        }
    }

    public static final class RedTree<A, B>
    extends Tree<A, B> {
        /*
         * WARNING - void declaration
         */
        @Override
        public Tree<A, B> black() {
            void apply_right;
            void apply_left;
            Tree tree = super.right();
            Tree tree2 = super.left();
            Object apply_value = super.value();
            Object apply_key = super.key();
            return new BlackTree(apply_key, apply_value, apply_left, apply_right);
        }

        @Override
        public Tree<A, B> red() {
            return this;
        }

        public String toString() {
            return new StringBuilder(15).append("RedTree(").append(super.key()).append(", ").append(super.value()).append(", ").append(super.left()).append(", ").append(super.right()).append(")").toString();
        }

        public RedTree(A key, B value, Tree<A, B> left, Tree<A, B> right) {
            super(key, value, left, right);
        }
    }

    public static abstract class Tree<A, B> {
        private final A key;
        private final B value;
        private final Tree<A, B> left;
        private final Tree<A, B> right;
        private final int count;

        public final A key() {
            return this.key;
        }

        public final B value() {
            return this.value;
        }

        public final Tree<A, B> left() {
            return this.left;
        }

        public final Tree<A, B> right() {
            return this.right;
        }

        public final int count() {
            return this.count;
        }

        public abstract Tree<A, B> black();

        public abstract Tree<A, B> red();

        public Tree(A key, B value, Tree<A, B> left, Tree<A, B> right) {
            this.key = key;
            this.value = value;
            this.left = left;
            this.right = right;
            this.count = 1 + RedBlackTree$.MODULE$.count(left) + RedBlackTree$.MODULE$.count(right);
        }
    }

    public static abstract class TreeIterator<A, B, R>
    extends AbstractIterator<R> {
        private final Tree<A, B> root;
        private final Ordering<A> ordering;
        private Tree<A, B>[] stackOfNexts;
        private int index;
        private Tree<A, B> lookahead;

        public abstract R nextResult(Tree<A, B> var1);

        @Override
        public boolean hasNext() {
            return this.lookahead != null;
        }

        @Override
        public R next() throws NoSuchElementException {
            Tree<A, B> tree = this.lookahead;
            if (tree != null) {
                this.lookahead = this.findLeftMostOrPopOnEmpty(tree.right());
                return this.nextResult(tree);
            }
            return (R)Iterator$.scala$collection$Iterator$$_empty.next();
        }

        private Tree<A, B> findLeftMostOrPopOnEmpty(Tree<A, B> tree) {
            while (tree != null) {
                Tree<A, B> tree2;
                if (tree.left() == null) {
                    return tree;
                }
                this.scala$collection$immutable$RedBlackTree$TreeIterator$$pushNext(tree);
                Tree<A, B> tree3 = tree2 = tree.left();
                tree2 = null;
                tree = tree3;
            }
            return this.popNext();
        }

        public void scala$collection$immutable$RedBlackTree$TreeIterator$$pushNext(Tree<A, B> tree) {
            this.stackOfNexts[this.index] = tree;
            ++this.index;
        }

        private Tree<A, B> popNext() {
            if (this.index == 0) {
                return null;
            }
            --this.index;
            return this.stackOfNexts[this.index];
        }

        private Tree<A, B> startFrom(A key) {
            if (this.root == null) {
                return null;
            }
            return this.find$1(this.root, key);
        }

        private final Tree find$1(Tree tree, Object key$1) {
            while (tree != null) {
                Tree tree2;
                if (this.ordering.lteq(key$1, tree.key())) {
                    this.scala$collection$immutable$RedBlackTree$TreeIterator$$pushNext(tree);
                    tree2 = tree.left();
                } else {
                    Tree tree3;
                    tree2 = tree3 = tree.right();
                    tree3 = null;
                }
                tree = tree2;
            }
            return this.popNext();
        }

        public TreeIterator(Tree<A, B> root, Option<A> start, Ordering<A> ordering) {
            Option option;
            this.root = root;
            this.ordering = ordering;
            this.stackOfNexts = root == null ? null : new Tree[2 * (32 - Integer.numberOfLeadingZeros(root.count() + 2 - 1)) - 2];
            this.index = 0;
            if (start == null) {
                throw null;
            }
            if (start.isEmpty()) {
                option = None$.MODULE$;
            } else {
                A a = start.get();
                Some<Tree> some = new Some<Tree>(this.startFrom(a));
                option = some;
            }
            Option getOrElse_this = option;
            this.lookahead = getOrElse_this.isEmpty() ? this.findLeftMostOrPopOnEmpty(this.root) : getOrElse_this.get();
        }
    }
}

