/*
 * Decompiled with CFR 0.152.
 */
package coursierapi.shaded.coursier.util.shaded.org.jsoup.parser;

import coursierapi.shaded.coursier.util.shaded.org.jsoup.parser.CharacterReader;
import coursierapi.shaded.coursier.util.shaded.org.jsoup.parser.Token;
import coursierapi.shaded.coursier.util.shaded.org.jsoup.parser.Tokeniser;

abstract class TokeniserState
extends Enum<TokeniserState> {
    public static final /* enum */ TokeniserState Data = new TokeniserState(){

        @Override
        void read(Tokeniser t, CharacterReader r) {
            switch (r.current()) {
                case '&': {
                    t.advanceTransition(CharacterReferenceInData);
                    break;
                }
                case '<': {
                    t.advanceTransition(TagOpen);
                    break;
                }
                case '\u0000': {
                    t.error(this);
                    t.emit(r.consume());
                    break;
                }
                case '\uffff': {
                    t.emit(new Token.EOF());
                    break;
                }
                default: {
                    String data = r.consumeData();
                    t.emit(data);
                }
            }
        }
    };
    public static final /* enum */ TokeniserState CharacterReferenceInData = new TokeniserState(){

        @Override
        void read(Tokeniser t, CharacterReader r) {
            TokeniserState.readCharRef(t, 2.Data);
        }
    };
    public static final /* enum */ TokeniserState Rcdata = new TokeniserState(){

        @Override
        void read(Tokeniser t, CharacterReader r) {
            switch (r.current()) {
                case '&': {
                    t.advanceTransition(CharacterReferenceInRcdata);
                    break;
                }
                case '<': {
                    t.advanceTransition(RcdataLessthanSign);
                    break;
                }
                case '\u0000': {
                    t.error(this);
                    r.advance();
                    t.emit('\ufffd');
                    break;
                }
                case '\uffff': {
                    t.emit(new Token.EOF());
                    break;
                }
                default: {
                    String data = r.consumeData();
                    t.emit(data);
                }
            }
        }
    };
    public static final /* enum */ TokeniserState CharacterReferenceInRcdata = new TokeniserState(){

        @Override
        void read(Tokeniser t, CharacterReader r) {
            TokeniserState.readCharRef(t, 4.Rcdata);
        }
    };
    public static final /* enum */ TokeniserState Rawtext = new TokeniserState(){

        @Override
        void read(Tokeniser t, CharacterReader r) {
            TokeniserState.readRawData(t, r, (TokeniserState)this, 5.RawtextLessthanSign);
        }
    };
    public static final /* enum */ TokeniserState ScriptData = new TokeniserState(){

        @Override
        void read(Tokeniser t, CharacterReader r) {
            TokeniserState.readRawData(t, r, (TokeniserState)this, 6.ScriptDataLessthanSign);
        }
    };
    public static final /* enum */ TokeniserState PLAINTEXT = new TokeniserState(){

        @Override
        void read(Tokeniser t, CharacterReader r) {
            switch (r.current()) {
                case '\u0000': {
                    t.error(this);
                    r.advance();
                    t.emit('\ufffd');
                    break;
                }
                case '\uffff': {
                    t.emit(new Token.EOF());
                    break;
                }
                default: {
                    String data = r.consumeTo('\u0000');
                    t.emit(data);
                }
            }
        }
    };
    public static final /* enum */ TokeniserState TagOpen = new TokeniserState(){

        @Override
        void read(Tokeniser t, CharacterReader r) {
            switch (r.current()) {
                case '!': {
                    t.advanceTransition(MarkupDeclarationOpen);
                    break;
                }
                case '/': {
                    t.advanceTransition(EndTagOpen);
                    break;
                }
                case '?': {
                    t.createBogusCommentPending();
                    t.transition(BogusComment);
                    break;
                }
                default: {
                    if (r.matchesAsciiAlpha()) {
                        t.createTagPending(true);
                        t.transition(TagName);
                        break;
                    }
                    t.error(this);
                    t.emit('<');
                    t.transition(Data);
                }
            }
        }
    };
    public static final /* enum */ TokeniserState EndTagOpen = new TokeniserState(){

        @Override
        void read(Tokeniser t, CharacterReader r) {
            if (r.isEmpty()) {
                t.eofError(this);
                t.emit("</");
                t.transition(Data);
            } else if (r.matchesAsciiAlpha()) {
                t.createTagPending(false);
                t.transition(TagName);
            } else if (r.matches('>')) {
                t.error(this);
                t.advanceTransition(Data);
            } else {
                t.error(this);
                t.createBogusCommentPending();
                t.commentPending.append('/');
                t.transition(BogusComment);
            }
        }
    };
    public static final /* enum */ TokeniserState TagName = new TokeniserState(){

        @Override
        void read(Tokeniser t, CharacterReader r) {
            String tagName = r.consumeTagName();
            t.tagPending.appendTagName(tagName);
            char c = r.consume();
            switch (c) {
                case '\t': 
                case '\n': 
                case '\f': 
                case '\r': 
                case ' ': {
                    t.transition(BeforeAttributeName);
                    break;
                }
                case '/': {
                    t.transition(SelfClosingStartTag);
                    break;
                }
                case '<': {
                    r.unconsume();
                    t.error(this);
                }
                case '>': {
                    t.emitTagPending();
                    t.transition(Data);
                    break;
                }
                case '\u0000': {
                    t.tagPending.appendTagName(replacementStr);
                    break;
                }
                case '\uffff': {
                    t.eofError(this);
                    t.transition(Data);
                    break;
                }
                default: {
                    t.tagPending.appendTagName(c);
                }
            }
        }
    };
    public static final /* enum */ TokeniserState RcdataLessthanSign = new TokeniserState(){

        @Override
        void read(Tokeniser t, CharacterReader r) {
            if (r.matches('/')) {
                t.createTempBuffer();
                t.advanceTransition(RCDATAEndTagOpen);
            } else if (r.matchesAsciiAlpha() && t.appropriateEndTagName() != null && !r.containsIgnoreCase(t.appropriateEndTagSeq())) {
                t.tagPending = t.createTagPending(false).name(t.appropriateEndTagName());
                t.emitTagPending();
                t.transition(TagOpen);
            } else {
                t.emit("<");
                t.transition(Rcdata);
            }
        }
    };
    public static final /* enum */ TokeniserState RCDATAEndTagOpen = new TokeniserState(){

        @Override
        void read(Tokeniser t, CharacterReader r) {
            if (r.matchesAsciiAlpha()) {
                t.createTagPending(false);
                t.tagPending.appendTagName(r.current());
                t.dataBuffer.append(r.current());
                t.advanceTransition(RCDATAEndTagName);
            } else {
                t.emit("</");
                t.transition(Rcdata);
            }
        }
    };
    public static final /* enum */ TokeniserState RCDATAEndTagName = new TokeniserState(){

        @Override
        void read(Tokeniser t, CharacterReader r) {
            if (r.matchesAsciiAlpha()) {
                String name = r.consumeLetterSequence();
                t.tagPending.appendTagName(name);
                t.dataBuffer.append(name);
                return;
            }
            char c = r.consume();
            switch (c) {
                case '\t': 
                case '\n': 
                case '\f': 
                case '\r': 
                case ' ': {
                    if (t.isAppropriateEndTagToken()) {
                        t.transition(BeforeAttributeName);
                        break;
                    }
                    this.anythingElse(t, r);
                    break;
                }
                case '/': {
                    if (t.isAppropriateEndTagToken()) {
                        t.transition(SelfClosingStartTag);
                        break;
                    }
                    this.anythingElse(t, r);
                    break;
                }
                case '>': {
                    if (t.isAppropriateEndTagToken()) {
                        t.emitTagPending();
                        t.transition(Data);
                        break;
                    }
                    this.anythingElse(t, r);
                    break;
                }
                default: {
                    this.anythingElse(t, r);
                }
            }
        }

        private void anythingElse(Tokeniser t, CharacterReader r) {
            t.emit("</");
            t.emit(t.dataBuffer);
            r.unconsume();
            t.transition(Rcdata);
        }
    };
    public static final /* enum */ TokeniserState RawtextLessthanSign = new TokeniserState(){

        @Override
        void read(Tokeniser t, CharacterReader r) {
            if (r.matches('/')) {
                t.createTempBuffer();
                t.advanceTransition(RawtextEndTagOpen);
            } else {
                t.emit('<');
                t.transition(Rawtext);
            }
        }
    };
    public static final /* enum */ TokeniserState RawtextEndTagOpen = new TokeniserState(){

        @Override
        void read(Tokeniser t, CharacterReader r) {
            TokeniserState.readEndTag(t, r, 15.RawtextEndTagName, 15.Rawtext);
        }
    };
    public static final /* enum */ TokeniserState RawtextEndTagName = new TokeniserState(){

        @Override
        void read(Tokeniser t, CharacterReader r) {
            TokeniserState.handleDataEndTag(t, r, 16.Rawtext);
        }
    };
    public static final /* enum */ TokeniserState ScriptDataLessthanSign = new TokeniserState(){

        @Override
        void read(Tokeniser t, CharacterReader r) {
            switch (r.consume()) {
                case '/': {
                    t.createTempBuffer();
                    t.transition(ScriptDataEndTagOpen);
                    break;
                }
                case '!': {
                    t.emit("<!");
                    t.transition(ScriptDataEscapeStart);
                    break;
                }
                case '\uffff': {
                    t.emit("<");
                    t.eofError(this);
                    t.transition(Data);
                    break;
                }
                default: {
                    t.emit("<");
                    r.unconsume();
                    t.transition(ScriptData);
                }
            }
        }
    };
    public static final /* enum */ TokeniserState ScriptDataEndTagOpen = new TokeniserState(){

        @Override
        void read(Tokeniser t, CharacterReader r) {
            TokeniserState.readEndTag(t, r, 18.ScriptDataEndTagName, 18.ScriptData);
        }
    };
    public static final /* enum */ TokeniserState ScriptDataEndTagName = new TokeniserState(){

        @Override
        void read(Tokeniser t, CharacterReader r) {
            TokeniserState.handleDataEndTag(t, r, 19.ScriptData);
        }
    };
    public static final /* enum */ TokeniserState ScriptDataEscapeStart = new TokeniserState(){

        @Override
        void read(Tokeniser t, CharacterReader r) {
            if (r.matches('-')) {
                t.emit('-');
                t.advanceTransition(ScriptDataEscapeStartDash);
            } else {
                t.transition(ScriptData);
            }
        }
    };
    public static final /* enum */ TokeniserState ScriptDataEscapeStartDash = new TokeniserState(){

        @Override
        void read(Tokeniser t, CharacterReader r) {
            if (r.matches('-')) {
                t.emit('-');
                t.advanceTransition(ScriptDataEscapedDashDash);
            } else {
                t.transition(ScriptData);
            }
        }
    };
    public static final /* enum */ TokeniserState ScriptDataEscaped = new TokeniserState(){

        @Override
        void read(Tokeniser t, CharacterReader r) {
            if (r.isEmpty()) {
                t.eofError(this);
                t.transition(Data);
                return;
            }
            switch (r.current()) {
                case '-': {
                    t.emit('-');
                    t.advanceTransition(ScriptDataEscapedDash);
                    break;
                }
                case '<': {
                    t.advanceTransition(ScriptDataEscapedLessthanSign);
                    break;
                }
                case '\u0000': {
                    t.error(this);
                    r.advance();
                    t.emit('\ufffd');
                    break;
                }
                default: {
                    String data = r.consumeToAny('-', '<', '\u0000');
                    t.emit(data);
                }
            }
        }
    };
    public static final /* enum */ TokeniserState ScriptDataEscapedDash = new TokeniserState(){

        @Override
        void read(Tokeniser t, CharacterReader r) {
            if (r.isEmpty()) {
                t.eofError(this);
                t.transition(Data);
                return;
            }
            char c = r.consume();
            switch (c) {
                case '-': {
                    t.emit(c);
                    t.transition(ScriptDataEscapedDashDash);
                    break;
                }
                case '<': {
                    t.transition(ScriptDataEscapedLessthanSign);
                    break;
                }
                case '\u0000': {
                    t.error(this);
                    t.emit('\ufffd');
                    t.transition(ScriptDataEscaped);
                    break;
                }
                default: {
                    t.emit(c);
                    t.transition(ScriptDataEscaped);
                }
            }
        }
    };
    public static final /* enum */ TokeniserState ScriptDataEscapedDashDash = new TokeniserState(){

        @Override
        void read(Tokeniser t, CharacterReader r) {
            if (r.isEmpty()) {
                t.eofError(this);
                t.transition(Data);
                return;
            }
            char c = r.consume();
            switch (c) {
                case '-': {
                    t.emit(c);
                    break;
                }
                case '<': {
                    t.transition(ScriptDataEscapedLessthanSign);
                    break;
                }
                case '>': {
                    t.emit(c);
                    t.transition(ScriptData);
                    break;
                }
                case '\u0000': {
                    t.error(this);
                    t.emit('\ufffd');
                    t.transition(ScriptDataEscaped);
                    break;
                }
                default: {
                    t.emit(c);
                    t.transition(ScriptDataEscaped);
                }
            }
        }
    };
    public static final /* enum */ TokeniserState ScriptDataEscapedLessthanSign = new TokeniserState(){

        @Override
        void read(Tokeniser t, CharacterReader r) {
            if (r.matchesAsciiAlpha()) {
                t.createTempBuffer();
                t.dataBuffer.append(r.current());
                t.emit("<");
                t.emit(r.current());
                t.advanceTransition(ScriptDataDoubleEscapeStart);
            } else if (r.matches('/')) {
                t.createTempBuffer();
                t.advanceTransition(ScriptDataEscapedEndTagOpen);
            } else {
                t.emit('<');
                t.transition(ScriptDataEscaped);
            }
        }
    };
    public static final /* enum */ TokeniserState ScriptDataEscapedEndTagOpen = new TokeniserState(){

        @Override
        void read(Tokeniser t, CharacterReader r) {
            if (r.matchesAsciiAlpha()) {
                t.createTagPending(false);
                t.tagPending.appendTagName(r.current());
                t.dataBuffer.append(r.current());
                t.advanceTransition(ScriptDataEscapedEndTagName);
            } else {
                t.emit("</");
                t.transition(ScriptDataEscaped);
            }
        }
    };
    public static final /* enum */ TokeniserState ScriptDataEscapedEndTagName = new TokeniserState(){

        @Override
        void read(Tokeniser t, CharacterReader r) {
            TokeniserState.handleDataEndTag(t, r, 27.ScriptDataEscaped);
        }
    };
    public static final /* enum */ TokeniserState ScriptDataDoubleEscapeStart = new TokeniserState(){

        @Override
        void read(Tokeniser t, CharacterReader r) {
            TokeniserState.handleDataDoubleEscapeTag(t, r, 28.ScriptDataDoubleEscaped, 28.ScriptDataEscaped);
        }
    };
    public static final /* enum */ TokeniserState ScriptDataDoubleEscaped = new TokeniserState(){

        @Override
        void read(Tokeniser t, CharacterReader r) {
            char c = r.current();
            switch (c) {
                case '-': {
                    t.emit(c);
                    t.advanceTransition(ScriptDataDoubleEscapedDash);
                    break;
                }
                case '<': {
                    t.emit(c);
                    t.advanceTransition(ScriptDataDoubleEscapedLessthanSign);
                    break;
                }
                case '\u0000': {
                    t.error(this);
                    r.advance();
                    t.emit('\ufffd');
                    break;
                }
                case '\uffff': {
                    t.eofError(this);
                    t.transition(Data);
                    break;
                }
                default: {
                    String data = r.consumeToAny('-', '<', '\u0000');
                    t.emit(data);
                }
            }
        }
    };
    public static final /* enum */ TokeniserState ScriptDataDoubleEscapedDash = new TokeniserState(){

        @Override
        void read(Tokeniser t, CharacterReader r) {
            char c = r.consume();
            switch (c) {
                case '-': {
                    t.emit(c);
                    t.transition(ScriptDataDoubleEscapedDashDash);
                    break;
                }
                case '<': {
                    t.emit(c);
                    t.transition(ScriptDataDoubleEscapedLessthanSign);
                    break;
                }
                case '\u0000': {
                    t.error(this);
                    t.emit('\ufffd');
                    t.transition(ScriptDataDoubleEscaped);
                    break;
                }
                case '\uffff': {
                    t.eofError(this);
                    t.transition(Data);
                    break;
                }
                default: {
                    t.emit(c);
                    t.transition(ScriptDataDoubleEscaped);
                }
            }
        }
    };
    public static final /* enum */ TokeniserState ScriptDataDoubleEscapedDashDash = new TokeniserState(){

        @Override
        void read(Tokeniser t, CharacterReader r) {
            char c = r.consume();
            switch (c) {
                case '-': {
                    t.emit(c);
                    break;
                }
                case '<': {
                    t.emit(c);
                    t.transition(ScriptDataDoubleEscapedLessthanSign);
                    break;
                }
                case '>': {
                    t.emit(c);
                    t.transition(ScriptData);
                    break;
                }
                case '\u0000': {
                    t.error(this);
                    t.emit('\ufffd');
                    t.transition(ScriptDataDoubleEscaped);
                    break;
                }
                case '\uffff': {
                    t.eofError(this);
                    t.transition(Data);
                    break;
                }
                default: {
                    t.emit(c);
                    t.transition(ScriptDataDoubleEscaped);
                }
            }
        }
    };
    public static final /* enum */ TokeniserState ScriptDataDoubleEscapedLessthanSign = new TokeniserState(){

        @Override
        void read(Tokeniser t, CharacterReader r) {
            if (r.matches('/')) {
                t.emit('/');
                t.createTempBuffer();
                t.advanceTransition(ScriptDataDoubleEscapeEnd);
            } else {
                t.transition(ScriptDataDoubleEscaped);
            }
        }
    };
    public static final /* enum */ TokeniserState ScriptDataDoubleEscapeEnd = new TokeniserState(){

        @Override
        void read(Tokeniser t, CharacterReader r) {
            TokeniserState.handleDataDoubleEscapeTag(t, r, 33.ScriptDataEscaped, 33.ScriptDataDoubleEscaped);
        }
    };
    public static final /* enum */ TokeniserState BeforeAttributeName = new TokeniserState(){

        @Override
        void read(Tokeniser t, CharacterReader r) {
            char c = r.consume();
            switch (c) {
                case '\t': 
                case '\n': 
                case '\f': 
                case '\r': 
                case ' ': {
                    break;
                }
                case '/': {
                    t.transition(SelfClosingStartTag);
                    break;
                }
                case '<': {
                    r.unconsume();
                    t.error(this);
                }
                case '>': {
                    t.emitTagPending();
                    t.transition(Data);
                    break;
                }
                case '\u0000': {
                    r.unconsume();
                    t.error(this);
                    t.tagPending.newAttribute();
                    t.transition(AttributeName);
                    break;
                }
                case '\uffff': {
                    t.eofError(this);
                    t.transition(Data);
                    break;
                }
                case '\"': 
                case '\'': 
                case '=': {
                    t.error(this);
                    t.tagPending.newAttribute();
                    t.tagPending.appendAttributeName(c);
                    t.transition(AttributeName);
                    break;
                }
                default: {
                    t.tagPending.newAttribute();
                    r.unconsume();
                    t.transition(AttributeName);
                }
            }
        }
    };
    public static final /* enum */ TokeniserState AttributeName = new TokeniserState(){

        @Override
        void read(Tokeniser t, CharacterReader r) {
            String name = r.consumeToAnySorted(attributeNameCharsSorted);
            t.tagPending.appendAttributeName(name);
            char c = r.consume();
            switch (c) {
                case '\t': 
                case '\n': 
                case '\f': 
                case '\r': 
                case ' ': {
                    t.transition(AfterAttributeName);
                    break;
                }
                case '/': {
                    t.transition(SelfClosingStartTag);
                    break;
                }
                case '=': {
                    t.transition(BeforeAttributeValue);
                    break;
                }
                case '>': {
                    t.emitTagPending();
                    t.transition(Data);
                    break;
                }
                case '\uffff': {
                    t.eofError(this);
                    t.transition(Data);
                    break;
                }
                case '\"': 
                case '\'': 
                case '<': {
                    t.error(this);
                    t.tagPending.appendAttributeName(c);
                    break;
                }
                default: {
                    t.tagPending.appendAttributeName(c);
                }
            }
        }
    };
    public static final /* enum */ TokeniserState AfterAttributeName = new TokeniserState(){

        @Override
        void read(Tokeniser t, CharacterReader r) {
            char c = r.consume();
            switch (c) {
                case '\t': 
                case '\n': 
                case '\f': 
                case '\r': 
                case ' ': {
                    break;
                }
                case '/': {
                    t.transition(SelfClosingStartTag);
                    break;
                }
                case '=': {
                    t.transition(BeforeAttributeValue);
                    break;
                }
                case '>': {
                    t.emitTagPending();
                    t.transition(Data);
                    break;
                }
                case '\u0000': {
                    t.error(this);
                    t.tagPending.appendAttributeName('\ufffd');
                    t.transition(AttributeName);
                    break;
                }
                case '\uffff': {
                    t.eofError(this);
                    t.transition(Data);
                    break;
                }
                case '\"': 
                case '\'': 
                case '<': {
                    t.error(this);
                    t.tagPending.newAttribute();
                    t.tagPending.appendAttributeName(c);
                    t.transition(AttributeName);
                    break;
                }
                default: {
                    t.tagPending.newAttribute();
                    r.unconsume();
                    t.transition(AttributeName);
                }
            }
        }
    };
    public static final /* enum */ TokeniserState BeforeAttributeValue = new TokeniserState(){

        @Override
        void read(Tokeniser t, CharacterReader r) {
            char c = r.consume();
            switch (c) {
                case '\t': 
                case '\n': 
                case '\f': 
                case '\r': 
                case ' ': {
                    break;
                }
                case '\"': {
                    t.transition(AttributeValue_doubleQuoted);
                    break;
                }
                case '&': {
                    r.unconsume();
                    t.transition(AttributeValue_unquoted);
                    break;
                }
                case '\'': {
                    t.transition(AttributeValue_singleQuoted);
                    break;
                }
                case '\u0000': {
                    t.error(this);
                    t.tagPending.appendAttributeValue('\ufffd');
                    t.transition(AttributeValue_unquoted);
                    break;
                }
                case '\uffff': {
                    t.eofError(this);
                    t.emitTagPending();
                    t.transition(Data);
                    break;
                }
                case '>': {
                    t.error(this);
                    t.emitTagPending();
                    t.transition(Data);
                    break;
                }
                case '<': 
                case '=': 
                case '`': {
                    t.error(this);
                    t.tagPending.appendAttributeValue(c);
                    t.transition(AttributeValue_unquoted);
                    break;
                }
                default: {
                    r.unconsume();
                    t.transition(AttributeValue_unquoted);
                }
            }
        }
    };
    public static final /* enum */ TokeniserState AttributeValue_doubleQuoted = new TokeniserState(){

        @Override
        void read(Tokeniser t, CharacterReader r) {
            String value = r.consumeAttributeQuoted(false);
            if (value.length() > 0) {
                t.tagPending.appendAttributeValue(value);
            } else {
                t.tagPending.setEmptyAttributeValue();
            }
            char c = r.consume();
            switch (c) {
                case '\"': {
                    t.transition(AfterAttributeValue_quoted);
                    break;
                }
                case '&': {
                    int[] ref = t.consumeCharacterReference(Character.valueOf('\"'), true);
                    if (ref != null) {
                        t.tagPending.appendAttributeValue(ref);
                        break;
                    }
                    t.tagPending.appendAttributeValue('&');
                    break;
                }
                case '\u0000': {
                    t.error(this);
                    t.tagPending.appendAttributeValue('\ufffd');
                    break;
                }
                case '\uffff': {
                    t.eofError(this);
                    t.transition(Data);
                    break;
                }
                default: {
                    t.tagPending.appendAttributeValue(c);
                }
            }
        }
    };
    public static final /* enum */ TokeniserState AttributeValue_singleQuoted = new TokeniserState(){

        @Override
        void read(Tokeniser t, CharacterReader r) {
            String value = r.consumeAttributeQuoted(true);
            if (value.length() > 0) {
                t.tagPending.appendAttributeValue(value);
            } else {
                t.tagPending.setEmptyAttributeValue();
            }
            char c = r.consume();
            switch (c) {
                case '\'': {
                    t.transition(AfterAttributeValue_quoted);
                    break;
                }
                case '&': {
                    int[] ref = t.consumeCharacterReference(Character.valueOf('\''), true);
                    if (ref != null) {
                        t.tagPending.appendAttributeValue(ref);
                        break;
                    }
                    t.tagPending.appendAttributeValue('&');
                    break;
                }
                case '\u0000': {
                    t.error(this);
                    t.tagPending.appendAttributeValue('\ufffd');
                    break;
                }
                case '\uffff': {
                    t.eofError(this);
                    t.transition(Data);
                    break;
                }
                default: {
                    t.tagPending.appendAttributeValue(c);
                }
            }
        }
    };
    public static final /* enum */ TokeniserState AttributeValue_unquoted = new TokeniserState(){

        @Override
        void read(Tokeniser t, CharacterReader r) {
            String value = r.consumeToAnySorted(attributeValueUnquoted);
            if (value.length() > 0) {
                t.tagPending.appendAttributeValue(value);
            }
            char c = r.consume();
            switch (c) {
                case '\t': 
                case '\n': 
                case '\f': 
                case '\r': 
                case ' ': {
                    t.transition(BeforeAttributeName);
                    break;
                }
                case '&': {
                    int[] ref = t.consumeCharacterReference(Character.valueOf('>'), true);
                    if (ref != null) {
                        t.tagPending.appendAttributeValue(ref);
                        break;
                    }
                    t.tagPending.appendAttributeValue('&');
                    break;
                }
                case '>': {
                    t.emitTagPending();
                    t.transition(Data);
                    break;
                }
                case '\u0000': {
                    t.error(this);
                    t.tagPending.appendAttributeValue('\ufffd');
                    break;
                }
                case '\uffff': {
                    t.eofError(this);
                    t.transition(Data);
                    break;
                }
                case '\"': 
                case '\'': 
                case '<': 
                case '=': 
                case '`': {
                    t.error(this);
                    t.tagPending.appendAttributeValue(c);
                    break;
                }
                default: {
                    t.tagPending.appendAttributeValue(c);
                }
            }
        }
    };
    public static final /* enum */ TokeniserState AfterAttributeValue_quoted = new TokeniserState(){

        @Override
        void read(Tokeniser t, CharacterReader r) {
            char c = r.consume();
            switch (c) {
                case '\t': 
                case '\n': 
                case '\f': 
                case '\r': 
                case ' ': {
                    t.transition(BeforeAttributeName);
                    break;
                }
                case '/': {
                    t.transition(SelfClosingStartTag);
                    break;
                }
                case '>': {
                    t.emitTagPending();
                    t.transition(Data);
                    break;
                }
                case '\uffff': {
                    t.eofError(this);
                    t.transition(Data);
                    break;
                }
                default: {
                    r.unconsume();
                    t.error(this);
                    t.transition(BeforeAttributeName);
                }
            }
        }
    };
    public static final /* enum */ TokeniserState SelfClosingStartTag = new TokeniserState(){

        @Override
        void read(Tokeniser t, CharacterReader r) {
            char c = r.consume();
            switch (c) {
                case '>': {
                    t.tagPending.selfClosing = true;
                    t.emitTagPending();
                    t.transition(Data);
                    break;
                }
                case '\uffff': {
                    t.eofError(this);
                    t.transition(Data);
                    break;
                }
                default: {
                    r.unconsume();
                    t.error(this);
                    t.transition(BeforeAttributeName);
                }
            }
        }
    };
    public static final /* enum */ TokeniserState BogusComment = new TokeniserState(){

        @Override
        void read(Tokeniser t, CharacterReader r) {
            t.commentPending.append(r.consumeTo('>'));
            char next = r.current();
            if (next == '>' || next == '\uffff') {
                r.consume();
                t.emitCommentPending();
                t.transition(Data);
            }
        }
    };
    public static final /* enum */ TokeniserState MarkupDeclarationOpen = new TokeniserState(){

        @Override
        void read(Tokeniser t, CharacterReader r) {
            if (r.matchConsume("--")) {
                t.createCommentPending();
                t.transition(CommentStart);
            } else if (r.matchConsumeIgnoreCase("DOCTYPE")) {
                t.transition(Doctype);
            } else if (r.matchConsume("[CDATA[")) {
                t.createTempBuffer();
                t.transition(CdataSection);
            } else {
                t.error(this);
                t.createBogusCommentPending();
                t.transition(BogusComment);
            }
        }
    };
    public static final /* enum */ TokeniserState CommentStart = new TokeniserState(){

        @Override
        void read(Tokeniser t, CharacterReader r) {
            char c = r.consume();
            switch (c) {
                case '-': {
                    t.transition(CommentStartDash);
                    break;
                }
                case '\u0000': {
                    t.error(this);
                    t.commentPending.append('\ufffd');
                    t.transition(Comment);
                    break;
                }
                case '>': {
                    t.error(this);
                    t.emitCommentPending();
                    t.transition(Data);
                    break;
                }
                case '\uffff': {
                    t.eofError(this);
                    t.emitCommentPending();
                    t.transition(Data);
                    break;
                }
                default: {
                    r.unconsume();
                    t.transition(Comment);
                }
            }
        }
    };
    public static final /* enum */ TokeniserState CommentStartDash = new TokeniserState(){

        @Override
        void read(Tokeniser t, CharacterReader r) {
            char c = r.consume();
            switch (c) {
                case '-': {
                    t.transition(CommentEnd);
                    break;
                }
                case '\u0000': {
                    t.error(this);
                    t.commentPending.append('\ufffd');
                    t.transition(Comment);
                    break;
                }
                case '>': {
                    t.error(this);
                    t.emitCommentPending();
                    t.transition(Data);
                    break;
                }
                case '\uffff': {
                    t.eofError(this);
                    t.emitCommentPending();
                    t.transition(Data);
                    break;
                }
                default: {
                    t.commentPending.append(c);
                    t.transition(Comment);
                }
            }
        }
    };
    public static final /* enum */ TokeniserState Comment = new TokeniserState(){

        @Override
        void read(Tokeniser t, CharacterReader r) {
            char c = r.current();
            switch (c) {
                case '-': {
                    t.advanceTransition(CommentEndDash);
                    break;
                }
                case '\u0000': {
                    t.error(this);
                    r.advance();
                    t.commentPending.append('\ufffd');
                    break;
                }
                case '\uffff': {
                    t.eofError(this);
                    t.emitCommentPending();
                    t.transition(Data);
                    break;
                }
                default: {
                    t.commentPending.append(r.consumeToAny('-', '\u0000'));
                }
            }
        }
    };
    public static final /* enum */ TokeniserState CommentEndDash = new TokeniserState(){

        @Override
        void read(Tokeniser t, CharacterReader r) {
            char c = r.consume();
            switch (c) {
                case '-': {
                    t.transition(CommentEnd);
                    break;
                }
                case '\u0000': {
                    t.error(this);
                    t.commentPending.append('-').append('\ufffd');
                    t.transition(Comment);
                    break;
                }
                case '\uffff': {
                    t.eofError(this);
                    t.emitCommentPending();
                    t.transition(Data);
                    break;
                }
                default: {
                    t.commentPending.append('-').append(c);
                    t.transition(Comment);
                }
            }
        }
    };
    public static final /* enum */ TokeniserState CommentEnd = new TokeniserState(){

        @Override
        void read(Tokeniser t, CharacterReader r) {
            char c = r.consume();
            switch (c) {
                case '>': {
                    t.emitCommentPending();
                    t.transition(Data);
                    break;
                }
                case '\u0000': {
                    t.error(this);
                    t.commentPending.append("--").append('\ufffd');
                    t.transition(Comment);
                    break;
                }
                case '!': {
                    t.transition(CommentEndBang);
                    break;
                }
                case '-': {
                    t.commentPending.append('-');
                    break;
                }
                case '\uffff': {
                    t.eofError(this);
                    t.emitCommentPending();
                    t.transition(Data);
                    break;
                }
                default: {
                    t.commentPending.append("--").append(c);
                    t.transition(Comment);
                }
            }
        }
    };
    public static final /* enum */ TokeniserState CommentEndBang = new TokeniserState(){

        @Override
        void read(Tokeniser t, CharacterReader r) {
            char c = r.consume();
            switch (c) {
                case '-': {
                    t.commentPending.append("--!");
                    t.transition(CommentEndDash);
                    break;
                }
                case '>': {
                    t.emitCommentPending();
                    t.transition(Data);
                    break;
                }
                case '\u0000': {
                    t.error(this);
                    t.commentPending.append("--!").append('\ufffd');
                    t.transition(Comment);
                    break;
                }
                case '\uffff': {
                    t.eofError(this);
                    t.emitCommentPending();
                    t.transition(Data);
                    break;
                }
                default: {
                    t.commentPending.append("--!").append(c);
                    t.transition(Comment);
                }
            }
        }
    };
    public static final /* enum */ TokeniserState Doctype = new TokeniserState(){

        @Override
        void read(Tokeniser t, CharacterReader r) {
            char c = r.consume();
            switch (c) {
                case '\t': 
                case '\n': 
                case '\f': 
                case '\r': 
                case ' ': {
                    t.transition(BeforeDoctypeName);
                    break;
                }
                case '\uffff': {
                    t.eofError(this);
                }
                case '>': {
                    t.error(this);
                    t.createDoctypePending();
                    t.doctypePending.forceQuirks = true;
                    t.emitDoctypePending();
                    t.transition(Data);
                    break;
                }
                default: {
                    t.error(this);
                    t.transition(BeforeDoctypeName);
                }
            }
        }
    };
    public static final /* enum */ TokeniserState BeforeDoctypeName = new TokeniserState(){

        @Override
        void read(Tokeniser t, CharacterReader r) {
            if (r.matchesAsciiAlpha()) {
                t.createDoctypePending();
                t.transition(DoctypeName);
                return;
            }
            char c = r.consume();
            switch (c) {
                case '\t': 
                case '\n': 
                case '\f': 
                case '\r': 
                case ' ': {
                    break;
                }
                case '\u0000': {
                    t.error(this);
                    t.createDoctypePending();
                    t.doctypePending.name.append('\ufffd');
                    t.transition(DoctypeName);
                    break;
                }
                case '\uffff': {
                    t.eofError(this);
                    t.createDoctypePending();
                    t.doctypePending.forceQuirks = true;
                    t.emitDoctypePending();
                    t.transition(Data);
                    break;
                }
                default: {
                    t.createDoctypePending();
                    t.doctypePending.name.append(c);
                    t.transition(DoctypeName);
                }
            }
        }
    };
    public static final /* enum */ TokeniserState DoctypeName = new TokeniserState(){

        @Override
        void read(Tokeniser t, CharacterReader r) {
            if (r.matchesLetter()) {
                String name = r.consumeLetterSequence();
                t.doctypePending.name.append(name);
                return;
            }
            char c = r.consume();
            switch (c) {
                case '>': {
                    t.emitDoctypePending();
                    t.transition(Data);
                    break;
                }
                case '\t': 
                case '\n': 
                case '\f': 
                case '\r': 
                case ' ': {
                    t.transition(AfterDoctypeName);
                    break;
                }
                case '\u0000': {
                    t.error(this);
                    t.doctypePending.name.append('\ufffd');
                    break;
                }
                case '\uffff': {
                    t.eofError(this);
                    t.doctypePending.forceQuirks = true;
                    t.emitDoctypePending();
                    t.transition(Data);
                    break;
                }
                default: {
                    t.doctypePending.name.append(c);
                }
            }
        }
    };
    public static final /* enum */ TokeniserState AfterDoctypeName = new TokeniserState(){

        @Override
        void read(Tokeniser t, CharacterReader r) {
            if (r.isEmpty()) {
                t.eofError(this);
                t.doctypePending.forceQuirks = true;
                t.emitDoctypePending();
                t.transition(Data);
                return;
            }
            if (r.matchesAny('\t', '\n', '\r', '\f', ' ')) {
                r.advance();
            } else if (r.matches('>')) {
                t.emitDoctypePending();
                t.advanceTransition(Data);
            } else if (r.matchConsumeIgnoreCase("PUBLIC")) {
                t.doctypePending.pubSysKey = "PUBLIC";
                t.transition(AfterDoctypePublicKeyword);
            } else if (r.matchConsumeIgnoreCase("SYSTEM")) {
                t.doctypePending.pubSysKey = "SYSTEM";
                t.transition(AfterDoctypeSystemKeyword);
            } else {
                t.error(this);
                t.doctypePending.forceQuirks = true;
                t.advanceTransition(BogusDoctype);
            }
        }
    };
    public static final /* enum */ TokeniserState AfterDoctypePublicKeyword = new TokeniserState(){

        @Override
        void read(Tokeniser t, CharacterReader r) {
            char c = r.consume();
            switch (c) {
                case '\t': 
                case '\n': 
                case '\f': 
                case '\r': 
                case ' ': {
                    t.transition(BeforeDoctypePublicIdentifier);
                    break;
                }
                case '\"': {
                    t.error(this);
                    t.transition(DoctypePublicIdentifier_doubleQuoted);
                    break;
                }
                case '\'': {
                    t.error(this);
                    t.transition(DoctypePublicIdentifier_singleQuoted);
                    break;
                }
                case '>': {
                    t.error(this);
                    t.doctypePending.forceQuirks = true;
                    t.emitDoctypePending();
                    t.transition(Data);
                    break;
                }
                case '\uffff': {
                    t.eofError(this);
                    t.doctypePending.forceQuirks = true;
                    t.emitDoctypePending();
                    t.transition(Data);
                    break;
                }
                default: {
                    t.error(this);
                    t.doctypePending.forceQuirks = true;
                    t.transition(BogusDoctype);
                }
            }
        }
    };
    public static final /* enum */ TokeniserState BeforeDoctypePublicIdentifier = new TokeniserState(){

        @Override
        void read(Tokeniser t, CharacterReader r) {
            char c = r.consume();
            switch (c) {
                case '\t': 
                case '\n': 
                case '\f': 
                case '\r': 
                case ' ': {
                    break;
                }
                case '\"': {
                    t.transition(DoctypePublicIdentifier_doubleQuoted);
                    break;
                }
                case '\'': {
                    t.transition(DoctypePublicIdentifier_singleQuoted);
                    break;
                }
                case '>': {
                    t.error(this);
                    t.doctypePending.forceQuirks = true;
                    t.emitDoctypePending();
                    t.transition(Data);
                    break;
                }
                case '\uffff': {
                    t.eofError(this);
                    t.doctypePending.forceQuirks = true;
                    t.emitDoctypePending();
                    t.transition(Data);
                    break;
                }
                default: {
                    t.error(this);
                    t.doctypePending.forceQuirks = true;
                    t.transition(BogusDoctype);
                }
            }
        }
    };
    public static final /* enum */ TokeniserState DoctypePublicIdentifier_doubleQuoted = new TokeniserState(){

        @Override
        void read(Tokeniser t, CharacterReader r) {
            char c = r.consume();
            switch (c) {
                case '\"': {
                    t.transition(AfterDoctypePublicIdentifier);
                    break;
                }
                case '\u0000': {
                    t.error(this);
                    t.doctypePending.publicIdentifier.append('\ufffd');
                    break;
                }
                case '>': {
                    t.error(this);
                    t.doctypePending.forceQuirks = true;
                    t.emitDoctypePending();
                    t.transition(Data);
                    break;
                }
                case '\uffff': {
                    t.eofError(this);
                    t.doctypePending.forceQuirks = true;
                    t.emitDoctypePending();
                    t.transition(Data);
                    break;
                }
                default: {
                    t.doctypePending.publicIdentifier.append(c);
                }
            }
        }
    };
    public static final /* enum */ TokeniserState DoctypePublicIdentifier_singleQuoted = new TokeniserState(){

        @Override
        void read(Tokeniser t, CharacterReader r) {
            char c = r.consume();
            switch (c) {
                case '\'': {
                    t.transition(AfterDoctypePublicIdentifier);
                    break;
                }
                case '\u0000': {
                    t.error(this);
                    t.doctypePending.publicIdentifier.append('\ufffd');
                    break;
                }
                case '>': {
                    t.error(this);
                    t.doctypePending.forceQuirks = true;
                    t.emitDoctypePending();
                    t.transition(Data);
                    break;
                }
                case '\uffff': {
                    t.eofError(this);
                    t.doctypePending.forceQuirks = true;
                    t.emitDoctypePending();
                    t.transition(Data);
                    break;
                }
                default: {
                    t.doctypePending.publicIdentifier.append(c);
                }
            }
        }
    };
    public static final /* enum */ TokeniserState AfterDoctypePublicIdentifier = new TokeniserState(){

        @Override
        void read(Tokeniser t, CharacterReader r) {
            char c = r.consume();
            switch (c) {
                case '\t': 
                case '\n': 
                case '\f': 
                case '\r': 
                case ' ': {
                    t.transition(BetweenDoctypePublicAndSystemIdentifiers);
                    break;
                }
                case '>': {
                    t.emitDoctypePending();
                    t.transition(Data);
                    break;
                }
                case '\"': {
                    t.error(this);
                    t.transition(DoctypeSystemIdentifier_doubleQuoted);
                    break;
                }
                case '\'': {
                    t.error(this);
                    t.transition(DoctypeSystemIdentifier_singleQuoted);
                    break;
                }
                case '\uffff': {
                    t.eofError(this);
                    t.doctypePending.forceQuirks = true;
                    t.emitDoctypePending();
                    t.transition(Data);
                    break;
                }
                default: {
                    t.error(this);
                    t.doctypePending.forceQuirks = true;
                    t.transition(BogusDoctype);
                }
            }
        }
    };
    public static final /* enum */ TokeniserState BetweenDoctypePublicAndSystemIdentifiers = new TokeniserState(){

        @Override
        void read(Tokeniser t, CharacterReader r) {
            char c = r.consume();
            switch (c) {
                case '\t': 
                case '\n': 
                case '\f': 
                case '\r': 
                case ' ': {
                    break;
                }
                case '>': {
                    t.emitDoctypePending();
                    t.transition(Data);
                    break;
                }
                case '\"': {
                    t.error(this);
                    t.transition(DoctypeSystemIdentifier_doubleQuoted);
                    break;
                }
                case '\'': {
                    t.error(this);
                    t.transition(DoctypeSystemIdentifier_singleQuoted);
                    break;
                }
                case '\uffff': {
                    t.eofError(this);
                    t.doctypePending.forceQuirks = true;
                    t.emitDoctypePending();
                    t.transition(Data);
                    break;
                }
                default: {
                    t.error(this);
                    t.doctypePending.forceQuirks = true;
                    t.transition(BogusDoctype);
                }
            }
        }
    };
    public static final /* enum */ TokeniserState AfterDoctypeSystemKeyword = new TokeniserState(){

        @Override
        void read(Tokeniser t, CharacterReader r) {
            char c = r.consume();
            switch (c) {
                case '\t': 
                case '\n': 
                case '\f': 
                case '\r': 
                case ' ': {
                    t.transition(BeforeDoctypeSystemIdentifier);
                    break;
                }
                case '>': {
                    t.error(this);
                    t.doctypePending.forceQuirks = true;
                    t.emitDoctypePending();
                    t.transition(Data);
                    break;
                }
                case '\"': {
                    t.error(this);
                    t.transition(DoctypeSystemIdentifier_doubleQuoted);
                    break;
                }
                case '\'': {
                    t.error(this);
                    t.transition(DoctypeSystemIdentifier_singleQuoted);
                    break;
                }
                case '\uffff': {
                    t.eofError(this);
                    t.doctypePending.forceQuirks = true;
                    t.emitDoctypePending();
                    t.transition(Data);
                    break;
                }
                default: {
                    t.error(this);
                    t.doctypePending.forceQuirks = true;
                    t.emitDoctypePending();
                }
            }
        }
    };
    public static final /* enum */ TokeniserState BeforeDoctypeSystemIdentifier = new TokeniserState(){

        @Override
        void read(Tokeniser t, CharacterReader r) {
            char c = r.consume();
            switch (c) {
                case '\t': 
                case '\n': 
                case '\f': 
                case '\r': 
                case ' ': {
                    break;
                }
                case '\"': {
                    t.transition(DoctypeSystemIdentifier_doubleQuoted);
                    break;
                }
                case '\'': {
                    t.transition(DoctypeSystemIdentifier_singleQuoted);
                    break;
                }
                case '>': {
                    t.error(this);
                    t.doctypePending.forceQuirks = true;
                    t.emitDoctypePending();
                    t.transition(Data);
                    break;
                }
                case '\uffff': {
                    t.eofError(this);
                    t.doctypePending.forceQuirks = true;
                    t.emitDoctypePending();
                    t.transition(Data);
                    break;
                }
                default: {
                    t.error(this);
                    t.doctypePending.forceQuirks = true;
                    t.transition(BogusDoctype);
                }
            }
        }
    };
    public static final /* enum */ TokeniserState DoctypeSystemIdentifier_doubleQuoted = new TokeniserState(){

        @Override
        void read(Tokeniser t, CharacterReader r) {
            char c = r.consume();
            switch (c) {
                case '\"': {
                    t.transition(AfterDoctypeSystemIdentifier);
                    break;
                }
                case '\u0000': {
                    t.error(this);
                    t.doctypePending.systemIdentifier.append('\ufffd');
                    break;
                }
                case '>': {
                    t.error(this);
                    t.doctypePending.forceQuirks = true;
                    t.emitDoctypePending();
                    t.transition(Data);
                    break;
                }
                case '\uffff': {
                    t.eofError(this);
                    t.doctypePending.forceQuirks = true;
                    t.emitDoctypePending();
                    t.transition(Data);
                    break;
                }
                default: {
                    t.doctypePending.systemIdentifier.append(c);
                }
            }
        }
    };
    public static final /* enum */ TokeniserState DoctypeSystemIdentifier_singleQuoted = new TokeniserState(){

        @Override
        void read(Tokeniser t, CharacterReader r) {
            char c = r.consume();
            switch (c) {
                case '\'': {
                    t.transition(AfterDoctypeSystemIdentifier);
                    break;
                }
                case '\u0000': {
                    t.error(this);
                    t.doctypePending.systemIdentifier.append('\ufffd');
                    break;
                }
                case '>': {
                    t.error(this);
                    t.doctypePending.forceQuirks = true;
                    t.emitDoctypePending();
                    t.transition(Data);
                    break;
                }
                case '\uffff': {
                    t.eofError(this);
                    t.doctypePending.forceQuirks = true;
                    t.emitDoctypePending();
                    t.transition(Data);
                    break;
                }
                default: {
                    t.doctypePending.systemIdentifier.append(c);
                }
            }
        }
    };
    public static final /* enum */ TokeniserState AfterDoctypeSystemIdentifier = new TokeniserState(){

        @Override
        void read(Tokeniser t, CharacterReader r) {
            char c = r.consume();
            switch (c) {
                case '\t': 
                case '\n': 
                case '\f': 
                case '\r': 
                case ' ': {
                    break;
                }
                case '>': {
                    t.emitDoctypePending();
                    t.transition(Data);
                    break;
                }
                case '\uffff': {
                    t.eofError(this);
                    t.doctypePending.forceQuirks = true;
                    t.emitDoctypePending();
                    t.transition(Data);
                    break;
                }
                default: {
                    t.error(this);
                    t.transition(BogusDoctype);
                }
            }
        }
    };
    public static final /* enum */ TokeniserState BogusDoctype = new TokeniserState(){

        @Override
        void read(Tokeniser t, CharacterReader r) {
            char c = r.consume();
            switch (c) {
                case '>': {
                    t.emitDoctypePending();
                    t.transition(Data);
                    break;
                }
                case '\uffff': {
                    t.emitDoctypePending();
                    t.transition(Data);
                    break;
                }
            }
        }
    };
    public static final /* enum */ TokeniserState CdataSection = new TokeniserState(){

        @Override
        void read(Tokeniser t, CharacterReader r) {
            String data = r.consumeTo("]]>");
            t.dataBuffer.append(data);
            if (r.matchConsume("]]>") || r.isEmpty()) {
                t.emit(new Token.CData(t.dataBuffer.toString()));
                t.transition(Data);
            }
        }
    };
    static final char[] attributeNameCharsSorted;
    static final char[] attributeValueUnquoted;
    private static final String replacementStr;
    private static final /* synthetic */ TokeniserState[] $VALUES;

    public static TokeniserState[] values() {
        return (TokeniserState[])$VALUES.clone();
    }

    abstract void read(Tokeniser var1, CharacterReader var2);

    private static void handleDataEndTag(Tokeniser t, CharacterReader r, TokeniserState elseTransition) {
        if (r.matchesLetter()) {
            String name = r.consumeLetterSequence();
            t.tagPending.appendTagName(name);
            t.dataBuffer.append(name);
            return;
        }
        boolean needsExitTransition = false;
        if (t.isAppropriateEndTagToken() && !r.isEmpty()) {
            char c = r.consume();
            switch (c) {
                case '\t': 
                case '\n': 
                case '\f': 
                case '\r': 
                case ' ': {
                    t.transition(BeforeAttributeName);
                    break;
                }
                case '/': {
                    t.transition(SelfClosingStartTag);
                    break;
                }
                case '>': {
                    t.emitTagPending();
                    t.transition(Data);
                    break;
                }
                default: {
                    t.dataBuffer.append(c);
                    needsExitTransition = true;
                    break;
                }
            }
        } else {
            needsExitTransition = true;
        }
        if (needsExitTransition) {
            t.emit("</");
            t.emit(t.dataBuffer);
            t.transition(elseTransition);
        }
    }

    private static void readRawData(Tokeniser t, CharacterReader r, TokeniserState current, TokeniserState advance) {
        switch (r.current()) {
            case '<': {
                t.advanceTransition(advance);
                break;
            }
            case '\u0000': {
                t.error(current);
                r.advance();
                t.emit('\ufffd');
                break;
            }
            case '\uffff': {
                t.emit(new Token.EOF());
                break;
            }
            default: {
                String data = r.consumeRawData();
                t.emit(data);
            }
        }
    }

    private static void readCharRef(Tokeniser t, TokeniserState advance) {
        int[] c = t.consumeCharacterReference(null, false);
        if (c == null) {
            t.emit('&');
        } else {
            t.emit(c);
        }
        t.transition(advance);
    }

    private static void readEndTag(Tokeniser t, CharacterReader r, TokeniserState a, TokeniserState b) {
        if (r.matchesAsciiAlpha()) {
            t.createTagPending(false);
            t.transition(a);
        } else {
            t.emit("</");
            t.transition(b);
        }
    }

    private static void handleDataDoubleEscapeTag(Tokeniser t, CharacterReader r, TokeniserState primary, TokeniserState fallback) {
        if (r.matchesLetter()) {
            String name = r.consumeLetterSequence();
            t.dataBuffer.append(name);
            t.emit(name);
            return;
        }
        char c = r.consume();
        switch (c) {
            case '\t': 
            case '\n': 
            case '\f': 
            case '\r': 
            case ' ': 
            case '/': 
            case '>': {
                if (t.dataBuffer.toString().equals("script")) {
                    t.transition(primary);
                } else {
                    t.transition(fallback);
                }
                t.emit(c);
                break;
            }
            default: {
                r.unconsume();
                t.transition(fallback);
            }
        }
    }

    private static /* synthetic */ TokeniserState[] $values() {
        return new TokeniserState[]{Data, CharacterReferenceInData, Rcdata, CharacterReferenceInRcdata, Rawtext, ScriptData, PLAINTEXT, TagOpen, EndTagOpen, TagName, RcdataLessthanSign, RCDATAEndTagOpen, RCDATAEndTagName, RawtextLessthanSign, RawtextEndTagOpen, RawtextEndTagName, ScriptDataLessthanSign, ScriptDataEndTagOpen, ScriptDataEndTagName, ScriptDataEscapeStart, ScriptDataEscapeStartDash, ScriptDataEscaped, ScriptDataEscapedDash, ScriptDataEscapedDashDash, ScriptDataEscapedLessthanSign, ScriptDataEscapedEndTagOpen, ScriptDataEscapedEndTagName, ScriptDataDoubleEscapeStart, ScriptDataDoubleEscaped, ScriptDataDoubleEscapedDash, ScriptDataDoubleEscapedDashDash, ScriptDataDoubleEscapedLessthanSign, ScriptDataDoubleEscapeEnd, BeforeAttributeName, AttributeName, AfterAttributeName, BeforeAttributeValue, AttributeValue_doubleQuoted, AttributeValue_singleQuoted, AttributeValue_unquoted, AfterAttributeValue_quoted, SelfClosingStartTag, BogusComment, MarkupDeclarationOpen, CommentStart, CommentStartDash, Comment, CommentEndDash, CommentEnd, CommentEndBang, Doctype, BeforeDoctypeName, DoctypeName, AfterDoctypeName, AfterDoctypePublicKeyword, BeforeDoctypePublicIdentifier, DoctypePublicIdentifier_doubleQuoted, DoctypePublicIdentifier_singleQuoted, AfterDoctypePublicIdentifier, BetweenDoctypePublicAndSystemIdentifiers, AfterDoctypeSystemKeyword, BeforeDoctypeSystemIdentifier, DoctypeSystemIdentifier_doubleQuoted, DoctypeSystemIdentifier_singleQuoted, AfterDoctypeSystemIdentifier, BogusDoctype, CdataSection};
    }

    static {
        $VALUES = TokeniserState.$values();
        attributeNameCharsSorted = new char[]{'\t', '\n', '\f', '\r', ' ', '\"', '\'', '/', '<', '=', '>'};
        attributeValueUnquoted = new char[]{'\u0000', '\t', '\n', '\f', '\r', ' ', '\"', '&', '\'', '<', '=', '>', '`'};
        replacementStr = String.valueOf('\ufffd');
    }
}

