/*
 * Decompiled with CFR 0.152.
 */
package coursierapi.shaded.zstd.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;

public final class Native
extends Enum<Native> {
    private static final String errorMsg;
    private static boolean loaded;
    private static final /* synthetic */ Native[] $VALUES;

    private static String osName() {
        String string = System.getProperty("os.name").toLowerCase().replace(' ', '_');
        if (string.startsWith("win")) {
            return "win";
        }
        if (string.startsWith("mac")) {
            return "darwin";
        }
        return string;
    }

    private static String osArch() {
        return System.getProperty("os.arch");
    }

    private static String libExtension() {
        if (Native.osName().contains("os_x") || Native.osName().contains("darwin")) {
            return "dylib";
        }
        if (Native.osName().contains("win")) {
            return "dll";
        }
        return "so";
    }

    private static String resourceName() {
        return "/" + Native.osName() + "/" + Native.osArch() + "/" + "libzstd-jni-1.5.2-4" + "." + Native.libExtension();
    }

    public static synchronized void load() {
        Native.load(null);
    }

    public static synchronized void load(File file) {
        if (loaded) {
            return;
        }
        String string = Native.resourceName();
        String string2 = System.getProperty("ZstdNativePath");
        if (string2 != null) {
            System.load(string2);
            loaded = true;
            return;
        }
        try {
            Class.forName("org.osgi.framework.BundleEvent");
            System.loadLibrary("libzstd-jni-1.5.2-4");
            loaded = true;
            return;
        }
        catch (Throwable throwable) {
            InputStream inputStream = Native.class.getResourceAsStream(string);
            if (inputStream == null) {
                try {
                    System.loadLibrary("zstd-jni-1.5.2-4");
                    loaded = true;
                    return;
                }
                catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                    UnsatisfiedLinkError unsatisfiedLinkError2 = new UnsatisfiedLinkError(unsatisfiedLinkError.getMessage() + "\n" + errorMsg);
                    unsatisfiedLinkError2.setStackTrace(unsatisfiedLinkError.getStackTrace());
                    throw unsatisfiedLinkError2;
                }
            }
            File file2 = null;
            FileOutputStream fileOutputStream = null;
            try {
                int n;
                file2 = File.createTempFile("libzstd-jni-1.5.2-4", "." + Native.libExtension(), file);
                file2.deleteOnExit();
                fileOutputStream = new FileOutputStream(file2);
                byte[] byArray = new byte[4096];
                while ((n = inputStream.read(byArray)) != -1) {
                    fileOutputStream.write(byArray, 0, n);
                }
                try {
                    fileOutputStream.flush();
                    fileOutputStream.close();
                    fileOutputStream = null;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                try {
                    System.load(file2.getAbsolutePath());
                }
                catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                    try {
                        System.loadLibrary("zstd-jni-1.5.2-4");
                    }
                    catch (UnsatisfiedLinkError unsatisfiedLinkError3) {
                        UnsatisfiedLinkError unsatisfiedLinkError4 = new UnsatisfiedLinkError(unsatisfiedLinkError.getMessage() + "\n" + unsatisfiedLinkError3.getMessage() + "\n" + errorMsg);
                        unsatisfiedLinkError4.setStackTrace(unsatisfiedLinkError3.getStackTrace());
                        throw unsatisfiedLinkError4;
                    }
                }
                loaded = true;
            }
            catch (IOException iOException) {
                ExceptionInInitializerError exceptionInInitializerError = new ExceptionInInitializerError("Cannot unpack libzstd-jni-1.5.2-4: " + iOException.getMessage());
                exceptionInInitializerError.setStackTrace(iOException.getStackTrace());
                throw exceptionInInitializerError;
            }
            finally {
                try {
                    inputStream.close();
                    if (fileOutputStream != null) {
                        fileOutputStream.close();
                    }
                    if (file2 != null && file2.exists()) {
                        file2.delete();
                    }
                }
                catch (IOException iOException) {}
            }
            return;
        }
    }

    static {
        $VALUES = new Native[0];
        errorMsg = "Unsupported OS/arch, cannot find " + Native.resourceName() + " or load " + "zstd-jni-1.5.2-4" + " from system libraries. Please try building from source the jar or providing " + "libzstd-jni-1.5.2-4" + " in your system.";
        loaded = false;
    }
}

