/*
 * Decompiled with CFR 0.152.
 */
package coursierapi.shaded.coursier.cache.internal;

import coursierapi.shaded.coursier.cache.ArtifactError;
import coursierapi.shaded.coursier.cache.ArtifactError$NotFound$;
import coursierapi.shaded.coursier.cache.CacheDefaults$;
import coursierapi.shaded.coursier.cache.CacheLocks$;
import coursierapi.shaded.coursier.cache.CacheLogger;
import coursierapi.shaded.coursier.cache.CachePolicy;
import coursierapi.shaded.coursier.cache.CacheUrl$;
import coursierapi.shaded.coursier.cache.ConnectionBuilder$;
import coursierapi.shaded.coursier.cache.internal.Downloader;
import coursierapi.shaded.coursier.cache.internal.Downloader$UnknownProtocol$;
import coursierapi.shaded.coursier.core.Authentication;
import coursierapi.shaded.coursier.credentials.DirectCredentials;
import coursierapi.shaded.coursier.util.Artifact;
import coursierapi.shaded.coursier.util.Sync;
import coursierapi.shaded.scala.Array$;
import coursierapi.shaded.scala.Function0;
import coursierapi.shaded.scala.Function1;
import coursierapi.shaded.scala.MatchError;
import coursierapi.shaded.scala.None$;
import coursierapi.shaded.scala.Option;
import coursierapi.shaded.scala.Option$;
import coursierapi.shaded.scala.Some;
import coursierapi.shaded.scala.Tuple2;
import coursierapi.shaded.scala.collection.immutable.$colon$colon;
import coursierapi.shaded.scala.collection.immutable.List;
import coursierapi.shaded.scala.collection.immutable.Nil$;
import coursierapi.shaded.scala.collection.immutable.Seq;
import coursierapi.shaded.scala.concurrent.duration.Duration;
import coursierapi.shaded.scala.concurrent.duration.FiniteDuration;
import coursierapi.shaded.scala.concurrent.duration.package$;
import coursierapi.shaded.scala.concurrent.duration.package$DoubleMult$;
import coursierapi.shaded.scala.reflect.ClassTag$;
import coursierapi.shaded.scala.runtime.BoxesRunTime;
import coursierapi.shaded.scala.runtime.Nothing$;
import coursierapi.shaded.scala.util.Either;
import coursierapi.shaded.scala.util.Left;
import coursierapi.shaded.scala.util.Properties$;
import coursierapi.shaded.scala.util.control.NonFatal$;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URLConnection;
import java.nio.file.AccessDeniedException;
import java.time.Clock;
import java.util.concurrent.ExecutorService;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSocketFactory;

public final class Downloader$
implements Serializable {
    public static final Downloader$ MODULE$ = new Downloader$();
    private static boolean coursier$cache$internal$Downloader$$throwExceptions;
    private static final Seq<String> coursier$cache$internal$Downloader$$checksumHeader;
    private static volatile boolean bitmap$0;

    static {
        coursier$cache$internal$Downloader$$checksumHeader = new $colon$colon<Nothing$>((Nothing$)((Object)"MD5"), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)"SHA1"), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)"SHA256"), Nil$.MODULE$)));
    }

    private boolean throwExceptions$lzycompute() {
        Downloader$ downloader$ = this;
        synchronized (downloader$) {
            if (!bitmap$0) {
                coursier$cache$internal$Downloader$$throwExceptions = Boolean.getBoolean("coursierapi.shaded.coursier.cache.throw-exceptions");
                bitmap$0 = true;
            }
        }
        return coursier$cache$internal$Downloader$$throwExceptions;
    }

    public boolean coursier$cache$internal$Downloader$$throwExceptions() {
        if (!bitmap$0) {
            return this.throwExceptions$lzycompute();
        }
        return coursier$cache$internal$Downloader$$throwExceptions;
    }

    public Seq<String> coursier$cache$internal$Downloader$$checksumHeader() {
        return coursier$cache$internal$Downloader$$checksumHeader;
    }

    public void coursier$cache$internal$Downloader$$readFullyTo(InputStream in, OutputStream out, CacheLogger logger, String url, long alreadyDownloaded, int bufferSize) {
        byte[] b = (byte[])Array$.MODULE$.fill(bufferSize, () -> 0, ClassTag$.MODULE$.Byte());
        this.helper$1(alreadyDownloaded, in, b, out, logger, url);
    }

    public <T> Either<ArtifactError, T> coursier$cache$internal$Downloader$$downloading(String url, File file, int retryCount, FiniteDuration retryBackoffInitialDelay2, double retryBackoffMultiplier, Function0<Either<ArtifactError, T>> f, Function0<Option<Either<ArtifactError, T>>> ifLocked) {
        return this.helper$2(retryCount, retryBackoffInitialDelay2, url, f, ifLocked, retryBackoffMultiplier);
    }

    public Either<ArtifactError, Option<Object>> coursier$cache$internal$Downloader$$contentLength(String url, Option<Authentication> authentication, boolean followHttpToHttpsRedirections, boolean followHttpsToHttpRedirections, Seq<DirectCredentials> credentials, Option<SSLSocketFactory> sslSocketFactoryOpt, Option<HostnameVerifier> hostnameVerifierOpt, CacheLogger logger, Option<Object> maxRedirectionsOpt) {
        Left<ArtifactError, Option<Object>> left;
        block9: {
            URLConnection conn;
            block8: {
                conn = null;
                try {
                    URLConnection uRLConnection = conn = ConnectionBuilder$.MODULE$.apply(url).withAuthentication(authentication).withFollowHttpToHttpsRedirections(followHttpToHttpsRedirections).withFollowHttpsToHttpRedirections(followHttpsToHttpRedirections).withAutoCredentials(credentials).withSslSocketFactoryOpt(sslSocketFactoryOpt).withHostnameVerifierOpt(hostnameVerifierOpt).withMethod("HEAD").withMaxRedirectionsOpt(maxRedirectionsOpt).connection();
                    if (uRLConnection instanceof HttpURLConnection) {
                        HttpURLConnection httpURLConnection = (HttpURLConnection)uRLConnection;
                        logger.gettingLength(url);
                        boolean success = false;
                        try {
                            Option<Object> len = new Some<Long>(BoxesRunTime.boxToLong(httpURLConnection.getContentLengthLong())).filter(x$27 -> x$27 >= 0L);
                            success = true;
                            logger.gettingLengthResult(url, len);
                            left = coursierapi.shaded.scala.package$.MODULE$.Right().apply(len);
                            break block8;
                        }
                        finally {
                            if (!success) {
                                logger.gettingLengthResult(url, None$.MODULE$);
                            }
                        }
                    }
                    left = coursierapi.shaded.scala.package$.MODULE$.Left().apply(new ArtifactError.DownloadError(new StringBuilder(42).append("Cannot do HEAD request with connection ").append(uRLConnection).append(" (").append(url).append(")").toString(), None$.MODULE$));
                }
                catch (Throwable throwable) {
                    if (conn != null) {
                        CacheUrl$.MODULE$.closeConn(conn);
                    }
                    throw throwable;
                }
            }
            if (conn == null) break block9;
            CacheUrl$.MODULE$.closeConn(conn);
        }
        return left;
    }

    public <F> Downloader<F> apply(Artifact artifact, CachePolicy cachePolicy, File location, Seq<String> actualChecksums, F allCredentials, CacheLogger logger, ExecutorService pool, Option<Duration> ttl, boolean localArtifactsShouldBeCached, boolean followHttpToHttpsRedirections, boolean followHttpsToHttpRedirections, Option<Object> maxRedirections, int sslRetry, Option<SSLSocketFactory> sslSocketFactoryOpt, Option<HostnameVerifier> hostnameVerifierOpt, int bufferSize, Seq<ClassLoader> classLoaders, Clock clock, Sync<F> S) {
        return new Downloader<F>(artifact, cachePolicy, location, actualChecksums, allCredentials, logger, pool, ttl, localArtifactsShouldBeCached, followHttpToHttpsRedirections, followHttpsToHttpRedirections, maxRedirections, sslRetry, sslSocketFactoryOpt, hostnameVerifierOpt, bufferSize, classLoaders, clock, CacheDefaults$.MODULE$.retryCount(), CacheDefaults$.MODULE$.retryBackoffInitialDelay(), CacheDefaults$.MODULE$.retryBackoffMultiplier(), S);
    }

    private final void helper$1(long count, InputStream in$1, byte[] b$1, OutputStream out$1, CacheLogger logger$2, String url$9) {
        int read;
        while ((read = in$1.read(b$1)) >= 0) {
            out$1.write(b$1, 0, read);
            out$1.flush();
            logger$2.downloadProgress(url$9, count + (long)read);
            count += (long)read;
        }
    }

    private final Either helper$2(int retry, FiniteDuration delay, String url$10, Function0 f$1, Function0 ifLocked$1, double retryBackoffMultiplier$1) {
        None$ none$;
        while (true) {
            FiniteDuration finiteDuration;
            None$ resOpt;
            Option option;
            try {
                Option res0 = CacheLocks$.MODULE$.withUrlLock(url$10, (Function0<Either> & Serializable)() -> {
                    Left left;
                    try {
                        left = (Left)f$1.apply();
                    }
                    catch (Throwable throwable) {
                        FileNotFoundException fileNotFoundException;
                        Throwable throwable2 = throwable;
                        if (throwable2 instanceof FileNotFoundException && (fileNotFoundException = (FileNotFoundException)throwable2).getMessage() != null) {
                            left = coursierapi.shaded.scala.package$.MODULE$.Left().apply(new ArtifactError.NotFound(fileNotFoundException.getMessage(), ArtifactError$NotFound$.MODULE$.$lessinit$greater$default$2()));
                        }
                        throw throwable;
                    }
                    return left;
                });
                option = res0.orElse(ifLocked$1);
            }
            catch (Throwable throwable) {
                Option<Throwable> option2;
                Option<Tuple2<MalformedURLException, String>> option3;
                Option<Throwable> option4;
                Throwable throwable2 = throwable;
                if (throwable2 != null && !(option4 = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                    Throwable e = option4.get();
                    if (this.coursier$cache$internal$Downloader$$throwExceptions()) {
                        ArtifactError.DownloadError ex = new ArtifactError.DownloadError(new StringBuilder(26).append("Caught ").append(e.getClass().getName()).append(Option$.MODULE$.apply(e.getMessage()).fold((Function0<String> & Serializable)() -> "", (Function1<String, String> & Serializable)x$25 -> new StringBuilder(3).append(" (").append((String)x$25).append(")").toString())).append(" while downloading ").append(url$10).toString(), new Some<Throwable>(e));
                        throw ex;
                    }
                }
                if (throwable2 != null && !(option3 = Downloader$UnknownProtocol$.MODULE$.unapply(throwable2)).isEmpty()) {
                    MalformedURLException e = option3.get()._1();
                    String msg0 = option3.get()._2();
                    String docUrl = "https://get-coursier.io/docs/extra.html#extra-protocols";
                    String msg = new $colon$colon<Nothing$>((Nothing$)((Object)new StringBuilder(30).append("Caught ").append(e.getClass().getName()).append(" (").append(msg0).append(") while downloading ").append(url$10).append(".").toString()), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)new StringBuilder(47).append("Visit ").append(docUrl).append(" to learn how to handle custom protocols.").toString()), Nil$.MODULE$)).mkString(" ");
                    ArtifactError.DownloadError ex = new ArtifactError.DownloadError(msg, new Some<Throwable>(e));
                    option = new Some(coursierapi.shaded.scala.package$.MODULE$.Left().apply(ex));
                }
                if (throwable2 instanceof AccessDeniedException && Properties$.MODULE$.isWin() && retry >= 1) {
                    option = None$.MODULE$;
                }
                if (throwable2 instanceof SSLException && retry >= 1) {
                    option = None$.MODULE$;
                }
                if (throwable2 != null && !(option2 = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                    Throwable e = option2.get();
                    ArtifactError.DownloadError ex = new ArtifactError.DownloadError(new StringBuilder(26).append("Caught ").append(e.getClass().getName()).append(Option$.MODULE$.apply(e.getMessage()).fold((Function0<String> & Serializable)() -> "", (Function1<String, String> & Serializable)x$26 -> new StringBuilder(3).append(" (").append((String)x$26).append(")").toString())).append(" while downloading ").append(url$10).toString(), new Some<Throwable>(e));
                    option = new Some(coursierapi.shaded.scala.package$.MODULE$.Left().apply(ex));
                }
                throw throwable;
            }
            none$ = resOpt = option;
            if (none$ instanceof Some) {
                Some some = (Some)((Object)none$);
                Either res = (Either)some.value();
                return res;
            }
            if (!None$.MODULE$.equals(none$)) break;
            Thread.sleep(delay.toMillis());
            Duration duration = package$DoubleMult$.MODULE$.$times$extension(package$.MODULE$.DoubleMult(retryBackoffMultiplier$1), delay);
            delay = duration instanceof FiniteDuration ? (finiteDuration = (FiniteDuration)duration) : delay;
            --retry;
        }
        throw new MatchError(none$);
    }

    private Downloader$() {
    }
}

