/*
 * Decompiled with CFR 0.152.
 */
package coursierapi.shaded.coursier.cache.internal;

import coursierapi.shaded.coursier.cache.ArtifactError;
import coursierapi.shaded.coursier.cache.ArtifactError$NotFound$;
import coursierapi.shaded.coursier.cache.CacheLogger;
import coursierapi.shaded.coursier.cache.CachePolicy;
import coursierapi.shaded.coursier.cache.CachePolicy$FetchMissing$;
import coursierapi.shaded.coursier.cache.CachePolicy$ForceDownload$;
import coursierapi.shaded.coursier.cache.CachePolicy$LocalOnly$;
import coursierapi.shaded.coursier.cache.CachePolicy$LocalOnlyIfValid$;
import coursierapi.shaded.coursier.cache.CachePolicy$LocalUpdate$;
import coursierapi.shaded.coursier.cache.CachePolicy$LocalUpdateChanging$;
import coursierapi.shaded.coursier.cache.CachePolicy$Update$;
import coursierapi.shaded.coursier.cache.CachePolicy$UpdateChanging$;
import coursierapi.shaded.coursier.cache.FileCache$;
import coursierapi.shaded.coursier.cache.internal.DownloadResult;
import coursierapi.shaded.coursier.cache.internal.DownloadResult$;
import coursierapi.shaded.coursier.cache.internal.Downloader$Blocking$;
import coursierapi.shaded.coursier.core.Authentication;
import coursierapi.shaded.coursier.credentials.DirectCredentials;
import coursierapi.shaded.coursier.paths.Util;
import coursierapi.shaded.coursier.util.Artifact;
import coursierapi.shaded.coursier.util.EitherT;
import coursierapi.shaded.coursier.util.Monad$ops$;
import coursierapi.shaded.coursier.util.Sync;
import coursierapi.shaded.scala.Array$;
import coursierapi.shaded.scala.Function0;
import coursierapi.shaded.scala.Function1;
import coursierapi.shaded.scala.MatchError;
import coursierapi.shaded.scala.None$;
import coursierapi.shaded.scala.Option;
import coursierapi.shaded.scala.Option$;
import coursierapi.shaded.scala.Predef$;
import coursierapi.shaded.scala.Product;
import coursierapi.shaded.scala.Some;
import coursierapi.shaded.scala.collection.Iterator;
import coursierapi.shaded.scala.collection.StringOps$;
import coursierapi.shaded.scala.collection.immutable.Seq;
import coursierapi.shaded.scala.concurrent.duration.Duration;
import coursierapi.shaded.scala.concurrent.duration.FiniteDuration;
import coursierapi.shaded.scala.package$;
import coursierapi.shaded.scala.runtime.BoxedUnit;
import coursierapi.shaded.scala.runtime.BoxesRunTime;
import coursierapi.shaded.scala.runtime.ScalaRunTime$;
import coursierapi.shaded.scala.runtime.Statics;
import coursierapi.shaded.scala.util.Either;
import coursierapi.shaded.scala.util.Left;
import coursierapi.shaded.scala.util.Right;
import java.io.File;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.time.Clock;
import java.util.Locale;
import java.util.concurrent.ExecutorService;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLSocketFactory;

public final class Downloader<F>
implements Serializable,
Product {
    private Option<File> referenceFileOpt;
    private volatile Downloader<F> Blocking$module;
    private final Artifact artifact;
    private final CachePolicy cachePolicy;
    private final File location;
    private final Seq<String> actualChecksums;
    private final F allCredentials;
    private final CacheLogger logger;
    private final ExecutorService pool;
    private final Option<Duration> ttl;
    private final boolean localArtifactsShouldBeCached;
    private final boolean followHttpToHttpsRedirections;
    private final boolean followHttpsToHttpRedirections;
    private final Option<Object> maxRedirections;
    private final int sslRetry;
    private final Option<SSLSocketFactory> sslSocketFactoryOpt;
    private final Option<HostnameVerifier> hostnameVerifierOpt;
    private final int bufferSize;
    private final Seq<ClassLoader> classLoaders;
    private final Clock clock;
    private final int retryCount;
    private final FiniteDuration retryBackoffInitialDelay;
    private final double retryBackoffMultiplier;
    private final Sync<F> S;
    private final boolean cacheErrors;
    private final CachePolicy.Mixed actualCachePolicy;
    private volatile boolean bitmap$0;

    @Override
    public Iterator<Object> productIterator() {
        return Product.productIterator$(this);
    }

    public Downloader<F> coursier$cache$internal$Downloader$$Blocking() {
        if (this.Blocking$module == null) {
            this.Blocking$lzycompute$1();
        }
        return this.Blocking$module;
    }

    public Artifact artifact() {
        return this.artifact;
    }

    public CachePolicy cachePolicy() {
        return this.cachePolicy;
    }

    public File location() {
        return this.location;
    }

    public Seq<String> actualChecksums() {
        return this.actualChecksums;
    }

    public F allCredentials() {
        return this.allCredentials;
    }

    public CacheLogger logger() {
        return this.logger;
    }

    public ExecutorService pool() {
        return this.pool;
    }

    public Option<Duration> ttl() {
        return this.ttl;
    }

    public boolean localArtifactsShouldBeCached() {
        return this.localArtifactsShouldBeCached;
    }

    public boolean followHttpToHttpsRedirections() {
        return this.followHttpToHttpsRedirections;
    }

    public boolean followHttpsToHttpRedirections() {
        return this.followHttpsToHttpRedirections;
    }

    public Option<Object> maxRedirections() {
        return this.maxRedirections;
    }

    public int sslRetry() {
        return this.sslRetry;
    }

    public Option<SSLSocketFactory> sslSocketFactoryOpt() {
        return this.sslSocketFactoryOpt;
    }

    public Option<HostnameVerifier> hostnameVerifierOpt() {
        return this.hostnameVerifierOpt;
    }

    public int bufferSize() {
        return this.bufferSize;
    }

    public Seq<ClassLoader> classLoaders() {
        return this.classLoaders;
    }

    public Clock clock() {
        return this.clock;
    }

    public int retryCount() {
        return this.retryCount;
    }

    public FiniteDuration retryBackoffInitialDelay() {
        return this.retryBackoffInitialDelay;
    }

    public double retryBackoffMultiplier() {
        return this.retryBackoffMultiplier;
    }

    public Sync<F> S() {
        return this.S;
    }

    private <T> F blockingIO(Function0<T> f) {
        return this.S().schedule(this.pool(), f);
    }

    private <T> EitherT<F, ArtifactError, T> blockingIOE(Function0<Either<ArtifactError, T>> f) {
        return new EitherT(this.S().schedule(this.pool(), f));
    }

    private File localFile(String url, Option<String> user) {
        return FileCache$.MODULE$.localFile0(url, this.location(), user, this.localArtifactsShouldBeCached());
    }

    private Option<File> referenceFileOpt$lzycompute() {
        Downloader downloader = this;
        synchronized (downloader) {
            if (!this.bitmap$0) {
                this.referenceFileOpt = this.artifact().extra().get("metadata").map((Function1<Artifact, File> & Serializable)a -> this.localFile(a.url(), a.authentication().map((Function1<Authentication, String> & Serializable)x$1 -> x$1.user())));
                this.bitmap$0 = true;
            }
        }
        return this.referenceFileOpt;
    }

    private Option<File> referenceFileOpt() {
        if (!this.bitmap$0) {
            return this.referenceFileOpt$lzycompute();
        }
        return this.referenceFileOpt;
    }

    private boolean cacheErrors() {
        return this.cacheErrors;
    }

    private boolean cacheErrors0() {
        return this.cacheErrors() || this.referenceFileOpt().exists((Function1<File, Object> & Serializable)x$2 -> BoxesRunTime.boxToBoolean(x$2.exists()));
    }

    private F urlLastModified(String url, Option<Object> currentLastModifiedOpt, CacheLogger logger) {
        return Monad$ops$.MODULE$.toAllMonadOps(this.allCredentials(), this.S()).flatMap((Function1<Seq, Object> & Serializable)allCredentials0 -> this.blockingIO((Function0<Either> & Serializable)() -> this.coursier$cache$internal$Downloader$$Blocking().urlLastModified(url, currentLastModifiedOpt, logger, (Seq<DirectCredentials>)allCredentials0)));
    }

    public File coursier$cache$internal$Downloader$$ttlFile(File file) {
        return new File(file.getParent(), new StringBuilder(9).append(".").append(file.getName()).append(".checked").toString());
    }

    private F checkNeeded(File file) {
        boolean bl = false;
        Some some = null;
        Option<Duration> option = this.ttl();
        if (None$.MODULE$.equals(option)) {
            return this.S().point(BoxesRunTime.boxToBoolean(true));
        }
        if (option instanceof Some) {
            bl = true;
            some = (Some)option;
            Duration ttl = (Duration)some.value();
            if (!ttl.isFinite()) {
                return this.S().point(BoxesRunTime.boxToBoolean(false));
            }
        }
        if (bl) {
            Duration ttl = (Duration)some.value();
            return this.blockingIO(() -> BoxesRunTime.unboxToBoolean(this.coursier$cache$internal$Downloader$$Blocking().lastCheck(file).fold(() -> true, ts -> {
                long now = this.clock().millis();
                return now > ts + ttl.toMillis();
            })));
        }
        throw new MatchError(option);
    }

    private boolean checkNeededBlocking(File file) {
        boolean bl = false;
        Some some = null;
        Option<Duration> option = this.ttl();
        if (None$.MODULE$.equals(option)) {
            return true;
        }
        if (option instanceof Some) {
            bl = true;
            some = (Some)option;
            Duration ttl = (Duration)some.value();
            if (!ttl.isFinite()) {
                return false;
            }
        }
        if (bl) {
            Duration ttl = (Duration)some.value();
            return BoxesRunTime.unboxToBoolean(this.coursier$cache$internal$Downloader$$Blocking().lastCheck(file).fold(() -> true, ts -> {
                long now = this.clock().millis();
                return now > ts + ttl.toMillis();
            }));
        }
        throw new MatchError(option);
    }

    private EitherT<F, ArtifactError, Object> shouldDownload(File file, String url, boolean checkRemote) {
        return this.blockingIOE((Function0<Either> & Serializable)() -> this.checkErrFile$1(file, url)).flatMap((Function1<BoxedUnit, EitherT> & Serializable)x$16 -> {
            BoxedUnit boxedUnit = x$16;
            return new EitherT(this.checkShouldDownload$1(file, checkRemote, url)).map((Function1<Object, Object> & Serializable)res -> BoxesRunTime.boxToBoolean(BoxesRunTime.unboxToBoolean(res)), this.S());
        }, this.S());
    }

    private boolean shouldDownloadSecondCheckBlocking(File file) {
        return !file.exists() || this.checkNeededBlocking(file);
    }

    private F remote(File file, String url, boolean keepHeaderChecksums, Function0<Object> proceed) {
        return Monad$ops$.MODULE$.toAllMonadOps(this.allCredentials(), this.S()).flatMap((Function1<Seq, Object> & Serializable)allCredentials0 -> this.blockingIO((Function0<Either> & Serializable)() -> this.coursier$cache$internal$Downloader$$Blocking().remote(file, url, keepHeaderChecksums, (Seq<DirectCredentials>)allCredentials0, proceed)));
    }

    private File errFile(File file) {
        return new File(file.getParentFile(), new StringBuilder(7).append(".").append(file.getName()).append(".error").toString());
    }

    private F remoteKeepErrors(File file, String url, boolean keepHeaderChecksums, Function0<Object> proceed) {
        File errFile0 = this.errFile(file);
        return Monad$ops$.MODULE$.toAllMonadOps(this.remote(file, url, keepHeaderChecksums, proceed), this.S()).flatMap((Function1<Either, Object> & Serializable)e -> this.blockingIO((Function0<Either> & Serializable)() -> {
            ArtifactError.NotFound notFound;
            Left left;
            ArtifactError nf;
            Either either = e;
            if (either instanceof Left && (nf = (ArtifactError)(left = (Left)either).value()) instanceof ArtifactError.NotFound && (notFound = (ArtifactError.NotFound)nf).permanent().contains(BoxesRunTime.boxToBoolean(true))) {
                this.createErrFileBlocking$1(errFile0);
                return left;
            }
            Downloader.deleteErrFileBlocking$1(errFile0);
            return either;
        }));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean checkFileExistsBlocking(File file, String url) {
        if (!file.exists()) return false;
        this.logger().foundLocally(url);
        if (!true) return false;
        return true;
    }

    private F checkFileExists(File file, String url, boolean log) {
        return this.blockingIO((Function0<Either> & Serializable)() -> {
            if (this.checkFileExistsBlocking(file, url)) {
                return package$.MODULE$.Right().apply(BoxedUnit.UNIT);
            }
            return package$.MODULE$.Left().apply(new ArtifactError.NotFound(file.toString(), ArtifactError$NotFound$.MODULE$.$lessinit$greater$default$2()));
        });
    }

    private boolean checkFileExists$default$3() {
        return true;
    }

    private CachePolicy.Mixed actualCachePolicy() {
        return this.actualCachePolicy;
    }

    private F downloadUrl(String url, boolean keepHeaderChecksums) {
        this.logger().checkingArtifact(url, this.artifact());
        File file = this.localFile(url, this.artifact().authentication().map((Function1<Authentication, String> & Serializable)x$17 -> x$17.user()));
        Object run0 = this.artifact().changing() && !this.cachePolicy().acceptsChangingArtifacts() ? this.S().point(package$.MODULE$.Left().apply(new ArtifactError.ForbiddenChangingArtifact(url))) : this.run$1(url, file, keepHeaderChecksums);
        return Monad$ops$.MODULE$.toAllMonadOps(run0, this.S()).map((Function1<Either, DownloadResult> & Serializable)e -> DownloadResult$.MODULE$.apply(url, file, e.left().toOption()));
    }

    public F download() {
        F mainTask = this.downloadUrl(this.artifact().url(), true);
        return Monad$ops$.MODULE$.toAllMonadOps(mainTask, this.S()).flatMap((Function1<DownloadResult, Object> & Serializable)r -> {
            Object f;
            if (r.errorOpt().isEmpty()) {
                Seq l2 = (Seq)this.actualChecksums().map((Function1<String, Object> & Serializable)c -> {
                    File candidate = FileCache$.MODULE$.auxiliaryFile(r.file(), (String)c);
                    return Monad$ops$.MODULE$.toAllMonadOps(this.blockingIO(() -> candidate.exists()), this.S()).map((Function1<Object, Seq> & Serializable)x0$1 -> Downloader.$anonfun$download$5(this, c, candidate, BoxesRunTime.unboxToBoolean(x0$1)));
                });
                f = Monad$ops$.MODULE$.toAllMonadOps(this.S().gather(l2), this.S()).flatMap((Function1<Seq, Object> & Serializable)l -> this.S().gather((Seq)l.flatten(Predef$.MODULE$.$conforms())));
            } else {
                Seq l3 = (Seq)this.actualChecksums().flatMap((Function1<String, Seq> & Serializable)c -> this.checksumRes$1((String)c));
                f = this.S().gather(l3);
            }
            Object l0 = f;
            return Monad$ops$.MODULE$.toAllMonadOps(l0, this.S()).map((Function1<Seq, Seq> & Serializable)x$24 -> {
                DownloadResult downloadResult = r;
                return (Seq)x$24.$plus$colon(downloadResult);
            });
        });
    }

    public String toString() {
        StringBuilder b = new StringBuilder("Downloader(");
        b.append(String.valueOf(this.artifact()));
        b.append(", ");
        b.append(String.valueOf(this.cachePolicy()));
        b.append(", ");
        b.append(String.valueOf(this.location()));
        b.append(", ");
        b.append(String.valueOf(this.actualChecksums()));
        b.append(", ");
        b.append(String.valueOf(this.allCredentials()));
        b.append(", ");
        b.append(String.valueOf(this.logger()));
        b.append(", ");
        b.append(String.valueOf(this.pool()));
        b.append(", ");
        b.append(String.valueOf(this.ttl()));
        b.append(", ");
        b.append(String.valueOf(this.localArtifactsShouldBeCached()));
        b.append(", ");
        b.append(String.valueOf(this.followHttpToHttpsRedirections()));
        b.append(", ");
        b.append(String.valueOf(this.followHttpsToHttpRedirections()));
        b.append(", ");
        b.append(String.valueOf(this.maxRedirections()));
        b.append(", ");
        b.append(String.valueOf(this.sslRetry()));
        b.append(", ");
        b.append(String.valueOf(this.sslSocketFactoryOpt()));
        b.append(", ");
        b.append(String.valueOf(this.hostnameVerifierOpt()));
        b.append(", ");
        b.append(String.valueOf(this.bufferSize()));
        b.append(", ");
        b.append(String.valueOf(this.classLoaders()));
        b.append(", ");
        b.append(String.valueOf(this.clock()));
        b.append(", ");
        b.append(String.valueOf(this.retryCount()));
        b.append(", ");
        b.append(String.valueOf(this.retryBackoffInitialDelay()));
        b.append(", ");
        b.append(String.valueOf(this.retryBackoffMultiplier()));
        b.append(", ");
        b.append(String.valueOf(this.S()));
        b.append(")");
        return b.toString();
    }

    public boolean canEqual(Object obj) {
        return obj != null && obj instanceof Downloader && true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (this == obj) return true;
        if (!this.canEqual(obj)) return false;
        Downloader other = (Downloader)obj;
        if (!true) return false;
        Artifact artifact = this.artifact();
        Artifact artifact2 = other.artifact();
        if (artifact == null) {
            if (artifact2 != null) {
                return false;
            }
        } else if (!((Object)artifact).equals(artifact2)) return false;
        CachePolicy cachePolicy = this.cachePolicy();
        CachePolicy cachePolicy2 = other.cachePolicy();
        if (cachePolicy == null) {
            if (cachePolicy2 != null) {
                return false;
            }
        } else if (!cachePolicy.equals(cachePolicy2)) return false;
        File file = this.location();
        File file2 = other.location();
        if (file == null) {
            if (file2 != null) {
                return false;
            }
        } else if (!((Object)file).equals(file2)) return false;
        Seq<String> seq = this.actualChecksums();
        Seq<String> seq2 = other.actualChecksums();
        if (seq == null) {
            if (seq2 != null) {
                return false;
            }
        } else if (!seq.equals(seq2)) return false;
        if (!BoxesRunTime.equals(this.allCredentials(), other.allCredentials())) return false;
        CacheLogger cacheLogger = this.logger();
        CacheLogger cacheLogger2 = other.logger();
        if (cacheLogger == null) {
            if (cacheLogger2 != null) {
                return false;
            }
        } else if (!cacheLogger.equals(cacheLogger2)) return false;
        ExecutorService executorService = this.pool();
        ExecutorService executorService2 = other.pool();
        if (executorService == null) {
            if (executorService2 != null) {
                return false;
            }
        } else if (!executorService.equals(executorService2)) return false;
        Option<Duration> option = this.ttl();
        Option<Duration> option2 = other.ttl();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        if (this.localArtifactsShouldBeCached() != other.localArtifactsShouldBeCached()) return false;
        if (this.followHttpToHttpsRedirections() != other.followHttpToHttpsRedirections()) return false;
        if (this.followHttpsToHttpRedirections() != other.followHttpsToHttpRedirections()) return false;
        Option<Object> option3 = this.maxRedirections();
        Option<Object> option4 = other.maxRedirections();
        if (option3 == null) {
            if (option4 != null) {
                return false;
            }
        } else if (!option3.equals(option4)) return false;
        if (this.sslRetry() != other.sslRetry()) return false;
        Option<SSLSocketFactory> option5 = this.sslSocketFactoryOpt();
        Option<SSLSocketFactory> option6 = other.sslSocketFactoryOpt();
        if (option5 == null) {
            if (option6 != null) {
                return false;
            }
        } else if (!option5.equals(option6)) return false;
        Option<HostnameVerifier> option7 = this.hostnameVerifierOpt();
        Option<HostnameVerifier> option8 = other.hostnameVerifierOpt();
        if (option7 == null) {
            if (option8 != null) {
                return false;
            }
        } else if (!option7.equals(option8)) return false;
        if (this.bufferSize() != other.bufferSize()) return false;
        Seq<ClassLoader> seq3 = this.classLoaders();
        Seq<ClassLoader> seq4 = other.classLoaders();
        if (seq3 == null) {
            if (seq4 != null) {
                return false;
            }
        } else if (!seq3.equals(seq4)) return false;
        Clock clock = this.clock();
        Clock clock2 = other.clock();
        if (clock == null) {
            if (clock2 != null) {
                return false;
            }
        } else if (!((Object)clock).equals(clock2)) return false;
        if (this.retryCount() != other.retryCount()) return false;
        FiniteDuration finiteDuration = this.retryBackoffInitialDelay();
        FiniteDuration finiteDuration2 = other.retryBackoffInitialDelay();
        if (finiteDuration == null) {
            if (finiteDuration2 != null) {
                return false;
            }
        } else if (!((Object)finiteDuration).equals(finiteDuration2)) return false;
        if (this.retryBackoffMultiplier() != other.retryBackoffMultiplier()) return false;
        Sync<F> sync = this.S();
        Sync<F> sync2 = other.S();
        if (sync == null) {
            if (sync2 == null) return true;
            return false;
        } else {
            if (!sync.equals(sync2)) return false;
            return true;
        }
    }

    public int hashCode() {
        int code = 17 + Statics.anyHash("Downloader");
        code = 37 * code + Statics.anyHash(this.artifact());
        code = 37 * code + Statics.anyHash(this.cachePolicy());
        code = 37 * code + Statics.anyHash(this.location());
        code = 37 * code + Statics.anyHash(this.actualChecksums());
        code = 37 * code + Statics.anyHash(this.allCredentials());
        code = 37 * code + Statics.anyHash(this.logger());
        code = 37 * code + Statics.anyHash(this.pool());
        code = 37 * code + Statics.anyHash(this.ttl());
        code = 37 * code + (this.localArtifactsShouldBeCached() ? 1231 : 1237);
        code = 37 * code + (this.followHttpToHttpsRedirections() ? 1231 : 1237);
        code = 37 * code + (this.followHttpsToHttpRedirections() ? 1231 : 1237);
        code = 37 * code + Statics.anyHash(this.maxRedirections());
        code = 37 * code + this.sslRetry();
        code = 37 * code + Statics.anyHash(this.sslSocketFactoryOpt());
        code = 37 * code + Statics.anyHash(this.hostnameVerifierOpt());
        code = 37 * code + this.bufferSize();
        code = 37 * code + Statics.anyHash(this.classLoaders());
        code = 37 * code + Statics.anyHash(this.clock());
        code = 37 * code + this.retryCount();
        code = 37 * code + Statics.anyHash(this.retryBackoffInitialDelay());
        code = 37 * code + Statics.doubleHash(this.retryBackoffMultiplier());
        code = 37 * code + Statics.anyHash(this.S());
        return 37 * code;
    }

    @Override
    public String productPrefix() {
        return "Downloader";
    }

    @Override
    public int productArity() {
        return 22;
    }

    @Override
    public Object productElement(int n) {
        int n2 = n;
        switch (n2) {
            case 0: {
                return this.artifact();
            }
            case 1: {
                return this.cachePolicy();
            }
            case 2: {
                return this.location();
            }
            case 3: {
                return this.actualChecksums();
            }
            case 4: {
                return this.allCredentials();
            }
            case 5: {
                return this.logger();
            }
            case 6: {
                return this.pool();
            }
            case 7: {
                return this.ttl();
            }
            case 8: {
                return BoxesRunTime.boxToBoolean(this.localArtifactsShouldBeCached());
            }
            case 9: {
                return BoxesRunTime.boxToBoolean(this.followHttpToHttpsRedirections());
            }
            case 10: {
                return BoxesRunTime.boxToBoolean(this.followHttpsToHttpRedirections());
            }
            case 11: {
                return this.maxRedirections();
            }
            case 12: {
                return BoxesRunTime.boxToInteger(this.sslRetry());
            }
            case 13: {
                return this.sslSocketFactoryOpt();
            }
            case 14: {
                return this.hostnameVerifierOpt();
            }
            case 15: {
                return BoxesRunTime.boxToInteger(this.bufferSize());
            }
            case 16: {
                return this.classLoaders();
            }
            case 17: {
                return this.clock();
            }
            case 18: {
                return BoxesRunTime.boxToInteger(this.retryCount());
            }
            case 19: {
                return this.retryBackoffInitialDelay();
            }
            case 20: {
                return BoxesRunTime.boxToDouble(this.retryBackoffMultiplier());
            }
            case 21: {
                return this.S();
            }
        }
        throw new IndexOutOfBoundsException(Integer.toString(n2));
    }

    private final void Blocking$lzycompute$1() {
        Downloader downloader = this;
        synchronized (downloader) {
            if (this.Blocking$module == null) {
                this.Blocking$module = new Downloader$Blocking$(this);
            }
        }
    }

    public static final /* synthetic */ boolean $anonfun$shouldDownload$2(Duration x$14) {
        return !x$14.isFinite();
    }

    private final Either checkErrFile$1(File file$4, String url$5) {
        File errFile0 = this.errFile(file$4);
        if (this.referenceFileOpt().exists((Function1<File, Object> & Serializable)x$13 -> BoxesRunTime.boxToBoolean(x$13.exists())) && errFile0.exists()) {
            return package$.MODULE$.Left().apply(new ArtifactError.NotFound(url$5, new Some<Object>(BoxesRunTime.boxToBoolean(true))));
        }
        if (this.cacheErrors() && errFile0.exists()) {
            long ts = errFile0.lastModified();
            long now = this.clock().millis();
            if (ts > 0L && (this.ttl().exists((Function1<Duration, Object> & Serializable)x$14 -> BoxesRunTime.boxToBoolean(Downloader.$anonfun$shouldDownload$2(x$14))) || now < ts + BoxesRunTime.unboxToLong(this.ttl().fold(() -> 0L, (Function1<Duration, Object> & Serializable)x$15 -> BoxesRunTime.boxToLong(x$15.toMillis()))))) {
                return package$.MODULE$.Left().apply(new ArtifactError.NotFound(url$5, ArtifactError$NotFound$.MODULE$.$lessinit$greater$default$2()));
            }
            return package$.MODULE$.Right().apply(BoxedUnit.UNIT);
        }
        return package$.MODULE$.Right().apply(BoxedUnit.UNIT);
    }

    public static final /* synthetic */ boolean $anonfun$shouldDownload$7(Option fileLastModOpt$1, Option urlLastModOpt) {
        Option<Object> fromDatesOpt = fileLastModOpt$1.flatMap((Function1<Object, Option> & Serializable)fileLastMod -> urlLastModOpt.map(urlLastMod -> fileLastMod < urlLastMod));
        return BoxesRunTime.unboxToBoolean(fromDatesOpt.getOrElse(() -> true));
    }

    private final EitherT doCheckRemote$1(File file$4, String url$5) {
        return this.blockingIOE((Function0<Either> & Serializable)() -> this.coursier$cache$internal$Downloader$$Blocking().fileLastModified(file$4)).flatMap((Function1<Option, EitherT> & Serializable)fileLastModOpt -> new EitherT(this.urlLastModified(url$5, (Option<Object>)fileLastModOpt, this.logger())).map((Function1<Option, Object> & Serializable)urlLastModOpt -> BoxesRunTime.boxToBoolean(Downloader.$anonfun$shouldDownload$7(fileLastModOpt, urlLastModOpt)), this.S()), this.S());
    }

    public static final /* synthetic */ Object $anonfun$shouldDownload$13(Downloader $this, boolean checkRemote$1, File file$4, String url$5, boolean x0$2) {
        boolean bl = x0$2;
        if (!bl) {
            return $this.S().point(package$.MODULE$.Right().apply(BoxesRunTime.boxToBoolean(false)));
        }
        if (bl) {
            if (checkRemote$1) {
                return Monad$ops$.MODULE$.toAllMonadOps($this.doCheckRemote$1(file$4, url$5).run(), $this.S()).flatMap((Function1<Either, Object> & Serializable)x0$3 -> {
                    Right right;
                    boolean bl;
                    Either either = x0$3;
                    if (either instanceof Right && !(bl = BoxesRunTime.unboxToBoolean((right = (Right)either).value()))) {
                        return $this.blockingIO((Function0<Right> & Serializable)() -> {
                            $this.coursier$cache$internal$Downloader$$Blocking().doTouchCheckFile(file$4, url$5, false);
                            return package$.MODULE$.Right().apply(BoxesRunTime.boxToBoolean(false));
                        });
                    }
                    return $this.S().point(either);
                });
            }
            return $this.S().point(package$.MODULE$.Right().apply(BoxesRunTime.boxToBoolean(true)));
        }
        throw new MatchError(BoxesRunTime.boxToBoolean(bl));
    }

    public static final /* synthetic */ Object $anonfun$shouldDownload$12(Downloader $this, File file$4, boolean checkRemote$1, String url$5, boolean x0$1) {
        boolean bl = x0$1;
        if (!bl) {
            return $this.S().point(package$.MODULE$.Right().apply(BoxesRunTime.boxToBoolean(true)));
        }
        if (bl) {
            return Monad$ops$.MODULE$.toAllMonadOps($this.checkNeeded(file$4), $this.S()).flatMap((Function1<Object, Object> & Serializable)x0$2 -> Downloader.$anonfun$shouldDownload$13($this, checkRemote$1, file$4, url$5, BoxesRunTime.unboxToBoolean(x0$2)));
        }
        throw new MatchError(BoxesRunTime.boxToBoolean(bl));
    }

    private final Object checkShouldDownload$1(File file$4, boolean checkRemote$1, String url$5) {
        return Monad$ops$.MODULE$.toAllMonadOps(this.blockingIO(() -> file$4.exists()), this.S()).flatMap((Function1<Object, Object> & Serializable)x0$1 -> Downloader.$anonfun$shouldDownload$12(this, file$4, checkRemote$1, url$5, BoxesRunTime.unboxToBoolean(x0$1)));
    }

    private final Object createErrFileBlocking$1(File errFile0$1) {
        if (this.cacheErrors0()) {
            Path p = errFile0$1.toPath();
            Util.createDirectories(p.getParent());
            return Files.write(p, Array$.MODULE$.emptyByteArray(), new OpenOption[0]);
        }
        return BoxedUnit.UNIT;
    }

    private static final Object deleteErrFileBlocking$1(File errFile0$1) {
        if (errFile0$1.exists()) {
            return BoxesRunTime.boxToBoolean(errFile0$1.delete());
        }
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ EitherT $anonfun$downloadUrl$2(Downloader $this, File file$7, String url$8, boolean keepHeaderChecksums$3, boolean needsUpdate) {
        Object f = needsUpdate ? $this.remoteKeepErrors(file$7, url$8, keepHeaderChecksums$3, () -> $this.shouldDownloadSecondCheckBlocking(file$7)) : $this.S().point(package$.MODULE$.Right().apply(BoxedUnit.UNIT));
        return new EitherT(f).map((Function1<BoxedUnit, Object> & Serializable)x$18 -> {
            boxedUnit = x$18;
            return BoxedUnit.UNIT;
        }, $this.S());
    }

    private final EitherT maybeUpdate$1(File file$7, String url$8, boolean keepHeaderChecksums$3) {
        return this.shouldDownload(file$7, url$8, true).flatMap((Function1<Object, EitherT> & Serializable)needsUpdate -> Downloader.$anonfun$downloadUrl$2(this, file$7, url$8, keepHeaderChecksums$3, BoxesRunTime.unboxToBoolean(needsUpdate)), this.S());
    }

    public static final /* synthetic */ EitherT $anonfun$downloadUrl$8(Downloader $this, File file$7, boolean needsUpdate) {
        Right e = needsUpdate ? package$.MODULE$.Left().apply(new ArtifactError.FileTooOldOrNotFound(file$7.toString())) : package$.MODULE$.Right().apply(BoxedUnit.UNIT);
        return new EitherT($this.S().point(e)).map((Function1<BoxedUnit, Object> & Serializable)x$21 -> {
            boxedUnit = x$21;
            return BoxedUnit.UNIT;
        }, $this.S());
    }

    private final Object run$1(String url$8, File file$7, boolean keepHeaderChecksums$3) {
        if (url$8.startsWith("file:/") && !this.localArtifactsShouldBeCached()) {
            return this.checkFileExists(file$7, url$8, this.checkFileExists$default$3());
        }
        CachePolicy.Mixed mixed = this.actualCachePolicy();
        if (CachePolicy$LocalOnly$.MODULE$.equals(mixed)) {
            return this.checkFileExists(file$7, url$8, this.checkFileExists$default$3());
        }
        if (CachePolicy$LocalUpdateChanging$.MODULE$.equals(mixed) ? true : CachePolicy$LocalUpdate$.MODULE$.equals(mixed)) {
            EitherT e = new EitherT(this.checkFileExists(file$7, url$8, false)).flatMap((Function1<BoxedUnit, EitherT> & Serializable)x$20 -> {
                BoxedUnit boxedUnit = x$20;
                return this.maybeUpdate$1(file$7, url$8, keepHeaderChecksums$3).map((Function1<BoxedUnit, Object> & Serializable)x$19 -> {
                    boxedUnit = x$19;
                    return BoxedUnit.UNIT;
                }, this.S());
            }, this.S());
            return e.run();
        }
        if (CachePolicy$LocalOnlyIfValid$.MODULE$.equals(mixed)) {
            EitherT e = new EitherT(this.checkFileExists(file$7, url$8, false)).flatMap((Function1<BoxedUnit, EitherT> & Serializable)x$22 -> {
                BoxedUnit boxedUnit = x$22;
                return this.shouldDownload(file$7, url$8, false).flatMap((Function1<Object, EitherT> & Serializable)needsUpdate -> Downloader.$anonfun$downloadUrl$8(this, file$7, BoxesRunTime.unboxToBoolean(needsUpdate)), this.S());
            }, this.S());
            return e.run();
        }
        if (CachePolicy$UpdateChanging$.MODULE$.equals(mixed) ? true : CachePolicy$Update$.MODULE$.equals(mixed)) {
            return this.maybeUpdate$1(file$7, url$8, keepHeaderChecksums$3).run();
        }
        if (CachePolicy$FetchMissing$.MODULE$.equals(mixed)) {
            return new EitherT(this.checkFileExists(file$7, url$8, this.checkFileExists$default$3())).orElse((Function0<EitherT> & Serializable)() -> new EitherT(this.remoteKeepErrors(file$7, url$8, keepHeaderChecksums$3, () -> !this.checkFileExistsBlocking(file$7, url$8))), this.S()).run();
        }
        if (CachePolicy$ForceDownload$.MODULE$.equals(mixed)) {
            return this.remoteKeepErrors(file$7, url$8, keepHeaderChecksums$3, () -> true);
        }
        throw new MatchError(mixed);
    }

    private final Seq checksumRes$1(String c) {
        return (Seq)Option$.MODULE$.option2Iterable(this.artifact().checksumUrls().get(c)).toSeq().map((Function1<String, Object> & Serializable)url -> this.downloadUrl((String)url, false));
    }

    public static final /* synthetic */ boolean $anonfun$download$6(char x$23) {
        return x$23 != '-';
    }

    private final String fallbackUrl$1(String c$2) {
        return new StringBuilder(1).append(this.artifact().url()).append(".").append(StringOps$.MODULE$.filter$extension(Predef$.MODULE$.augmentString(c$2.toLowerCase(Locale.ROOT)), (Function1<Object, Object> & Serializable)x$23 -> BoxesRunTime.boxToBoolean(Downloader.$anonfun$download$6(BoxesRunTime.unboxToChar(x$23))))).toString();
    }

    public static final /* synthetic */ Seq $anonfun$download$5(Downloader $this, String c$2, File candidate$1, boolean x0$1) {
        boolean bl = x0$1;
        if (!bl) {
            return $this.checksumRes$1(c$2);
        }
        if (bl) {
            String url = (String)$this.artifact().checksumUrls().getOrElse(c$2, (Function0<String> & Serializable)() -> $this.fallbackUrl$1(c$2));
            return (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray(new Object[]{$this.S().point(DownloadResult$.MODULE$.apply(url, candidate$1))}));
        }
        throw new MatchError(BoxesRunTime.boxToBoolean(bl));
    }

    public Downloader(Artifact artifact, CachePolicy cachePolicy, File location, Seq<String> actualChecksums, F allCredentials, CacheLogger logger, ExecutorService pool, Option<Duration> ttl, boolean localArtifactsShouldBeCached, boolean followHttpToHttpsRedirections, boolean followHttpsToHttpRedirections, Option<Object> maxRedirections, int sslRetry, Option<SSLSocketFactory> sslSocketFactoryOpt, Option<HostnameVerifier> hostnameVerifierOpt, int bufferSize, Seq<ClassLoader> classLoaders, Clock clock, int retryCount, FiniteDuration retryBackoffInitialDelay2, double retryBackoffMultiplier, Sync<F> S) {
        this.artifact = artifact;
        this.cachePolicy = cachePolicy;
        this.location = location;
        this.actualChecksums = actualChecksums;
        this.allCredentials = allCredentials;
        this.logger = logger;
        this.pool = pool;
        this.ttl = ttl;
        this.localArtifactsShouldBeCached = localArtifactsShouldBeCached;
        this.followHttpToHttpsRedirections = followHttpToHttpsRedirections;
        this.followHttpsToHttpRedirections = followHttpsToHttpRedirections;
        this.maxRedirections = maxRedirections;
        this.sslRetry = sslRetry;
        this.sslSocketFactoryOpt = sslSocketFactoryOpt;
        this.hostnameVerifierOpt = hostnameVerifierOpt;
        this.bufferSize = bufferSize;
        this.classLoaders = classLoaders;
        this.clock = clock;
        this.retryCount = retryCount;
        this.retryBackoffInitialDelay = retryBackoffInitialDelay2;
        this.retryBackoffMultiplier = retryBackoffMultiplier;
        this.S = S;
        Product.$init$(this);
        this.cacheErrors = artifact.changing() && artifact.extra().contains("cache-errors");
        CachePolicy.Mixed mixed = cachePolicy.acceptChanging();
        this.actualCachePolicy = CachePolicy$UpdateChanging$.MODULE$.equals(mixed) && !artifact.changing() ? CachePolicy$FetchMissing$.MODULE$ : ((CachePolicy$LocalUpdateChanging$.MODULE$.equals(mixed) ? true : CachePolicy$LocalOnlyIfValid$.MODULE$.equals(mixed)) && !artifact.changing() ? CachePolicy$LocalOnly$.MODULE$ : mixed);
    }
}

