/*
 * Decompiled with CFR 0.152.
 */
package coursierapi.shaded.coursier.jvm;

import coursierapi.shaded.coursier.cache.ArchiveCache;
import coursierapi.shaded.coursier.cache.ArchiveCache$;
import coursierapi.shaded.coursier.cache.ArtifactError;
import coursierapi.shaded.coursier.cache.CacheLogger;
import coursierapi.shaded.coursier.cache.CacheLogger$;
import coursierapi.shaded.coursier.jvm.JvmCache$;
import coursierapi.shaded.coursier.jvm.JvmCache$JvmCacheException$;
import coursierapi.shaded.coursier.jvm.JvmIndex;
import coursierapi.shaded.coursier.jvm.JvmIndex$;
import coursierapi.shaded.coursier.jvm.JvmIndexEntry;
import coursierapi.shaded.coursier.util.Artifact;
import coursierapi.shaded.coursier.util.Artifact$;
import coursierapi.shaded.coursier.util.Task;
import coursierapi.shaded.coursier.util.Task$;
import coursierapi.shaded.scala.Function0;
import coursierapi.shaded.scala.Function1;
import coursierapi.shaded.scala.Function2;
import coursierapi.shaded.scala.MatchError;
import coursierapi.shaded.scala.None$;
import coursierapi.shaded.scala.Option;
import coursierapi.shaded.scala.Option$;
import coursierapi.shaded.scala.Product;
import coursierapi.shaded.scala.Some;
import coursierapi.shaded.scala.Tuple2;
import coursierapi.shaded.scala.collection.IterableOnceOps;
import coursierapi.shaded.scala.collection.IterableOps;
import coursierapi.shaded.scala.collection.Iterator;
import coursierapi.shaded.scala.collection.immutable.Seq;
import coursierapi.shaded.scala.concurrent.ExecutionContext;
import coursierapi.shaded.scala.concurrent.Future;
import coursierapi.shaded.scala.runtime.BoxesRunTime;
import coursierapi.shaded.scala.runtime.Statics;
import coursierapi.shaded.scala.util.Either;
import coursierapi.shaded.scala.util.Left;
import coursierapi.shaded.scala.util.Right;
import java.io.File;
import java.io.Serializable;

public final class JvmCache
implements Serializable,
Product {
    private final String os;
    private final String architecture;
    private final Option<String> defaultJdkNameOpt;
    private final Option<String> defaultVersionOpt;
    private final Option<Task<JvmIndex>> index;
    private final boolean handleLoggerLifecycle;
    private final ArchiveCache<Task> archiveCache;

    @Override
    public Iterator<Object> productIterator() {
        return Product.productIterator$(this);
    }

    public String os() {
        return this.os;
    }

    public String architecture() {
        return this.architecture;
    }

    public Option<String> defaultJdkNameOpt() {
        return this.defaultJdkNameOpt;
    }

    public Option<String> defaultVersionOpt() {
        return this.defaultVersionOpt;
    }

    public Option<Task<JvmIndex>> index() {
        return this.index;
    }

    public boolean handleLoggerLifecycle() {
        return this.handleLoggerLifecycle;
    }

    public ArchiveCache<Task> archiveCache() {
        return this.archiveCache;
    }

    public Function1<ExecutionContext, Future<Option<File>>> getIfInstalled(String id) {
        if (id.contains("://")) {
            return this.getIfInstalled(Artifact$.MODULE$.fromUrl(id));
        }
        return Task$.MODULE$.flatMap$extension(this.entries(id), (Function1<Either, Object> & Serializable)x0$1 -> new Task(JvmCache.$anonfun$getIfInstalled$1(this, id, x0$1)));
    }

    public Function1<ExecutionContext, Future<Option<File>>> getIfInstalled(JvmIndexEntry entry) {
        Artifact artifact = Artifact$.MODULE$.apply(entry.url()).withChanging(entry.version().endsWith("SNAPSHOT"));
        return this.getIfInstalled(artifact);
    }

    public Function1<ExecutionContext, Future<Option<File>>> getIfInstalled(Artifact artifact) {
        return Task$.MODULE$.flatMap$extension(this.archiveCache().getIfExists(artifact).value(), (Function1<Either, Object> & Serializable)x0$1 -> new Task(JvmCache.$anonfun$getIfInstalled$5(this, artifact, x0$1)));
    }

    public Function1<ExecutionContext, Future<File>> get(JvmIndexEntry entry, Option<Object> logger) {
        Artifact artifact = Artifact$.MODULE$.apply(entry.url()).withChanging(entry.version().endsWith("SNAPSHOT"));
        return this.get(artifact, logger);
    }

    public Function1<ExecutionContext, Future<File>> get(Artifact artifact, Option<Object> logger) {
        Function1 task = Task$.MODULE$.flatMap$extension(this.archiveCache().get(artifact).value(), (Function1<Either, Object> & Serializable)x0$1 -> new Task(JvmCache.$anonfun$get$1(x0$1)));
        return Task$.MODULE$.flatMap$extension(task, (Function1<File, Object> & Serializable)x$3 -> new Task(JvmCache$.MODULE$.coursier$jvm$JvmCache$$finalDirectory(artifact.url(), x$3, this.os())));
    }

    public Function1<ExecutionContext, Future<Either<String, Seq<JvmIndexEntry>>>> entries(String id) {
        Some some;
        Tuple2 tuple2;
        Option<Tuple2<String, String>> option = JvmCache$.MODULE$.idToNameVersion(id, this.defaultJdkNameOpt(), this.defaultVersionOpt());
        if (None$.MODULE$.equals(option)) {
            return Task$.MODULE$.fail(new MalformedJvmId(id));
        }
        if (option instanceof Some && (tuple2 = (Tuple2)(some = (Some)option).value()) != null) {
            String name = (String)tuple2._1();
            String ver = (String)tuple2._2();
            Option<Task<JvmIndex>> option2 = this.index();
            if (None$.MODULE$.equals(option2)) {
                return Task$.MODULE$.fail(new NoIndexSpecified());
            }
            if (option2 instanceof Some) {
                Some some2 = (Some)option2;
                Function1 indexTask = ((Task)some2.value()).value();
                return Task$.MODULE$.map$extension(indexTask, (Function1<JvmIndex, Either> & Serializable)index0 -> index0.lookup(name, ver, new Some<String>(this.os()), new Some<String>(this.architecture())));
            }
            throw new MatchError(option2);
        }
        throw new MatchError(option);
    }

    public Function1<ExecutionContext, Future<File>> get(String id) {
        if (id.contains("://")) {
            return this.get(Artifact$.MODULE$.fromUrl(id), (Option<Object>)None$.MODULE$);
        }
        return Task$.MODULE$.flatMap$extension(this.entries(id), (Function1<Either, Object> & Serializable)x0$1 -> new Task(JvmCache.$anonfun$get$3(this, id, x0$1)));
    }

    public JvmCache withIndex(Function1<ExecutionContext, Future<JvmIndex>> index) {
        return this.withIndex(new Some<Task<JvmIndex>>(new Task(index)));
    }

    public JvmCache withDefaultIndex() {
        Function1<ExecutionContext, Future<JvmIndex>> indexTask = ((CacheLogger)this.archiveCache().cache().loggerOpt().filter((Function1<CacheLogger, Object> & Serializable)x$6 -> BoxesRunTime.boxToBoolean(this.handleLoggerLifecycle())).getOrElse((Function0<CacheLogger> & Serializable)() -> CacheLogger$.MODULE$.nop())).using().apply(new Task(JvmIndex$.MODULE$.load(this.archiveCache().cache())), Task$.MODULE$.sync()).value();
        return this.withIndex(indexTask);
    }

    public JvmCache withIndex(Option<Task<JvmIndex>> index) {
        return new JvmCache(this.os(), this.architecture(), this.defaultJdkNameOpt(), this.defaultVersionOpt(), index, this.handleLoggerLifecycle(), this.archiveCache());
    }

    public JvmCache withArchiveCache(ArchiveCache<Task> archiveCache) {
        return new JvmCache(this.os(), this.architecture(), this.defaultJdkNameOpt(), this.defaultVersionOpt(), this.index(), this.handleLoggerLifecycle(), archiveCache);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("JvmCache(");
        b.append(String.valueOf(this.os()));
        b.append(", ");
        b.append(String.valueOf(this.architecture()));
        b.append(", ");
        b.append(String.valueOf(this.defaultJdkNameOpt()));
        b.append(", ");
        b.append(String.valueOf(this.defaultVersionOpt()));
        b.append(", ");
        b.append(String.valueOf(this.index()));
        b.append(", ");
        b.append(String.valueOf(this.handleLoggerLifecycle()));
        b.append(", ");
        b.append(String.valueOf(this.archiveCache()));
        b.append(")");
        return b.toString();
    }

    public boolean canEqual(Object obj) {
        return obj != null && obj instanceof JvmCache && true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (this == obj) return true;
        if (!this.canEqual(obj)) return false;
        JvmCache other = (JvmCache)obj;
        if (!true) return false;
        String string = this.os();
        String string2 = other.os();
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        String string3 = this.architecture();
        String string4 = other.architecture();
        if (string3 == null) {
            if (string4 != null) {
                return false;
            }
        } else if (!string3.equals(string4)) return false;
        Option<String> option = this.defaultJdkNameOpt();
        Option<String> option2 = other.defaultJdkNameOpt();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        Option<String> option3 = this.defaultVersionOpt();
        Option<String> option4 = other.defaultVersionOpt();
        if (option3 == null) {
            if (option4 != null) {
                return false;
            }
        } else if (!option3.equals(option4)) return false;
        Option<Task<JvmIndex>> option5 = this.index();
        Option<Task<JvmIndex>> option6 = other.index();
        if (option5 == null) {
            if (option6 != null) {
                return false;
            }
        } else if (!option5.equals(option6)) return false;
        if (this.handleLoggerLifecycle() != other.handleLoggerLifecycle()) return false;
        ArchiveCache<Task> archiveCache = this.archiveCache();
        ArchiveCache<Task> archiveCache2 = other.archiveCache();
        if (archiveCache == null) {
            if (archiveCache2 == null) return true;
            return false;
        } else {
            if (!((Object)archiveCache).equals(archiveCache2)) return false;
            return true;
        }
    }

    public int hashCode() {
        int code = 17 + Statics.anyHash("JvmCache");
        code = 37 * code + Statics.anyHash(this.os());
        code = 37 * code + Statics.anyHash(this.architecture());
        code = 37 * code + Statics.anyHash(this.defaultJdkNameOpt());
        code = 37 * code + Statics.anyHash(this.defaultVersionOpt());
        code = 37 * code + Statics.anyHash(this.index());
        code = 37 * code + (this.handleLoggerLifecycle() ? 1231 : 1237);
        code = 37 * code + Statics.anyHash(this.archiveCache());
        return 37 * code;
    }

    @Override
    public String productPrefix() {
        return "JvmCache";
    }

    @Override
    public int productArity() {
        return 7;
    }

    @Override
    public Object productElement(int n) {
        int n2 = n;
        switch (n2) {
            case 0: {
                return this.os();
            }
            case 1: {
                return this.architecture();
            }
            case 2: {
                return this.defaultJdkNameOpt();
            }
            case 3: {
                return this.defaultVersionOpt();
            }
            case 4: {
                return this.index();
            }
            case 5: {
                return BoxesRunTime.boxToBoolean(this.handleLoggerLifecycle());
            }
            case 6: {
                return this.archiveCache();
            }
        }
        throw new IndexOutOfBoundsException(Integer.toString(n2));
    }

    public static final /* synthetic */ Function1 $anonfun$getIfInstalled$4(Function1 task$1, Option x0$2) {
        Option option = x0$2;
        if (None$.MODULE$.equals(option)) {
            return task$1;
        }
        if (option instanceof Some) {
            Some some = (Some)option;
            File f = (File)some.value();
            return Task$.MODULE$.point(new Some<File>(f));
        }
        throw new MatchError(option);
    }

    public static final /* synthetic */ Function1 $anonfun$getIfInstalled$1(JvmCache $this, String id$1, Either x0$1) {
        Either either = x0$1;
        if (either instanceof Left) {
            Left left = (Left)either;
            String err = (String)left.value();
            return Task$.MODULE$.fail(new JvmNotFoundInIndex(id$1, err));
        }
        if (either instanceof Right) {
            Right right = (Right)either;
            Seq entries0 = (Seq)right.value();
            return ((IterableOnceOps)((IterableOps)entries0.reverse()).map((Function1<JvmIndexEntry, Object> & Serializable)x$1 -> new Task($this.getIfInstalled(x$1)))).foldLeft(new Task(Task$.MODULE$.point(Option$.MODULE$.empty())), (Function2<Object, Object, Object> & Serializable)(acc, task) -> new Task(Task$.MODULE$.flatMap$extension(((Task)acc).value(), (Function1<Option, Object> & Serializable)x0$2 -> new Task(JvmCache.$anonfun$getIfInstalled$4(task, x0$2))))).value();
        }
        throw new MatchError(either);
    }

    public static final /* synthetic */ Function1 $anonfun$getIfInstalled$5(JvmCache $this, Artifact artifact$1, Either x0$1) {
        Option option;
        boolean bl = false;
        Right right = null;
        Either either = x0$1;
        if (either instanceof Left) {
            Left left = (Left)either;
            ArtifactError e = (ArtifactError)left.value();
            return Task$.MODULE$.fail(e);
        }
        if (either instanceof Right) {
            bl = true;
            right = (Right)either;
            Option option2 = (Option)right.value();
            if (None$.MODULE$.equals(option2)) {
                return Task$.MODULE$.point(None$.MODULE$);
            }
        }
        if (bl && (option = (Option)right.value()) instanceof Some) {
            Some some = (Some)option;
            File dir = (File)some.value();
            return Task$.MODULE$.map$extension(JvmCache$.MODULE$.coursier$jvm$JvmCache$$finalDirectory(artifact$1.url(), dir, $this.os()), (Function1<File, Some> & Serializable)x$2 -> new Some<File>((File)x$2));
        }
        throw new MatchError(either);
    }

    public static final /* synthetic */ Function1 $anonfun$get$1(Either x0$1) {
        Either either = x0$1;
        if (either instanceof Left) {
            Left left = (Left)either;
            ArtifactError err = (ArtifactError)left.value();
            return Task$.MODULE$.fail(err);
        }
        if (either instanceof Right) {
            Right right = (Right)either;
            File f = (File)right.value();
            return Task$.MODULE$.point(f);
        }
        throw new MatchError(either);
    }

    public static final /* synthetic */ Function1 $anonfun$get$3(JvmCache $this, String id$2, Either x0$1) {
        Either either = x0$1;
        if (either instanceof Left) {
            Left left = (Left)either;
            String err = (String)left.value();
            return Task$.MODULE$.fail(new JvmNotFoundInIndex(id$2, err));
        }
        if (either instanceof Right) {
            Right right = (Right)either;
            Seq entries0 = (Seq)right.value();
            return $this.get((JvmIndexEntry)entries0.last(), (Option<Object>)None$.MODULE$);
        }
        throw new MatchError(either);
    }

    public JvmCache(String os, String architecture, Option<String> defaultJdkNameOpt, Option<String> defaultVersionOpt, Option<Task<JvmIndex>> index, boolean handleLoggerLifecycle, ArchiveCache<Task> archiveCache) {
        this.os = os;
        this.architecture = architecture;
        this.defaultJdkNameOpt = defaultJdkNameOpt;
        this.defaultVersionOpt = defaultVersionOpt;
        this.index = index;
        this.handleLoggerLifecycle = handleLoggerLifecycle;
        this.archiveCache = archiveCache;
        Product.$init$(this);
    }

    public JvmCache() {
        this(JvmIndex$.MODULE$.defaultOs(), JvmIndex$.MODULE$.defaultArchitecture(), new Some<String>(JvmCache$.MODULE$.defaultJdkName()), new Some<String>(JvmCache$.MODULE$.defaultVersion()), None$.MODULE$, true, ArchiveCache$.MODULE$.apply(Task$.MODULE$.sync()));
    }

    public static final class EmptyArchive
    extends JvmCacheException {
        private final File archive;
        private final String archiveUrl;

        public EmptyArchive(File archive, String archiveUrl) {
            this.archive = archive;
            this.archiveUrl = archiveUrl;
            super(new StringBuilder(17).append(archive).append(" is empty (from ").append(archiveUrl).append(")").toString(), JvmCache$JvmCacheException$.MODULE$.$lessinit$greater$default$2());
        }
    }

    public static abstract class JvmCacheException
    extends Exception {
        public JvmCacheException(String message, Throwable parent) {
            super(message, parent);
        }
    }

    public static final class JvmNotFoundInIndex
    extends JvmCacheException {
        private final String id;
        private final String reason;

        public JvmNotFoundInIndex(String id, String reason) {
            this.id = id;
            this.reason = reason;
            super(new StringBuilder(25).append("JVM ").append(id).append(" not found in index: ").append(reason).toString(), JvmCache$JvmCacheException$.MODULE$.$lessinit$greater$default$2());
        }
    }

    public static final class MalformedJvmId
    extends JvmCacheException {
        private final String id;

        public MalformedJvmId(String id) {
            this.id = id;
            super(new StringBuilder(19).append("Malformed JVM id '").append(id).append("'").toString(), JvmCache$JvmCacheException$.MODULE$.$lessinit$greater$default$2());
        }
    }

    public static final class NoDirectoryFoundInArchive
    extends JvmCacheException {
        private final File archive;
        private final String archiveUrl;

        public NoDirectoryFoundInArchive(File archive, String archiveUrl) {
            this.archive = archive;
            this.archiveUrl = archiveUrl;
            super(new StringBuilder(37).append(archive).append(" does not contain a directory (from ").append(archiveUrl).append(")").toString(), JvmCache$JvmCacheException$.MODULE$.$lessinit$greater$default$2());
        }
    }

    public static final class NoIndexSpecified
    extends JvmCacheException {
        public NoIndexSpecified() {
            super("No index specified", JvmCache$JvmCacheException$.MODULE$.$lessinit$greater$default$2());
        }
    }

    public static final class UnexpectedContentInArchive
    extends JvmCacheException {
        private final File archive;
        private final String archiveUrl;
        private final Seq<String> rootFileNames;

        public UnexpectedContentInArchive(File archive, String archiveUrl, Seq<String> rootFileNames) {
            this.archive = archive;
            this.archiveUrl = archiveUrl;
            this.rootFileNames = rootFileNames;
            super(new StringBuilder(44).append("Unexpected content at the root of ").append(archive).append(" (from ").append(archiveUrl).append("): ").append(rootFileNames.mkString(", ")).toString(), JvmCache$JvmCacheException$.MODULE$.$lessinit$greater$default$2());
        }
    }
}

