/*
 * Decompiled with CFR 0.152.
 */
package coursierapi.shaded.scala.math;

import coursierapi.shaded.scala.Function1;
import coursierapi.shaded.scala.Option;
import coursierapi.shaded.scala.Tuple2;
import coursierapi.shaded.scala.Tuple3;
import coursierapi.shaded.scala.Tuple6;
import coursierapi.shaded.scala.math.PartialOrdering;
import coursierapi.shaded.scala.util.hashing.MurmurHash3$;
import java.util.Comparator;

public interface Ordering<T>
extends Comparator<T>,
PartialOrdering<T> {
    @Override
    public int compare(T var1, T var2);

    default public boolean lteq(T x, T y) {
        return this.compare(x, y) <= 0;
    }

    default public boolean gteq(T x, T y) {
        return this.compare(x, y) >= 0;
    }

    default public boolean lt(T x, T y) {
        return this.compare(x, y) < 0;
    }

    default public boolean gt(T x, T y) {
        return this.compare(x, y) > 0;
    }

    default public boolean equiv(T x, T y) {
        return this.compare(x, y) == 0;
    }

    default public <U extends T> U max(U x, U y) {
        if (this.gteq(x, y)) {
            return x;
        }
        return y;
    }

    default public <U extends T> U min(U x, U y) {
        if (this.lteq(x, y)) {
            return x;
        }
        return y;
    }

    default public Ordering<T> reverse() {
        return new Reverse(this);
    }

    default public boolean isReverseOf(Ordering<?> other) {
        boolean bl;
        if (other instanceof Reverse) {
            Ordering ordering = ((Reverse)other).outer();
            bl = ordering != null && ordering.equals(this);
        } else {
            bl = false;
        }
        return bl;
    }

    default public <U> Ordering<U> on(Function1<U, T> f) {
        return new Ordering<U>(this, f){
            private final /* synthetic */ Ordering $outer;
            private final Function1 f$1;

            public boolean lteq(U x, U y) {
                return Ordering.lteq$(this, x, y);
            }

            public boolean gteq(U x, U y) {
                return Ordering.gteq$(this, x, y);
            }

            public boolean lt(U x, U y) {
                return Ordering.lt$(this, x, y);
            }

            public boolean gt(U x, U y) {
                return Ordering.gt$(this, x, y);
            }

            public boolean equiv(U x, U y) {
                return Ordering.equiv$(this, x, y);
            }

            public <U extends U> U max(U x, U y) {
                return (U)Ordering.max$(this, x, y);
            }

            public <U extends U> U min(U x, U y) {
                return (U)Ordering.min$(this, x, y);
            }

            public Ordering<U> reverse() {
                return Ordering.reverse$(this);
            }

            public boolean isReverseOf(Ordering<?> other) {
                return Ordering.isReverseOf$(this, other);
            }

            public <U> Ordering<U> on(Function1<U, U> f) {
                return Ordering.on$(this, f);
            }

            public int compare(U x, U y) {
                return this.$outer.compare(this.f$1.apply(x), this.f$1.apply(y));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.f$1 = f$1;
            }
        };
    }

    public static interface BooleanOrdering
    extends Ordering<Object> {
        public static /* synthetic */ int compare$(BooleanOrdering $this, boolean x, boolean y) {
            return $this.compare(x, y);
        }

        @Override
        default public int compare(boolean x, boolean y) {
            return Boolean.compare(x, y);
        }
    }

    public static interface ByteOrdering
    extends Ordering<Object> {
        public static /* synthetic */ int compare$(ByteOrdering $this, byte x, byte y) {
            return $this.compare(x, y);
        }

        @Override
        default public int compare(byte x, byte y) {
            return Byte.compare(x, y);
        }
    }

    public static interface CachedReverse<T>
    extends Ordering<T> {
        public void scala$math$Ordering$CachedReverse$_setter_$scala$math$Ordering$CachedReverse$$_reverse_$eq(Ordering<T> var1);

        public /* synthetic */ Ordering scala$math$Ordering$CachedReverse$$super$reverse();

        public Ordering<T> scala$math$Ordering$CachedReverse$$_reverse();

        public static /* synthetic */ Ordering reverse$(CachedReverse $this) {
            return $this.reverse();
        }

        @Override
        default public Ordering<T> reverse() {
            return this.scala$math$Ordering$CachedReverse$$_reverse();
        }

        public static /* synthetic */ boolean isReverseOf$(CachedReverse $this, Ordering other) {
            return $this.isReverseOf(other);
        }

        @Override
        default public boolean isReverseOf(Ordering<?> other) {
            return other == this.scala$math$Ordering$CachedReverse$$_reverse();
        }

        public static void $init$(CachedReverse $this) {
            $this.scala$math$Ordering$CachedReverse$_setter_$scala$math$Ordering$CachedReverse$$_reverse_$eq($this.scala$math$Ordering$CachedReverse$$super$reverse());
        }
    }

    public static interface CharOrdering
    extends Ordering<Object> {
        public static /* synthetic */ int compare$(CharOrdering $this, char x, char y) {
            return $this.compare(x, y);
        }

        @Override
        default public int compare(char x, char y) {
            return Character.compare(x, y);
        }
    }

    public static interface ExtraImplicits {
        public static /* synthetic */ OrderingOps infixOrderingOps$(ExtraImplicits $this, Object x, Ordering ord) {
            return $this.infixOrderingOps(x, ord);
        }

        default public <T> OrderingOps infixOrderingOps(T x, Ordering<T> ord) {
            return new OrderingOps(ord, x);
        }
    }

    public static interface IntOrdering
    extends Ordering<Object> {
        public static /* synthetic */ int compare$(IntOrdering $this, int x, int y) {
            return $this.compare(x, y);
        }

        @Override
        default public int compare(int x, int y) {
            return Integer.compare(x, y);
        }
    }

    public static interface LongOrdering
    extends Ordering<Object> {
        public static /* synthetic */ int compare$(LongOrdering $this, long x, long y) {
            return $this.compare(x, y);
        }

        @Override
        default public int compare(long x, long y) {
            return Long.compare(x, y);
        }
    }

    public static interface OptionOrdering<T>
    extends Ordering<Option<T>> {
        public Ordering<T> optionOrdering();

        @Override
        default public boolean equals(Object obj) {
            boolean bl;
            if (obj instanceof Object && this == obj) {
                bl = true;
            } else if (obj instanceof OptionOrdering) {
                OptionOrdering optionOrdering = (OptionOrdering)obj;
                Ordering<T> ordering = this.optionOrdering();
                Ordering<T> ordering2 = optionOrdering.optionOrdering();
                bl = !(ordering != null ? !ordering.equals(ordering2) : ordering2 != null);
            } else {
                bl = false;
            }
            return bl;
        }

        default public int hashCode() {
            return this.optionOrdering().hashCode() * 43;
        }
    }

    public class OrderingOps {
        private final T lhs;
        public final /* synthetic */ Ordering $outer;

        public boolean $less(T rhs) {
            return this.scala$math$Ordering$OrderingOps$$$outer().lt(this.lhs, rhs);
        }

        public /* synthetic */ Ordering scala$math$Ordering$OrderingOps$$$outer() {
            return this.$outer;
        }

        public OrderingOps(Ordering $outer, T lhs) {
            this.lhs = lhs;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
        }
    }

    public static final class Reverse<T>
    implements Ordering<T> {
        private final Ordering<T> outer;

        @Override
        public <U> Ordering<U> on(Function1<U, T> f) {
            return ((Ordering)this).on(f);
        }

        public Ordering<T> outer() {
            return this.outer;
        }

        @Override
        public Ordering<T> reverse() {
            return this.outer();
        }

        @Override
        public boolean isReverseOf(Ordering<?> other) {
            Ordering<?> ordering = other;
            Ordering<T> ordering2 = this.outer();
            return !(ordering != null ? !ordering.equals(ordering2) : ordering2 != null);
        }

        @Override
        public int compare(T x, T y) {
            return this.outer().compare(y, x);
        }

        @Override
        public boolean lteq(T x, T y) {
            return this.outer().lteq(y, x);
        }

        @Override
        public boolean gteq(T x, T y) {
            return this.outer().gteq(y, x);
        }

        @Override
        public boolean lt(T x, T y) {
            return this.outer().lt(y, x);
        }

        @Override
        public boolean gt(T x, T y) {
            return this.outer().gt(y, x);
        }

        @Override
        public boolean equiv(T x, T y) {
            return this.outer().equiv(y, x);
        }

        @Override
        public <U extends T> U max(U x, U y) {
            return this.outer().min(x, y);
        }

        @Override
        public <U extends T> U min(U x, U y) {
            return this.outer().max(x, y);
        }

        @Override
        public boolean equals(Object obj) {
            boolean bl;
            if (obj instanceof Object && this == obj) {
                bl = true;
            } else if (obj instanceof Reverse) {
                Reverse reverse = (Reverse)obj;
                Ordering<T> ordering = this.outer();
                Ordering<T> ordering2 = reverse.outer();
                bl = !(ordering != null ? !ordering.equals(ordering2) : ordering2 != null);
            } else {
                bl = false;
            }
            return bl;
        }

        public int hashCode() {
            return this.outer().hashCode() * 41;
        }

        public Reverse(Ordering<T> outer) {
            this.outer = outer;
        }
    }

    public static interface ShortOrdering
    extends Ordering<Object> {
        public static /* synthetic */ int compare$(ShortOrdering $this, short x, short y) {
            return $this.compare(x, y);
        }

        @Override
        default public int compare(short x, short y) {
            return Short.compare(x, y);
        }
    }

    public static interface StringOrdering
    extends Ordering<String> {
        public static /* synthetic */ int compare$(StringOrdering $this, String x, String y) {
            return $this.compare(x, y);
        }

        @Override
        default public int compare(String x, String y) {
            return x.compareTo(y);
        }
    }

    public static final class Tuple2Ordering<T1, T2>
    implements Ordering<Tuple2<T1, T2>> {
        private final Ordering<T1> ord1;
        private final Ordering<T2> ord2;

        @Override
        public boolean lteq(Object x, Object y) {
            return ((Ordering)this).lteq(x, y);
        }

        @Override
        public boolean gteq(Object x, Object y) {
            return ((Ordering)this).gteq(x, y);
        }

        @Override
        public boolean lt(Object x, Object y) {
            return ((Ordering)this).lt(x, y);
        }

        @Override
        public boolean gt(Object x, Object y) {
            return ((Ordering)this).gt(x, y);
        }

        @Override
        public boolean equiv(Object x, Object y) {
            return ((Ordering)this).equiv(x, y);
        }

        @Override
        public Object max(Object x, Object y) {
            return ((Ordering)this).max(x, y);
        }

        @Override
        public Object min(Object x, Object y) {
            return ((Ordering)this).min(x, y);
        }

        @Override
        public Ordering<Tuple2<T1, T2>> reverse() {
            return ((Ordering)this).reverse();
        }

        @Override
        public boolean isReverseOf(Ordering<?> other) {
            return ((Ordering)this).isReverseOf((Ordering)other);
        }

        @Override
        public <U> Ordering<U> on(Function1<U, Tuple2<T1, T2>> f) {
            return ((Ordering)this).on(f);
        }

        private Ordering<T1> ord1() {
            return this.ord1;
        }

        private Ordering<T2> ord2() {
            return this.ord2;
        }

        @Override
        public int compare(Tuple2<T1, T2> x, Tuple2<T1, T2> y) {
            int compare1 = this.ord1().compare(x._1(), y._1());
            if (compare1 != 0) {
                return compare1;
            }
            return this.ord2().compare(x._2(), y._2());
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(Object obj) {
            if (obj instanceof Object && this == obj) {
                return true;
            }
            if (!(obj instanceof Tuple2Ordering)) return false;
            Tuple2Ordering tuple2Ordering = (Tuple2Ordering)obj;
            Ordering<T1> ordering = this.ord1();
            Ordering<T1> ordering2 = tuple2Ordering.ord1();
            if (ordering == null) {
                if (ordering2 != null) {
                    return false;
                }
            } else if (!ordering.equals(ordering2)) return false;
            Ordering<T2> ordering3 = this.ord2();
            Ordering<T2> ordering4 = tuple2Ordering.ord2();
            if (ordering3 == null) {
                if (ordering4 == null) return true;
                return false;
            } else {
                if (!ordering3.equals(ordering4)) return false;
                return true;
            }
        }

        public int hashCode() {
            return new Tuple2<Ordering<T1>, Ordering<T2>>(this.ord1(), this.ord2()).hashCode();
        }

        public Tuple2Ordering(Ordering<T1> ord1, Ordering<T2> ord2) {
            this.ord1 = ord1;
            this.ord2 = ord2;
        }
    }

    public static final class Tuple3Ordering<T1, T2, T3>
    implements Ordering<Tuple3<T1, T2, T3>> {
        private final Ordering<T1> ord1;
        private final Ordering<T2> ord2;
        private final Ordering<T3> ord3;

        @Override
        public boolean lteq(Object x, Object y) {
            return ((Ordering)this).lteq(x, y);
        }

        @Override
        public boolean gteq(Object x, Object y) {
            return ((Ordering)this).gteq(x, y);
        }

        @Override
        public boolean lt(Object x, Object y) {
            return ((Ordering)this).lt(x, y);
        }

        @Override
        public boolean gt(Object x, Object y) {
            return ((Ordering)this).gt(x, y);
        }

        @Override
        public boolean equiv(Object x, Object y) {
            return ((Ordering)this).equiv(x, y);
        }

        @Override
        public Object max(Object x, Object y) {
            return ((Ordering)this).max(x, y);
        }

        @Override
        public Object min(Object x, Object y) {
            return ((Ordering)this).min(x, y);
        }

        @Override
        public Ordering<Tuple3<T1, T2, T3>> reverse() {
            return ((Ordering)this).reverse();
        }

        @Override
        public boolean isReverseOf(Ordering<?> other) {
            return ((Ordering)this).isReverseOf((Ordering)other);
        }

        @Override
        public <U> Ordering<U> on(Function1<U, Tuple3<T1, T2, T3>> f) {
            return ((Ordering)this).on(f);
        }

        private Ordering<T1> ord1() {
            return this.ord1;
        }

        private Ordering<T2> ord2() {
            return this.ord2;
        }

        private Ordering<T3> ord3() {
            return this.ord3;
        }

        @Override
        public int compare(Tuple3<T1, T2, T3> x, Tuple3<T1, T2, T3> y) {
            int compare1 = this.ord1().compare(x._1(), y._1());
            if (compare1 != 0) {
                return compare1;
            }
            int compare2 = this.ord2().compare(x._2(), y._2());
            if (compare2 != 0) {
                return compare2;
            }
            return this.ord3().compare(x._3(), y._3());
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(Object obj) {
            if (obj instanceof Object && this == obj) {
                return true;
            }
            if (!(obj instanceof Tuple3Ordering)) return false;
            Tuple3Ordering tuple3Ordering = (Tuple3Ordering)obj;
            Ordering<T1> ordering = this.ord1();
            Ordering<T1> ordering2 = tuple3Ordering.ord1();
            if (ordering == null) {
                if (ordering2 != null) {
                    return false;
                }
            } else if (!ordering.equals(ordering2)) return false;
            Ordering<T2> ordering3 = this.ord2();
            Ordering<T2> ordering4 = tuple3Ordering.ord2();
            if (ordering3 == null) {
                if (ordering4 != null) {
                    return false;
                }
            } else if (!ordering3.equals(ordering4)) return false;
            Ordering<T3> ordering5 = this.ord3();
            Ordering<T3> ordering6 = tuple3Ordering.ord3();
            if (ordering5 == null) {
                if (ordering6 == null) return true;
                return false;
            } else {
                if (!ordering5.equals(ordering6)) return false;
                return true;
            }
        }

        public int hashCode() {
            Tuple3<Ordering<T1>, Ordering<T2>, Ordering<T3>> hashCode_this = new Tuple3<Ordering<T1>, Ordering<T2>, Ordering<T3>>(this.ord1(), this.ord2(), this.ord3());
            return MurmurHash3$.MODULE$.productHash(hashCode_this);
        }

        public Tuple3Ordering(Ordering<T1> ord1, Ordering<T2> ord2, Ordering<T3> ord3) {
            this.ord1 = ord1;
            this.ord2 = ord2;
            this.ord3 = ord3;
        }
    }

    public static final class Tuple6Ordering<T1, T2, T3, T4, T5, T6>
    implements Ordering<Tuple6<T1, T2, T3, T4, T5, T6>> {
        private final Ordering<T1> ord1;
        private final Ordering<T2> ord2;
        private final Ordering<T3> ord3;
        private final Ordering<T4> ord4;
        private final Ordering<T5> ord5;
        private final Ordering<T6> ord6;

        @Override
        public boolean lteq(Object x, Object y) {
            return ((Ordering)this).lteq(x, y);
        }

        @Override
        public boolean gteq(Object x, Object y) {
            return ((Ordering)this).gteq(x, y);
        }

        @Override
        public boolean lt(Object x, Object y) {
            return ((Ordering)this).lt(x, y);
        }

        @Override
        public boolean gt(Object x, Object y) {
            return ((Ordering)this).gt(x, y);
        }

        @Override
        public boolean equiv(Object x, Object y) {
            return ((Ordering)this).equiv(x, y);
        }

        @Override
        public Object max(Object x, Object y) {
            return ((Ordering)this).max(x, y);
        }

        @Override
        public Object min(Object x, Object y) {
            return ((Ordering)this).min(x, y);
        }

        @Override
        public Ordering<Tuple6<T1, T2, T3, T4, T5, T6>> reverse() {
            return ((Ordering)this).reverse();
        }

        @Override
        public boolean isReverseOf(Ordering<?> other) {
            return ((Ordering)this).isReverseOf((Ordering)other);
        }

        @Override
        public <U> Ordering<U> on(Function1<U, Tuple6<T1, T2, T3, T4, T5, T6>> f) {
            return ((Ordering)this).on(f);
        }

        private Ordering<T1> ord1() {
            return this.ord1;
        }

        private Ordering<T2> ord2() {
            return this.ord2;
        }

        private Ordering<T3> ord3() {
            return this.ord3;
        }

        private Ordering<T4> ord4() {
            return this.ord4;
        }

        private Ordering<T5> ord5() {
            return this.ord5;
        }

        private Ordering<T6> ord6() {
            return this.ord6;
        }

        @Override
        public int compare(Tuple6<T1, T2, T3, T4, T5, T6> x, Tuple6<T1, T2, T3, T4, T5, T6> y) {
            int compare1 = this.ord1().compare(x._1(), y._1());
            if (compare1 != 0) {
                return compare1;
            }
            int compare2 = this.ord2().compare(x._2(), y._2());
            if (compare2 != 0) {
                return compare2;
            }
            int compare3 = this.ord3().compare(x._3(), y._3());
            if (compare3 != 0) {
                return compare3;
            }
            int compare4 = this.ord4().compare(x._4(), y._4());
            if (compare4 != 0) {
                return compare4;
            }
            int compare5 = this.ord5().compare(x._5(), y._5());
            if (compare5 != 0) {
                return compare5;
            }
            return this.ord6().compare(x._6(), y._6());
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(Object obj) {
            if (obj instanceof Object && this == obj) {
                return true;
            }
            if (!(obj instanceof Tuple6Ordering)) return false;
            Tuple6Ordering tuple6Ordering = (Tuple6Ordering)obj;
            Ordering<T1> ordering = this.ord1();
            Ordering<T1> ordering2 = tuple6Ordering.ord1();
            if (ordering == null) {
                if (ordering2 != null) {
                    return false;
                }
            } else if (!ordering.equals(ordering2)) return false;
            Ordering<T2> ordering3 = this.ord2();
            Ordering<T2> ordering4 = tuple6Ordering.ord2();
            if (ordering3 == null) {
                if (ordering4 != null) {
                    return false;
                }
            } else if (!ordering3.equals(ordering4)) return false;
            Ordering<T3> ordering5 = this.ord3();
            Ordering<T3> ordering6 = tuple6Ordering.ord3();
            if (ordering5 == null) {
                if (ordering6 != null) {
                    return false;
                }
            } else if (!ordering5.equals(ordering6)) return false;
            Ordering<T4> ordering7 = this.ord4();
            Ordering<T4> ordering8 = tuple6Ordering.ord4();
            if (ordering7 == null) {
                if (ordering8 != null) {
                    return false;
                }
            } else if (!ordering7.equals(ordering8)) return false;
            Ordering<T5> ordering9 = this.ord5();
            Ordering<T5> ordering10 = tuple6Ordering.ord5();
            if (ordering9 == null) {
                if (ordering10 != null) {
                    return false;
                }
            } else if (!ordering9.equals(ordering10)) return false;
            Ordering<T6> ordering11 = this.ord6();
            Ordering<T6> ordering12 = tuple6Ordering.ord6();
            if (ordering11 == null) {
                if (ordering12 == null) return true;
                return false;
            } else {
                if (!ordering11.equals(ordering12)) return false;
                return true;
            }
        }

        public int hashCode() {
            Tuple6<Ordering<T1>, Ordering<T2>, Ordering<T3>, Ordering<T4>, Ordering<T5>, Ordering<T6>> hashCode_this = new Tuple6<Ordering<T1>, Ordering<T2>, Ordering<T3>, Ordering<T4>, Ordering<T5>, Ordering<T6>>(this.ord1(), this.ord2(), this.ord3(), this.ord4(), this.ord5(), this.ord6());
            return MurmurHash3$.MODULE$.productHash(hashCode_this);
        }

        public Tuple6Ordering(Ordering<T1> ord1, Ordering<T2> ord2, Ordering<T3> ord3, Ordering<T4> ord4, Ordering<T5> ord5, Ordering<T6> ord6) {
            this.ord1 = ord1;
            this.ord2 = ord2;
            this.ord3 = ord3;
            this.ord4 = ord4;
            this.ord5 = ord5;
            this.ord6 = ord6;
        }
    }
}

