package coursier.jniutils;

import java.util.Objects;

public final class TerminalSize {
    private final int width;
    private final int height;

    TerminalSize(int width, int height) {
        this.width = width;
        this.height = height;
    }

    public static TerminalSize of(int width, int height) {
        return new TerminalSize(width, height);
    }


    // methods below are generated by IntelliJ

    public int getHeight() {
        return height;
    }

    public int getWidth() {
        return width;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        TerminalSize size = (TerminalSize) o;
        return width == size.width &&
                height == size.height;
    }

    @Override
    public int hashCode() {
        return Objects.hash(width, height);
    }

    @Override
    public String toString() {
        return "TerminalSize{" +
                "width=" + width +
                ", height=" + height +
                '}';
    }
}
