/*
 * Decompiled with CFR 0.152.
 */
package lmcoursier.internal.shaded.org.codehaus.plexus.components.io.resources;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import javax.annotation.Nonnull;
import lmcoursier.internal.shaded.org.apache.commons.io.IOUtils;
import lmcoursier.internal.shaded.org.apache.commons.io.output.DeferredFileOutputStream;
import lmcoursier.internal.shaded.org.codehaus.plexus.components.io.attributes.AttributeUtils;
import lmcoursier.internal.shaded.org.codehaus.plexus.components.io.attributes.PlexusIoResourceAttributes;
import lmcoursier.internal.shaded.org.codehaus.plexus.components.io.functions.ContentSupplier;
import lmcoursier.internal.shaded.org.codehaus.plexus.components.io.functions.FileSupplier;
import lmcoursier.internal.shaded.org.codehaus.plexus.components.io.functions.InputStreamTransformer;
import lmcoursier.internal.shaded.org.codehaus.plexus.components.io.functions.ResourceAttributeSupplier;
import lmcoursier.internal.shaded.org.codehaus.plexus.components.io.resources.AbstractPlexusIoResource;
import lmcoursier.internal.shaded.org.codehaus.plexus.components.io.resources.AbstractPlexusIoResourceCollection;
import lmcoursier.internal.shaded.org.codehaus.plexus.components.io.resources.PlexusIoResource;

public class PlexusIoFileResource
extends AbstractPlexusIoResource
implements ResourceAttributeSupplier,
FileSupplier {
    @Nonnull
    private final File file;
    @Nonnull
    private final PlexusIoResourceAttributes attributes;
    private final ContentSupplier contentSupplier;
    private final DeferredFileOutputStream dfos;
    private static final InputStreamTransformer identityTransformer = AbstractPlexusIoResourceCollection.identityTransformer;

    protected PlexusIoFileResource(@Nonnull File file, @Nonnull String name, @Nonnull PlexusIoResourceAttributes attrs) throws IOException {
        this(file, name, attrs, null, null);
    }

    PlexusIoFileResource(@Nonnull File file, @Nonnull String name, @Nonnull PlexusIoResourceAttributes attrs, ContentSupplier contentSupplier, InputStreamTransformer streamTransformer) throws IOException {
        super(name, file.lastModified(), file.length(), file.isFile(), file.isDirectory(), file.exists());
        this.file = file;
        this.contentSupplier = contentSupplier != null ? contentSupplier : PlexusIoFileResource.getRootContentSupplier(file);
        boolean hasTransformer = streamTransformer != null && streamTransformer != identityTransformer;
        InputStreamTransformer transToUse = streamTransformer != null ? streamTransformer : identityTransformer;
        DeferredFileOutputStream deferredFileOutputStream = this.dfos = hasTransformer && file.isFile() ? PlexusIoFileResource.asDeferredStream(this.contentSupplier, transToUse, this) : null;
        if (attrs == null) {
            throw new IllegalArgumentException("attrs is null for file " + file.getName());
        }
        this.attributes = attrs;
    }

    private static DeferredFileOutputStream asDeferredStream(@Nonnull ContentSupplier supplier, @Nonnull InputStreamTransformer transToUse, PlexusIoResource resource) throws IOException {
        DeferredFileOutputStream dfos = new DeferredFileOutputStream(5000000, "p-archiver", null, null);
        InputStream inputStream = supplier.getContents();
        InputStream transformed = transToUse.transform(resource, inputStream);
        IOUtils.copy(transformed, (OutputStream)dfos);
        IOUtils.closeQuietly(inputStream);
        IOUtils.closeQuietly(transformed);
        return dfos;
    }

    private static ContentSupplier getRootContentSupplier(final File file) {
        return new ContentSupplier(){

            @Override
            public InputStream getContents() throws IOException {
                return new FileInputStream(file);
            }
        };
    }

    public static String getName(File file) {
        return file.getPath().replace('\\', '/');
    }

    @Override
    @Nonnull
    public File getFile() {
        return this.file;
    }

    @Override
    @Nonnull
    public InputStream getContents() throws IOException {
        if (this.dfos == null) {
            return this.contentSupplier.getContents();
        }
        if (this.dfos.isInMemory()) {
            return new ByteArrayInputStream(this.dfos.getData());
        }
        return new FileInputStream(this.dfos.getFile()){

            @Override
            public void close() throws IOException {
                super.close();
                PlexusIoFileResource.this.dfos.getFile().delete();
            }
        };
    }

    @Override
    @Nonnull
    public URL getURL() throws IOException {
        return this.getFile().toURI().toURL();
    }

    @Override
    public long getSize() {
        if (this.dfos == null) {
            return this.getFile().length();
        }
        if (this.dfos.isInMemory()) {
            return this.dfos.getByteCount();
        }
        return this.dfos.getFile().length();
    }

    @Override
    public boolean isDirectory() {
        return this.getFile().isDirectory();
    }

    @Override
    public boolean isExisting() {
        return this.getFile().exists();
    }

    @Override
    public boolean isFile() {
        return this.getFile().isFile();
    }

    @Override
    @Nonnull
    public PlexusIoResourceAttributes getAttributes() {
        return this.attributes;
    }

    @Override
    public long getLastModified() {
        return AttributeUtils.getLastModified(this.getFile());
    }

    @Override
    public boolean isSymbolicLink() {
        return this.getAttributes().isSymbolicLink();
    }
}

