/*
 * Decompiled with CFR 0.152.
 */
package lmcoursier.internal.shaded.org.codehaus.plexus.container.initialization;

import lmcoursier.internal.shaded.org.codehaus.plexus.DefaultComponentRegistry;
import lmcoursier.internal.shaded.org.codehaus.plexus.component.composition.CycleDetectedInComponentGraphException;
import lmcoursier.internal.shaded.org.codehaus.plexus.component.manager.PerLookupComponentManagerFactory;
import lmcoursier.internal.shaded.org.codehaus.plexus.component.manager.SingletonComponentManagerFactory;
import lmcoursier.internal.shaded.org.codehaus.plexus.component.repository.ComponentDescriptor;
import lmcoursier.internal.shaded.org.codehaus.plexus.component.repository.ComponentRepository;
import lmcoursier.internal.shaded.org.codehaus.plexus.component.repository.io.PlexusTools;
import lmcoursier.internal.shaded.org.codehaus.plexus.configuration.PlexusConfiguration;
import lmcoursier.internal.shaded.org.codehaus.plexus.configuration.PlexusConfigurationException;
import lmcoursier.internal.shaded.org.codehaus.plexus.container.initialization.ContainerInitializationContext;
import lmcoursier.internal.shaded.org.codehaus.plexus.container.initialization.ContainerInitializationException;
import lmcoursier.internal.shaded.org.codehaus.plexus.container.initialization.ContainerInitializationPhase;
import lmcoursier.internal.shaded.org.codehaus.plexus.lifecycle.LifecycleHandlerManager;

public class InitializeComponentRegistryPhase
implements ContainerInitializationPhase {
    @Override
    public void execute(ContainerInitializationContext context) throws ContainerInitializationException {
        ComponentRepository repository = this.getComponentRepository(context);
        LifecycleHandlerManager lifecycleHandlerManager = this.getLifecycleHandlerManager(context);
        DefaultComponentRegistry componentRegistry = new DefaultComponentRegistry(context.getContainer(), repository, lifecycleHandlerManager);
        componentRegistry.registerComponentManagerFactory(new PerLookupComponentManagerFactory());
        componentRegistry.registerComponentManagerFactory(new SingletonComponentManagerFactory());
        context.getContainer().setComponentRegistry(componentRegistry);
    }

    private ComponentRepository getComponentRepository(ContainerInitializationContext context) throws ContainerInitializationException {
        ComponentRepository repository = context.getContainerConfiguration().getComponentRepository();
        try {
            PlexusConfiguration[] componentConfigurations;
            PlexusConfiguration configuration = context.getContainerXmlConfiguration();
            for (PlexusConfiguration componentConfiguration : componentConfigurations = configuration.getChild("components").getChildren("component")) {
                ComponentDescriptor<?> componentDescriptor = PlexusTools.buildComponentDescriptor(componentConfiguration, context.getContainer().getContainerRealm());
                componentDescriptor.setRealm(context.getContainer().getContainerRealm());
                repository.addComponentDescriptor(componentDescriptor);
            }
        }
        catch (PlexusConfigurationException e) {
            throw new ContainerInitializationException("Error initializing component repository: Cannot unmarshall component descriptor: ", e);
        }
        catch (CycleDetectedInComponentGraphException e) {
            throw new ContainerInitializationException("A cycle has been detected in the components of the system: ", e);
        }
        return repository;
    }

    private LifecycleHandlerManager getLifecycleHandlerManager(ContainerInitializationContext context) {
        LifecycleHandlerManager lifecycleHandlerManager = context.getContainerConfiguration().getLifecycleHandlerManager();
        lifecycleHandlerManager.initialize();
        return lifecycleHandlerManager;
    }
}

