/*
 * Decompiled with CFR 0.152.
 */
package lmcoursier.internal.shaded.org.codehaus.plexus.archiver.tar;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.zip.GZIPOutputStream;
import lmcoursier.internal.shaded.javax.inject.Named;
import lmcoursier.internal.shaded.org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import lmcoursier.internal.shaded.org.apache.commons.compress.archivers.tar.TarArchiveOutputStream;
import lmcoursier.internal.shaded.org.apache.commons.compress.compressors.bzip2.BZip2CompressorOutputStream;
import lmcoursier.internal.shaded.org.apache.commons.compress.compressors.xz.XZCompressorOutputStream;
import lmcoursier.internal.shaded.org.apache.commons.compress.compressors.zstandard.ZstdCompressorOutputStream;
import lmcoursier.internal.shaded.org.codehaus.plexus.archiver.AbstractArchiver;
import lmcoursier.internal.shaded.org.codehaus.plexus.archiver.ArchiveEntry;
import lmcoursier.internal.shaded.org.codehaus.plexus.archiver.ArchiverException;
import lmcoursier.internal.shaded.org.codehaus.plexus.archiver.ResourceIterator;
import lmcoursier.internal.shaded.org.codehaus.plexus.archiver.exceptions.EmptyArchiveException;
import lmcoursier.internal.shaded.org.codehaus.plexus.archiver.tar.TarLongFileMode;
import lmcoursier.internal.shaded.org.codehaus.plexus.archiver.util.ResourceUtils;
import lmcoursier.internal.shaded.org.codehaus.plexus.archiver.util.Streams;
import lmcoursier.internal.shaded.org.codehaus.plexus.components.io.attributes.PlexusIoResourceAttributes;
import lmcoursier.internal.shaded.org.codehaus.plexus.components.io.functions.SymlinkDestinationSupplier;
import lmcoursier.internal.shaded.org.codehaus.plexus.util.IOUtil;
import lmcoursier.internal.shaded.org.codehaus.plexus.util.StringUtils;
import lmcoursier.internal.shaded.org.iq80.snappy.SnappyOutputStream;

@Named(value="tar")
public class TarArchiver
extends AbstractArchiver {
    private boolean longWarningGiven = false;
    private TarLongFileMode longFileMode = TarLongFileMode.warn;
    private TarCompressionMethod compression = TarCompressionMethod.none;
    private final TarOptions options = new TarOptions();
    private TarArchiveOutputStream tOut;

    public void setLongfile(TarLongFileMode mode) {
        this.longFileMode = mode;
    }

    public void setCompression(TarCompressionMethod mode) {
        this.compression = mode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void execute() throws ArchiverException, IOException {
        if (!this.checkForced()) {
            return;
        }
        ResourceIterator iter = this.getResources();
        if (!iter.hasNext()) {
            throw new EmptyArchiveException("archive cannot be empty");
        }
        File tarFile = this.getDestFile();
        if (tarFile == null) {
            throw new ArchiverException("You must set the destination tar file.");
        }
        if (tarFile.exists() && !tarFile.isFile()) {
            throw new ArchiverException(tarFile + " isn't a file.");
        }
        if (tarFile.exists() && !tarFile.canWrite()) {
            throw new ArchiverException(tarFile + " is read-only.");
        }
        this.getLogger().info("Building tar: " + tarFile.getAbsolutePath());
        try {
            this.tOut = new TarArchiveOutputStream(this.compress(this.compression, Files.newOutputStream(tarFile.toPath(), new OpenOption[0])), "UTF8");
            if (this.longFileMode.isTruncateMode()) {
                this.tOut.setLongFileMode(1);
            } else if (this.longFileMode.isPosixMode() || this.longFileMode.isPosixWarnMode()) {
                this.tOut.setLongFileMode(3);
                this.tOut.setBigNumberMode(2);
            } else if (this.longFileMode.isFailMode() || this.longFileMode.isOmitMode()) {
                this.tOut.setLongFileMode(0);
            } else {
                this.tOut.setLongFileMode(2);
            }
            this.longWarningGiven = false;
            while (iter.hasNext()) {
                ArchiveEntry entry = iter.next();
                if (ResourceUtils.isSame(entry.getResource(), tarFile)) {
                    throw new ArchiverException("A tar file cannot include itself.");
                }
                String fileName = entry.getName();
                String name = StringUtils.replace(fileName, File.separatorChar, '/');
                this.tarFile(entry, this.tOut, name);
            }
            this.tOut.close();
        }
        finally {
            IOUtil.close(this.tOut);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void tarFile(ArchiveEntry entry, TarArchiveOutputStream tOut, String vPath) throws ArchiverException, IOException {
        block34: {
            if (vPath.length() <= 0) {
                return;
            }
            if (entry.getResource().isDirectory() && !vPath.endsWith("/")) {
                vPath = vPath + "/";
            }
            if (vPath.startsWith("/") && !this.options.getPreserveLeadingSlashes()) {
                int l = vPath.length();
                if (l <= 1) {
                    return;
                }
                vPath = vPath.substring(1, l);
            }
            int pathLength = vPath.length();
            InputStream fIn = null;
            try {
                block33: {
                    int groupId;
                    int userId;
                    TarArchiveEntry te;
                    if (!this.longFileMode.isGnuMode() && pathLength >= 100) {
                        int maxPosixPathLen = 255;
                        if (!this.longFileMode.isPosixMode()) {
                            if (this.longFileMode.isPosixWarnMode()) {
                                if (pathLength > maxPosixPathLen) {
                                    this.getLogger().warn("Entry: " + vPath + " longer than " + maxPosixPathLen + " characters.");
                                    if (!this.longWarningGiven) {
                                        this.getLogger().warn("Resulting tar file can only be processed successfully by GNU compatible tar commands");
                                        this.longWarningGiven = true;
                                    }
                                }
                            } else {
                                if (this.longFileMode.isOmitMode()) {
                                    this.getLogger().info("Omitting: " + vPath);
                                    return;
                                }
                                if (this.longFileMode.isWarnMode()) {
                                    this.getLogger().warn("Entry: " + vPath + " longer than " + 100 + " characters.");
                                    if (!this.longWarningGiven) {
                                        this.getLogger().warn("Resulting tar file can only be processed successfully by GNU compatible tar commands");
                                        this.longWarningGiven = true;
                                    }
                                } else {
                                    if (this.longFileMode.isFailMode()) {
                                        throw new ArchiverException("Entry: " + vPath + " longer than " + 100 + " characters.");
                                    }
                                    throw new IllegalStateException("Non gnu mode should never get here?");
                                }
                            }
                        }
                    }
                    if (entry.getType() == 3) {
                        SymlinkDestinationSupplier plexusIoSymlinkResource = (SymlinkDestinationSupplier)((Object)entry.getResource());
                        te = new TarArchiveEntry(vPath, 50);
                        te.setLinkName(plexusIoSymlinkResource.getSymlinkDestination());
                    } else {
                        te = new TarArchiveEntry(vPath);
                    }
                    if (this.getLastModifiedTime() == null) {
                        long teLastModified = entry.getResource().getLastModified();
                        te.setModTime(teLastModified == 0L ? System.currentTimeMillis() : teLastModified);
                    } else {
                        te.setModTime(this.getLastModifiedTime().toMillis());
                    }
                    if (entry.getType() == 3) {
                        te.setSize(0L);
                    } else if (!entry.getResource().isDirectory()) {
                        long size = entry.getResource().getSize();
                        te.setSize(size == -1L ? 0L : size);
                    }
                    te.setMode(entry.getMode());
                    PlexusIoResourceAttributes attributes = entry.getResourceAttributes();
                    te.setUserName(attributes != null && attributes.getUserName() != null ? attributes.getUserName() : this.options.getUserName());
                    te.setGroupName(attributes != null && attributes.getGroupName() != null ? attributes.getGroupName() : this.options.getGroup());
                    int n = userId = attributes != null && attributes.getUserId() != null ? attributes.getUserId().intValue() : this.options.getUid();
                    if (userId >= 0) {
                        te.setUserId(userId);
                    }
                    int n2 = groupId = attributes != null && attributes.getGroupId() != null ? attributes.getGroupId().intValue() : this.options.getGid();
                    if (groupId >= 0) {
                        te.setGroupId(groupId);
                    }
                    tOut.putArchiveEntry(te);
                    try {
                        if (!entry.getResource().isFile() || entry.getType() == 3) break block33;
                        fIn = entry.getInputStream();
                        Streams.copyFullyDontCloseOutput(fIn, tOut, "xAR");
                    }
                    catch (Throwable e) {
                        try {
                            this.getLogger().warn("When creating tar entry", e);
                            break block34;
                        }
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                        finally {
                            tOut.closeArchiveEntry();
                        }
                    }
                }
                tOut.closeArchiveEntry();
            }
            finally {
                IOUtil.close(fIn);
            }
        }
    }

    private OutputStream compress(TarCompressionMethod tarCompressionMethod, OutputStream ostream) throws IOException {
        if (TarCompressionMethod.gzip.equals((Object)tarCompressionMethod)) {
            return Streams.bufferedOutputStream(new GZIPOutputStream(ostream));
        }
        if (TarCompressionMethod.bzip2.equals((Object)tarCompressionMethod)) {
            return new BZip2CompressorOutputStream(Streams.bufferedOutputStream(ostream));
        }
        if (TarCompressionMethod.snappy.equals((Object)tarCompressionMethod)) {
            return new SnappyOutputStream(Streams.bufferedOutputStream(ostream));
        }
        if (TarCompressionMethod.xz.equals((Object)tarCompressionMethod)) {
            return new XZCompressorOutputStream(Streams.bufferedOutputStream(ostream));
        }
        if (TarCompressionMethod.zstd.equals((Object)tarCompressionMethod)) {
            return new ZstdCompressorOutputStream(Streams.bufferedOutputStream(ostream));
        }
        return ostream;
    }

    @Override
    public boolean isSupportingForced() {
        return true;
    }

    @Override
    protected void cleanUp() throws IOException {
        super.cleanUp();
        if (this.tOut != null) {
            this.tOut.close();
        }
    }

    @Override
    protected void close() throws IOException {
        if (this.tOut != null) {
            this.tOut.close();
        }
    }

    @Override
    protected String getArchiveType() {
        return "TAR";
    }

    public static enum TarCompressionMethod {
        none,
        gzip,
        bzip2,
        snappy,
        xz,
        zstd;

    }

    public class TarOptions {
        private String userName = "";
        private String groupName = "";
        private int uid;
        private int gid;
        private boolean preserveLeadingSlashes = false;

        public void setUserName(String userName) {
            this.userName = userName;
        }

        public String getUserName() {
            return this.userName;
        }

        public void setUid(int uid) {
            this.uid = uid;
        }

        public int getUid() {
            return this.uid;
        }

        public void setGroup(String groupName) {
            this.groupName = groupName;
        }

        public String getGroup() {
            return this.groupName;
        }

        public void setGid(int gid) {
            this.gid = gid;
        }

        public int getGid() {
            return this.gid;
        }

        public boolean getPreserveLeadingSlashes() {
            return this.preserveLeadingSlashes;
        }

        public void setPreserveLeadingSlashes(boolean preserveLeadingSlashes) {
            this.preserveLeadingSlashes = preserveLeadingSlashes;
        }
    }
}

