/*
 * Decompiled with CFR 0.152.
 */
package lmcoursier.internal.shaded.org.tukaani.xz;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import lmcoursier.internal.shaded.org.tukaani.xz.ArrayCache;
import lmcoursier.internal.shaded.org.tukaani.xz.CorruptedInputException;
import lmcoursier.internal.shaded.org.tukaani.xz.SingleXZInputStream;
import lmcoursier.internal.shaded.org.tukaani.xz.XZFormatException;
import lmcoursier.internal.shaded.org.tukaani.xz.XZIOException;

public class XZInputStream
extends InputStream {
    private final ArrayCache arrayCache;
    private final int memoryLimit;
    private InputStream in;
    private SingleXZInputStream xzIn;
    private final boolean verifyCheck;
    private boolean endReached = false;
    private IOException exception = null;
    private final byte[] tempBuf = new byte[1];

    public XZInputStream(InputStream inputStream) throws IOException {
        this(inputStream, -1);
    }

    public XZInputStream(InputStream inputStream, ArrayCache arrayCache) throws IOException {
        this(inputStream, -1, arrayCache);
    }

    public XZInputStream(InputStream inputStream, int n) throws IOException {
        this(inputStream, n, true);
    }

    public XZInputStream(InputStream inputStream, int n, ArrayCache arrayCache) throws IOException {
        this(inputStream, n, true, arrayCache);
    }

    public XZInputStream(InputStream inputStream, int n, boolean bl) throws IOException {
        this(inputStream, n, bl, ArrayCache.getDefaultCache());
    }

    public XZInputStream(InputStream inputStream, int n, boolean bl, ArrayCache arrayCache) throws IOException {
        this.arrayCache = arrayCache;
        this.in = inputStream;
        this.memoryLimit = n;
        this.verifyCheck = bl;
        this.xzIn = new SingleXZInputStream(inputStream, n, bl, arrayCache);
    }

    @Override
    public int read() throws IOException {
        return this.read(this.tempBuf, 0, 1) == -1 ? -1 : this.tempBuf[0] & 0xFF;
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3;
        block11: {
            if (n < 0 || n2 < 0 || n + n2 < 0 || n + n2 > byArray.length) {
                throw new IndexOutOfBoundsException();
            }
            if (n2 == 0) {
                return 0;
            }
            if (this.in == null) {
                throw new XZIOException("Stream closed");
            }
            if (this.exception != null) {
                throw this.exception;
            }
            if (this.endReached) {
                return -1;
            }
            n3 = 0;
            try {
                while (n2 > 0) {
                    int n4;
                    if (this.xzIn == null) {
                        this.prepareNextStream();
                        if (this.endReached) {
                            return n3 == 0 ? -1 : n3;
                        }
                    }
                    if ((n4 = this.xzIn.read(byArray, n, n2)) > 0) {
                        n3 += n4;
                        n += n4;
                        n2 -= n4;
                        continue;
                    }
                    if (n4 != -1) continue;
                    this.xzIn = null;
                }
            }
            catch (IOException iOException) {
                this.exception = iOException;
                if (n3 != 0) break block11;
                throw iOException;
            }
        }
        return n3;
    }

    private void prepareNextStream() throws IOException {
        DataInputStream dataInputStream = new DataInputStream(this.in);
        byte[] byArray = new byte[12];
        do {
            int n;
            if ((n = dataInputStream.read(byArray, 0, 1)) == -1) {
                this.endReached = true;
                return;
            }
            dataInputStream.readFully(byArray, 1, 3);
        } while (byArray[0] == 0 && byArray[1] == 0 && byArray[2] == 0 && byArray[3] == 0);
        dataInputStream.readFully(byArray, 4, 8);
        try {
            this.xzIn = new SingleXZInputStream(this.in, this.memoryLimit, this.verifyCheck, byArray, this.arrayCache);
        }
        catch (XZFormatException xZFormatException) {
            throw new CorruptedInputException("Garbage after a valid XZ Stream");
        }
    }

    @Override
    public int available() throws IOException {
        if (this.in == null) {
            throw new XZIOException("Stream closed");
        }
        if (this.exception != null) {
            throw this.exception;
        }
        return this.xzIn == null ? 0 : this.xzIn.available();
    }

    @Override
    public void close() throws IOException {
        this.close(true);
    }

    public void close(boolean bl) throws IOException {
        if (this.in != null) {
            if (this.xzIn != null) {
                this.xzIn.close(false);
                this.xzIn = null;
            }
            try {
                if (bl) {
                    this.in.close();
                }
            }
            finally {
                this.in = null;
            }
        }
    }
}

