/*
 * Decompiled with CFR 0.152.
 */
package lmcoursier.internal.shaded.coursier.core.shaded.geny;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import lmcoursier.internal.shaded.coursier.core.shaded.geny.Internal$;
import lmcoursier.internal.shaded.coursier.core.shaded.geny.Readable$;
import lmcoursier.internal.shaded.coursier.core.shaded.geny.Writable;
import scala.Function1;
import scala.Option;
import scala.Some;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005=eaB\u0011#!\u0003\r\t!\n\u0005\u0006a\u0001!\t!\r\u0005\u0006k\u00011\tA\u000e\u0005\u0006!\u0002!\t!U\u0004\u0006/\nB\t\u0001\u0017\u0004\u0006C\tB\t!\u0017\u0005\u00065\u0016!\ta\u0017\u0004\u00059\u0016\tQ\f\u0003\u0005`\u000f\t\u0005\t\u0015!\u0003a\u0011\u0015Qv\u0001\"\u0001l\u0011\u0015)t\u0001\"\u0001p\u0011\u0015)x\u0001\"\u0011w\u0011\u0019yx\u0001\"\u0011\u0002\u0002!I\u00111B\u0003\u0002\u0002\u0013\r\u0011Q\u0002\u0004\u0007\u0003#)\u0011!a\u0005\t\u0015\u0005UaB!A!\u0002\u0013\t9\u0002\u0003\u0004[\u001d\u0011\u0005\u00111\u0005\u0005\u0007k9!\t!!\u000b\t\u000bUtA\u0011\t<\t\r}tA\u0011IA\u0001\u0011%\t)$BA\u0001\n\u0007\t9D\u0002\u0004\u0002<\u0015\t\u0011Q\b\u0005\u000b\u0003\u007f)\"\u0011!Q\u0001\n\u0005\u0005\u0003B\u0002.\u0016\t\u0003\ti\u0005\u0003\u00046+\u0011\u0005\u00111\u000b\u0005\u0006kV!\tE\u001e\u0005\u0007\u007fV!\t%!\u0001\t\u0013\u0005}S!!A\u0005\u0004\u0005\u0005dABA3\u000b\u0005\t9\u0007C\u0005\u0002jq\u0011\t\u0011)A\u0005\u0011\"1!\f\bC\u0001\u0003WBa!\u000e\u000f\u0005\u0002\u0005E\u0004\"CA?\u000b\u0005\u0005I1AA@\u0005!\u0011V-\u00193bE2,'bA\u0012\u0002\u000e\u0006!q-\u001a8z\u0007\u0001\u00192\u0001\u0001\u0014-!\t9#&D\u0001)\u0015\u0005I\u0013!B:dC2\f\u0017BA\u0016)\u0005\u0019\te.\u001f*fMB\u0011QFL\u0007\u0002E%\u0011qF\t\u0002\t/JLG/\u00192mK\u00061A%\u001b8ji\u0012\"\u0012A\r\t\u0003OMJ!\u0001\u000e\u0015\u0003\tUs\u0017\u000e^\u0001\u0011e\u0016\fGMQ=uKN$\u0006N]8vO\",\"a\u000e\u001e\u0015\u0005a\u001a\u0005CA\u001d;\u0019\u0001!Qa\u000f\u0002C\u0002q\u0012\u0011\u0001V\t\u0003{\u0001\u0003\"a\n \n\u0005}B#a\u0002(pi\"Lgn\u001a\t\u0003O\u0005K!A\u0011\u0015\u0003\u0007\u0005s\u0017\u0010C\u0003E\u0005\u0001\u0007Q)A\u0001g!\u00119c\t\u0013\u001d\n\u0005\u001dC#!\u0003$v]\u000e$\u0018n\u001c82!\tIe*D\u0001K\u0015\tYE*\u0001\u0002j_*\tQ*\u0001\u0003kCZ\f\u0017BA(K\u0005-Ie\u000e];u'R\u0014X-Y7\u0002\u0019]\u0014\u0018\u000e^3CsR,7\u000fV8\u0015\u0005I\u0012\u0006\"B*\u0004\u0001\u0004!\u0016aA8viB\u0011\u0011*V\u0005\u0003-*\u0013AbT;uaV$8\u000b\u001e:fC6\f\u0001BU3bI\u0006\u0014G.\u001a\t\u0003[\u0015\u0019\"!\u0002\u0014\u0002\rqJg.\u001b;?)\u0005A&AD*ue&twMU3bI\u0006\u0014G.Z\n\u0004\u000f\u0019r\u0006CA\u0017\u0001\u0003\u0005\u0019\bCA1i\u001d\t\u0011g\r\u0005\u0002dQ5\tAM\u0003\u0002fI\u00051AH]8pizJ!a\u001a\u0015\u0002\rA\u0013X\rZ3g\u0013\tI'N\u0001\u0004TiJLgn\u001a\u0006\u0003O\"\"\"\u0001\u001c8\u0011\u00055<Q\"A\u0003\t\u000b}K\u0001\u0019\u00011\u0016\u0005A\u0014HCA9t!\tI$\u000fB\u0003<\u0015\t\u0007A\bC\u0003E\u0015\u0001\u0007A\u000f\u0005\u0003(\r\"\u000b\u0018a\u00045uiB\u001cuN\u001c;f]R$\u0016\u0010]3\u0016\u0003]\u00042a\n={\u0013\tI\bF\u0001\u0003T_6,\u0007CA>\u007f\u001b\u0005a(BA?M\u0003\u0011a\u0017M\\4\n\u0005%d\u0018!D2p]R,g\u000e\u001e'f]\u001e$\b.\u0006\u0002\u0002\u0004A!q\u0005_A\u0003!\r9\u0013qA\u0005\u0004\u0003\u0013A#\u0001\u0002'p]\u001e\fab\u0015;sS:<'+Z1eC\ndW\rF\u0002m\u0003\u001fAQaX\u0007A\u0002\u0001\u0014\u0011CQ=uK\u0006\u0013(/Y=SK\u0006$\u0017M\u00197f'\rqaEX\u0001\u0002CB)q%!\u0007\u0002\u001e%\u0019\u00111\u0004\u0015\u0003\u000b\u0005\u0013(/Y=\u0011\u0007\u001d\ny\"C\u0002\u0002\"!\u0012AAQ=uKR!\u0011QEA\u0014!\tig\u0002C\u0004\u0002\u0016A\u0001\r!a\u0006\u0016\t\u0005-\u0012q\u0006\u000b\u0005\u0003[\t\t\u0004E\u0002:\u0003_!QaO\tC\u0002qBa\u0001R\tA\u0002\u0005M\u0002#B\u0014G\u0011\u00065\u0012!\u0005\"zi\u0016\f%O]1z%\u0016\fG-\u00192mKR!\u0011QEA\u001d\u0011\u001d\t)\u0002\u0006a\u0001\u0003/\u0011!CQ=uK\n+hMZ3s%\u0016\fG-\u00192mKN\u0019QC\n0\u0002\r\t,hMZ3s!\u0011\t\u0019%!\u0013\u000e\u0005\u0005\u0015#bAA$\u0019\u0006\u0019a.[8\n\t\u0005-\u0013Q\t\u0002\u000b\u0005f$XMQ;gM\u0016\u0014H\u0003BA(\u0003#\u0002\"!\\\u000b\t\u000f\u0005}r\u00031\u0001\u0002BU!\u0011QKA-)\u0011\t9&a\u0017\u0011\u0007e\nI\u0006B\u0003<1\t\u0007A\b\u0003\u0004E1\u0001\u0007\u0011Q\f\t\u0006O\u0019C\u0015qK\u0001\u0013\u0005f$XMQ;gM\u0016\u0014(+Z1eC\ndW\r\u0006\u0003\u0002P\u0005\r\u0004bBA 7\u0001\u0007\u0011\u0011\t\u0002\u0014\u0013:\u0004X\u000f^*ue\u0016\fWNU3bI\u0006\u0014G.Z\n\u00049\u0019r\u0016!A5\u0015\t\u00055\u0014q\u000e\t\u0003[rAa!!\u001b\u001f\u0001\u0004AU\u0003BA:\u0003o\"B!!\u001e\u0002zA\u0019\u0011(a\u001e\u0005\u000bmz\"\u0019\u0001\u001f\t\r\u0011{\u0002\u0019AA>!\u00159c\tSA;\u0003MIe\u000e];u'R\u0014X-Y7SK\u0006$\u0017M\u00197f)\u0011\ti'!!\t\r\u0005%\u0004\u00051\u0001I\u0003!\u0019w.\u001e:tS\u0016\u0014(BAAB\u0003\u0011\u0019wN]3\u000b\t\u0005\u001d\u0015QQ\u0001\u0007g\"\fG-\u001a3\u000b\t\u0005-\u0015\u0011\u0012")
public interface Readable
extends Writable {
    public static InputStreamReadable InputStreamReadable(InputStream inputStream) {
        return Readable$.MODULE$.InputStreamReadable(inputStream);
    }

    public static ByteBufferReadable ByteBufferReadable(ByteBuffer byteBuffer) {
        return Readable$.MODULE$.ByteBufferReadable(byteBuffer);
    }

    public static ByteArrayReadable ByteArrayReadable(byte[] byArray) {
        return Readable$.MODULE$.ByteArrayReadable(byArray);
    }

    public static StringReadable StringReadable(String string) {
        return Readable$.MODULE$.StringReadable(string);
    }

    public <T> T readBytesThrough(Function1<InputStream, T> var1);

    @Override
    default public void writeBytesTo(OutputStream out) {
        this.readBytesThrough((Function1 & Serializable & scala.Serializable)x$1 -> {
            Internal$.MODULE$.transfer(x$1, out, Internal$.MODULE$.transfer$default$3(), Internal$.MODULE$.transfer$default$4(), Internal$.MODULE$.transfer$default$5());
            return BoxedUnit.UNIT;
        });
    }

    public static void $init$(Readable $this) {
    }

    public static class ByteArrayReadable
    implements Readable {
        private final byte[] a;

        @Override
        public void writeBytesTo(OutputStream out) {
            ((Readable)this).writeBytesTo(out);
        }

        @Override
        public <T> T readBytesThrough(Function1<InputStream, T> f) {
            return (T)f.apply((Object)new ByteArrayInputStream(this.a));
        }

        public Some<String> httpContentType() {
            return new Some((Object)"application/octet-stream");
        }

        public Some<Object> contentLength() {
            return new Some((Object)BoxesRunTime.boxToLong((long)this.a.length));
        }

        public ByteArrayReadable(byte[] a) {
            this.a = a;
            Writable.$init$(this);
            Readable.$init$(this);
        }
    }

    public static class ByteBufferReadable
    implements Readable {
        private final ByteBuffer buffer;

        @Override
        public void writeBytesTo(OutputStream out) {
            ((Readable)this).writeBytesTo(out);
        }

        @Override
        public <T> T readBytesThrough(Function1<InputStream, T> f) {
            ByteBuffer bb = this.buffer.duplicate().order(this.buffer.order());
            InputStream is = new InputStream(null, bb){
                private final ByteBuffer bb$1;

                public int read() {
                    return !this.bb$1.hasRemaining() ? -1 : this.bb$1.get() & 0xFF;
                }

                public int read(byte[] bytes, int off, int len) {
                    int n;
                    if (!this.bb$1.hasRemaining()) {
                        n = -1;
                    } else {
                        int l = package$.MODULE$.min(len, this.bb$1.remaining());
                        this.bb$1.get(bytes, off, l);
                        n = l;
                    }
                    return n;
                }
                {
                    this.bb$1 = bb$1;
                }
            };
            return (T)f.apply((Object)is);
        }

        public Some<String> httpContentType() {
            return new Some((Object)"application/octet-stream");
        }

        public Some<Object> contentLength() {
            return new Some((Object)BoxesRunTime.boxToLong((long)this.buffer.remaining()));
        }

        public ByteBufferReadable(ByteBuffer buffer) {
            this.buffer = buffer;
            Writable.$init$(this);
            Readable.$init$(this);
        }
    }

    public static class InputStreamReadable
    implements Readable {
        private final InputStream i;

        @Override
        public void writeBytesTo(OutputStream out) {
            ((Readable)this).writeBytesTo(out);
        }

        @Override
        public Option<String> httpContentType() {
            return Writable.httpContentType$(this);
        }

        @Override
        public Option<Object> contentLength() {
            return Writable.contentLength$(this);
        }

        @Override
        public <T> T readBytesThrough(Function1<InputStream, T> f) {
            return (T)f.apply((Object)this.i);
        }

        public InputStreamReadable(InputStream i) {
            this.i = i;
            Writable.$init$(this);
            Readable.$init$(this);
        }
    }

    public static class StringReadable
    implements Readable {
        private final String s;

        @Override
        public void writeBytesTo(OutputStream out) {
            ((Readable)this).writeBytesTo(out);
        }

        @Override
        public <T> T readBytesThrough(Function1<InputStream, T> f) {
            return (T)f.apply((Object)new ByteArrayInputStream(this.s.getBytes(StandardCharsets.UTF_8)));
        }

        public Some<String> httpContentType() {
            return new Some((Object)"text/plain; charset=utf-8");
        }

        public Some<Object> contentLength() {
            return new Some((Object)BoxesRunTime.boxToLong((long)Internal$.MODULE$.encodedLength(this.s)));
        }

        public StringReadable(String s) {
            this.s = s;
            Writable.$init$(this);
            Readable.$init$(this);
        }
    }
}

