/*
 * Decompiled with CFR 0.152.
 */
package lmcoursier.internal.shaded.org.codehaus.plexus.archiver;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.attribute.FileTime;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import lmcoursier.internal.shaded.org.codehaus.plexus.archiver.ArchiveEntry;
import lmcoursier.internal.shaded.org.codehaus.plexus.archiver.ArchivedFileSet;
import lmcoursier.internal.shaded.org.codehaus.plexus.archiver.ArchiverException;
import lmcoursier.internal.shaded.org.codehaus.plexus.archiver.FileSet;
import lmcoursier.internal.shaded.org.codehaus.plexus.archiver.ResourceIterator;
import lmcoursier.internal.shaded.org.codehaus.plexus.components.io.resources.PlexusIoResource;
import lmcoursier.internal.shaded.org.codehaus.plexus.components.io.resources.PlexusIoResourceCollection;

public interface Archiver {
    public static final int DEFAULT_DIR_MODE = 16877;
    public static final int DEFAULT_FILE_MODE = 33188;
    public static final int DEFAULT_SYMLILNK_MODE = 41471;
    public static final String DUPLICATES_ADD = "add";
    public static final String DUPLICATES_PRESERVE = "preserve";
    public static final String DUPLICATES_SKIP = "skip";
    public static final String DUPLICATES_FAIL = "fail";
    public static final Set<String> DUPLICATES_VALID_BEHAVIORS = new HashSet<String>(){
        private static final long serialVersionUID = 1L;
        {
            this.add(Archiver.DUPLICATES_ADD);
            this.add(Archiver.DUPLICATES_PRESERVE);
            this.add(Archiver.DUPLICATES_SKIP);
            this.add(Archiver.DUPLICATES_FAIL);
        }
    };

    public void createArchive() throws ArchiverException, IOException;

    @Deprecated
    public void addDirectory(@Nonnull File var1) throws ArchiverException;

    @Deprecated
    public void addDirectory(@Nonnull File var1, String var2) throws ArchiverException;

    @Deprecated
    public void addDirectory(@Nonnull File var1, String[] var2, String[] var3) throws ArchiverException;

    @Deprecated
    public void addDirectory(@Nonnull File var1, String var2, String[] var3, String[] var4) throws ArchiverException;

    public void addFileSet(@Nonnull FileSet var1) throws ArchiverException;

    public void addSymlink(String var1, String var2) throws ArchiverException;

    public void addSymlink(String var1, int var2, String var3) throws ArchiverException;

    public void addFile(@Nonnull File var1, @Nonnull String var2) throws ArchiverException;

    public void addFile(@Nonnull File var1, @Nonnull String var2, int var3) throws ArchiverException;

    public void addArchivedFileSet(@Nonnull File var1) throws ArchiverException;

    @Deprecated
    public void addArchivedFileSet(@Nonnull File var1, String var2) throws ArchiverException;

    @Deprecated
    public void addArchivedFileSet(File var1, String[] var2, String[] var3) throws ArchiverException;

    @Deprecated
    public void addArchivedFileSet(@Nonnull File var1, String var2, String[] var3, String[] var4) throws ArchiverException;

    public void addArchivedFileSet(ArchivedFileSet var1) throws ArchiverException;

    public void addArchivedFileSet(ArchivedFileSet var1, Charset var2) throws ArchiverException;

    public void addResource(PlexusIoResource var1, String var2, int var3) throws ArchiverException;

    public void addResources(PlexusIoResourceCollection var1) throws ArchiverException;

    public File getDestFile();

    public void setDestFile(File var1);

    public void setFileMode(int var1);

    public int getFileMode();

    public int getOverrideFileMode();

    public void setDefaultFileMode(int var1);

    public int getDefaultFileMode();

    public void setDirectoryMode(int var1);

    public int getDirectoryMode();

    public int getOverrideDirectoryMode();

    public void setDefaultDirectoryMode(int var1);

    public int getDefaultDirectoryMode();

    public boolean getIncludeEmptyDirs();

    public void setIncludeEmptyDirs(boolean var1);

    public void setDotFileDirectory(File var1);

    @Nonnull
    public ResourceIterator getResources() throws ArchiverException;

    public Map<String, ArchiveEntry> getFiles();

    public boolean isForced();

    public void setForced(boolean var1);

    public boolean isSupportingForced();

    public String getDuplicateBehavior();

    public void setDuplicateBehavior(String var1);

    @Deprecated
    public void setUseJvmChmod(boolean var1);

    @Deprecated
    public boolean isUseJvmChmod();

    public boolean isIgnorePermissions();

    public void setIgnorePermissions(boolean var1);

    @Deprecated
    public void setLastModifiedDate(Date var1);

    @Deprecated
    public Date getLastModifiedDate();

    public void setLastModifiedTime(FileTime var1);

    public FileTime getLastModifiedTime();

    public void setFilenameComparator(Comparator<String> var1);

    public void setOverrideUid(int var1);

    public void setOverrideUserName(String var1);

    public int getOverrideUid();

    public String getOverrideUserName();

    public void setOverrideGid(int var1);

    public void setOverrideGroupName(String var1);

    public int getOverrideGid();

    public String getOverrideGroupName();

    @Deprecated
    public void configureReproducible(Date var1);

    public void configureReproducibleBuild(FileTime var1);
}

