/*
 * Decompiled with CFR 0.152.
 */
package lmcoursier.internal.shaded.org.codehaus.plexus.archiver;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.Collections;
import java.util.List;
import lmcoursier.internal.shaded.org.codehaus.plexus.archiver.AbstractArchiveFinalizer;
import lmcoursier.internal.shaded.org.codehaus.plexus.archiver.Archiver;
import lmcoursier.internal.shaded.org.codehaus.plexus.archiver.ArchiverException;
import lmcoursier.internal.shaded.org.codehaus.plexus.archiver.FileSet;
import lmcoursier.internal.shaded.org.codehaus.plexus.archiver.util.DefaultFileSet;
import lmcoursier.internal.shaded.org.codehaus.plexus.util.FileUtils;
import lmcoursier.internal.shaded.org.codehaus.plexus.util.StringUtils;

public class DotDirectiveArchiveFinalizer
extends AbstractArchiveFinalizer {
    private static final String DEFAULT_DOT_FILE_PREFIX = ".plxarc";
    private final File dotFileDirectory;
    private final String dotFilePrefix;

    public DotDirectiveArchiveFinalizer(File dotFileDirectory) {
        this(dotFileDirectory, DEFAULT_DOT_FILE_PREFIX);
    }

    public DotDirectiveArchiveFinalizer(File dotFileDirectory, String dotFilePrefix) {
        this.dotFileDirectory = dotFileDirectory;
        this.dotFilePrefix = dotFilePrefix;
    }

    @Override
    public void finalizeArchiveCreation(Archiver archiver) throws ArchiverException {
        try {
            List<File> dotFiles = FileUtils.getFiles(this.dotFileDirectory, this.dotFilePrefix + "*", null);
            for (File dotFile : dotFiles) {
                BufferedReader in = Files.newBufferedReader(dotFile.toPath(), StandardCharsets.UTF_8);
                try {
                    String line = in.readLine();
                    while (line != null) {
                        File directory;
                        String[] s = StringUtils.split(line, ":");
                        if (s.length == 1) {
                            directory = new File(this.dotFileDirectory, s[0]);
                            System.out.println("adding directory = " + directory);
                            archiver.addFileSet(new DefaultFileSet(directory));
                        } else {
                            directory = new File(this.dotFileDirectory, s[0]);
                            System.out.println("adding directory = " + directory + " to: " + s[1]);
                            if (s[1].endsWith("/")) {
                                archiver.addFileSet((FileSet)new DefaultFileSet(directory).prefixed(s[1]));
                            } else {
                                archiver.addFileSet((FileSet)new DefaultFileSet(directory).prefixed(s[1] + "/"));
                            }
                        }
                        line = in.readLine();
                    }
                }
                finally {
                    if (in == null) continue;
                    in.close();
                }
            }
        }
        catch (IOException e) {
            throw new ArchiverException("Error processing dot files.", e);
        }
    }

    @Override
    public List getVirtualFiles() {
        return Collections.EMPTY_LIST;
    }
}

