package lmcoursier.definitions

import dataclass._

@data final class Authentication private (val user: String, val password: String, val optional: Boolean, val realmOpt: Option[String], @since("1.0") val headers: Seq[(String, String)], @since("1.1") val httpsOnly: Boolean, @since("1.2") val passOnRedirect: Boolean) extends Product with Serializable {

override def equals(obj: Any): Boolean = obj match {
  case c: Authentication =>
    this.user == c.user && this.password == c.password && this.optional == c.optional && this.realmOpt == c.realmOpt && this.headers == c.headers && this.httpsOnly == c.httpsOnly && this.passOnRedirect == c.passOnRedirect
  case _ =>
    false
}
override lazy val hashCode: Int = {
  val state = Seq(user, password, optional, realmOpt, headers, httpsOnly, passOnRedirect)
  state.foldLeft(0)((a, b) => 31 * a.hashCode() + b.hashCode())
}
private def copy(user: String = this.user, password: String = this.password, optional: Boolean = this.optional, realmOpt: Option[String] = this.realmOpt, headers: Seq[(String, String)] = this.headers, httpsOnly: Boolean = this.httpsOnly, passOnRedirect: Boolean = this.passOnRedirect): Authentication = new Authentication(user, password, optional, realmOpt, headers, httpsOnly, passOnRedirect)
override def canEqual(obj: Any): Boolean = obj match {
  case c: Authentication => true
  case _ => false
}
override def productArity = 7
override def productElement(n: Int) = n match {
  case 0 =>
    user
  case 1 =>
    password
  case 2 =>
    optional
  case 3 =>
    realmOpt
  case 4 =>
    headers
  case 5 =>
    httpsOnly
  case 6 =>
    passOnRedirect
  case _ =>
    throw new IndexOutOfBoundsException()
}
def productElementName(n: Int) = n match {
  case 0 =>
    "user"
  case 1 =>
    "password"
  case 2 =>
    "optional"
  case 3 =>
    "realmOpt"
  case 4 =>
    "headers"
  case 5 =>
    "httpsOnly"
  case 6 =>
    "passOnRedirect"
  case _ =>
    throw new IndexOutOfBoundsException()
}
def productElementNames = {
  Iterator("user", "password", "optional", "realmOpt", "headers", "httpsOnly", "passOnRedirect")
}
override def productIterator = {
  Iterator(user, password, optional, realmOpt, headers, httpsOnly, passOnRedirect)
}
override def productPrefix = "Authentication"
def withUser(user: String): Authentication = copy(user = user)
def withPassword(password: String): Authentication = copy(password = password)
def withOptional(optional: Boolean): Authentication = copy(optional = optional)
def withRealmOpt(realmOpt: Option[String]): Authentication = copy(realmOpt = realmOpt)
def withHeaders(headers: Seq[(String, String)]): Authentication = copy(headers = headers)
def withHttpsOnly(httpsOnly: Boolean): Authentication = copy(httpsOnly = httpsOnly)
def withPassOnRedirect(passOnRedirect: Boolean): Authentication = copy(passOnRedirect = passOnRedirect)

override def toString(): String =
    s"Authentication(user=$user)"
}
object Authentication {
def apply(user: String, password: String, optional: Boolean, realmOpt: Option[String], headers: Seq[(String, String)], httpsOnly: Boolean, passOnRedirect: Boolean): Authentication = new Authentication(user, password, optional, realmOpt, headers, httpsOnly, passOnRedirect)
def apply(user: String, password: String, optional: Boolean, realmOpt: Option[String]): Authentication = new Authentication(user, password, optional, realmOpt, Nil, true, false)
def apply(user: String, password: String, optional: Boolean, realmOpt: Option[String], headers: Seq[(String, String)]): Authentication = new Authentication(user, password, optional, realmOpt, headers, true, false)
def apply(user: String, password: String, optional: Boolean, realmOpt: Option[String], headers: Seq[(String, String)], httpsOnly: Boolean): Authentication = new Authentication(user, password, optional, realmOpt, headers, httpsOnly, false)
def apply(user: String, password: String): Authentication = new Authentication(user, password, false, None, Nil, true, false)
}

