package lmcoursier.definitions

import dataclass.data

@data final class Developer private (val id: String, val name: String, val url: String) extends Product with Serializable {

override def equals(obj: Any): Boolean = obj match {
  case c: Developer =>
    this.id == c.id && this.name == c.name && this.url == c.url
  case _ =>
    false
}
override lazy val hashCode: Int = {
  val state = Seq(id, name, url)
  state.foldLeft(0)((a, b) => 31 * a.hashCode() + b.hashCode())
}
private def copy(id: String = this.id, name: String = this.name, url: String = this.url): Developer = new Developer(id, name, url)
override def canEqual(obj: Any): Boolean = obj match {
  case c: Developer => true
  case _ => false
}
override def productArity = 3
override def productElement(n: Int) = n match {
  case 0 =>
    id
  case 1 =>
    name
  case 2 =>
    url
  case _ =>
    throw new IndexOutOfBoundsException()
}
def productElementName(n: Int) = n match {
  case 0 =>
    "id"
  case 1 =>
    "name"
  case 2 =>
    "url"
  case _ =>
    throw new IndexOutOfBoundsException()
}
def productElementNames = {
  Iterator("id", "name", "url")
}
override def productIterator = {
  Iterator(id, name, url)
}
override def productPrefix = "Developer"
def withId(id: String): Developer = copy(id = id)
def withName(name: String): Developer = copy(name = name)
def withUrl(url: String): Developer = copy(url = url)
override def toString = {
  val sb = new StringBuilder("Developer")
  sb.append(productElementNames.zip(productIterator).map {
    case (name, value) =>
      s"$name=$value"
  }.mkString("(", ",", ")"))
  sb.toString
}


}
object Developer {
def apply(id: String, name: String, url: String): Developer = new Developer(id, name, url)
}

