package lmcoursier.credentials

import dataclass._

@data final class DirectCredentials private (val host: String, val username: String, val password: String, @since("1.0") val realm: Option[String], @since("1.1") val optional: Boolean, @since("1.2") val matchHost: Boolean, @since("1.3") val httpsOnly: Boolean) extends Credentials with Product with Serializable {

override def equals(obj: Any): Boolean = obj match {
  case c: DirectCredentials =>
    this.host == c.host && this.username == c.username && this.password == c.password && this.realm == c.realm && this.optional == c.optional && this.matchHost == c.matchHost && this.httpsOnly == c.httpsOnly
  case _ =>
    false
}
override lazy val hashCode: Int = {
  val state = Seq(host, username, password, realm, optional, matchHost, httpsOnly)
  state.foldLeft(0)((a, b) => 31 * a.hashCode() + b.hashCode())
}
private def copy(host: String = this.host, username: String = this.username, password: String = this.password, realm: Option[String] = this.realm, optional: Boolean = this.optional, matchHost: Boolean = this.matchHost, httpsOnly: Boolean = this.httpsOnly): DirectCredentials = new DirectCredentials(host, username, password, realm, optional, matchHost, httpsOnly)
override def canEqual(obj: Any): Boolean = obj match {
  case c: DirectCredentials => true
  case _ => false
}
override def productArity = 7
override def productElement(n: Int) = n match {
  case 0 =>
    host
  case 1 =>
    username
  case 2 =>
    password
  case 3 =>
    realm
  case 4 =>
    optional
  case 5 =>
    matchHost
  case 6 =>
    httpsOnly
  case _ =>
    throw new IndexOutOfBoundsException()
}
def productElementName(n: Int) = n match {
  case 0 =>
    "host"
  case 1 =>
    "username"
  case 2 =>
    "password"
  case 3 =>
    "realm"
  case 4 =>
    "optional"
  case 5 =>
    "matchHost"
  case 6 =>
    "httpsOnly"
  case _ =>
    throw new IndexOutOfBoundsException()
}
def productElementNames = {
  Iterator("host", "username", "password", "realm", "optional", "matchHost", "httpsOnly")
}
override def productIterator = {
  Iterator(host, username, password, realm, optional, matchHost, httpsOnly)
}
override def productPrefix = "DirectCredentials"
def withHost(host: String): DirectCredentials = copy(host = host)
def withUsername(username: String): DirectCredentials = copy(username = username)
def withPassword(password: String): DirectCredentials = copy(password = password)
def withRealm(realm: Option[String]): DirectCredentials = copy(realm = realm)
def withOptional(optional: Boolean): DirectCredentials = copy(optional = optional)
def withMatchHost(matchHost: Boolean): DirectCredentials = copy(matchHost = matchHost)
def withHttpsOnly(httpsOnly: Boolean): DirectCredentials = copy(httpsOnly = httpsOnly)

override def toString(): String = s"DirectCredentials(host=$host, username=$username)"
}
object DirectCredentials {
def apply(host: String, username: String, password: String, realm: Option[String], optional: Boolean, matchHost: Boolean, httpsOnly: Boolean): DirectCredentials = new DirectCredentials(host, username, password, realm, optional, matchHost, httpsOnly)
def apply(host: String, username: String, password: String): DirectCredentials = new DirectCredentials(host, username, password, None, true, false, true)
def apply(host: String, username: String, password: String, realm: Option[String]): DirectCredentials = new DirectCredentials(host, username, password, realm, true, false, true)
def apply(host: String, username: String, password: String, realm: Option[String], optional: Boolean): DirectCredentials = new DirectCredentials(host, username, password, realm, optional, false, true)
def apply(host: String, username: String, password: String, realm: Option[String], optional: Boolean, matchHost: Boolean): DirectCredentials = new DirectCredentials(host, username, password, realm, optional, matchHost, true)
def apply(): DirectCredentials = new DirectCredentials("", "", "", None, true, false, true)
}

