package lmcoursier.definitions

import dataclass.data

@data final class Attributes private (val `type`: Type, val classifier: Classifier) extends Product with Serializable {

override def equals(obj: Any): Boolean = obj match {
  case c: Attributes =>
    this.`type` == c.`type` && this.classifier == c.classifier
  case _ =>
    false
}
override lazy val hashCode: Int = {
  val state = Seq(`type`, classifier)
  state.foldLeft(0)((a, b) => 31 * a.hashCode() + b.hashCode())
}
private def copy(`type`: Type = this.`type`, classifier: Classifier = this.classifier): Attributes = new Attributes(`type`, classifier)
override def canEqual(obj: Any): Boolean = obj match {
  case c: Attributes => true
  case _ => false
}
override def productArity = 2
override def productElement(n: Int) = n match {
  case 0 =>
    `type`
  case 1 =>
    classifier
  case _ =>
    throw new IndexOutOfBoundsException()
}
def productElementName(n: Int) = n match {
  case 0 =>
    "type"
  case 1 =>
    "classifier"
  case _ =>
    throw new IndexOutOfBoundsException()
}
def productElementNames = {
  Iterator("type", "classifier")
}
override def productIterator = {
  Iterator(`type`, classifier)
}
override def productPrefix = "Attributes"
def withType(`type`: Type): Attributes = copy(`type` = `type`)
def withClassifier(classifier: Classifier): Attributes = copy(classifier = classifier)
override def toString = {
  val sb = new StringBuilder("Attributes")
  sb.append(productElementNames.zip(productIterator).map {
    case (name, value) =>
      s"$name=$value"
  }.mkString("(", ",", ")"))
  sb.toString
}


}
object Attributes {
def apply(`type`: Type, classifier: Classifier): Attributes = new Attributes(`type`, classifier)
}

