package lmcoursier.definitions

import dataclass.data

/**
 * @param exclude Use "*" in either organization or name to match any.
 * @param include Use "*" in either organization or name to match any.
 */
@data final class ModuleMatchers private (val exclude: Set[Module], val include: Set[Module], val includeByDefault: Boolean) extends Product with Serializable {

override def equals(obj: Any): Boolean = obj match {
  case c: ModuleMatchers =>
    this.exclude == c.exclude && this.include == c.include && this.includeByDefault == c.includeByDefault
  case _ =>
    false
}
override lazy val hashCode: Int = {
  val state = Seq(exclude, include, includeByDefault)
  state.foldLeft(0)((a, b) => 31 * a.hashCode() + b.hashCode())
}
private def copy(exclude: Set[Module] = this.exclude, include: Set[Module] = this.include, includeByDefault: Boolean = this.includeByDefault): ModuleMatchers = new ModuleMatchers(exclude, include, includeByDefault)
override def canEqual(obj: Any): Boolean = obj match {
  case c: ModuleMatchers => true
  case _ => false
}
override def productArity = 3
override def productElement(n: Int) = n match {
  case 0 =>
    exclude
  case 1 =>
    include
  case 2 =>
    includeByDefault
  case _ =>
    throw new IndexOutOfBoundsException()
}
def productElementName(n: Int) = n match {
  case 0 =>
    "exclude"
  case 1 =>
    "include"
  case 2 =>
    "includeByDefault"
  case _ =>
    throw new IndexOutOfBoundsException()
}
def productElementNames = {
  Iterator("exclude", "include", "includeByDefault")
}
override def productIterator = {
  Iterator(exclude, include, includeByDefault)
}
override def productPrefix = "ModuleMatchers"
def withExclude(exclude: Set[Module]): ModuleMatchers = copy(exclude = exclude)
def withInclude(include: Set[Module]): ModuleMatchers = copy(include = include)
def withIncludeByDefault(includeByDefault: Boolean): ModuleMatchers = copy(includeByDefault = includeByDefault)
override def toString = {
  val sb = new StringBuilder("ModuleMatchers")
  sb.append(productElementNames.zip(productIterator).map {
    case (name, value) =>
      s"$name=$value"
  }.mkString("(", ",", ")"))
  sb.toString
}


}
object ModuleMatchers {
def apply(exclude: Set[Module], include: Set[Module], includeByDefault: Boolean): ModuleMatchers = new ModuleMatchers(exclude, include, includeByDefault)
def apply(exclude: Set[Module], include: Set[Module]): ModuleMatchers = new ModuleMatchers(exclude, include, true)
}

