package lmcoursier.definitions

import dataclass.data

@data final class Project private (val module: Module, val version: String, val dependencies: Seq[(Configuration, Dependency)], val configurations: Map[Configuration, Seq[Configuration]], val properties: Seq[(String, String)], val packagingOpt: Option[Type], val publications: Seq[(Configuration, Publication)], val info: Info) extends Product with Serializable {

override def equals(obj: Any): Boolean = obj match {
  case c: Project =>
    this.module == c.module && this.version == c.version && this.dependencies == c.dependencies && this.configurations == c.configurations && this.properties == c.properties && this.packagingOpt == c.packagingOpt && this.publications == c.publications && this.info == c.info
  case _ =>
    false
}
override lazy val hashCode: Int = {
  val state = Seq(module, version, dependencies, configurations, properties, packagingOpt, publications, info)
  state.foldLeft(0)((a, b) => 31 * a.hashCode() + b.hashCode())
}
private def copy(module: Module = this.module, version: String = this.version, dependencies: Seq[(Configuration, Dependency)] = this.dependencies, configurations: Map[Configuration, Seq[Configuration]] = this.configurations, properties: Seq[(String, String)] = this.properties, packagingOpt: Option[Type] = this.packagingOpt, publications: Seq[(Configuration, Publication)] = this.publications, info: Info = this.info): Project = new Project(module, version, dependencies, configurations, properties, packagingOpt, publications, info)
override def canEqual(obj: Any): Boolean = obj match {
  case c: Project => true
  case _ => false
}
override def productArity = 8
override def productElement(n: Int) = n match {
  case 0 =>
    module
  case 1 =>
    version
  case 2 =>
    dependencies
  case 3 =>
    configurations
  case 4 =>
    properties
  case 5 =>
    packagingOpt
  case 6 =>
    publications
  case 7 =>
    info
  case _ =>
    throw new IndexOutOfBoundsException()
}
def productElementName(n: Int) = n match {
  case 0 =>
    "module"
  case 1 =>
    "version"
  case 2 =>
    "dependencies"
  case 3 =>
    "configurations"
  case 4 =>
    "properties"
  case 5 =>
    "packagingOpt"
  case 6 =>
    "publications"
  case 7 =>
    "info"
  case _ =>
    throw new IndexOutOfBoundsException()
}
def productElementNames = {
  Iterator("module", "version", "dependencies", "configurations", "properties", "packagingOpt", "publications", "info")
}
override def productIterator = {
  Iterator(module, version, dependencies, configurations, properties, packagingOpt, publications, info)
}
override def productPrefix = "Project"
def withModule(module: Module): Project = copy(module = module)
def withVersion(version: String): Project = copy(version = version)
def withDependencies(dependencies: Seq[(Configuration, Dependency)]): Project = copy(dependencies = dependencies)
def withConfigurations(configurations: Map[Configuration, Seq[Configuration]]): Project = copy(configurations = configurations)
def withProperties(properties: Seq[(String, String)]): Project = copy(properties = properties)
def withPackagingOpt(packagingOpt: Option[Type]): Project = copy(packagingOpt = packagingOpt)
def withPublications(publications: Seq[(Configuration, Publication)]): Project = copy(publications = publications)
def withInfo(info: Info): Project = copy(info = info)
override def toString = {
  val sb = new StringBuilder("Project")
  sb.append(productElementNames.zip(productIterator).map {
    case (name, value) =>
      s"$name=$value"
  }.mkString("(", ",", ")"))
  sb.toString
}


}
object Project {
def apply(module: Module, version: String, dependencies: Seq[(Configuration, Dependency)], configurations: Map[Configuration, Seq[Configuration]], properties: Seq[(String, String)], packagingOpt: Option[Type], publications: Seq[(Configuration, Publication)], info: Info): Project = new Project(module, version, dependencies, configurations, properties, packagingOpt, publications, info)
}

