package lmcoursier.definitions

import dataclass._

@data final class Strict private (val include: Set[(String, String)], val exclude: Set[(String, String)], val ignoreIfForcedVersion: Boolean, @since val includeByDefault: Boolean, val semVer: Boolean) extends Product with Serializable {

override def equals(obj: Any): Boolean = obj match {
  case c: Strict =>
    this.include == c.include && this.exclude == c.exclude && this.ignoreIfForcedVersion == c.ignoreIfForcedVersion && this.includeByDefault == c.includeByDefault && this.semVer == c.semVer
  case _ =>
    false
}
override lazy val hashCode: Int = {
  val state = Seq(include, exclude, ignoreIfForcedVersion, includeByDefault, semVer)
  state.foldLeft(0)((a, b) => 31 * a.hashCode() + b.hashCode())
}
private def copy(include: Set[(String, String)] = this.include, exclude: Set[(String, String)] = this.exclude, ignoreIfForcedVersion: Boolean = this.ignoreIfForcedVersion, includeByDefault: Boolean = this.includeByDefault, semVer: Boolean = this.semVer): Strict = new Strict(include, exclude, ignoreIfForcedVersion, includeByDefault, semVer)
override def canEqual(obj: Any): Boolean = obj match {
  case c: Strict => true
  case _ => false
}
override def productArity = 5
override def productElement(n: Int) = n match {
  case 0 =>
    include
  case 1 =>
    exclude
  case 2 =>
    ignoreIfForcedVersion
  case 3 =>
    includeByDefault
  case 4 =>
    semVer
  case _ =>
    throw new IndexOutOfBoundsException()
}
def productElementName(n: Int) = n match {
  case 0 =>
    "include"
  case 1 =>
    "exclude"
  case 2 =>
    "ignoreIfForcedVersion"
  case 3 =>
    "includeByDefault"
  case 4 =>
    "semVer"
  case _ =>
    throw new IndexOutOfBoundsException()
}
def productElementNames = {
  Iterator("include", "exclude", "ignoreIfForcedVersion", "includeByDefault", "semVer")
}
override def productIterator = {
  Iterator(include, exclude, ignoreIfForcedVersion, includeByDefault, semVer)
}
override def productPrefix = "Strict"
def withInclude(include: Set[(String, String)]): Strict = copy(include = include)
def withExclude(exclude: Set[(String, String)]): Strict = copy(exclude = exclude)
def withIgnoreIfForcedVersion(ignoreIfForcedVersion: Boolean): Strict = copy(ignoreIfForcedVersion = ignoreIfForcedVersion)
def withIncludeByDefault(includeByDefault: Boolean): Strict = copy(includeByDefault = includeByDefault)
def withSemVer(semVer: Boolean): Strict = copy(semVer = semVer)
override def toString = {
  val sb = new StringBuilder("Strict")
  sb.append(productElementNames.zip(productIterator).map {
    case (name, value) =>
      s"$name=$value"
  }.mkString("(", ",", ")"))
  sb.toString
}


}
object Strict {
def apply(include: Set[(String, String)], exclude: Set[(String, String)], ignoreIfForcedVersion: Boolean, includeByDefault: Boolean, semVer: Boolean): Strict = new Strict(include, exclude, ignoreIfForcedVersion, includeByDefault, semVer)
def apply(include: Set[(String, String)], exclude: Set[(String, String)], ignoreIfForcedVersion: Boolean, semVer: Boolean): Strict = new Strict(include, exclude, ignoreIfForcedVersion, false, semVer)
def apply(): Strict = new Strict(Set(("*", "*")), Set.empty, true, false, false)
}

