package lmcoursier

import java.net.URL

import dataclass.data
import lmcoursier.definitions.Module

@data final class FallbackDependency private (val module: Module, val version: String, val url: URL, val changing: Boolean) extends Product with Serializable {

override def equals(obj: Any): Boolean = obj match {
  case c: FallbackDependency =>
    this.module == c.module && this.version == c.version && this.url == c.url && this.changing == c.changing
  case _ =>
    false
}
override lazy val hashCode: Int = {
  val state = Seq(module, version, url, changing)
  state.foldLeft(0)((a, b) => 31 * a.hashCode() + b.hashCode())
}
private def copy(module: Module = this.module, version: String = this.version, url: URL = this.url, changing: Boolean = this.changing): FallbackDependency = new FallbackDependency(module, version, url, changing)
override def canEqual(obj: Any): Boolean = obj match {
  case c: FallbackDependency => true
  case _ => false
}
override def productArity = 4
override def productElement(n: Int) = n match {
  case 0 =>
    module
  case 1 =>
    version
  case 2 =>
    url
  case 3 =>
    changing
  case _ =>
    throw new IndexOutOfBoundsException()
}
def productElementName(n: Int) = n match {
  case 0 =>
    "module"
  case 1 =>
    "version"
  case 2 =>
    "url"
  case 3 =>
    "changing"
  case _ =>
    throw new IndexOutOfBoundsException()
}
def productElementNames = {
  Iterator("module", "version", "url", "changing")
}
override def productIterator = {
  Iterator(module, version, url, changing)
}
override def productPrefix = "FallbackDependency"
def withModule(module: Module): FallbackDependency = copy(module = module)
def withVersion(version: String): FallbackDependency = copy(version = version)
def withUrl(url: URL): FallbackDependency = copy(url = url)
def withChanging(changing: Boolean): FallbackDependency = copy(changing = changing)
override def toString = {
  val sb = new StringBuilder("FallbackDependency")
  sb.append(productElementNames.zip(productIterator).map {
    case (name, value) =>
      s"$name=$value"
  }.mkString("(", ",", ")"))
  sb.toString
}


}
object FallbackDependency {
def apply(module: Module, version: String, url: URL, changing: Boolean): FallbackDependency = new FallbackDependency(module, version, url, changing)
}

