package lmcoursier.credentials

import dataclass.data

@data final class FileCredentials private (val path: String, val optional: Boolean) extends Credentials with Product with Serializable {

override def equals(obj: Any): Boolean = obj match {
  case c: FileCredentials =>
    this.path == c.path && this.optional == c.optional
  case _ =>
    false
}
override lazy val hashCode: Int = {
  val state = Seq(path, optional)
  state.foldLeft(0)((a, b) => 31 * a.hashCode() + b.hashCode())
}
private def copy(path: String = this.path, optional: Boolean = this.optional): FileCredentials = new FileCredentials(path, optional)
override def canEqual(obj: Any): Boolean = obj match {
  case c: FileCredentials => true
  case _ => false
}
override def productArity = 2
override def productElement(n: Int) = n match {
  case 0 =>
    path
  case 1 =>
    optional
  case _ =>
    throw new IndexOutOfBoundsException()
}
def productElementName(n: Int) = n match {
  case 0 =>
    "path"
  case 1 =>
    "optional"
  case _ =>
    throw new IndexOutOfBoundsException()
}
def productElementNames = {
  Iterator("path", "optional")
}
override def productIterator = {
  Iterator(path, optional)
}
override def productPrefix = "FileCredentials"
def withPath(path: String): FileCredentials = copy(path = path)
def withOptional(optional: Boolean): FileCredentials = copy(optional = optional)
override def toString = {
  val sb = new StringBuilder("FileCredentials")
  sb.append(productElementNames.zip(productIterator).map {
    case (name, value) =>
      s"$name=$value"
  }.mkString("(", ",", ")"))
  sb.toString
}


}
object FileCredentials {
def apply(path: String, optional: Boolean): FileCredentials = new FileCredentials(path, optional)
def apply(path: String): FileCredentials = new FileCredentials(path, true)
}

